/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.worker.matlab.errors;

import com.mathworks.toolbox.distcomp.client.PackageInfo;
import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ErrorCatcherFuture
implements Future<String> {
    private final Future<String> fFuture;

    public ErrorCatcherFuture(Future<String> future) {
        this.fFuture = future;
    }

    @Override
    public boolean cancel(boolean bl) {
        return this.fFuture.cancel(bl);
    }

    @Override
    public boolean isCancelled() {
        return this.fFuture.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.fFuture.isDone();
    }

    @Override
    public String get() {
        String string = "";
        try {
            string = this.fFuture.get();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException executionException) {
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Error in MATLAB error catcher thread", executionException);
            throw ErrorCatcherFuture.launderThrowable(executionException.getCause());
        }
        return string;
    }

    @Override
    public String get(long l, TimeUnit timeUnit) throws TimeoutException {
        String string = "";
        try {
            string = this.fFuture.get(l, timeUnit);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException executionException) {
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Error in MATLAB error catcher thread", executionException);
            throw ErrorCatcherFuture.launderThrowable(executionException.getCause());
        }
        return string;
    }

    private static RuntimeException launderThrowable(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            return (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        throw new IllegalStateException("Unexpected exception thrown in MATLAB error checker thread", throwable);
    }
}

