/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.desktop.mnemonics;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mathworks.desktop.mnemonics.Mnemonic;
import com.mathworks.desktop.mnemonics.MnemonicPath;
import com.mathworks.desktop.mnemonics.Mnemonics;
import com.mathworks.desktop.mnemonics.MnemonicsManager;
import com.mathworks.desktop.mnemonics.MnemonicsManagers;
import com.mathworks.desktop.mnemonics.MnemonicsProvider;
import com.mathworks.desktop.overlay.AnchorPosition;
import com.mathworks.desktop.overlay.Overlay;
import com.mathworks.desktop.overlay.OverlayConstraints;
import com.mathworks.desktop.overlay.OverlayManager;
import com.mathworks.desktop.overlay.OverlayManagers;
import com.mathworks.mwswing.FontUtils;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.mwswing.binding.InputMapUtils;
import com.mathworks.util.NativeEvent;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.async.Callback;
import com.mathworks.util.async.Status;
import com.mathworks.util.event.AWTKeyListener;
import com.mathworks.util.event.AWTMouseListener;
import com.mathworks.util.event.AbstractInputEventsDispatcher;
import com.mathworks.util.logger.Log;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MnemonicsManagerImpl
implements MnemonicsManager {
    private static final Log LOG = Log.getInstance((String)"com.mathworks.desktop.mnemonics.MnemonicsManagerImpl");
    private final Stack<MnemLevel> fLevels = new Stack();
    private boolean fActivated;
    private boolean fVisible;
    private Point fInitialWindowLocation;
    private final Map<Window, RootProvider> fRootMap = new HashMap<Window, RootProvider>();
    private MnemonicsProvider fActiveRoot;
    private MnemonicEventListener fEventListener;
    private Window fActiveWindow;
    private Component fSavedFocusedComponent;
    private final Set<Component> fNonFocusables = Sets.newHashSet();
    private final MnemonicsManagers.KeyboardFocusProvider fFocusProvider;
    private final AbstractInputEventsDispatcher fEventsDispatcher;

    public MnemonicsManagerImpl(AbstractInputEventsDispatcher abstractInputEventsDispatcher, MnemonicsManagers.KeyboardFocusProvider keyboardFocusProvider) {
        this.fEventsDispatcher = abstractInputEventsDispatcher;
        this.fFocusProvider = keyboardFocusProvider;
        if (!PlatformInfo.isMacintosh()) {
            this.enable();
        }
    }

    public void enable() {
        if (this.fEventListener == null) {
            this.fEventListener = new MnemonicEventListener();
            this.fEventsDispatcher.addAWTMouseListener((AWTMouseListener)this.fEventListener);
            this.fEventsDispatcher.addAWTKeyListener((AWTKeyListener)this.fEventListener);
        }
    }

    public void disable() {
        if (this.fEventListener != null) {
            this.fEventsDispatcher.removeAWTMouseListener((AWTMouseListener)this.fEventListener);
            this.fEventsDispatcher.removeAWTKeyListener((AWTKeyListener)this.fEventListener);
            this.fEventListener = null;
        }
    }

    private void select(final Mnem mnem) {
        final MnemonicPath mnemonicPath = new MnemonicPath(this.fLevels.peek().fPath, mnem.fMnemonic);
        this.hide(this.fLevels.peek(), false, false).on((Callback)new Callback<Component>(){

            public void complete(Component component) {
                MnemonicsManagerImpl.this.fLevels.push(new MnemLevel(mnem.fProvider, new ProviderCollector(mnem.fProvider, mnemonicPath)));
                MnemonicsManagerImpl.this.show();
            }
        });
    }

    @Override
    public void clear() {
        if (this.isActivated()) {
            this.clear(true, true);
        } else {
            this.restoreFocus();
        }
    }

    public void suppressFocusReturn() {
        this.fSavedFocusedComponent = null;
    }

    private Status clear(final boolean bl, boolean bl2) {
        ArrayList<Status<Component>> arrayList = new ArrayList<Status<Component>>();
        while (!this.fLevels.isEmpty()) {
            arrayList.add(this.hide(this.fLevels.pop(), bl, bl2));
        }
        Status.And and = new Status.And(arrayList);
        and.on((Callback)new Callback<Object[]>(){

            public void complete(Object[] objectArray) {
                MnemonicsManagerImpl.this.deActivate();
                MnemonicsManagerImpl.this.setVisible(false);
                if (bl) {
                    MnemonicsManagerImpl.this.restoreFocus();
                }
            }
        });
        return and;
    }

    private Status<Component> hide(final MnemLevel mnemLevel, final boolean bl, boolean bl2) {
        Status.Success success = mnemLevel.mnems().iterator();
        while (success.hasNext()) {
            Mnem mnem = success.next();
            mnem.disable();
        }
        Status.Success success2 = success = bl2 ? mnemLevel.fProvider.cancel(mnemLevel.fPath) : null;
        if (success == null) {
            success = new Status.Success();
        }
        success.on((Callback)new Callback<Component>(){

            public void complete(Component component) {
                if (mnemLevel.fPrevFocusOwner != null && bl && MnemonicsManagerImpl.this.fSavedFocusedComponent != null) {
                    final Component component2 = mnemLevel.fPrevFocusOwner;
                    Component component3 = MnemonicsManagerImpl.this.fFocusProvider.getFocusOwner();
                    if (component3 == null || SwingUtilities.windowForComponent(component3) == SwingUtilities.windowForComponent(component2)) {
                        component2.requestFocusInWindow();
                    } else {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                component2.requestFocus();
                            }
                        });
                    }
                }
                mnemLevel.fPrefix = "";
                MnemonicsManagerImpl.this.setVisible(false);
            }
        });
        return success;
    }

    private void show() {
        this.show(this.fLevels.peek());
    }

    private void show(final MnemLevel mnemLevel) {
        mnemLevel.saveFocusOwner();
        mnemLevel.fProvider.select(mnemLevel.fPath).on((Callback)new Callback<Component>(){

            public void fail(Component component) {
                MnemonicsManagerImpl.this.clear();
                if (component != null) {
                    component.requestFocusInWindow();
                }
            }

            public void success(Component component) {
                mnemLevel.init();
                for (Mnem mnem : mnemLevel.mnems()) {
                    mnem.enable();
                }
                MnemonicsManagerImpl.this.setVisible(true);
                if (component != null && component != mnemLevel.fPrevFocusOwner) {
                    if (!component.isFocusable()) {
                        component.setFocusable(true);
                        MnemonicsManagerImpl.this.fNonFocusables.add(component);
                    }
                    component.requestFocusInWindow();
                }
            }
        });
    }

    @Override
    public void register(MnemonicsProvider mnemonicsProvider, Window window) {
        RootProvider rootProvider = this.fRootMap.get(window);
        if (rootProvider == null) {
            rootProvider = new RootProvider();
            this.fRootMap.put(window, rootProvider);
        }
        rootProvider.fProviders.add(mnemonicsProvider);
    }

    @Override
    public void unRegister(MnemonicsProvider mnemonicsProvider, Window window) {
        RootProvider rootProvider = this.fRootMap.get(window);
        if (rootProvider != null) {
            rootProvider.fProviders.remove(mnemonicsProvider);
            if (rootProvider.fProviders.isEmpty()) {
                this.fRootMap.remove(window);
            }
        }
    }

    private boolean isActivated() {
        return this.fActivated;
    }

    private void activate(Component component, RootProvider rootProvider) {
        this.fActivated = true;
        this.fActiveRoot = rootProvider;
        this.fNonFocusables.clear();
        this.fSavedFocusedComponent = component;
        this.fLevels.clear();
        MnemLevel mnemLevel = new MnemLevel(rootProvider, new RootCollector(rootProvider));
        this.fLevels.push(mnemLevel);
        this.show();
    }

    private void deActivate() {
        this.fActivated = false;
        this.fEventListener.iReleasedAltSinceActivating = true;
        this.removeWindowListeners();
        if (this.fActiveRoot != null && !this.fActiveRoot.isFocusOwner()) {
            this.restoreNonFocusables();
        }
    }

    private void restoreNonFocusables() {
        for (Component component : this.fNonFocusables) {
            component.setFocusable(false);
        }
        this.fNonFocusables.clear();
    }

    private void restoreFocus() {
        this.restoreNonFocusables();
        Component component = this.fSavedFocusedComponent;
        this.fSavedFocusedComponent = null;
        if (component != null) {
            component.requestFocusInWindow();
        }
    }

    private void addWindowListeners() {
        this.fInitialWindowLocation = this.fActiveWindow.getLocation();
        this.fActiveWindow.addWindowFocusListener(this.fEventListener);
        this.fActiveWindow.addComponentListener(this.fEventListener);
        if (this.fActiveWindow instanceof MJFrame) {
            ((MJFrame)this.fActiveWindow).addNativeListener((NativeEvent.Listener)this.fEventListener);
        }
    }

    private void removeWindowListeners() {
        if (this.fActiveWindow != null) {
            this.fActiveWindow.removeWindowFocusListener(this.fEventListener);
            this.fActiveWindow.removeComponentListener(this.fEventListener);
            if (this.fActiveWindow instanceof MJFrame) {
                ((MJFrame)this.fActiveWindow).removeNativeListener((NativeEvent.Listener)this.fEventListener);
            }
            this.fActiveWindow = null;
        }
    }

    boolean isVisible() {
        return this.fVisible;
    }

    void setVisible(boolean bl) {
        this.fVisible = bl;
    }

    private static boolean isAlphaNumKeyCode(int n) {
        return n >= 48 && n <= 57 || n >= 65 && n <= 90;
    }

    private static boolean hidePopups(Component component) {
        MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
        if (menuElementArray != null && menuElementArray.length > 0) {
            MenuSelectionManager.defaultManager().clearSelectedPath();
            return true;
        }
        OverlayManager overlayManager = OverlayManagers.get(component);
        if (overlayManager != null && overlayManager.isPopupShowing()) {
            overlayManager.removePopups();
            return true;
        }
        return false;
    }

    private static class RootProvider
    implements MnemonicsProvider {
        private final Collection<MnemonicsProvider> fProviders = Lists.newArrayList();

        private RootProvider() {
        }

        @Override
        @NotNull
        public Mnemonics getMnemonics(@NotNull MnemonicPath mnemonicPath) {
            Preconditions.checkArgument((boolean)mnemonicPath.isEmpty());
            ArrayList arrayList = Lists.newArrayList();
            for (MnemonicsProvider mnemonicsProvider : this.fProviders) {
                Mnemonics mnemonics = mnemonicsProvider.getMnemonics(mnemonicPath);
                arrayList.addAll(mnemonics);
            }
            return new Mnemonics(arrayList);
        }

        @Override
        @NotNull
        public Status<Component> select(@NotNull MnemonicPath mnemonicPath) {
            MnemonicsProvider mnemonicsProvider = this.getDefaultProvider();
            Status.Fail fail = mnemonicsProvider != null ? mnemonicsProvider.select(mnemonicPath) : new Status.Fail(null);
            return fail;
        }

        @Override
        @Nullable
        public Status<Component> cancel(@NotNull MnemonicPath mnemonicPath) {
            MnemonicsProvider mnemonicsProvider = this.getDefaultProvider();
            return mnemonicsProvider != null ? mnemonicsProvider.cancel(mnemonicPath) : null;
        }

        MnemonicsProvider getDefaultProvider() {
            for (MnemonicsProvider mnemonicsProvider : this.fProviders) {
                if (!mnemonicsProvider.isDefaultFocusOwner()) continue;
                return mnemonicsProvider;
            }
            return null;
        }

        @Override
        public boolean isFocusOwner() {
            MnemonicsProvider mnemonicsProvider = this.getDefaultProvider();
            return mnemonicsProvider != null && mnemonicsProvider.isFocusOwner();
        }

        @Override
        public boolean isDefaultFocusOwner() {
            return true;
        }
    }

    private static class Mnem {
        private final MnemonicsProvider fProvider;
        private final Mnemonic fMnemonic;
        private Overlay fOverlay;

        private Mnem(MnemonicsProvider mnemonicsProvider, Mnemonic mnemonic) {
            this.fProvider = mnemonicsProvider;
            this.fMnemonic = mnemonic;
        }

        void enable() {
            if (this.fOverlay == null) {
                OverlayManager overlayManager;
                Mnemonic mnemonic = this.fMnemonic;
                JComponent jComponent = mnemonic.getComponent();
                Point point = mnemonic.getLocationOnComponent();
                if (point != null && (overlayManager = OverlayManagers.get(jComponent)) != null) {
                    MnemonicComponent mnemonicComponent = new MnemonicComponent(mnemonic.getMnemonic().toUpperCase());
                    Dimension dimension = mnemonicComponent.calcSize();
                    this.fOverlay = overlayManager.addOverlay(mnemonicComponent, new OverlayConstraints((Component)jComponent, AnchorPosition.NORTHWEST, point.x - dimension.width / 2, point.y - dimension.height / 2, dimension.width, dimension.height, 1000, Overlay.Mode.AUTO));
                }
            }
        }

        void disable() {
            if (this.fOverlay != null) {
                OverlayManager overlayManager = OverlayManagers.get(this.fMnemonic.getComponent());
                if (overlayManager != null) {
                    overlayManager.removeOverlay(this.fOverlay);
                }
                this.fOverlay = null;
            }
        }

        public void update() {
            OverlayManager overlayManager;
            if (this.fOverlay != null && (overlayManager = OverlayManagers.get(this.fMnemonic.getComponent())) != null) {
                overlayManager.repaint(this.fOverlay);
            }
        }
    }

    private class MnemLevel {
        private MnemonicsProvider fProvider;
        private Collection<Mnem> fMnems = Lists.newArrayList();
        private boolean fInited;
        private String fPrefix;
        private MnemonicPath fPath;
        private Collector fCollector;
        private Component fPrevFocusOwner;

        MnemLevel(MnemonicsProvider mnemonicsProvider, Collector collector) {
            this.fCollector = collector;
            this.fProvider = mnemonicsProvider;
            this.fPrefix = "";
            this.fPath = collector.fPath;
        }

        void saveFocusOwner() {
            if (!this.fInited) {
                this.fPrevFocusOwner = MnemonicsManagerImpl.this.fFocusProvider.getFocusOwner();
            }
        }

        void init() {
            if (!this.fInited) {
                this.fMnems = this.fCollector.collect();
                this.fInited = true;
                this.assertUniqueness();
            }
        }

        public Collection<Mnem> mnems() {
            this.init();
            return this.fMnems;
        }

        private void assertUniqueness() {
            HashSet hashSet = Sets.newHashSet();
            for (Mnem mnem : this.fMnems) {
                String string = mnem.fMnemonic.getMnemonic().toUpperCase();
                if (hashSet.add(string)) continue;
                LOG.warn("Found duplicated mnemonic '%s' at path %s", new Object[]{string, this.fPath});
            }
        }
    }

    private static class ProviderCollector
    extends Collector {
        private MnemonicsProvider fProvider;

        private ProviderCollector(MnemonicsProvider mnemonicsProvider, MnemonicPath mnemonicPath) {
            super(mnemonicPath);
            this.fProvider = mnemonicsProvider;
        }

        @Override
        public Collection<Mnem> collect() {
            return this.collect(new ArrayList<Mnem>(), this.fProvider);
        }
    }

    private static class RootCollector
    extends Collector {
        private final RootProvider iRoot;

        private RootCollector(RootProvider rootProvider) {
            super(new MnemonicPath());
            this.iRoot = rootProvider;
        }

        @Override
        public Collection<Mnem> collect() {
            ArrayList<Mnem> arrayList = new ArrayList<Mnem>();
            for (MnemonicsProvider mnemonicsProvider : this.iRoot.fProviders) {
                this.collect(arrayList, mnemonicsProvider);
            }
            return arrayList;
        }
    }

    private static abstract class Collector {
        private MnemonicPath fPath;

        Collector(MnemonicPath mnemonicPath) {
            this.fPath = mnemonicPath;
        }

        Collection<Mnem> collect(Collection<Mnem> collection, MnemonicsProvider mnemonicsProvider) {
            Mnemonics mnemonics = mnemonicsProvider.getMnemonics(this.fPath);
            for (Mnemonic mnemonic : mnemonics) {
                collection.add(new Mnem(mnemonicsProvider, mnemonic));
            }
            return collection;
        }

        abstract Collection<Mnem> collect();
    }

    private class MnemonicEventListener
    implements AWTMouseListener,
    AWTKeyListener,
    ActionListener,
    WindowFocusListener,
    ComponentListener,
    NativeEvent.Listener {
        private boolean iReleasedAltSinceActivating;
        private boolean iGotMatchWhileAltDown;
        private Component iPendingFocusOwner;
        private RootProvider iPendingRoot;
        private Timer iActivationTimer;
        private boolean iEscapeDown;

        private MnemonicEventListener() {
        }

        public void mouseEventDispatched(MouseEvent mouseEvent, @Nullable Window window, @Nullable Component component) {
            if (mouseEvent.getID() != 501) {
                return;
            }
            MnemonicsManagerImpl.this.clear();
            this.cancelPendingActivation(false);
        }

        public void keyEventDispatched(KeyEvent keyEvent, @Nullable Window window) {
            boolean bl;
            Component component = MnemonicsManagerImpl.this.fFocusProvider.getFocusOwner();
            if (component == null) {
                component = keyEvent.getComponent();
            }
            if (window == null && component != null) {
                window = SwingUtilities.getWindowAncestor(component);
            }
            if (window == null) {
                this.cancelPendingActivation(false);
                return;
            }
            RootProvider rootProvider = (RootProvider)MnemonicsManagerImpl.this.fRootMap.get(window);
            if (rootProvider == null) {
                this.cancelPendingActivation(false);
                return;
            }
            if (this.iPendingFocusOwner != component || this.iPendingRoot != rootProvider) {
                this.cancelPendingActivation(false);
            }
            int n = keyEvent.getKeyCode();
            int n2 = keyEvent.getID();
            boolean bl2 = n2 == 401;
            boolean bl3 = n2 == 402;
            boolean bl4 = bl = n2 == 400;
            if (n == 18) {
                if (keyEvent.isControlDown()) {
                    this.iReleasedAltSinceActivating = true;
                } else if (bl2) {
                    this.iGotMatchWhileAltDown = false;
                    if (!MnemonicsManagerImpl.this.isActivated() && !this.isActivationPending() && MnemonicsManagerImpl.this.fSavedFocusedComponent == null) {
                        if (MnemonicsManagerImpl.hidePopups(keyEvent.getComponent())) {
                            this.iReleasedAltSinceActivating = true;
                        } else {
                            this.iPendingFocusOwner = component;
                            this.iPendingRoot = rootProvider;
                            this.iActivationTimer = new Timer(1000, this);
                            this.iActivationTimer.setRepeats(false);
                            this.iActivationTimer.start();
                            this.iReleasedAltSinceActivating = false;
                            MnemonicsManagerImpl.this.fActiveWindow = window;
                            MnemonicsManagerImpl.this.addWindowListeners();
                        }
                    }
                } else if (bl3) {
                    boolean bl5 = false;
                    if (!this.iReleasedAltSinceActivating) {
                        if (!MnemonicsManagerImpl.this.isActivated()) {
                            if (PlatformInfo.isWindowsClassicAppearance() && this.iActivationTimer != null) {
                                this.iActivationTimer.setInitialDelay(10);
                                this.iActivationTimer.restart();
                                bl5 = true;
                            } else {
                                MnemonicsManagerImpl.this.activate(component, rootProvider);
                            }
                        }
                        this.iReleasedAltSinceActivating = true;
                    } else if (MnemonicsManagerImpl.this.isActivated() && !this.iGotMatchWhileAltDown) {
                        MnemonicsManagerImpl.this.clear();
                    }
                    if (!bl5) {
                        this.cancelPendingActivation(MnemonicsManagerImpl.this.isActivated());
                    }
                }
                keyEvent.consume();
            } else if (n == 27) {
                if (bl2) {
                    this.iEscapeDown = true;
                    if (MnemonicsManagerImpl.this.isActivated()) {
                        if (!MnemonicsManagerImpl.this.fLevels.isEmpty()) {
                            MnemonicsManagerImpl.this.hide((MnemLevel)MnemonicsManagerImpl.this.fLevels.pop(), true, true).on((Callback)new Callback<Component>(){

                                public void complete(Component component) {
                                    if (MnemonicsManagerImpl.this.fLevels.isEmpty()) {
                                        MnemonicsManagerImpl.this.clear(true, true);
                                    } else {
                                        MnemonicsManagerImpl.this.show((MnemLevel)MnemonicsManagerImpl.this.fLevels.peek());
                                    }
                                }
                            });
                        }
                        keyEvent.consume();
                    } else if (rootProvider.isFocusOwner()) {
                        MnemonicsManagerImpl.this.restoreFocus();
                    }
                } else if (bl3) {
                    this.iEscapeDown = false;
                }
            } else if (this.isActivationPending() && keyEvent.isAltDown() && !MnemonicsManagerImpl.isAlphaNumKeyCode(n)) {
                this.iReleasedAltSinceActivating = true;
                this.cancelPendingActivation(true);
            } else {
                if (bl2 && keyEvent.isAltDown() && this.isActivationPending() && !this.iReleasedAltSinceActivating && InputMapUtils.hasEnabledBinding((Component)keyEvent.getComponent(), (KeyStroke)KeyStroke.getKeyStroke(n, keyEvent.getModifiers()))) {
                    this.cancelPendingActivation(false);
                    this.iReleasedAltSinceActivating = true;
                }
                if (this.isActivationPending()) {
                    this.iReleasedAltSinceActivating = false;
                    MnemonicsManagerImpl.this.activate(this.iPendingFocusOwner, this.iPendingRoot);
                    this.cancelPendingActivation(true);
                }
                if (MnemonicsManagerImpl.this.isActivated()) {
                    if (this.isNavigationKey(n)) {
                        if (MnemonicsManagerImpl.this.fLevels.size() <= 2 && InputMapUtils.hasEnabledBinding((Component)keyEvent.getComponent(), (KeyStroke)KeyStroke.getKeyStroke(n, keyEvent.getModifiers()))) {
                            boolean bl6 = !this.iReleasedAltSinceActivating;
                            MnemonicsManagerImpl.this.clear(bl6, bl6);
                            this.iReleasedAltSinceActivating = true;
                        }
                    } else if (bl) {
                        String string = String.valueOf(keyEvent.getKeyChar());
                        MnemLevel mnemLevel = (MnemLevel)MnemonicsManagerImpl.this.fLevels.peek();
                        String string2 = mnemLevel.fPrefix;
                        String string3 = (string2 + string).toUpperCase();
                        ArrayList arrayList = Lists.newArrayList();
                        ArrayList arrayList2 = Lists.newArrayList();
                        for (Mnem mnem : mnemLevel.mnems()) {
                            Mnemonic mnemonic = mnem.fMnemonic;
                            if (!mnemonic.getComponent().isVisible()) continue;
                            if (mnemonic.getMnemonic().toUpperCase().startsWith(string3)) {
                                arrayList.add(mnem);
                                continue;
                            }
                            arrayList2.add(mnem);
                        }
                        if (arrayList.isEmpty()) {
                            if (keyEvent.isAltDown() && !this.iEscapeDown) {
                                this.cancelPendingActivation(false);
                                MnemonicsManagerImpl.this.clear();
                                this.iReleasedAltSinceActivating = true;
                            }
                        } else if (arrayList.size() == 1 && ((Mnem)arrayList.get(0)).fMnemonic.getMnemonic().toUpperCase().equals(string3)) {
                            MnemonicsManagerImpl.this.select((Mnem)arrayList.get(0));
                            this.iGotMatchWhileAltDown = true;
                            keyEvent.consume();
                        } else {
                            mnemLevel.fPrefix = string3;
                            for (Mnem mnem : arrayList) {
                                mnem.enable();
                            }
                            for (Mnem mnem : arrayList2) {
                                mnem.disable();
                            }
                            for (Mnem mnem : mnemLevel.mnems()) {
                                mnem.update();
                            }
                            this.iGotMatchWhileAltDown = true;
                            keyEvent.consume();
                        }
                    }
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!MnemonicsManagerImpl.this.isActivated()) {
                MnemonicsManagerImpl.this.activate(this.iPendingFocusOwner, this.iPendingRoot);
            }
            this.cancelPendingActivation(true);
        }

        private boolean isActivationPending() {
            return this.iActivationTimer != null;
        }

        private void cancelPendingActivation(boolean bl) {
            if (this.iActivationTimer != null) {
                this.iActivationTimer.stop();
                this.iActivationTimer = null;
                this.iPendingFocusOwner = null;
                this.iPendingRoot = null;
                if (!bl) {
                    MnemonicsManagerImpl.this.removeWindowListeners();
                }
            }
        }

        private boolean isNavigationKey(int n) {
            return n == 37 || n == 39 || n == 38 || n == 40 || n == 9;
        }

        @Override
        public void windowGainedFocus(WindowEvent windowEvent) {
        }

        @Override
        public void windowLostFocus(WindowEvent windowEvent) {
            Window window = windowEvent.getOppositeWindow();
            if (window == null || WindowUtils.getFrameForComponent((Component)window) != MnemonicsManagerImpl.this.fActiveWindow) {
                this.cancelPendingActivation(false);
                MnemonicsManagerImpl.this.clear();
            }
        }

        public void framePressed(NativeEvent nativeEvent) {
            this.cancelPendingActivation(false);
            MnemonicsManagerImpl.this.clear();
        }

        public void frameReleased(NativeEvent nativeEvent) {
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
            if (!PlatformInfo.isLinux() || MnemonicsManagerImpl.this.fActiveWindow == null || !MnemonicsManagerImpl.this.fActiveWindow.getLocation().equals(MnemonicsManagerImpl.this.fInitialWindowLocation)) {
                MnemonicsManagerImpl.this.clear();
            }
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            MnemonicsManagerImpl.this.clear();
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
        }
    }

    private static class MnemonicComponent
    extends JComponent {
        private String fText;
        private static final int VGAP = 2;
        private static final int HGAP = 5;
        private static final Font MNEMONIC_FONT = new Font("Tahoma", 0, 12);
        private static final BasicStroke STROKE = new BasicStroke(1.0f);
        private static final Color BORDER_COLOR = new Color(0x303030);
        private static final Color CONTENT_COLOR = new Color(0xF0F0F0);

        private MnemonicComponent(String string) {
            this.fText = string;
            this.setOpaque(false);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setFont(MNEMONIC_FONT);
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            int n = this.getWidth();
            int n2 = this.getHeight();
            Rectangle rectangle = new Rectangle(0, 0, n - 1, n2 - 1);
            graphics2D.setColor(CONTENT_COLOR);
            graphics2D.fill(rectangle);
            graphics2D.setColor(BORDER_COLOR);
            graphics2D.setStroke(STROKE);
            graphics2D.draw(rectangle);
            int n3 = fontMetrics.stringWidth(this.fText);
            graphics2D.drawString(this.fText, (n - n3) / 2, (n2 - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent());
        }

        public Dimension calcSize() {
            FontMetrics fontMetrics = FontUtils.getFontMetrics((Font)MNEMONIC_FONT);
            return new Dimension(fontMetrics.stringWidth(this.fText) + 10, fontMetrics.getHeight() + 4);
        }
    }
}

