/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.desktop.overlay;

import com.mathworks.desktop.overlay.OverlayManager;
import com.mathworks.desktop.overlay.impl.DefaultOverlayManager;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Map;
import java.util.WeakHashMap;
import org.jetbrains.annotations.Nullable;

public class OverlayManagers {
    private static final OverlayManagerFactory DEFAULT_FACTORY;
    private static OverlayManagerFactory sFactory;

    private OverlayManagers() {
    }

    @Nullable
    public static OverlayManager get(Component component) {
        while (component != null) {
            if (component instanceof Window && component.getParent() == null) {
                return OverlayManagers.get((Window)component);
            }
            component = component.getParent();
        }
        return null;
    }

    private static OverlayManager get(Window window) {
        return sFactory.get(window);
    }

    public static void setFactory(OverlayManagerFactory overlayManagerFactory) {
        sFactory = overlayManagerFactory;
    }

    public static void setDefaultFactory() {
        OverlayManagers.setFactory(DEFAULT_FACTORY);
    }

    static {
        sFactory = DEFAULT_FACTORY = new DefaultFactory();
    }

    public static class DefaultFactory
    implements OverlayManagerFactory {
        private static final Map<Window, OverlayManager> sManagers = new WeakHashMap<Window, OverlayManager>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public OverlayManager get(final Window window) {
            Map<Window, OverlayManager> map = sManagers;
            synchronized (map) {
                OverlayManager overlayManager = sManagers.get(window);
                if (overlayManager == null && DefaultOverlayManager.isSupported(window)) {
                    overlayManager = new DefaultOverlayManager(window);
                    window.addWindowListener(new WindowAdapter(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void windowClosed(WindowEvent windowEvent) {
                            Map map = sManagers;
                            synchronized (map) {
                                sManagers.remove(window);
                            }
                        }
                    });
                    sManagers.put(window, overlayManager);
                }
                return overlayManager;
            }
        }
    }

    public static interface OverlayManagerFactory {
        public OverlayManager get(Window var1);
    }
}

