/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.DFormElement;
import ice.pilots.html4.MultipartEncoder;
import ice.storm.ContentLoader;
import ice.util.net.URLEncoder;
import java.io.File;

class FormSubmitData {
    private boolean multipartFormData;
    private boolean post;
    private MultipartEncoder encoder;
    private StringBuffer dataToSubmit;
    private DFormElement formElement;

    FormSubmitData(boolean bl) {
        this(bl, true, null);
    }

    FormSubmitData(boolean bl, boolean bl2) {
        this(bl, bl2, null);
    }

    FormSubmitData(boolean bl, boolean bl2, DFormElement dFormElement) {
        this.multipartFormData = bl;
        this.post = bl2;
        this.formElement = dFormElement;
        this.dataToSubmit = new StringBuffer(100);
        if (this.multipartFormData && this.post) {
            this.encoder = new MultipartEncoder();
        }
    }

    void appendFileData(String string, String string2) {
        if (string == null || string.length() == 0 || string2 == null) {
            return;
        }
        if (this.multipartFormData && this.post) {
            this.encoder.appendFile(string, string2);
        } else {
            this.appendData(string, string2 != null ? new File(string2).getName() : "");
        }
    }

    void appendData(String string, String string2) {
        if (string == null || string.length() == 0 || string2 == null) {
            return;
        }
        if (this.multipartFormData && this.post) {
            this.encoder.appendData(string, string2);
        } else {
            if (this.dataToSubmit.length() > 0) {
                this.dataToSubmit.append("&");
            }
            String string3 = null;
            if (this.formElement != null) {
                string3 = this.formElement.doc.getDefaultCharset();
            }
            this.dataToSubmit.append(URLEncoder.encode((String)string, (String)string3));
            this.dataToSubmit.append("=");
            this.dataToSubmit.append(URLEncoder.encode((String)string2, (String)string3));
        }
    }

    void prepareContentLoader(ContentLoader contentLoader) {
        if (this.multipartFormData && this.post) {
            contentLoader.setPostStream(this.encoder.getHeader(), this.encoder);
        } else {
            contentLoader.setPostData("application/x-www-form-urlencoded", this.dataToSubmit.toString().getBytes());
        }
    }

    String toLocationSearchPart() {
        if (this.multipartFormData && this.post) {
            return "";
        }
        return this.dataToSubmit.toString();
    }
}

