/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4.swing;

import ice.debug.Debug;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.DOMUIEvent;
import ice.pilots.html4.DocPaneXml;
import ice.pilots.html4.EmbeddedObject;
import ice.pilots.html4.ObjectBox;
import ice.pilots.html4.ObjectPainter;
import ice.pilots.html4.ScrollBox;
import ice.pilots.html4.ScrollHandler;
import ice.pilots.html4.swing.BufferedHeavyweightPanel;
import ice.pilots.html4.swing.DocPanel;
import ice.pilots.html4.swing.EmbeddedObjectContainer;
import ice.pilots.html4.swing.FormInputButton;
import ice.pilots.html4.swing.FormInputCheckbox;
import ice.pilots.html4.swing.FormInputPasswordText;
import ice.pilots.html4.swing.FormInputRadio;
import ice.pilots.html4.swing.FormInputText;
import ice.pilots.html4.swing.FormInputUpload;
import ice.pilots.html4.swing.FormSelectChoice;
import ice.pilots.html4.swing.FormSelectChoicePre14;
import ice.pilots.html4.swing.FormSelectList;
import ice.pilots.html4.swing.FormTextArea;
import ice.pilots.html4.swing.PanePanel;
import ice.pilots.html4.swing.Scroller;
import ice.pilots.html4.swing.TheFactory;
import ice.storm.ViewportLayoutManager;
import ice.util.Defs;
import ice.util.JavaVersion;
import ice.util.alg.HashArray;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.accessibility.AccessibleContext;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.w3c.dom.events.EventListener;

final class DocView
extends DocPaneXml
implements AdjustmentListener {
    TheFactory factory;
    PanePanel _panePanel;
    JScrollBar vbar;
    JScrollBar hbar;
    DocPanel docPanel;
    boolean fVerticalScrollbarSpacer = false;
    JPanel spacer;
    JPanel southPanel;
    JPanel eastPanel;
    Color spacerBackColor;
    BufferedHeavyweightPanel heavyPanel = null;
    private ScrollHandler scrollHandler;
    boolean cursorChange = true;
    private boolean scrollbarEast = true;
    private final HashArray cgs = new HashArray();
    private final HashArray cgs_none = new HashArray();
    int validateTreeNesting = 0;
    public static final String ACCESSIBILITY_NONE = "none";
    public static final String ACCESSIBILITY_JAVA = "java";
    public static final String ACCESSIBILITY_JAWS = "jaws";
    static String accessibility = "none";
    static boolean isAccessible = false;
    static int headlessLayoutWidth = 800;
    static int headlessLayoutHeight = 800;

    DocView(TheFactory theFactory) {
        this.factory = theFactory;
    }

    protected void init(int n) {
        boolean bl;
        this.docPanel = new DocPanel(this);
        this._panePanel = new PanePanel(this);
        this._panePanel.setLayout(new BorderLayout());
        this._panePanel.setOpaque(true);
        boolean bl2 = Defs.sysPropertyBoolean((String)"ice.pilots.html4.scrollbars", (boolean)true);
        String string = Defs.sysProperty((String)"ice.pilots.html4.verticalScrollbarSpacer", (String)"0");
        int n2 = Integer.parseInt(string);
        boolean bl3 = this.fVerticalScrollbarSpacer = n2 == 1;
        if (bl2 && n != 2) {
            this.vbar = new JScrollBar(1);
            this.hbar = new JScrollBar(0);
        }
        if (bl = Defs.sysPropertyBoolean((String)"ice.pilots.html4.swing.heavy")) {
            this.heavyPanel = new BufferedHeavyweightPanel();
            this.heavyPanel.getContentPane().setLayout(new BorderLayout());
            this._panePanel.add((Component)this.heavyPanel, "Center");
            this.heavyPanel.getContentPane().add(this.docPanel);
        } else {
            this._panePanel.add((Component)this.docPanel, "Center");
        }
        if (this.vbar != null) {
            if (this.fVerticalScrollbarSpacer) {
                this.eastPanel = new JPanel(new BorderLayout());
                this.eastPanel.add((Component)this.vbar, "Center");
                this.eastPanel.setBackground(Color.white);
                this._panePanel.add((Component)this.eastPanel, "East");
                this.spacer = new JPanel();
                this.spacer.setPreferredSize(new Dimension(this.hbar.getPreferredSize().height, this.vbar.getPreferredSize().width));
                this.southPanel = new JPanel(new BorderLayout());
                this.southPanel.add((Component)this.hbar, "Center");
                this.southPanel.add((Component)this.spacer, "East");
                this._panePanel.add((Component)this.southPanel, "South");
            } else {
                this._panePanel.add((Component)this.vbar, "East");
                this._panePanel.add((Component)this.hbar, "South");
            }
            this.vbar.addAdjustmentListener(this);
            this.hbar.addAdjustmentListener(this);
            this.initMouseWheelSupport();
        }
        this.cursorChange = Defs.sysPropertyBoolean((String)"ice.pilots.html4.cssCursor", (boolean)this.cursorChange);
    }

    private void initMouseWheelSupport() {
        block7: {
            try {
                Class<?> clazz = Class.forName("java.awt.event.MouseWheelEvent");
                try {
                    String string = "ice.util.swing.jdk14.SwingMouseWheelListener";
                    Constructor<?> constructor = Class.forName(string).getConstructors()[0];
                    Object[] objectArray = new Object[]{this.vbar, this.hbar};
                    java.util.EventListener eventListener = null;
                    eventListener = (java.util.EventListener)constructor.newInstance(objectArray);
                    this.addMouseWheelListenerReflectively(eventListener, this.docPanel);
                    this.addMouseWheelListenerReflectively(eventListener, this.vbar);
                    this.addMouseWheelListenerReflectively(eventListener, this.hbar);
                    if (Debug.trace) {
                        Debug.trace((String)"MouseWheel support found and configured.");
                    }
                }
                catch (Throwable throwable) {
                    if (Debug.trace) {
                        Debug.trace((String)"MouseWheel support found, but error occurred during configuration.");
                    }
                    if (Debug.ex) {
                        Debug.ex((Throwable)throwable);
                    }
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (!Debug.trace) break block7;
                Debug.trace((String)"MouseWheel support not found.");
            }
        }
    }

    private void addMouseWheelListenerReflectively(Object object, Object object2) throws Throwable {
        Class<?> clazz = object2.getClass();
        Class[] classArray = new Class[]{Class.forName("java.awt.event.MouseWheelListener")};
        Method method = clazz.getMethod("addMouseWheelListener", classArray);
        method.invoke(object2, object);
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.docPanel.scroll(this.hbar.getValue(), this.vbar.getValue());
    }

    public void updateScrollbars(boolean bl) {
        if (this.vbar == null) {
            return;
        }
        if (bl) {
            if (this.scrollbarEast) {
                this._panePanel.remove(this.vbar);
                this._panePanel.add((Component)this.vbar, "West");
                this.scrollbarEast = false;
            }
        } else if (!this.scrollbarEast) {
            this._panePanel.remove(this.vbar);
            this._panePanel.add((Component)this.vbar, "East");
            this.scrollbarEast = true;
        }
    }

    public int getScrollX() {
        return this.docPanel.sx;
    }

    public int getScrollY() {
        return this.docPanel.sy;
    }

    public int getPaneWidth() {
        return this.docPanel.getSize().width;
    }

    public int getPaneHeight() {
        return this.docPanel.getSize().height;
    }

    public void setScrollPosition(int n, int n2) {
        if (this.vbar != null) {
            this.hbar.setValue(this.getScrollX(n));
            this.vbar.setValue(this.getScrollY(n2));
        } else {
            this.docPanel.scroll(this.getScrollX(n), this.getScrollY(n2));
        }
    }

    public void setPaneBounds(int n, int n2, int n3, int n4) {
        this._panePanel.setBounds(n, n2, n3, n4);
    }

    public void revalidate() {
        if (!this.docPanel.isShowing()) {
            this.docPanel.doLayout(headlessLayoutWidth, headlessLayoutHeight);
            return;
        }
        this.docPanel.invalidate();
        if (this.heavyPanel != null) {
            this.heavyPanel.invalidate();
        }
        this._panePanel.revalidate();
        this._panePanel.repaint();
        if (this.heavyPanel != null) {
            this.heavyPanel.repaint();
        }
    }

    public void reqRepaint() {
        this.docPanel.repaint();
    }

    public void reqRepaint(int n, int n2, int n3, int n4) {
        n2 -= this.getScrollY();
        if ((n -= this.getScrollX()) < 0) {
            if (n + n3 <= 0) {
                return;
            }
            n3 += n;
            n = 0;
        }
        if (n2 < 0) {
            if (n2 + n4 <= 0) {
                return;
            }
            n4 += n2;
            n2 = 0;
        }
        int n5 = this.getPaneWidth();
        int n6 = this.getPaneHeight();
        if (n >= n5 || n2 >= n6) {
            return;
        }
        if (n + n3 > n5) {
            n3 = n5 - n;
        }
        if (n2 + n4 > n6) {
            n4 = n6 - n2;
        }
        if (n3 > 0 && n4 > 0) {
            this.docPanel.repaint(n, n2, n3, n4);
        }
    }

    public void reqClear() {
        this.docPanel.removeAll();
        this.docPanel.sy = 0;
        this.docPanel.sx = 0;
        this.docPanel.nsy = 0;
        this.docPanel.nsx = 0;
        if (this.vbar != null) {
            this.vbar.setValue(0);
            this.hbar.setValue(0);
        }
    }

    public void setAutoRepaint(boolean bl) {
    }

    public boolean doesAutoRepaint() {
        return false;
    }

    public void setCursor(int n) {
        if (this.cursorChange) {
            final Cursor cursor = Cursor.getPredefinedCursor(n);
            if (SwingUtilities.isEventDispatchThread()) {
                this.docPanel.setCursor(cursor);
            } else {
                Runnable runnable = new Runnable(){

                    public void run() {
                        DocView.this.docPanel.setCursor(cursor);
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        }
    }

    public Image createImage(int n, int n2) {
        return this._panePanel.createImage(n, n2);
    }

    protected Component getPaneComponent() {
        return this._panePanel;
    }

    public void setCursorChangeable(boolean bl) {
        this.cursorChange = bl;
    }

    protected ObjectPainter createFormControl(DElement dElement) {
        JComponent jComponent = null;
        String string = dElement.getTagName();
        if (string.equalsIgnoreCase("input")) {
            String string2 = dElement.getAttribute("type");
            if (string2 == null || string2.equalsIgnoreCase("text")) {
                jComponent = new FormInputText(this, dElement);
            } else if (string2.equalsIgnoreCase("password")) {
                jComponent = new FormInputPasswordText(this, dElement);
            } else if (string2.equalsIgnoreCase("button")) {
                jComponent = new FormInputButton(this, dElement, "button");
            } else if (string2.equalsIgnoreCase("submit")) {
                jComponent = new FormInputButton(this, dElement, "submit");
            } else if (string2.equalsIgnoreCase("reset")) {
                jComponent = new FormInputButton(this, dElement, "reset");
            } else if (string2.equalsIgnoreCase("checkbox")) {
                jComponent = new FormInputCheckbox(this, dElement);
            } else if (string2.equalsIgnoreCase("file")) {
                jComponent = new FormInputUpload(this, dElement);
            } else if (string2.equalsIgnoreCase("radio")) {
                JRadioButton jRadioButton = null;
                ButtonGroup buttonGroup = null;
                String string3 = dElement.getAttribute("name");
                if (string3 != null) {
                    jRadioButton = (JRadioButton)this.cgs_none.get((Object)string3);
                    buttonGroup = (ButtonGroup)this.cgs.get((Object)string3);
                    if (buttonGroup == null) {
                        buttonGroup = new ButtonGroup();
                        jRadioButton = new JRadioButton();
                        buttonGroup.add(jRadioButton);
                        this.cgs.put((Object)string3, (Object)buttonGroup);
                        this.cgs_none.put((Object)string3, (Object)jRadioButton);
                    }
                }
                jComponent = new FormInputRadio(this, dElement, jRadioButton, buttonGroup);
            }
        } else if (string.equalsIgnoreCase("textarea")) {
            jComponent = new FormTextArea(this, dElement);
        } else if (string.equalsIgnoreCase("select")) {
            int n = dElement.getAttributeAsInt("size");
            if (n <= 1) {
                jComponent = JavaVersion.isV14orGreater() ? new FormSelectChoice(this, dElement) : new FormSelectChoicePre14(this, dElement);
                if (this.heavyPanel != null) {
                    ((JComboBox)jComponent).setLightWeightPopupEnabled(false);
                }
            } else {
                jComponent = new FormSelectList(this, dElement, n);
            }
        }
        if (jComponent != null) {
            ((Component)jComponent).setVisible(false);
            this.docPanel.add(jComponent);
            if (isAccessible) {
                this.setComponentAccessibleName(dElement, jComponent);
                jComponent.getAccessibleContext().setAccessibleParent(this.docPanel);
            }
        }
        return (ObjectPainter)((Object)jComponent);
    }

    private void setComponentAccessibleName(DElement dElement, Component component) {
        String string = dElement.getName();
        AccessibleContext accessibleContext = component.getAccessibleContext();
        if (accessibleContext != null && string != null && string != null) {
            accessibleContext.setAccessibleName(string);
        }
    }

    protected ObjectPainter createScroller() {
        Scroller scroller = new Scroller(this);
        this.docPanel.add(scroller);
        return scroller;
    }

    protected Container createEmbeddedContainer(EmbeddedObject embeddedObject, Component component) {
        EmbeddedObjectContainer embeddedObjectContainer = new EmbeddedObjectContainer(embeddedObject);
        embeddedObjectContainer.setLayout(new ViewportLayoutManager(embeddedObject));
        embeddedObjectContainer.setSize(embeddedObject.getPrefWidth(), embeddedObject.getPrefHeight());
        embeddedObjectContainer.add(component);
        this.docPanel.add(embeddedObjectContainer);
        ((JComponent)embeddedObjectContainer.getParent()).revalidate();
        return embeddedObjectContainer;
    }

    protected Component createFramesDividerComponent() {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(new Color(200, 200, 200));
        return jPanel;
    }

    protected void checkAwtTree(ObjectBox objectBox, Component component) {
        if (objectBox == null) {
            return;
        }
        ScrollBox scrollBox = objectBox.getAncestorScrollBox();
        if (scrollBox == null) {
            if (this.docPanel != component.getParent()) {
                this.docPanel.add(component);
            }
        } else {
            ObjectBox objectBox2 = scrollBox.getObjectBox();
            ObjectPainter objectPainter = objectBox2.getObjectPainter();
            if (objectPainter instanceof Scroller) {
                Scroller scroller = (Scroller)objectPainter;
                scroller.getView().add(component);
            }
        }
    }

    private DOMUIEvent _translateMouseEvent(MouseEvent mouseEvent) {
        DOMUIEvent dOMUIEvent = null;
        int n = this._translateX(mouseEvent);
        int n2 = this._translateY(mouseEvent);
        int n3 = -1;
        switch (mouseEvent.getID()) {
            case 504: {
                n3 = 5;
                break;
            }
            case 505: {
                n3 = 7;
                break;
            }
            case 500: {
                break;
            }
            case 501: {
                n3 = 3;
                break;
            }
            case 502: {
                n3 = 4;
                break;
            }
            case 503: 
            case 506: {
                n3 = 6;
            }
        }
        if (n3 >= 0) {
            dOMUIEvent = this.createDomUIEvent(n3);
            dOMUIEvent.setClientCoords(n, n2, this.docPanel.sx, this.docPanel.sy);
            try {
                Component component = mouseEvent.getComponent();
                if (component.isShowing()) {
                    Point point = component.getLocationOnScreen();
                    dOMUIEvent.setScreenCoords(point.x + mouseEvent.getX(), point.y + mouseEvent.getY());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return dOMUIEvent;
    }

    private int _translateX(MouseEvent mouseEvent) {
        int n = 0;
        for (Component component = mouseEvent.getComponent(); component != null && component != this.docPanel; component = component.getParent()) {
            Point point = component.getLocation();
            n += point.x;
        }
        return mouseEvent.getX() + n;
    }

    private int _translateY(MouseEvent mouseEvent) {
        int n = 0;
        for (Component component = mouseEvent.getComponent(); component != null && component != this.docPanel; component = component.getParent()) {
            Point point = component.getLocation();
            n += point.y;
        }
        return mouseEvent.getY() + n;
    }

    final boolean onComponentEvent(Component component, AWTEvent aWTEvent) {
        return this.onComponentEvent(component, aWTEvent, null);
    }

    boolean onComponentEvent(Component component, AWTEvent aWTEvent, EventListener eventListener) {
        if (!this.checkDocumentId()) {
            return false;
        }
        int n = aWTEvent.getID();
        if (500 <= n && n <= 507) {
            return this.onComponentMouseEvent(component, (MouseEvent)aWTEvent, eventListener);
        }
        if (400 <= n && n <= 402) {
            return this.processAwtKeyEvent(component, (KeyEvent)aWTEvent, eventListener);
        }
        if (1004 == n) {
            this.notifyFocusGain();
        } else if (1005 == n) {
            this.notifyFocusLost();
        }
        return true;
    }

    protected boolean onComponentMouseEvent(Component component, MouseEvent mouseEvent, EventListener eventListener) {
        DOMUIEvent dOMUIEvent = this._translateMouseEvent(mouseEvent);
        if (dOMUIEvent != null) {
            int n = dOMUIEvent.getTypeId();
            int n2 = dOMUIEvent.getPosX();
            int n3 = dOMUIEvent.getPosY();
            return this.uiEvent(dOMUIEvent, mouseEvent, eventListener);
        }
        return true;
    }

    protected void onNodeSelectCall(DNode dNode) {
        ObjectPainter objectPainter = this.getNodePainter(dNode);
        if (objectPainter instanceof Component) {
            Component component = (Component)((Object)objectPainter);
            if (component instanceof JScrollPane) {
                component = ((JScrollPane)component).getViewport().getView();
            }
            if (component instanceof JTextComponent) {
                ((JTextComponent)component).selectAll();
            }
        }
    }

    protected void onNodeBlurEvent(DOMUIEvent dOMUIEvent, DNode dNode) {
        ObjectPainter objectPainter = this.getNodePainter(dNode);
        if (objectPainter instanceof Component && dOMUIEvent.getRelatedTarget() == null) {
            ((Component)((Object)objectPainter)).getParent().requestFocus();
        }
    }

    protected void onNodeFocusEvent(DOMUIEvent dOMUIEvent, DNode dNode) {
        ObjectPainter objectPainter = this.getNodePainter(dNode);
        if (objectPainter instanceof Component) {
            Component component = (Component)((Object)objectPainter);
            if (component instanceof JScrollPane) {
                component = ((JScrollPane)component).getViewport().getView();
            }
            component.requestFocus();
        }
    }

    public void reqFocus() {
        this.docPanel.requestFocus();
    }

    static {
        accessibility = Defs.sysProperty((String)"ice.pilots.html4.swing.accessible", (String)ACCESSIBILITY_NONE);
        if (accessibility.equalsIgnoreCase(ACCESSIBILITY_JAVA) || accessibility.equalsIgnoreCase(ACCESSIBILITY_JAWS)) {
            isAccessible = true;
        }
        String string = Defs.sysProperty((String)"ice.pilots.html4.swing.headlessWidth", (String)"800");
        try {
            headlessLayoutWidth = Integer.parseInt(string);
            if (headlessLayoutWidth < 0) {
                headlessLayoutWidth = 200;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        string = Defs.sysProperty((String)"ice.pilots.html4.swing.headlessHeight", (String)"800");
        try {
            headlessLayoutHeight = Integer.parseInt(string);
            if (headlessLayoutHeight < 0) {
                headlessLayoutHeight = 200;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

