/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.matlab.guide.action;

import com.mathworks.common.icons.CommonIcon;
import com.mathworks.common.icons.DebuggingIcon;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.toolbox.matlab.guide.LayoutEditor;
import com.mathworks.toolbox.matlab.guide.ResourceManager;
import com.mathworks.toolbox.matlab.guide.action.LayoutAction;
import com.mathworks.toolbox.matlab.guide.action.LayoutActionEnum;
import com.mathworks.toolbox.matlab.guide.action.RegisteredToolAction;
import com.mathworks.toolbox.matlab.guide.icons.GuideIcon;
import com.mathworks.toolbox.matlab.guide.layouttool.LayoutToolInfo;
import com.mathworks.toolbox.matlab.guide.layouttool.LayoutToolRegistry;
import java.awt.Toolkit;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public class LayoutActionManager {
    public static final int FIRST_REGISTERED_TOOL = 10000;
    private Map<Integer, MJAbstractAction> fActionMap;
    private LayoutEditor fEditor;

    public LayoutActionManager(LayoutEditor layoutEditor) {
        this.fEditor = layoutEditor;
        this.fActionMap = new HashMap<Integer, MJAbstractAction>(60);
        this.createStandardActions();
        this.createRegisteredToolActions();
    }

    public MJAbstractAction getAction(LayoutActionEnum layoutActionEnum) {
        return this.fActionMap.get(layoutActionEnum.ordinal());
    }

    public MJAbstractAction getAction(int n) {
        return this.fActionMap.get(n);
    }

    public LayoutEditor getLayoutEditor() {
        return this.fEditor;
    }

    private void createStandardActions() {
        this.createFileActions();
        this.createEditActions();
        this.createViewActions();
        this.createLayoutActions();
        this.createToolsActions();
        this.createHelpActions();
        this.createOtherActions();
    }

    private void createFileActions() {
        int n = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this.addAction(LayoutActionEnum.NEW, ResourceManager.getString("menu.new"), KeyStroke.getKeyStroke(78, n), CommonIcon.NEW.getIcon(), ResourceManager.getString("tip.new"));
        this.addAction(LayoutActionEnum.OPEN, ResourceManager.getString("menu.open"), KeyStroke.getKeyStroke(79, n), CommonIcon.OPEN.getIcon(), ResourceManager.getString("tip.open"));
        this.addAction(LayoutActionEnum.CLOSE, ResourceManager.getString("menu.close"), KeyStroke.getKeyStroke(87, n), null, ResourceManager.getString("tip.close"));
        this.addAction(LayoutActionEnum.SAVE, ResourceManager.getString("menu.save"), KeyStroke.getKeyStroke(83, n), CommonIcon.SAVE.getIcon(), ResourceManager.getString("tip.save"));
        this.addAction(LayoutActionEnum.SAVE_AS, ResourceManager.getString("menu.save_as"), null, null, ResourceManager.getString("tip.save_as"));
        this.addAction(LayoutActionEnum.GUI_EXPORT, ResourceManager.getString("menu.export"), null, null, ResourceManager.getString("tip.export"));
        this.addAction(LayoutActionEnum.PREFERENCES, ResourceManager.getString("menu.prefs"), null, null, ResourceManager.getString("tip.prefs"));
        this.addAction(LayoutActionEnum.PRINT, ResourceManager.getString("menu.print"), KeyStroke.getKeyStroke(80, n), CommonIcon.PRINT.getIcon(), ResourceManager.getString("tip.print"));
    }

    private void createEditActions() {
        int n = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this.addAction(LayoutActionEnum.UNDO, ResourceManager.getString("menu.undo"), KeyStroke.getKeyStroke(90, n), CommonIcon.UNDO.getIcon(), ResourceManager.getString("tip.undo"));
        this.addAction(LayoutActionEnum.REDO, ResourceManager.getString("menu.redo"), KeyStroke.getKeyStroke(89, n), CommonIcon.REDO.getIcon(), ResourceManager.getString("tip.redo"));
        this.addAction(LayoutActionEnum.CUT, ResourceManager.getString("menu.cut"), KeyStroke.getKeyStroke(88, n), CommonIcon.CUT.getIcon(), ResourceManager.getString("tip.cut"));
        this.addAction(LayoutActionEnum.COPY, ResourceManager.getString("menu.copy"), KeyStroke.getKeyStroke(67, n), CommonIcon.COPY.getIcon(), ResourceManager.getString("tip.copy"));
        this.addAction(LayoutActionEnum.PASTE, ResourceManager.getString("menu.paste"), KeyStroke.getKeyStroke(86, n), CommonIcon.PASTE.getIcon(), ResourceManager.getString("tip.paste"));
        this.addAction(LayoutActionEnum.CLEAR, ResourceManager.getString("menu.clear"), null, null, ResourceManager.getString("tip.clear"));
        this.addAction(LayoutActionEnum.SELECT_ALL, ResourceManager.getString("menu.select_all"), KeyStroke.getKeyStroke(65, n), null, ResourceManager.getString("tip.select_all"));
        this.addAction(LayoutActionEnum.DUPLICATE, ResourceManager.getString("menu.duplicate"), KeyStroke.getKeyStroke(68, n), null, ResourceManager.getString("tip.duplicate"));
    }

    private void createViewActions() {
        this.addAction(LayoutActionEnum.PROPERTY_INSPECTOR, ResourceManager.getString("menu.property_inspector"), null, GuideIcon.PROPERTY_INSPECTOR.getIcon(), ResourceManager.getString("tip.property_inspector"));
        this.addAction(LayoutActionEnum.OBJECT_BROWSER, ResourceManager.getString("menu.object_browser"), null, GuideIcon.OBJECT_BROWSER.getIcon(), ResourceManager.getString("tip.object_browser"));
        this.addAction(LayoutActionEnum.MFILE_EDITOR, ResourceManager.getString("menu.matlab_editor"), null, GuideIcon.MFILE_EDITOR.getIcon(), ResourceManager.getString("tip.matlab_editor"));
        this.addAction(LayoutActionEnum.SHOW_TOOLBAR, ResourceManager.getString("menu.show_toolbar"), null, null, ResourceManager.getString("tip.show_toolbar"));
        this.addAction(LayoutActionEnum.SHOW_STATUSBAR, ResourceManager.getString("menu.show_statusbar"), null, null, ResourceManager.getString("tip.show_statusbar"));
    }

    private void createLayoutActions() {
        int n = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this.addAction(LayoutActionEnum.SNAP_TO_GRID, ResourceManager.getString("menu.snap_to_grid"), null, null, ResourceManager.getString("tip.snap_to_grid"));
        this.addAction(LayoutActionEnum.MOVE_TO_FRONT, ResourceManager.getString("menu.bring_to_front"), KeyStroke.getKeyStroke(70, n), null, ResourceManager.getString("tip.bring_to_front"));
        this.addAction(LayoutActionEnum.MOVE_TO_BACK, ResourceManager.getString("menu.send_to_back"), KeyStroke.getKeyStroke(66, n), null, ResourceManager.getString("tip.send_to_back"));
        this.addAction(LayoutActionEnum.MOVE_FORWARD, ResourceManager.getString("menu.bring_forward"), null, null, ResourceManager.getString("tip.bring_forward"));
        this.addAction(LayoutActionEnum.MOVE_BACKWARD, ResourceManager.getString("menu.send_backward"), null, null, ResourceManager.getString("tip.send_backward"));
    }

    private void createToolsActions() {
        int n = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this.addAction(LayoutActionEnum.RUN, ResourceManager.getString("menu.run"), KeyStroke.getKeyStroke(84, n), DebuggingIcon.PLAY.getIcon(), ResourceManager.getString("tip.run"));
        this.addAction(LayoutActionEnum.ALIGN_OBJECTS, ResourceManager.getString("menu.align_objects"), null, GuideIcon.ALIGN_OBJECTS.getIcon(), ResourceManager.getString("tip.align_objects"));
        this.addAction(LayoutActionEnum.GRID_RULERS, ResourceManager.getString("menu.grid_and_rulers"), null, null, ResourceManager.getString("tip.grid_and_rulers"));
        this.addAction(LayoutActionEnum.MENU_EDITOR, ResourceManager.getString("menu.menubar"), null, GuideIcon.MENU_EDITOR.getIcon(), ResourceManager.getString("tip.edit_menubar"));
        this.addAction(LayoutActionEnum.TAB_ORDER, ResourceManager.getString("menu.tabeditor"), null, GuideIcon.TAB_ORDER_EDITOR.getIcon(), ResourceManager.getString("tip.edit_tab_order"));
        this.addAction(LayoutActionEnum.APP_OPTIONS, ResourceManager.getString("menu.gui_options"), null, null, ResourceManager.getString("tip.gui_options"));
        this.addAction(LayoutActionEnum.EDIT_PROPERTIES, ResourceManager.getString("menu.edit_properties"), null, null, ResourceManager.getString("tip.edit_properties"));
    }

    private void createHelpActions() {
        this.addAction(LayoutActionEnum.GETTING_STARTED, ResourceManager.getString("menu.getting_Started"), null, null, ResourceManager.getString("tip.getting_Started"));
        this.addAction(LayoutActionEnum.HELP_LAYING_OUT_GUIS, ResourceManager.getString("menu.laying_Out_GUIS"), null, null, ResourceManager.getString("tip.laying_Out_GUIS"));
        this.addAction(LayoutActionEnum.HELP_PROGRAMMING_GUIS, ResourceManager.getString("menu.programming_GUIS"), null, null, ResourceManager.getString("tip.programming_GUIS"));
        this.addAction(LayoutActionEnum.EXAMPLE_GUIS, ResourceManager.getString("menu.example_GUIS"), null, null, ResourceManager.getString("tip.example_GUIS"));
        this.addAction(LayoutActionEnum.ONLINE_VIDEOS, ResourceManager.getString("menu.online_Videos"), null, null, ResourceManager.getString("tip.online_Videos"));
    }

    private void createOtherActions() {
        this.addAction(LayoutActionEnum.CALLBACK_CMDS, ResourceManager.getString("menu.view_callbacks"), null, null, ResourceManager.getString("tip.view_callbacks"));
        this.addAction(LayoutActionEnum.CONTENT_CHANGED, LayoutActionEnum.CONTENT_CHANGED.name(), null, null, LayoutActionEnum.CONTENT_CHANGED.name());
    }

    private void addAction(LayoutActionEnum layoutActionEnum, String string, KeyStroke keyStroke, Icon icon, String string2) {
        LayoutAction layoutAction = new LayoutAction(this.fEditor, layoutActionEnum, string);
        layoutAction.setAccelerator(keyStroke);
        layoutAction.setButtonOnlyIcon(icon);
        layoutAction.setTip(string2);
        layoutAction.setEnabled(layoutActionEnum.getDefaultEnabledState());
        if (layoutAction.getName() != null) {
            layoutAction.setComponentName(layoutAction.getName());
        }
        this.fActionMap.put(layoutActionEnum.ordinal(), layoutAction);
    }

    private void createRegisteredToolActions() {
        LayoutToolInfo[] layoutToolInfoArray = LayoutToolRegistry.getTools();
        for (int i = 0; i < layoutToolInfoArray.length; ++i) {
            int n = 10000 + i;
            RegisteredToolAction registeredToolAction = new RegisteredToolAction(this.fEditor, n, layoutToolInfoArray[i].getName() + "...");
            registeredToolAction.setButtonOnlyIcon(layoutToolInfoArray[i].getIcon());
            registeredToolAction.setTip(layoutToolInfoArray[i].getName());
            this.fActionMap.put(n, registeredToolAction);
        }
    }
}

