/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.matlab.guide.objectbrowser;

import com.jgoodies.forms.factories.Borders;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.mlservices.MLInspectorServices;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJTree;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.services.ObjectRegistry;
import com.mathworks.services.ObjectRegistryEvent;
import com.mathworks.services.ObjectRegistryListener;
import com.mathworks.toolbox.matlab.guide.objectbrowser.ObjectNodeUtils;
import com.mathworks.toolbox.matlab.guide.objectbrowser.ObjectTreeNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ObjectView
extends MJPanel {
    private static final int ADD_AT_END = Integer.MIN_VALUE;
    private ObjectRegistry fRegistry;
    private RegistryHandler fRegistryHandler = new RegistryHandler();
    private MJTree fTree = new MJTree((TreeModel)new DefaultTreeModel(new ObjectTreeNode(null, -100)));
    private int fUniqueID;
    private Hashtable<Integer, ObjectTreeNode> fTreeNodes;
    private static boolean fInitSize = true;

    public ObjectView(ObjectRegistry objectRegistry) {
        this.fTree.setRootVisible(false);
        this.fTree.setShowsRootHandles(true);
        this.fTree.setExpandsSelectedPaths(false);
        this.fTree.setCellRenderer((TreeCellRenderer)new ObjectTreeCellRenderer());
        this.fTree.getSelectionModel().setSelectionMode(4);
        this.fTree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                super.mouseClicked(mouseEvent);
                if (mouseEvent.getClickCount() == 1) {
                    ObjectView.this.updateRegistrySelections();
                } else if (mouseEvent.getClickCount() == 2) {
                    MLInspectorServices.activateInspector();
                }
            }
        });
        this.fTree.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                switch (keyEvent.getKeyCode()) {
                    case 10: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: {
                        ObjectView.this.updateRegistrySelections();
                        break;
                    }
                }
            }
        });
        MJScrollPane mJScrollPane = new MJScrollPane((Component)this.fTree);
        mJScrollPane.setBorder(Borders.EMPTY_BORDER);
        this.setLayout(new BorderLayout());
        this.add((Component)mJScrollPane, "Center");
        this.fUniqueID = 0;
        this.fTreeNodes = new Hashtable();
        this.setRegistry(objectRegistry);
        this.populate();
        this.fTree.scrollRowToVisible(0);
    }

    MJTree getObjectTree() {
        return this.fTree;
    }

    private void updateRegistrySelections() {
        Object[] objectArray = this.getSelectedObjects();
        if (this.fRegistry != null) {
            this.fRegistry.setSelected(objectArray, true, true);
        }
    }

    public void setRegistry(ObjectRegistry objectRegistry) {
        if (this.fRegistry != null) {
            this.fRegistry.removeItemListener((ItemListener)this.fRegistryHandler);
            this.fRegistry.removeObjectRegistryListener((ObjectRegistryListener)this.fRegistryHandler);
        }
        if (objectRegistry != null) {
            objectRegistry.addItemListener((ItemListener)this.fRegistryHandler);
            objectRegistry.addObjectRegistryListener((ObjectRegistryListener)this.fRegistryHandler);
        }
        this.fRegistry = objectRegistry;
    }

    public Dimension getPreferredSize() {
        int n = 18 * this.fTree.getRowHeight();
        return new Dimension(n, n);
    }

    public Object[] getSelectedObjects() {
        int n = this.fTree.getSelectionCount();
        Object[] objectArray = new Object[n];
        if (n > 0) {
            TreePath[] treePathArray = this.fTree.getSelectionPaths();
            int n2 = 0;
            for (TreePath treePath : treePathArray) {
                ObjectTreeNode objectTreeNode = (ObjectTreeNode)treePath.getLastPathComponent();
                objectArray[n2++] = objectTreeNode.getUserObject();
            }
        }
        return objectArray;
    }

    private void addChildNodes(Object object, int n) {
        Vector vector;
        if (this.fRegistry != null && (vector = this.fRegistry.getChildren(object)) != null && vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                this.addTreeNode(vector.elementAt(i), n);
            }
        }
    }

    private void addTreeNode(Object object, int n) {
        this.addTreeNode(object, n, Integer.MIN_VALUE);
    }

    private void addTreeNode(Object object, int n, int n2) {
        if (this.fRegistry == null) {
            return;
        }
        int n3 = this.findTreeNode(object);
        if (n3 != -100) {
            this.removeTreeNode(n3);
        }
        ObjectTreeNode objectTreeNode = new ObjectTreeNode(object, this.fUniqueID);
        ObjectViewWorker objectViewWorker = new ObjectViewWorker((JTree)this.fTree, objectTreeNode, object);
        objectViewWorker.start();
        ObjectTreeNode objectTreeNode2 = null;
        if (this.fTreeNodes.containsKey(n)) {
            objectTreeNode2 = this.fTreeNodes.get(n);
        }
        if (objectTreeNode2 == null) {
            objectTreeNode2 = (ObjectTreeNode)this.fTree.getModel().getRoot();
        }
        if (n2 == Integer.MIN_VALUE) {
            n2 = objectTreeNode2.getChildCount();
        }
        ((DefaultTreeModel)this.fTree.getModel()).insertNodeInto(objectTreeNode, objectTreeNode2, n2);
        this.fTreeNodes.put(this.fUniqueID, objectTreeNode);
        ++this.fUniqueID;
        this.addChildNodes(object, objectTreeNode.getIndex());
        TreePath treePath = new TreePath(objectTreeNode2.getPath());
        if (!this.fTree.isExpanded(treePath)) {
            this.fTree.expandPath(treePath);
        }
        boolean bl = this.fRegistry.isSelected(object);
        TreePath treePath2 = new TreePath(objectTreeNode.getPath());
        if (bl && !this.fTree.isPathSelected(treePath2)) {
            this.fTree.getSelectionModel().addSelectionPath(treePath2);
        } else if (!bl && this.fTree.isPathSelected(treePath2)) {
            this.fTree.getSelectionModel().removeSelectionPath(treePath2);
        }
    }

    private int findTreeNode(Object object) {
        Iterator<Integer> iterator = this.fTreeNodes.keySet().iterator();
        int n = -100;
        while (iterator.hasNext()) {
            Integer n2 = iterator.next();
            ObjectTreeNode objectTreeNode = this.fTreeNodes.get(n2);
            if (objectTreeNode == null || objectTreeNode.getUserObject() == null || !objectTreeNode.getUserObject().equals(object)) continue;
            n = n2;
            break;
        }
        return n;
    }

    private ObjectTreeNode getTreeNodeForObject(Object object) {
        for (Integer n : this.fTreeNodes.keySet()) {
            ObjectTreeNode objectTreeNode = this.fTreeNodes.get(n);
            if (objectTreeNode == null || objectTreeNode.getUserObject() == null || !objectTreeNode.getUserObject().equals(object)) continue;
            return objectTreeNode;
        }
        return null;
    }

    private void removeTreeNode(Object object) {
        this.removeTreeNode(this.findTreeNode(object));
    }

    private void removeTreeNode(int n) {
        Serializable serializable;
        if (this.fRegistry == null) {
            return;
        }
        ObjectTreeNode objectTreeNode = this.fTreeNodes.get(n);
        Enumeration<TreeNode> enumeration = objectTreeNode.children();
        while (enumeration.hasMoreElements()) {
            serializable = (ObjectTreeNode)enumeration.nextElement();
            this.fTreeNodes.remove(((ObjectTreeNode)serializable).getIndex());
        }
        objectTreeNode.removeAllChildren();
        serializable = (DefaultTreeModel)this.fTree.getModel();
        ((DefaultTreeModel)serializable).removeNodeFromParent(objectTreeNode);
        this.fTreeNodes.remove(n);
    }

    private void populate() {
        MatlabWorker matlabWorker = new MatlabWorker(){

            public Object runOnMatlabThread() throws Exception {
                return null;
            }

            public void runOnAWTEventDispatchThread(Object object) {
                ObjectView.this.populateHelper();
                ObjectView.this.setObjectViewSize();
            }
        };
        matlabWorker.start();
    }

    private void setObjectViewSize() {
        if (fInitSize && this.getParent() != null) {
            Rectangle rectangle = MJUtilities.getScreenBounds();
            Rectangle rectangle2 = new Rectangle(rectangle.width - this.getPreferredSize().width, 0, this.getPreferredSize().width, this.getPreferredSize().height);
            if (this.getTopLevelAncestor() != null) {
                this.getTopLevelAncestor().setLocation(rectangle2.x, rectangle2.y);
                this.getTopLevelAncestor().setSize(rectangle2.width, rectangle2.height);
                fInitSize = false;
            }
        }
    }

    private void populateHelper() {
        this.fTreeNodes.clear();
        this.fUniqueID = 0;
        ObjectTreeNode objectTreeNode = new ObjectTreeNode(null, -100);
        this.fTreeNodes.put(-100, objectTreeNode);
        this.fTree.setModel((TreeModel)new DefaultTreeModel(objectTreeNode));
        if (this.fRegistry != null) {
            Vector vector = this.fRegistry.getTopLevelObjects();
            for (int i = 0; i < vector.size(); ++i) {
                this.addTreeNode(vector.elementAt(i), -100);
            }
        }
        this.fTree.invalidate();
    }

    private void processRegistrySelection(Object object) {
        ItemEvent itemEvent = (ItemEvent)object;
        Object[] objectArray = (Object[])itemEvent.getItem();
        boolean bl = itemEvent.getStateChange() == 1;
        for (Object object2 : objectArray) {
            TreePath treePath;
            boolean bl2;
            ObjectTreeNode objectTreeNode = this.getTreeNodeForObject(object2);
            if (objectTreeNode == null || objectTreeNode.getIndex() == -100 || (bl2 = this.fTree.isPathSelected(treePath = new TreePath(objectTreeNode.getPath()))) == bl) continue;
            if (bl) {
                this.fTree.getSelectionModel().addSelectionPath(treePath);
                continue;
            }
            this.fTree.getSelectionModel().removeSelectionPath(treePath);
        }
    }

    private void processRegistryDelete(Object object) {
        Object[] objectArray;
        ObjectRegistryEvent objectRegistryEvent = (ObjectRegistryEvent)object;
        for (Object object2 : objectArray = objectRegistryEvent.getObjects()) {
            this.removeTreeNode(object2);
        }
    }

    private void processRegistryChange(Object object) {
        Object[] objectArray;
        ObjectRegistryEvent objectRegistryEvent = (ObjectRegistryEvent)object;
        for (Object object2 : objectArray = objectRegistryEvent.getObjects()) {
            ObjectTreeNode objectTreeNode = this.getTreeNodeForObject(object2);
            if (objectTreeNode == null || objectTreeNode.getIndex() == -100) continue;
            objectTreeNode.setUserObject(object2);
            ObjectViewWorker objectViewWorker = new ObjectViewWorker((JTree)this.fTree, objectTreeNode, object2);
            objectViewWorker.start();
        }
    }

    private void processRegistryAdd(Object object) {
        ObjectRegistryEvent objectRegistryEvent = (ObjectRegistryEvent)object;
        Object[] objectArray = objectRegistryEvent.getObjects();
        Object object2 = objectRegistryEvent.getParent();
        int n = this.findTreeNode(object2);
        int n2 = objectRegistryEvent.getPosition();
        if (n != -100) {
            if (n2 != -1) {
                for (int i = 0; i < objectArray.length; ++i) {
                    this.addTreeNode(objectArray[i], n, n2 + i);
                }
            } else {
                for (Object object3 : objectArray) {
                    this.addTreeNode(object3, n);
                }
            }
        } else {
            for (Object object4 : objectArray) {
                this.addTreeNode(object4, -100);
            }
        }
    }

    private class ObjectViewWorker
    extends MatlabWorker {
        private JTree tree;
        private ObjectTreeNode node;
        private Object userObject;

        public ObjectViewWorker(JTree jTree, ObjectTreeNode objectTreeNode, Object object) {
            this.tree = jTree;
            this.node = objectTreeNode;
            this.userObject = object;
        }

        public Object runOnMatlabThread() throws Exception {
            this.node.setNodeIcon(ObjectNodeUtils.getObjectIcon(this.userObject));
            this.node.setNodeText(ObjectNodeUtils.getObjectName(this.userObject));
            return null;
        }

        public void runOnAWTEventDispatchThread(Object object) {
            ((DefaultTreeModel)this.tree.getModel()).nodeChanged(this.node);
        }
    }

    private class RegistryHandler
    implements ItemListener,
    ObjectRegistryListener {
        private RegistryHandler() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            RegistryHandlerWorker registryHandlerWorker = new RegistryHandlerWorker((Object)itemEvent){

                public Object runOnMatlabThread() throws Exception {
                    return true;
                }

                public void runOnAWTEventDispatchThread(Object object) {
                    ObjectView.this.processRegistrySelection(this.fRegistryEvent);
                }
            };
            registryHandlerWorker.start();
        }

        public void objectRegistered(ObjectRegistryEvent objectRegistryEvent) {
            RegistryHandlerWorker registryHandlerWorker = new RegistryHandlerWorker((Object)objectRegistryEvent){

                public Object runOnMatlabThread() throws Exception {
                    return true;
                }

                public void runOnAWTEventDispatchThread(Object object) {
                    ObjectView.this.processRegistryAdd(this.fRegistryEvent);
                }
            };
            registryHandlerWorker.start();
        }

        public void objectUnregistered(ObjectRegistryEvent objectRegistryEvent) {
            RegistryHandlerWorker registryHandlerWorker = new RegistryHandlerWorker((Object)objectRegistryEvent){

                public Object runOnMatlabThread() throws Exception {
                    return true;
                }

                public void runOnAWTEventDispatchThread(Object object) {
                    ObjectView.this.processRegistryDelete(this.fRegistryEvent);
                }
            };
            registryHandlerWorker.start();
        }

        public void objectChanged(ObjectRegistryEvent objectRegistryEvent) {
            RegistryHandlerWorker registryHandlerWorker = new RegistryHandlerWorker((Object)objectRegistryEvent){

                public Object runOnMatlabThread() throws Exception {
                    return true;
                }

                public void runOnAWTEventDispatchThread(Object object) {
                    ObjectView.this.processRegistryChange(this.fRegistryEvent);
                }
            };
            registryHandlerWorker.start();
        }

        public void objectMoved(ObjectRegistryEvent objectRegistryEvent) {
        }

        public void transactionStarted(ObjectRegistryEvent objectRegistryEvent) {
        }

        public void transactionEnded(ObjectRegistryEvent objectRegistryEvent) {
        }
    }

    private class ObjectTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private ObjectTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            JLabel jLabel = (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            ObjectTreeNode objectTreeNode = (ObjectTreeNode)object;
            jLabel.setIcon(objectTreeNode.getNodeIcon());
            jLabel.setText(objectTreeNode.getNodeText());
            return jLabel;
        }
    }

    private abstract class RegistryHandlerWorker
    extends MatlabWorker {
        Object fRegistryEvent;

        public RegistryHandlerWorker(Object object) {
            this.fRegistryEvent = object;
        }
    }
}

