/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.array;

import com.mathworks.jmi.AWTUtilities;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabListener;
import com.mathworks.mde.array.ArrayEditorFontPrefs;
import com.mathworks.mde.array.ArrayEditorPrefs;
import com.mathworks.mde.array.ArrayEditorResources;
import com.mathworks.mde.array.ArrayEditorToolstripTabFactory;
import com.mathworks.mde.desk.MLDesktop;
import com.mathworks.mde.desk.PlotableClientBase;
import com.mathworks.mlservices.WorkspaceVariable;
import com.mathworks.mlservices.WorkspaceVariableAdaptor;
import com.mathworks.mlwidgets.actionbrowser.TearOffDialog;
import com.mathworks.mlwidgets.array.ArrayUtils;
import com.mathworks.mlwidgets.array.ValueEditorProvider;
import com.mathworks.mlwidgets.array.ValuePanel;
import com.mathworks.mlwidgets.workspace.MatlabWorkspaceListener;
import com.mathworks.mlwidgets.workspace.WorkspaceCommandEvent;
import com.mathworks.mlwidgets.workspace.WorkspaceCommandListener;
import com.mathworks.mlwidgets.workspace.WorkspaceCommands;
import com.mathworks.mlwidgets.workspace.WorkspacePrefs;
import com.mathworks.mlwidgets.workspace.graphics.IGraphableInfoProvider;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.services.ColorPrefs;
import com.mathworks.services.FontListener;
import com.mathworks.services.FontPrefs;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.services.Prefs;
import com.mathworks.toolstrip.ToolstripTab;
import com.mathworks.toolstrip.factory.TSToolSet;
import com.mathworks.util.Log;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.desk.DTClientAdapter;
import com.mathworks.widgets.desk.DTClientEvent;
import com.mathworks.widgets.desk.DTClientListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ArrayEditor
extends PlotableClientBase {
    private boolean fClosed;
    private static final Map<WorkspaceVariable, ArrayEditor> OPEN_ARRAYS_HASH = new HashMap<WorkspaceVariable, ArrayEditor>();
    private static final Icon SMALL_ICON = new ImageIcon(ArrayEditor.class.getResource("/com/mathworks/mlwidgets/workspace/resources/array_editor_16.png"));
    private static final Icon ICON = new ImageIcon(ArrayEditor.class.getResource("/com/mathworks/mlwidgets/workspace/resources/editor_array32.gif"));
    private WorkspaceVariable fWorkspaceVariable;
    private ValuePanel fValuePanel;
    private MultiListener fPL;
    private MatlabWorkspacePrefListener fMatlabWorkspacePrefListener;
    private boolean fMatlabWorkspacePrefListenerAdded = false;
    private ActionListener fMenuBarListener;
    private ActionListener fToolBarListener;
    private List<ToolstripTab> fTabList;
    static final String GROUP_NAME = "Array Editor";
    public static final Dimension DEFAULT_SIZE = new Dimension(330, 200);
    private static WorkspaceCommandListener sWorkspaceCommandListener = new WorkspaceCommandListener(){

        public void workspaceCommandOccured(WorkspaceCommandEvent workspaceCommandEvent) {
            if ("renameVariable".equals(workspaceCommandEvent.getCommand()) && workspaceCommandEvent.getSource() instanceof Object[]) {
                Object[] objectArray = (Object[])workspaceCommandEvent.getSource();
                if (objectArray.length != 2 || !(objectArray[0] instanceof String) || !(objectArray[1] instanceof String)) {
                    return;
                }
                ArrayEditor.renameVar((WorkspaceVariable)new WorkspaceVariableAdaptor((String)objectArray[0]), (WorkspaceVariable)new WorkspaceVariableAdaptor((String)objectArray[1]));
            }
        }
    };
    private TearOffDialog fTearOffDialog = null;
    private ArrayUtils.UpAction fUpAction = null;
    private WorkspaceVariable fStartingWorkspaceVariable;
    private static final boolean DEFAULT_COFL = false;
    private static boolean sCloseOnFocusLoss = false;
    private static boolean sWorkspaceCommandListenerAdded = false;
    private boolean fAddedToOpenArraysHash = false;
    private boolean fMenuBarRequested = false;
    private boolean fMenuBarShowing = false;
    private ComponentListener fWindowListener;
    private Point fWindowLocation = new Point(0, 0);
    private boolean fWindowVisible = false;

    public static boolean cofl(boolean bl) {
        boolean bl2 = sCloseOnFocusLoss;
        sCloseOnFocusLoss = bl;
        return bl2;
    }

    private ArrayEditor() {
    }

    protected static void showEditor(final WorkspaceVariable workspaceVariable) {
        if (EventQueue.isDispatchThread()) {
            ArrayEditor arrayEditor = ArrayEditor.getPreexistingEditor(workspaceVariable);
            if (arrayEditor != null) {
                arrayEditor.getParentDesktop().setClientSelected((Component)((Object)arrayEditor), true);
            } else {
                ArrayEditor.setPreexistingEditor(workspaceVariable, new ArrayEditor(workspaceVariable));
            }
            if (!sWorkspaceCommandListenerAdded) {
                sWorkspaceCommandListenerAdded = true;
                WorkspaceCommands.addWorkspaceCommandListener((WorkspaceCommandListener)sWorkspaceCommandListener);
            }
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ArrayEditor.showEditor(workspaceVariable);
                }
            });
        }
    }

    private static void renameVar(final WorkspaceVariable workspaceVariable, final WorkspaceVariable workspaceVariable2) {
        assert (workspaceVariable.getWorkspaceID() == workspaceVariable2.getWorkspaceID());
        MJUtilities.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (OPEN_ARRAYS_HASH.containsKey(workspaceVariable2)) {
                    return;
                }
                ArrayEditor arrayEditor = ArrayEditor.getPreexistingEditor(workspaceVariable);
                if (arrayEditor == null) {
                    return;
                }
                OPEN_ARRAYS_HASH.remove(workspaceVariable);
                arrayEditor.rename(workspaceVariable2);
                OPEN_ARRAYS_HASH.put(workspaceVariable2, arrayEditor);
                new Matlab().feval("datamanager.renameArrayEditorVariable", new Object[]{workspaceVariable.getVariableName(), workspaceVariable2.getVariableName()}, 0, (MatlabListener)null);
            }
        });
    }

    static void setEditable(final WorkspaceVariable workspaceVariable, final boolean bl) {
        if (EventQueue.isDispatchThread()) {
            ArrayEditor arrayEditor = ArrayEditor.getPreexistingEditor(workspaceVariable);
            if (arrayEditor != null) {
                arrayEditor.internalSetEditable(bl);
            }
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ArrayEditor.setEditable(workspaceVariable, bl);
                }
            });
        }
    }

    static boolean isEditable(final WorkspaceVariable workspaceVariable) {
        if (EventQueue.isDispatchThread()) {
            boolean bl = false;
            ArrayEditor arrayEditor = ArrayEditor.getPreexistingEditor(workspaceVariable);
            if (arrayEditor != null) {
                bl = arrayEditor.internalIsEditable();
            }
            return bl;
        }
        boolean bl = false;
        try {
            bl = (Boolean)AWTUtilities.invokeAndWait((AWTUtilities.InvocationRunnable)new AWTUtilities.InvocationRunnable(){

                public Object runWithOutput() {
                    return ArrayEditor.isEditable(workspaceVariable);
                }
            });
        }
        catch (Throwable throwable) {
            Log.logThrowable((Throwable)throwable);
        }
        return bl;
    }

    private void internalSetEditable(boolean bl) {
        this.fValuePanel.setEditable(bl);
        if (bl) {
            this.setTitle(this.fWorkspaceVariable.toString());
        } else {
            Object[] objectArray = new Object[]{this.fWorkspaceVariable.toString()};
            this.setTitle(MessageFormat.format(ArrayEditorResources.getBundle().getString("title.readOnly"), objectArray));
        }
    }

    private boolean internalIsEditable() {
        return this.fValuePanel.isEditable();
    }

    protected static ArrayEditor getPreexistingEditor(WorkspaceVariable workspaceVariable) {
        ArrayEditor arrayEditor = null;
        if (OPEN_ARRAYS_HASH.containsKey(workspaceVariable)) {
            arrayEditor = OPEN_ARRAYS_HASH.get(workspaceVariable);
        }
        return arrayEditor;
    }

    private static void setPreexistingEditor(WorkspaceVariable workspaceVariable, ArrayEditor arrayEditor) {
        OPEN_ARRAYS_HASH.put(workspaceVariable, arrayEditor);
        arrayEditor.setAddedToOpenArraysHash();
    }

    private static void removePreexistingEditor(WorkspaceVariable workspaceVariable) {
        if (OPEN_ARRAYS_HASH.containsKey(workspaceVariable)) {
            OPEN_ARRAYS_HASH.remove(workspaceVariable);
        }
    }

    private void setAddedToOpenArraysHash() {
        this.fAddedToOpenArraysHash = true;
    }

    public ArrayEditor(WorkspaceVariable workspaceVariable) {
        this(workspaceVariable, GROUP_NAME);
        this.showMenuBar();
        MLDesktop.getInstance().addClient((Component)((Object)this), this.fWorkspaceVariable.toString(), true, null, true, (DTClientListener)new DTCL());
    }

    private void showMenuBar() {
        this.fMenuBarRequested = true;
        if (this.fMenuBarShowing) {
            return;
        }
        this.addMenuBar();
    }

    private void addMenuBar() {
        assert (!this.fMenuBarShowing);
        this.fMenuBarShowing = true;
        this.setMenuBar((JMenuBar)this.fValuePanel.getMenuBar());
        this.fMenuBarListener = new MenuBarListener();
        this.fValuePanel.addMenuBarActionListener(this.fMenuBarListener);
        this.setToolBar((JToolBar)this.fValuePanel.getToolBar());
        this.fToolBarListener = new ToolBarListener();
        this.fValuePanel.addToolBarActionListener(this.fToolBarListener);
        if (MLDesktop.getInstance().useToolstrip()) {
            TSToolSet tSToolSet = ArrayEditorToolstripTabFactory.createToolSet();
            TSToolSet tSToolSet2 = ArrayEditorToolstripTabFactory.createViewToolSet();
            ValuePanel.ToolSetUpdateListener toolSetUpdateListener = new ValuePanel.ToolSetUpdateListener(){

                public void toolsetUpdated(ValueEditorProvider valueEditorProvider) {
                    ArrayEditorToolstripTabFactory.disposeTabs(ArrayEditor.this.fTabList);
                    if (valueEditorProvider instanceof IGraphableInfoProvider) {
                        final IGraphableInfoProvider iGraphableInfoProvider = (IGraphableInfoProvider)valueEditorProvider;
                        iGraphableInfoProvider.addGraphableSelectionListener(new ListSelectionListener(){

                            @Override
                            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                                ArrayEditor.this.setVariablesToPlot(iGraphableInfoProvider.getGraphableNames());
                            }
                        });
                    }
                    ArrayEditor.this.fTabList = ArrayEditorToolstripTabFactory.createTabs(ArrayEditor.this.fValuePanel.getToolSet(), ArrayEditor.this.fValuePanel.getViewToolSet());
                    ArrayEditor.this.setToolstripTabs(ArrayEditor.this.fTabList.toArray(new ToolstripTab[ArrayEditor.this.fTabList.size()]));
                }
            };
            this.fValuePanel.setToolSet(tSToolSet, tSToolSet2, toolSetUpdateListener);
            this.fTabList = ArrayEditorToolstripTabFactory.createTabs(tSToolSet, tSToolSet2);
            this.setToolstripTabs(this.fTabList.toArray(new ToolstripTab[this.fTabList.size()]));
        }
    }

    private void removeMenuBar() {
        if (this.fMenuBarShowing) {
            this.fValuePanel.removeMenuBarActionListener(this.fMenuBarListener);
            this.fMenuBarListener = null;
            this.setMenuBar(null);
            this.fValuePanel.removeToolBarActionListener(this.fToolBarListener);
            this.fToolBarListener = null;
            this.setToolBar(null);
            this.fMenuBarShowing = false;
        }
    }

    public ArrayEditor(WorkspaceVariable workspaceVariable, String string) {
        if (workspaceVariable == null) {
            throw new IllegalArgumentException("null workspaceVariable supplied to Variable Editor");
        }
        this.setDontReopen(true);
        this.fStartingWorkspaceVariable = workspaceVariable;
        this.fWorkspaceVariable = workspaceVariable;
        this.setOpaque(false);
        this.setBounds(10, 10, ArrayEditor.DEFAULT_SIZE.width, ArrayEditor.DEFAULT_SIZE.height);
        this.setMultipleInstances(true);
        String string2 = string;
        if (string2 == null || string2.isEmpty()) {
            string2 = GROUP_NAME;
        }
        this.setGroup(string2);
        this.setIcon(ICON);
        this.setSmallIcon(SMALL_ICON);
        this.setName("ArrayEditor");
        this.initialize();
    }

    private void initialize() {
        this.fClosed = false;
        this.fValuePanel = new ValuePanel(this.fWorkspaceVariable, true);
        this.fValuePanel.setFormat(ArrayEditorPrefs.getDefaultFormat());
        this.fValuePanel.setMotionOnEnter(ArrayEditorPrefs.isEnterCausesMotion());
        this.fValuePanel.setMotionOnEnterDirection(ArrayEditorPrefs.getEnterMotionDirection());
        this.fValuePanel.setFont(FontPrefs.getFontForComponent((String)ArrayEditorFontPrefs.DISPLAY_NAME));
        this.fValuePanel.updateValueInformation();
        this.setColors();
        this.addWindowListeners();
        this.addPrefsListeners();
        this.setLayout(new BorderLayout());
        this.add((Component)this.fValuePanel);
        if (this.fMenuBarRequested) {
            this.showMenuBar();
        }
    }

    private void addWindowListeners() {
        assert (this.fWindowListener == null);
        this.fWindowListener = new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                if (ArrayEditor.this.getTopLevelAncestor() != null) {
                    ArrayEditor.this.fWindowLocation = ArrayEditor.this.getTopLevelAncestor().getLocation();
                }
            }
        };
        this.addComponentListener(this.fWindowListener);
    }

    public boolean isWindowVisible() {
        return this.fWindowVisible;
    }

    private void removeWindowListeners() {
        if (this.fWindowListener != null) {
            this.removeComponentListener(this.fWindowListener);
            this.fWindowListener = null;
        }
    }

    private void addPrefsListeners() {
        assert (this.fPL == null);
        this.fPL = new MultiListener();
        FontPrefs.addFontListener((String)ArrayEditorFontPrefs.DISPLAY_NAME, (FontListener)this.fPL);
        Prefs.addListener((PrefListener)this.fPL, (String)ArrayEditorPrefs.getEnterCausesMotionKey());
        Prefs.addListener((PrefListener)this.fPL, (String)ArrayEditorPrefs.getEnterMotionDirectionKey());
        this.addMLWorkspaceUseNanPrefListener();
        ColorPrefs.addColorListener((String)"ColorsText", (PrefListener)this.fPL);
        ColorPrefs.addColorListener((String)"ColorsBackground", (PrefListener)this.fPL);
    }

    private void removePrefsListeners() {
        if (this.fPL != null) {
            FontPrefs.removeFontListener((String)ArrayEditorFontPrefs.DISPLAY_NAME, (FontListener)this.fPL);
            Prefs.removeListener((PrefListener)this.fPL);
            ColorPrefs.removeColorListener((String)"ColorsText", (PrefListener)this.fPL);
            ColorPrefs.removeColorListener((String)"ColorsBackground", (PrefListener)this.fPL);
            this.fPL = null;
            this.removeMLWorkspaceUseNanPrefListener();
        }
    }

    public Point getWindowLocation() {
        if (MLDesktop.getInstance().hasClient((Component)((Object)this))) assert (false) : "getWindowLocation cannot be used when window is docked.";
        return this.fWindowLocation;
    }

    public void setWindowLocation(final Point point) {
        if (MLDesktop.getInstance().hasClient((Component)((Object)this))) assert (false) : "setWindowLocation cannot be used when window is docked.";
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (ArrayEditor.this.fTearOffDialog != null && ArrayEditor.this.fTearOffDialog.isShowing()) {
                    ArrayEditor.this.fTearOffDialog.toFront();
                    return;
                }
                if (ArrayEditor.this.fClosed) {
                    ArrayEditor.this.initialize();
                }
                ActionListener actionListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ArrayEditor.this.rename(new WorkspaceVariable(actionEvent.getActionCommand(), ArrayEditor.this.fWorkspaceVariable.getWorkspaceID()));
                    }
                };
                ArrayEditor.this.fValuePanel.setOpenActionHandler(actionListener);
                ArrayEditor.this.fValuePanel.setUseMinimalMenus(true);
                ArrayEditor.this.fTearOffDialog = new TearOffDialog(null, true);
                ArrayEditor.this.fTearOffDialog.setName("VariableEditorFrame_" + ArrayEditor.this.fWorkspaceVariable.getVariableBaseName());
                ArrayEditor.this.fTearOffDialog.setMinimumSize(DEFAULT_SIZE);
                MJToolBar mJToolBar = new MJToolBar();
                mJToolBar.setFloatable(false);
                ArrayEditor.this.fUpAction = new ArrayUtils.UpAction(ArrayEditor.this.fWorkspaceVariable.getVariableName(), actionListener);
                mJToolBar.add((Action)ArrayEditor.this.fUpAction);
                mJToolBar.setMorePopupEnabled(false);
                mJToolBar.setBorder(null);
                MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout());
                mJPanel.setOpaque(false);
                mJPanel.add((Component)mJToolBar, (Object)"East");
                ArrayEditor.this.fValuePanel.setSummaryBarGlassPane((JComponent)mJPanel);
                ArrayEditor.this.fTearOffDialog.addComponentListener((ComponentListener)new ComponentAdapter(){

                    @Override
                    public void componentHidden(ComponentEvent componentEvent) {
                        ArrayEditor.this.cleanup();
                    }
                });
                WindowAdapter windowAdapter = new WindowAdapter(){
                    private boolean fOpened = false;
                    private boolean fHasFocus = false;

                    @Override
                    public void windowOpened(WindowEvent windowEvent) {
                        this.fOpened = true;
                        ArrayEditor.this.fWindowVisible = !ArrayEditor.this.fClosed;
                    }

                    @Override
                    public void windowGainedFocus(WindowEvent windowEvent) {
                        this.fHasFocus = !PlatformInfo.isMacintosh() || this.fOpened;
                        ArrayEditor.this.fWindowVisible = !ArrayEditor.this.fClosed;
                    }
                };
                ArrayEditor.this.fTearOffDialog.addWindowListener((WindowListener)windowAdapter);
                ArrayEditor.this.fTearOffDialog.addWindowFocusListener((WindowFocusListener)windowAdapter);
                ArrayEditor.this.fTearOffDialog.setUndecorated(true);
                ArrayEditor.this.fTearOffDialog.getRootPane().setWindowDecorationStyle(0);
                MJPanel mJPanel2 = new MJPanel((LayoutManager)new BorderLayout());
                mJPanel2.add((Component)ArrayEditor.this.fValuePanel, (Object)"Center");
                ArrayEditor.this.fTearOffDialog.getContentPane().add((Component)mJPanel2);
                ArrayEditor.this.fTearOffDialog.setBounds(point.x, point.y, ArrayEditor.DEFAULT_SIZE.width, ArrayEditor.DEFAULT_SIZE.height);
                ArrayEditor.this.fTearOffDialog.open(true);
                ArrayEditor.this.fTearOffDialog.toFront();
            }
        };
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            EventQueue.invokeLater(runnable);
        }
    }

    private void rename(WorkspaceVariable workspaceVariable) {
        this.fValuePanel.rename(workspaceVariable);
        this.fWorkspaceVariable = workspaceVariable;
        this.setTitle(this.fWorkspaceVariable.toString());
        if (this.fUpAction != null) {
            this.fUpAction.setVariableName(this.fWorkspaceVariable.getVariableName());
        }
    }

    public void refresh() {
        if (!this.fClosed) {
            this.fValuePanel.updateValueInformation();
        }
    }

    private void cleanup() {
        if (this.fClosed) {
            return;
        }
        this.fClosed = true;
        if (this.fAddedToOpenArraysHash) {
            ArrayEditor.removePreexistingEditor(this.fWorkspaceVariable);
        }
        this.fWorkspaceVariable = this.fStartingWorkspaceVariable;
        this.removeMenuBar();
        this.removePrefsListeners();
        this.removeWindowListeners();
        ArrayEditorToolstripTabFactory.disposeTabs(this.fTabList);
        this.fValuePanel.cleanup();
        this.remove((Component)this.fValuePanel);
        this.fValuePanel = null;
        if (MLDesktop.getInstance().hasClient((Component)((Object)this))) {
            MLDesktop.getInstance().removeClient((Component)((Object)this));
        }
        if (this.fTearOffDialog != null) {
            this.fTearOffDialog.close();
            this.fTearOffDialog.dispose();
            this.fTearOffDialog = null;
        }
        this.fWindowVisible = false;
    }

    public void close() {
        if (EventQueue.isDispatchThread()) {
            this.cleanup();
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ArrayEditor.this.close();
                }
            });
        }
    }

    private void addMLWorkspaceUseNanPrefListener() {
        assert (this.fMatlabWorkspacePrefListener == null);
        this.fMatlabWorkspacePrefListener = new MatlabWorkspacePrefListener();
        if (Matlab.isMatlabAvailable()) {
            WorkspacePrefs.addUseNaNsForStatCalculationsListener((PrefListener)this.fMatlabWorkspacePrefListener);
            this.fMatlabWorkspacePrefListenerAdded = true;
        }
    }

    private void removeMLWorkspaceUseNanPrefListener() {
        if (this.fMatlabWorkspacePrefListenerAdded) {
            assert (Matlab.isMatlabAvailable());
            WorkspacePrefs.removeUseNaNsForStatCalculationsListener((PrefListener)this.fMatlabWorkspacePrefListener);
        }
        this.fMatlabWorkspacePrefListener = null;
    }

    private void setColors() {
        this.fValuePanel.setForeground(ColorPrefs.getTextColor());
        this.fValuePanel.setBackground(ColorPrefs.getBackgroundColor());
    }

    public void requestFocus() {
        super.requestFocus();
        if (this.fValuePanel != null && !this.fValuePanel.isCleanupInitiated()) {
            this.fValuePanel.requestFocus();
        }
    }

    public boolean requestFocusInWindow() {
        boolean bl = super.requestFocusInWindow();
        if (bl && this.fValuePanel != null && !this.fValuePanel.isCleanupInitiated()) {
            bl = this.fValuePanel.requestFocusInWindow();
        }
        return bl;
    }

    private static class MatlabWorkspacePrefListener
    implements PrefListener {
        private MatlabWorkspacePrefListener() {
        }

        public void prefChanged(PrefEvent prefEvent) {
            MatlabWorkspaceListener.reportWSChange();
        }
    }

    private class MultiListener
    implements FontListener,
    PrefListener {
        private MultiListener() {
        }

        public void fontChanged(Font font) {
            ArrayEditor.this.fValuePanel.setFont(font);
        }

        public void prefChanged(PrefEvent prefEvent) {
            String string = prefEvent.getPrefKey();
            if (string.equals("ColorsText") || string.equals("ColorsBackground")) {
                ArrayEditor.this.setColors();
            } else {
                ArrayEditor.this.fValuePanel.setMotionOnEnter(ArrayEditorPrefs.isEnterCausesMotion());
                ArrayEditor.this.fValuePanel.setMotionOnEnterDirection(ArrayEditorPrefs.getEnterMotionDirection());
            }
        }
    }

    private class ToolBarListener
    implements ActionListener {
        private ToolBarListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ArrayEditor.this.setToolBar((JToolBar)ArrayEditor.this.fValuePanel.getToolBar());
        }
    }

    private class MenuBarListener
    implements ActionListener {
        private MenuBarListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ArrayEditor.this.setMenuBar((JMenuBar)ArrayEditor.this.fValuePanel.getMenuBar());
        }
    }

    private class DTCL
    extends DTClientAdapter {
        private DTCL() {
        }

        public void clientClosed(DTClientEvent dTClientEvent) {
            ArrayEditor.this.cleanup();
            super.clientClosed(dTClientEvent);
        }
    }
}

