/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.cmdhist;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.SearchableUtils;
import com.jidesoft.swing.TreeSearchable;
import com.mathworks.mde.cmdhist.CmdHistory;
import com.mathworks.mde.cmdhist.CmdHistoryIO;
import com.mathworks.mde.cmdhist.CmdHistoryPrinter;
import com.mathworks.mde.cmdhist.HistoryChangedListener;
import com.mathworks.mde.desk.MLDesktop;
import com.mathworks.mde.desk.MLMenuMergeTag;
import com.mathworks.mlservices.MLEditorServices;
import com.mathworks.mlservices.MLExecuteServices;
import com.mathworks.mlwidgets.prefs.ConfirmationDialogPrefsPanel;
import com.mathworks.mlwidgets.shortcuts.ShortcutEditor;
import com.mathworks.mlwidgets.shortcuts.ShortcutUtils;
import com.mathworks.mwswing.AppearanceFocusDispatcher;
import com.mathworks.mwswing.AppearanceFocusEvent;
import com.mathworks.mwswing.AppearanceFocusListener;
import com.mathworks.mwswing.ColorUtils;
import com.mathworks.mwswing.ExtendedAction;
import com.mathworks.mwswing.ExtendedInputMap;
import com.mathworks.mwswing.MInputMap;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJList;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.MJMenuBar;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJTree;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.datatransfer.MJClipboard;
import com.mathworks.mwswing.datatransfer.MJDragCursorUtilities;
import com.mathworks.services.ColorPrefs;
import com.mathworks.services.FontListener;
import com.mathworks.services.FontPrefs;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.services.binding.MatlabKeyBindings;
import com.mathworks.toolstrip.factory.ContextTargetingManager;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.StringUtils;
import com.mathworks.widgets.Dialogs;
import com.mathworks.widgets.SyntaxTextLabel;
import com.mathworks.widgets.desk.DTClientAdapter;
import com.mathworks.widgets.desk.DTClientBase;
import com.mathworks.widgets.desk.DTClientEvent;
import com.mathworks.widgets.desk.DTClientListener;
import com.mathworks.widgets.desk.DTMenuMergeTag;
import com.mathworks.widgets.find.FindClientInterface;
import com.mathworks.widgets.find.FindClientRegistry;
import com.mathworks.widgets.find.FindDialog;
import com.mathworks.widgets.find.FindEvent;
import com.mathworks.widgets.find.FindParentListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.Position;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class CmdHistoryWindow
extends DTClientBase
implements FindClientInterface {
    private static final String NEWLINE = "\n";
    static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.mde.cmdhist.resources.RES_CmdHist");
    private static CmdHistoryWindow sHistoryWindow;
    private static String sCmdHistoryName;
    private CmdHistory fHistory;
    private Vector fHistoryCommands;
    private boolean fIsPopulated = false;
    private HistoryTree fTree;
    private MJScrollPane fScrolledTree;
    private DefaultTreeModel fModel;
    private DefaultMutableTreeNode fTopNode;
    private DefaultMutableTreeNode fCurrentDateNode;
    private ColorTreeRenderer fHistoryRenderer;
    private MJPopupMenu fPopupMenu;
    private int fPendingCommands = 0;
    private DropTargetListener fDropTargetListener = null;
    private DragGestureListener fDragGestureListener = null;
    private DragSource fDragSource = null;
    private CopyAction fCopyAction;
    private CutAction fCutAction;
    private SelectAllAction fSelectAllAction;
    private PrintAction fPrintAction;
    private PrintSelectionAction fPrintSelectionAction;
    private PageSetupAction fPageSetupAction;
    private EvalAction fEvalAction;
    private CreateMFileAction fCreateMFileAction;
    private CreateShortcutAction fCreateShortcutAction;
    private ProfileCodeAction fProfileCodeAction;
    private DeleteSelectionAction fDeleteSelectionAction;
    private DeleteToSelectionAction fDeleteToSelectionAction;
    private DeleteEntireHistoryAction fDeleteEntireHistoryAction;
    private FindDialogAction fFindAction;
    private FindDialog fFindDialog;
    private FindParentListener fFindListener;
    private String fFindString = "";
    private int fFindOptions = 0;
    private boolean fFirstFind = false;
    private boolean fInFindSelection = false;
    private static final int END_INDEX = -1;
    private Dimension fPreviousSize;
    private static final String COMMAND_HISTORY_CONTEXT = "CommandHistory";

    public static void main(String[] stringArray) {
        CmdHistoryWindow.getInstance();
    }

    private CmdHistoryWindow() {
        this.setLayout(new BorderLayout());
        this.setName("Command History");
        this.createActions();
        if (MLDesktop.getInstance().useToolstrip()) {
            ContextTargetingManager.setToolName((Action)((Object)this.fCutAction), (String)DTMenuMergeTag.CUT.toString());
            ContextTargetingManager.setToolName((Action)((Object)this.fCopyAction), (String)DTMenuMergeTag.COPY.toString());
            ContextTargetingManager.setToolName((Action)((Object)this.fDeleteSelectionAction), (String)DTMenuMergeTag.DELETE.toString());
            ContextTargetingManager.setToolName((Action)((Object)this.fSelectAllAction), (String)DTMenuMergeTag.SELECT_ALL.toString());
            ContextTargetingManager.setToolName((Action)((Object)this.fPrintAction), (String)DTMenuMergeTag.PRINT.toString());
            ContextTargetingManager.setToolName((Action)((Object)this.fPageSetupAction), (String)DTMenuMergeTag.PAGE_SETUP.toString());
            ContextTargetingManager.setToolName((Action)((Object)this.fFindAction), (String)DTMenuMergeTag.FIND.toString());
            ContextTargetingManager.setToolName((Action)((Object)this.fEvalAction), (String)"evaluate_selection");
            this.setContextActions(new Action[]{this.fCutAction, this.fCopyAction, this.fDeleteSelectionAction, this.fSelectAllAction, this.fPrintAction, this.fPageSetupAction, this.fFindAction, this.fEvalAction});
        } else {
            this.setMenuBar((JMenuBar)this.createMenuBar());
        }
        this.setContextMenu(this.createTitleBarContextMenu());
        sHistoryWindow = this;
    }

    public static CmdHistoryWindow getInstance() {
        if (sHistoryWindow == null) {
            sHistoryWindow = new CmdHistoryWindow();
            sHistoryWindow.refresh();
        }
        return sHistoryWindow;
    }

    public void refresh() {
        this.createTree();
        this.populate();
    }

    private void createTree() {
        this.fTopNode = new DefaultMutableTreeNode("Top Level");
        this.fTree = new HistoryTree();
        this.fTree.setLargeModel(true);
        this.fTree.setRowHeight(20);
        this.fTree.setName("Command History Tree");
        this.fTree.getAccessibleContext().setAccessibleName(sCmdHistoryName);
        this.fModel = new DefaultTreeModel(this.fTopNode);
        this.fTree.setModel(this.fModel);
        this.fTree.setRootVisible(false);
        this.fTree.setShowsRootHandles(true);
        this.fTree.getSelectionModel().setSelectionMode(4);
        this.fTree.setRightSelectionEnabled(true);
        this.fTree.addTreeSelectionListener(new CmdHistTreeSelectionListener());
        this.fTree.setCellViewerEnabled(true);
        this.setBackgroundColor();
        this.setForegroundColor();
        CmdHistColorListener cmdHistColorListener = new CmdHistColorListener();
        ColorPrefs.addColorListener((String)"ColorsText", (PrefListener)cmdHistColorListener);
        ColorPrefs.addColorListener((String)"ColorsBackground", (PrefListener)cmdHistColorListener);
        this.fHistoryRenderer = new ColorTreeRenderer();
        this.fTree.setRowHeight(this.fHistoryRenderer.getPreferredSize().height);
        this.fTree.setCellRenderer(this.fHistoryRenderer);
        this.fTree.addMouseListener(new CmdHistoryMouseAdapter());
        this.fTree.setFirstCharacterNavigationEnabled(false);
        this.fTree.addPropertyChangeListener(new CmdHistPropertyChangedListener());
        this.setFont(FontPrefs.getFontForComponent((String)sCmdHistoryName));
        FontPrefs.addFontListener((String)sCmdHistoryName, (FontListener)new CmdHistFontListener());
        this.fScrolledTree = new MJScrollPane((Component)((Object)this.fTree));
        this.fScrolledTree.anchorToBottom();
        MJUtilities.initJIDE();
        final TreeSearchable treeSearchable = SearchableUtils.installSearchable((JTree)((Object)this.fTree));
        treeSearchable.setSearchLabel(sRes.getString("jide.search_history") + " ");
        treeSearchable.setRecursive(true);
        treeSearchable.setReverseOrder(true);
        treeSearchable.setHeavyweightComponentEnabled(true);
        treeSearchable.setRepeats(true);
        this.fTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                treeSearchable.hidePopup();
            }
        });
    }

    public static void invoke() {
        if (sHistoryWindow != null) {
            MLDesktop.getInstance().showClient((Component)((Object)sHistoryWindow), null, true);
        } else {
            CmdHistoryWindow.getInstance();
            MLDesktop.getInstance().addClient((Component)((Object)sHistoryWindow), "Command History");
        }
    }

    private void populate() {
        PopulateThread populateThread = new PopulateThread();
        populateThread.start();
    }

    private boolean isExpandedDateNode(TreePath treePath) {
        if (treePath != null) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            return defaultMutableTreeNode.getLevel() == 1 && !defaultMutableTreeNode.isLeaf() && this.fTree.isExpanded(treePath);
        }
        return false;
    }

    public void requestFocus() {
        if (this.fTree != null) {
            this.fTree.requestFocus();
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.fTree != null) {
            this.fTree.setFont(font);
        }
    }

    private void setBackgroundColor() {
        this.fTree.setBackground(ColorPrefs.getBackgroundColor());
        this.setBackground(ColorPrefs.getBackgroundColor());
    }

    private void setForegroundColor() {
        this.setForeground(ColorPrefs.getTextColor());
        this.fTree.setForeground(ColorPrefs.getTextColor());
    }

    private void createActions() {
        this.fCopyAction = new CopyAction();
        this.fCutAction = new CutAction();
        this.fSelectAllAction = new SelectAllAction();
        this.fPrintAction = new PrintAction();
        this.fPrintAction.setEnabled(true);
        this.fPrintSelectionAction = new PrintSelectionAction();
        this.fPrintSelectionAction.setEnabled(false);
        this.fPageSetupAction = new PageSetupAction();
        this.fEvalAction = new EvalAction();
        this.fCreateMFileAction = new CreateMFileAction();
        this.fCreateShortcutAction = new CreateShortcutAction();
        this.fProfileCodeAction = new ProfileCodeAction();
        this.fDeleteSelectionAction = new DeleteSelectionAction();
        this.fDeleteToSelectionAction = new DeleteToSelectionAction();
        this.fDeleteEntireHistoryAction = new DeleteEntireHistoryAction();
        this.fFindAction = new FindDialogAction();
    }

    private MJMenuBar createMenuBar() {
        MJMenuBar mJMenuBar = new MJMenuBar();
        MJMenu mJMenu = new MJMenu();
        mJMenuBar.add((JMenu)mJMenu);
        DTMenuMergeTag.FILE.setTag((JMenuItem)mJMenu);
        MJMenuItem mJMenuItem = new MJMenuItem((Action)((Object)this.fPageSetupAction));
        DTMenuMergeTag.PAGE_SETUP.setTag((JMenuItem)mJMenuItem);
        mJMenu.add((JMenuItem)mJMenuItem);
        MJMenuItem mJMenuItem2 = new MJMenuItem((Action)((Object)this.fPrintAction));
        DTMenuMergeTag.PRINT.setTag((JMenuItem)mJMenuItem2);
        mJMenu.add((JMenuItem)mJMenuItem2);
        MJMenuItem mJMenuItem3 = new MJMenuItem((Action)((Object)this.fPrintSelectionAction));
        DTMenuMergeTag.PRINT_SELECTION.setTag((JMenuItem)mJMenuItem3);
        mJMenu.add((JMenuItem)mJMenuItem3);
        MJMenu mJMenu2 = new MJMenu();
        mJMenuBar.add((JMenu)mJMenu2);
        DTMenuMergeTag.EDIT.setTag((JMenuItem)mJMenu2);
        MJMenuItem mJMenuItem4 = new MJMenuItem((Action)((Object)this.fCopyAction));
        DTMenuMergeTag.COPY.setTag((JMenuItem)mJMenuItem4);
        mJMenu2.add((JMenuItem)mJMenuItem4);
        MJMenuItem mJMenuItem5 = new MJMenuItem((Action)((Object)this.fCutAction));
        DTMenuMergeTag.CUT.setTag((JMenuItem)mJMenuItem5);
        mJMenu2.add((JMenuItem)mJMenuItem5);
        MJMenuItem mJMenuItem6 = new MJMenuItem((Action)((Object)this.fDeleteSelectionAction));
        MLMenuMergeTag.DELETE.setTag((JMenuItem)mJMenuItem6);
        mJMenu2.add((JMenuItem)mJMenuItem6);
        MJMenuItem mJMenuItem7 = new MJMenuItem((Action)((Object)this.fSelectAllAction));
        MLMenuMergeTag.SELECT_ALL.setTag((JMenuItem)mJMenuItem7);
        mJMenu2.add((Action)((Object)this.fSelectAllAction));
        MJMenuItem mJMenuItem8 = new MJMenuItem((Action)((Object)this.fFindAction));
        MLMenuMergeTag.FIND.setTag((JMenuItem)mJMenuItem8);
        mJMenu2.add((JMenuItem)mJMenuItem8);
        return mJMenuBar;
    }

    private JMenu createTitleBarContextMenu() {
        MJMenu mJMenu = new MJMenu();
        mJMenu.add((Action)((Object)this.fDeleteEntireHistoryAction));
        return mJMenu;
    }

    private void createPopupMenu() {
        MJPopupMenu.setDefaultLightWeightPopupEnabled((boolean)false);
        this.fPopupMenu = new MJPopupMenu();
        this.fPopupMenu.add((Action)((Object)this.fEvalAction));
        this.fPopupMenu.add((Action)((Object)this.fCreateMFileAction));
        this.fPopupMenu.add((Action)((Object)this.fCreateShortcutAction));
        this.fPopupMenu.add((Action)((Object)this.fProfileCodeAction));
        this.fPopupMenu.addSeparator();
        this.fPopupMenu.add((Action)((Object)this.fCutAction));
        this.fPopupMenu.add((Action)((Object)this.fCopyAction));
        this.fPopupMenu.add((Action)((Object)this.fDeleteSelectionAction));
        this.fPopupMenu.add((Action)((Object)this.fDeleteToSelectionAction));
        this.fPopupMenu.addSeparator();
        this.fPopupMenu.add((Action)((Object)this.fSelectAllAction));
        this.fPopupMenu.add((Action)((Object)this.fFindAction));
        this.fPopupMenu.addSeparator();
        this.fPopupMenu.add((Action)((Object)this.fPrintAction));
        this.fPopupMenu.add((Action)((Object)this.fPrintSelectionAction));
        this.fPopupMenu.add((Action)((Object)this.fPageSetupAction));
        this.fPopupMenu.addSeparator();
        this.fPopupMenu.add((Action)((Object)this.fDeleteEntireHistoryAction));
    }

    private void addTreeToPanel() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.addTreeToPanelMethod();
        } else {
            SwingUtilities.invokeLater(new AddTreeToPanelThread());
        }
    }

    private void addTreeToPanelMethod() {
        this.removeAll();
        this.add((Component)this.fScrolledTree, "Center");
        this.fModel.reload();
        this.fTree.expandAllNodes();
        this.fTree.addTreeExpansionListener(new ContentsTreeExpansionListener());
        this.scrollToRow(this.fTree.getRowCount() - 1);
        this.validate();
    }

    public void reloadModel() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.reloadModelMethod();
        } else {
            SwingUtilities.invokeLater(new ReloadModelThread());
        }
    }

    private void reloadModelMethod() {
        this.fModel.reload();
    }

    public static ConfirmationDialogPrefsPanel.DialogItem[] getDialogItems() {
        return new ConfirmationDialogPrefsPanel.DialogItem[]{new ConfirmationDialogPrefsPanel.DialogItem(sRes.getString("chpp.delete_dialog"), "CommandHistoryDeleteConfirm", sCmdHistoryName, true)};
    }

    private boolean hasTreePathInArray(TreePath[] treePathArray, TreePath treePath) {
        for (int i = 0; i < treePathArray.length; ++i) {
            if (!treePathArray[i].equals(treePath)) continue;
            return true;
        }
        return false;
    }

    private void deleteSelectedCommands(boolean bl) {
        TreePath[] treePathArray;
        if (this.fTree.isSelectionEmpty()) {
            return;
        }
        int n = this.fTree.getLeadSelectionRow();
        TreePath[] treePathArray2 = this.fTree.getSelectionPaths();
        int n2 = 1;
        TreePath treePath = this.fTree.getPathForRow(n + n2);
        while (this.hasTreePathInArray(treePathArray2, treePath)) {
            treePath = this.fTree.getPathForRow(n + ++n2);
        }
        boolean bl2 = n == this.fTree.getRowCount() - 1;
        int n3 = 0;
        if (bl) {
            n3 = Dialogs.showOptionalConfirmDialog((Component)((Object)this), (Object)sRes.getString("message.delete_commands"), (String)sCmdHistoryName, (int)2, (int)2, (String)"CommandHistoryDeleteConfirm", (int)0, (boolean)true);
        }
        if (n3 == 0 && (treePathArray = this.fTree.getSelectionPaths()) != null) {
            NodeRemovalList nodeRemovalList = new NodeRemovalList();
            for (int i = 0; i < treePathArray.length && n3 != 2; ++i) {
                int n4;
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[i].getLastPathComponent();
                if (!(defaultMutableTreeNode.getUserObject() instanceof String) || (n4 = this.fTree.getRowForPath(treePathArray[i])) == -1) continue;
                if (!defaultMutableTreeNode.isLeaf()) {
                    int n5;
                    boolean bl3 = true;
                    if (this.fTree.isExpanded(n4)) {
                        for (n5 = defaultMutableTreeNode.getChildCount(); n5 > 0; --n5) {
                            if (this.fTree.isPathSelected(this.fTree.getPathForRow(n4 + n5))) continue;
                            bl3 = false;
                            break;
                        }
                    }
                    if (!bl3) continue;
                    for (n5 = defaultMutableTreeNode.getChildCount(); n5 > 0; --n5) {
                        TreeNode treeNode = defaultMutableTreeNode.getChildAt(n5 - 1);
                        Object[] objectArray = new Object[treePathArray[i].getPathCount() + 1];
                        for (int j = 0; j < treePathArray[i].getPathCount(); ++j) {
                            objectArray[j] = treePathArray[i].getPathComponent(j);
                        }
                        objectArray[objectArray.length - 1] = treeNode;
                        nodeRemovalList.add(new TreePath(objectArray), n4 + n5);
                    }
                    nodeRemovalList.add(treePathArray[i]);
                    continue;
                }
                nodeRemovalList.add(treePathArray[i]);
            }
            nodeRemovalList.fireAll();
            this.selectAfterDelete(treePath, bl2);
        }
    }

    private void selectAfterDelete(TreePath treePath, boolean bl) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        int n = this.fTree.getRowForPath(treePath);
        if (treePath != null) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            int n2 = defaultMutableTreeNode.getChildCount();
            while (this.isExpandedDateNode(treePath) && n2 > 0 && n < this.fTree.getRowCount()) {
                treePath = this.fTree.getPathForRow(n++);
            }
        }
        if (treePath == null || n == -1) {
            treePath = this.fTree.getPathForRow(this.fTree.getRowCount() - 1);
        }
        if ((defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent()) == this.fCurrentDateNode && defaultMutableTreeNode.getChildCount() == 0 && this.fTree.getRowCount() > 1 && bl) {
            Toolkit.getDefaultToolkit().beep();
        }
        if (treePath != null) {
            this.fTree.setSelectionPath(treePath);
        }
    }

    private String[] getSelectedStrings() {
        TreePath[] treePathArray = this.getSortedTreePaths(this.fTree.getSelectionPaths());
        LinkedList<String> linkedList = new LinkedList<String>();
        for (int i = 0; i < treePathArray.length; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[i].getLastPathComponent();
            if (defaultMutableTreeNode.getUserObject() instanceof String) {
                linkedList.add((String)defaultMutableTreeNode.getUserObject());
            }
            if (defaultMutableTreeNode.getChildCount() <= 0 || !this.fTree.isCollapsed(treePathArray[i])) continue;
            for (int j = 0; j < defaultMutableTreeNode.getChildCount(); ++j) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(j);
                if (!(defaultMutableTreeNode2.getUserObject() instanceof String)) continue;
                linkedList.add((String)defaultMutableTreeNode2.getUserObject());
            }
        }
        return linkedList.toArray(new String[0]);
    }

    private String getSelectedCommands() {
        String string = "";
        if (this.fTree.isSelectionEmpty()) {
            return string;
        }
        TreePath[] treePathArray = this.getSortedTreePaths(this.fTree.getSelectionPaths());
        for (int i = 0; i < treePathArray.length; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[i].getLastPathComponent();
            if (!(defaultMutableTreeNode.getUserObject() instanceof String)) continue;
            string = string + (String)defaultMutableTreeNode.getUserObject() + NEWLINE;
            if (defaultMutableTreeNode.getChildCount() <= 0 || !this.fTree.isCollapsed(treePathArray[i])) continue;
            for (int j = 0; j < defaultMutableTreeNode.getChildCount(); ++j) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(j);
                string = string + (String)defaultMutableTreeNode2.getUserObject() + NEWLINE;
            }
        }
        return string;
    }

    private void executeSelectedCommands() {
        if (this.fTree.isSelectionEmpty()) {
            return;
        }
        TreePath[] treePathArray = this.getSortedTreePaths(this.fTree.getSelectionPaths());
        this.fPendingCommands = treePathArray.length;
        for (int i = 0; i < treePathArray.length; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[i].getLastPathComponent();
            if (!defaultMutableTreeNode.isLeaf() || !(defaultMutableTreeNode.getUserObject() instanceof String)) continue;
            MLExecuteServices.executeCommand((String)((String)defaultMutableTreeNode.getUserObject()));
        }
    }

    private void copySelectedCommands() {
        if (this.fTree.isSelectionEmpty()) {
            return;
        }
        String string = this.getSelectedCommands().trim();
        if (string.length() > 0) {
            MJClipboard.getMJClipboard().setContents(string, null);
            if (PlatformInfo.isXWindows()) {
                MJClipboard.getMJClipboard().setXSelectionContents(string);
            }
        }
    }

    private TreePath[] getSortedTreePaths(TreePath[] treePathArray) {
        int n;
        int n2 = treePathArray.length;
        Vector<Integer> vector = new Vector<Integer>(n2);
        for (n = 0; n < treePathArray.length; ++n) {
            vector.addElement(new Integer(this.fTree.getRowForPath(treePathArray[n])));
        }
        Collections.sort(vector);
        for (n = 0; n < vector.size(); ++n) {
            Integer n3 = (Integer)vector.elementAt(n);
            int n4 = n3;
            treePathArray[n] = this.fTree.getPathForRow(n4);
        }
        return treePathArray;
    }

    private void enableCommands() {
        boolean bl = !this.fTree.isSelectionEmpty();
        this.fCopyAction.setEnabled(bl);
        this.fCutAction.setEnabled(bl);
        this.fEvalAction.setEnabled(bl);
        this.fCreateMFileAction.setEnabled(bl);
        this.fCreateShortcutAction.setEnabled(bl);
        this.fDeleteSelectionAction.setEnabled(bl);
        this.fProfileCodeAction.setEnabled(bl);
        int[] nArray = this.fTree.getSelectionRows();
        bl = nArray != null && nArray.length == 1;
        this.fDeleteToSelectionAction.setEnabled(bl);
    }

    private void deleteToSelection(boolean bl) {
        if (this.fTree.isSelectionEmpty()) {
            return;
        }
        int n = 0;
        if (bl) {
            n = MJOptionPane.showConfirmDialog((Component)((Object)this), (Object)sRes.getString("message.delete_to_selected"), (String)sCmdHistoryName, (int)0);
        }
        if (n == 0) {
            int n2;
            TreePath[] treePathArray = this.fTree.getSelectionPaths();
            int n3 = this.fTree.getRowForPath(treePathArray[0]);
            int n4 = this.fTree.getRowForPath(new TreePath(this.fCurrentDateNode.getPath()));
            for (int i = n3 - 1; i >= 0; --i) {
                if (i == n4) continue;
                this.fHistory.remove(i);
            }
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[0].getLastPathComponent();
            int n5 = defaultMutableTreeNode.getLevel();
            DefaultMutableTreeNode defaultMutableTreeNode2 = defaultMutableTreeNode;
            if (n5 == 2) {
                defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                for (n2 = defaultMutableTreeNode2.getIndex(defaultMutableTreeNode) - 1; n2 >= 0; --n2) {
                    this.fModel.removeNodeFromParent((DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(n2));
                }
            }
            for (n2 = this.fTopNode.getIndex(defaultMutableTreeNode2) - 1; n2 >= 0; --n2) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)this.fTopNode.getChildAt(n2);
                this.fModel.removeNodeFromParent(defaultMutableTreeNode3);
            }
        }
    }

    private void deleteAllHistory() {
        this.fTopNode.removeAllChildren();
        this.fCurrentDateNode = this.fTopNode;
        CmdHistoryIO.addStartingTagLine();
        this.fModel.reload(this.fTopNode);
    }

    public void addFindParentListener(FindParentListener findParentListener) {
        this.fFindListener = findParentListener;
        this.setActiveColors();
    }

    public void bringForward() {
        MLDesktop.getInstance().showCommandHistory();
    }

    public void findBack(FindEvent findEvent) {
        this.fFindString = findEvent.getFindString();
        this.fFindOptions = findEvent.getOptions();
        if (this.fFindString.length() > 0 && this.fTree.getRowCount() > 0) {
            boolean bl;
            int n;
            this.fInFindSelection = true;
            boolean bl2 = (this.fFindOptions & 1) != 0;
            boolean bl3 = (this.fFindOptions & 4) != 0;
            boolean bl4 = (this.fFindOptions & 2) != 0;
            int n2 = 0;
            int[] nArray = this.fTree.getSelectionRows();
            if (nArray == null || nArray.length == 0) {
                n = this.fTree.getRowCount() - 1;
            } else {
                n = nArray[nArray.length - 1];
                boolean bl5 = bl = StringUtils.indexOf((String)this.getStringFromRow(n), (String)this.fFindString, (int)0, (boolean)bl2) != -1;
                if (bl && n != n2) {
                    --n;
                } else if (bl && n == n2) {
                    n = bl4 ? this.fTree.getRowCount() - 1 : -1;
                    MJUtilities.beep();
                }
            }
            bl = false;
            boolean bl6 = false;
            int n3 = 0;
            int n4 = 0;
            int n5 = this.fTree.getRowCount();
            while (n != -1 && !bl) {
                String string = this.getStringFromRow(n);
                n3 = StringUtils.indexOf((String)string, (String)this.fFindString, (int)n3, (boolean)bl2);
                boolean bl7 = bl = n3 != -1;
                if (bl && bl3) {
                    bl = StringUtils.isWholeWord((String)string, (String)this.fFindString);
                }
                if (bl) {
                    this.fTree.removeSelectionRows(this.fTree.getSelectionRows());
                    this.fTree.setSelectionRow(n);
                    this.scrollToRow(n);
                    if (bl6) {
                        MJUtilities.beep();
                    }
                }
                if (++n4 == n5) {
                    bl = true;
                    MJUtilities.beep();
                }
                if (--n >= 0) continue;
                if (bl4) {
                    n = this.fTree.getRowCount() - 1;
                    bl6 = true;
                    continue;
                }
                if (bl) continue;
                MJUtilities.beep();
            }
            this.fInFindSelection = false;
        } else {
            MJUtilities.beep();
        }
        this.fFirstFind = false;
    }

    public void findForward(FindEvent findEvent) {
        this.fFindString = findEvent.getFindString();
        this.fFindOptions = findEvent.getOptions();
        if (this.fFindString.length() > 0 && this.fTree.getRowCount() > 0) {
            boolean bl;
            boolean bl2 = (this.fFindOptions & 1) != 0;
            boolean bl3 = (this.fFindOptions & 4) != 0;
            boolean bl4 = (this.fFindOptions & 2) != 0;
            boolean bl5 = this.fFirstFind;
            this.fInFindSelection = true;
            int n = -1;
            int n2 = this.fTree.getRowCount() - 1;
            if (bl5) {
                if (this.fTree.isRowSelected(n2)) {
                    n = 0;
                } else {
                    bl5 = false;
                }
            }
            if (!bl5) {
                int[] nArray = this.fTree.getSelectionRows();
                if (nArray != null && nArray.length > 0) {
                    n = nArray[nArray.length - 1];
                    boolean bl6 = bl = StringUtils.indexOf((String)this.getStringFromRow(n), (String)this.fFindString, (int)0, (boolean)bl2) != -1;
                    if (bl && n != n2) {
                        ++n;
                    } else if (bl && n == n2) {
                        n = bl4 ? 0 : -1;
                        MJUtilities.beep();
                    }
                } else {
                    n = 0;
                }
            }
            bl = false;
            boolean bl7 = false;
            int n3 = 0;
            int n4 = 0;
            int n5 = this.fTree.getRowCount();
            while (n != -1 && !bl && n < this.fTree.getRowCount()) {
                String string = this.getStringFromRow(n);
                n3 = StringUtils.indexOf((String)string, (String)this.fFindString, (int)n3, (boolean)bl2);
                boolean bl8 = bl = n3 != -1;
                if (bl && bl3) {
                    bl = StringUtils.isWholeWord((String)string, (String)this.fFindString);
                }
                if (bl) {
                    this.fTree.removeSelectionRows(this.fTree.getSelectionRows());
                    this.fTree.setSelectionRow(n);
                    this.scrollToRow(n);
                    if (bl7) {
                        MJUtilities.beep();
                    }
                }
                if (++n4 == n5) {
                    bl = true;
                    MJUtilities.beep();
                }
                if (++n < this.fTree.getRowCount()) continue;
                if (bl4) {
                    n = 0;
                    bl7 = true;
                    continue;
                }
                if (bl) continue;
                MJUtilities.beep();
            }
            this.fInFindSelection = false;
        } else {
            MJUtilities.beep();
        }
        this.fFirstFind = false;
    }

    private void scrollToRow(int n) {
        Rectangle rectangle = this.fTree.getRowBounds(n);
        if (rectangle != null) {
            rectangle.x = 0;
            this.fTree.scrollRectToVisible(rectangle);
        }
    }

    public Component getInvoker() {
        return this;
    }

    public void removeFindParentListener(FindParentListener findParentListener) {
        this.fFindListener = null;
        if (FindDialog.isReparenting()) {
            this.setDeactivatedColors();
        }
    }

    FindParentListener getFindParentListener() {
        return this.fFindListener;
    }

    FindDialog getFindDialog() {
        return this.fFindDialog;
    }

    public void replace(FindEvent findEvent) {
    }

    public void replaceAll(FindEvent findEvent) {
    }

    private void setDeactivatedColors() {
        this.fHistoryRenderer.setBackgroundSelectionColor(ColorUtils.getUnfocusedSelectionBackgroundColor((Component)((Object)this)));
        this.fHistoryRenderer.setTextSelectionColor(ColorUtils.getUnfocusedSelectionForegroundColor((Component)((Object)this)));
        this.repaint();
    }

    private void setActiveColors() {
        this.fHistoryRenderer.setBackgroundSelectionColor(ColorUtils.getSelectionBackgroundColor());
        this.fHistoryRenderer.setTextSelectionColor(ColorUtils.getSelectionForegroundColor());
        this.repaint();
    }

    private String getStringFromRow(int n) {
        return (String)((DefaultMutableTreeNode)this.fTree.getPathForRow(n).getLastPathComponent()).getUserObject();
    }

    private void registerWithFindDialog() {
        FindClientRegistry.register((FindClientInterface)this, (String[])new String[]{sRes.getString("find.LookinName")}, (boolean)false);
    }

    private static void deleteSelForTesting() {
        sHistoryWindow.deleteSelectedCommands(false);
    }

    private static void deleteToSelectionForTesting() {
        sHistoryWindow.deleteToSelection(false);
    }

    private static synchronized Boolean isDoneLoading() {
        return CmdHistoryWindow.sHistoryWindow.fIsPopulated;
    }

    static {
        sCmdHistoryName = sRes.getString("title");
    }

    private class ClientListener
    extends DTClientAdapter {
        private ClientListener() {
        }

        public void clientActivated(DTClientEvent dTClientEvent) {
            FindParentListener findParentListener = CmdHistoryWindow.this.fFindListener;
            if (findParentListener == null) {
                CmdHistoryWindow.this.registerWithFindDialog();
            }
        }

        public void clientDocked(DTClientEvent dTClientEvent) {
            FindParentListener findParentListener = CmdHistoryWindow.this.fFindListener;
            if (findParentListener != null) {
                findParentListener.docked((FindClientInterface)CmdHistoryWindow.this);
            }
        }

        public void clientUndocked(DTClientEvent dTClientEvent) {
            FindParentListener findParentListener = CmdHistoryWindow.this.fFindListener;
            if (findParentListener != null) {
                findParentListener.undocked((FindClientInterface)CmdHistoryWindow.this);
            }
        }

        public void clientClosed(DTClientEvent dTClientEvent) {
            FindParentListener findParentListener = CmdHistoryWindow.this.fFindListener;
            if (findParentListener != null) {
                findParentListener.closing((FindClientInterface)CmdHistoryWindow.this);
            }
            FindClientRegistry.unregister((FindClientInterface)CmdHistoryWindow.this);
        }

        public void clientOpened(DTClientEvent dTClientEvent) {
            CmdHistoryWindow.this.registerWithFindDialog();
        }
    }

    private class FindDialogAction
    extends MJAbstractAction {
        FindDialogAction() {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo(CmdHistoryWindow.COMMAND_HISTORY_CONTEXT, "find-and-replace", (ExtendedAction)this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CmdHistoryWindow.this.fFindDialog = FindDialog.invoke((FindClientInterface)CmdHistoryWindow.this, (String)CmdHistoryWindow.this.fFindString, (int)CmdHistoryWindow.this.fFindOptions);
            CmdHistoryWindow.this.fFirstFind = true;
        }
    }

    private class MyAppearanceFocusListener
    implements AppearanceFocusListener {
        private MyAppearanceFocusListener() {
        }

        public void appearanceFocusGained(AppearanceFocusEvent appearanceFocusEvent) {
            CmdHistoryWindow.this.setActiveColors();
        }

        public void appearanceFocusLost(AppearanceFocusEvent appearanceFocusEvent) {
            Window window;
            FindParentListener findParentListener = CmdHistoryWindow.this.getFindParentListener();
            Component component = appearanceFocusEvent.getFocusEvent().getOppositeComponent();
            Window window2 = window = findParentListener == null ? null : findParentListener.getWindow();
            if (findParentListener != null && window != null && (component == window || SwingUtilities.getAncestorOfClass(window.getClass(), component) != null && SwingUtilities.getAncestorOfClass(window.getClass(), component).equals(window))) {
                return;
            }
            CmdHistoryWindow.this.setDeactivatedColors();
        }
    }

    class ColorTreeRenderer
    extends DefaultTreeCellRenderer
    implements ListCellRenderer {
        private SyntaxTextLabel fLabel = new SyntaxTextLabel(0);
        private MJLabel fJawsLabel;

        ColorTreeRenderer() {
            this.fLabel.setOpaque(true);
            this.fJawsLabel = new MJLabel();
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            return this.getTreeCellRendererComponent((JTree)((Object)CmdHistoryWindow.this.fTree), object, bl, false, true, n, bl2);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            String string = jTree.convertValueToText(object, bl, bl2, bl3, n, bl4);
            if (!SwingUtilities.isEventDispatchThread()) {
                this.fJawsLabel.setText(string);
                return this.fJawsLabel;
            }
            this.fLabel.setPreferredSize(null);
            this.fLabel.setText(string, false);
            this.fLabel.setFont(jTree.getFont());
            this.fLabel.setSelected(bl);
            if (bl) {
                this.fLabel.setBackground(this.getBackgroundSelectionColor());
                this.fLabel.setForeground(this.getTextSelectionColor());
            } else {
                this.fLabel.setBackground(CmdHistoryWindow.this.fTree.getBackground());
                this.fLabel.setForeground(CmdHistoryWindow.this.fTree.getForeground());
            }
            Dimension dimension = this.fLabel.getPreferredSize();
            this.fLabel.setPreferredSize(new Dimension(dimension.width + 2, dimension.height));
            if (bl4) {
                this.fLabel.setBorder(null);
                if (bl) {
                    this.fLabel.setBorder(UIDefaultsLookup.getBorder((Object)"Table.focusSelectedCellHighlightBorder"));
                }
                if (this.fLabel.getBorder() == null) {
                    this.fLabel.setBorder(UIDefaultsLookup.getBorder((Object)"Table.focusCellHighlightBorder"));
                }
            } else {
                this.fLabel.setBorder((Border)new EmptyBorder(1, 1, 1, 1));
            }
            return this.fLabel;
        }
    }

    class DragListener
    implements DragGestureListener,
    DragSourceListener,
    DropTargetListener {
        DragListener() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            if (CmdHistoryWindow.this.fTree.isSelectionEmpty()) {
                return;
            }
            String string = null;
            TreePath[] treePathArray = CmdHistoryWindow.this.getSortedTreePaths(CmdHistoryWindow.this.fTree.getSelectionPaths());
            for (int i = 0; i < treePathArray.length; ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[i].getLastPathComponent();
                if (!defaultMutableTreeNode.isLeaf() || !(defaultMutableTreeNode.getUserObject() instanceof String)) continue;
                string = string == null ? (String)defaultMutableTreeNode.getUserObject() : string.concat(CmdHistoryWindow.NEWLINE + (String)defaultMutableTreeNode.getUserObject());
            }
            if (string == null) {
                return;
            }
            StringSelection stringSelection = new StringSelection(string);
            CmdHistoryWindow.this.fDragSource.startDrag(dragGestureEvent, MJDragCursorUtilities.getCursor((int)1), MJDragCursorUtilities.getMacImageToDrag(), new Point(0, 0), stringSelection, this);
        }

        @Override
        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
            Cursor cursor = null;
            Cursor cursor2 = dragSourceDragEvent.getDragSourceContext().getCursor();
            switch (dragSourceDragEvent.getUserAction()) {
                case 1: {
                    if (cursor2.equals(MJDragCursorUtilities.getCursor((int)1))) break;
                    cursor = MJDragCursorUtilities.getCursor((int)1);
                    break;
                }
                default: {
                    cursor = MJDragCursorUtilities.getCursor((int)1);
                }
            }
            if (cursor != null) {
                dragSourceDragEvent.getDragSourceContext().setCursor(cursor);
            }
        }

        @Override
        public void dragExit(DragSourceEvent dragSourceEvent) {
            dragSourceEvent.getDragSourceContext().setCursor(MJDragCursorUtilities.getCursor((int)7563));
        }

        @Override
        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
            Cursor cursor = null;
            Cursor cursor2 = dragSourceDragEvent.getDragSourceContext().getCursor();
            switch (dragSourceDragEvent.getUserAction()) {
                case 1: {
                    if (cursor2.equals(MJDragCursorUtilities.getCursor((int)1))) break;
                    cursor = MJDragCursorUtilities.getCursor((int)1);
                    break;
                }
                default: {
                    cursor = MJDragCursorUtilities.getCursor((int)1);
                }
            }
            if (cursor != null) {
                dragSourceDragEvent.getDragSourceContext().setCursor(cursor);
            }
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        }

        @Override
        public void dragExit(DropTargetEvent dropTargetEvent) {
        }

        @Override
        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            dropTargetDragEvent.rejectDrag();
        }

        @Override
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            dropTargetDropEvent.rejectDrop();
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }
    }

    private class DeleteEntireHistoryAction
    extends MJAbstractAction {
        DeleteEntireHistoryAction() {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo(CmdHistoryWindow.COMMAND_HISTORY_CONTEXT, "clear-command-history", (ExtendedAction)this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = MJOptionPane.showConfirmDialog((Component)((Object)CmdHistoryWindow.this), (Object)sRes.getString("message.delete_entire_history"), (String)sCmdHistoryName, (int)0);
            if (n == 0) {
                CmdHistoryWindow.this.fHistory.removeAll();
            }
        }
    }

    private class DeleteToSelectionAction
    extends MJAbstractAction {
        DeleteToSelectionAction() {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo(CmdHistoryWindow.COMMAND_HISTORY_CONTEXT, "delete-commands-to-selection", (ExtendedAction)this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CmdHistoryWindow.this.deleteToSelection(true);
        }
    }

    private class DeleteSelectionAction
    extends MJAbstractAction {
        DeleteSelectionAction() {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo(CmdHistoryWindow.COMMAND_HISTORY_CONTEXT, "delete-next", (ExtendedAction)this);
            this.setName(sRes.getString("action.delete_selection"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CmdHistoryWindow.this.deleteSelectedCommands(true);
        }
    }

    private class ProfileCodeAction
    extends MJAbstractAction {
        ProfileCodeAction() {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo(CmdHistoryWindow.COMMAND_HISTORY_CONTEXT, "profile-selected-code", (ExtendedAction)this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String[] stringArray = CmdHistoryWindow.this.getSelectedStrings();
            MLExecuteServices.executeCommand((String)"profile on");
            for (int i = 0; i < stringArray.length; ++i) {
                MLExecuteServices.executeCommand((String)stringArray[i]);
            }
            MLExecuteServices.executeCommand((String)"profile viewer");
        }
    }

    private class CreateShortcutAction
    extends MJAbstractAction {
        CreateShortcutAction() {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo(CmdHistoryWindow.COMMAND_HISTORY_CONTEXT, "create-shortcut-from-selection", (ExtendedAction)this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ShortcutEditor.invoke(null, (String)CmdHistoryWindow.this.getSelectedCommands(), (String)ShortcutUtils.getDefaultToolbarCategoryName());
        }
    }

    private class CreateMFileAction
    extends MJAbstractAction {
        CreateMFileAction() {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo(CmdHistoryWindow.COMMAND_HISTORY_CONTEXT, "create-mfile-from-selection", (ExtendedAction)this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MLEditorServices.getEditorApplication().newEditor(CmdHistoryWindow.this.getSelectedCommands());
        }
    }

    private class EvalAction
    extends MJAbstractAction {
        EvalAction() {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo(CmdHistoryWindow.COMMAND_HISTORY_CONTEXT, "evaluate-selection", (ExtendedAction)this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CmdHistoryWindow.this.executeSelectedCommands();
        }
    }

    class PageSetupAction
    extends MJAbstractAction {
        PageSetupAction() {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo(CmdHistoryWindow.COMMAND_HISTORY_CONTEXT, "show-page-setup", (ExtendedAction)this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CmdHistoryPrinter.pageSetup();
        }
    }

    private class PrintSelectionAction
    extends MJAbstractAction {
        PrintSelectionAction() {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo(CmdHistoryWindow.COMMAND_HISTORY_CONTEXT, "print-selection", (ExtendedAction)this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MJList mJList = new MJList((Object[])CmdHistoryWindow.this.getSelectedStrings());
            mJList.setCellRenderer((ListCellRenderer)new ColorTreeRenderer());
            mJList.setFont(CmdHistoryWindow.this.fTree.getFont());
            CmdHistoryPrinter.print((JList)mJList);
        }
    }

    private class PrintAction
    extends MJAbstractAction {
        PrintAction() {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo(CmdHistoryWindow.COMMAND_HISTORY_CONTEXT, "print", (ExtendedAction)this);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CmdHistoryPrinter.print((JTree)((Object)CmdHistoryWindow.this.fTree));
        }
    }

    private class CutAction
    extends MJAbstractAction {
        CutAction() {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo(CmdHistoryWindow.COMMAND_HISTORY_CONTEXT, "cut-to-clipboard", (ExtendedAction)this);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CmdHistoryWindow.this.copySelectedCommands();
            CmdHistoryWindow.this.deleteSelectedCommands(false);
        }
    }

    private class SelectAllAction
    extends MJAbstractAction {
        SelectAllAction() {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo(CmdHistoryWindow.COMMAND_HISTORY_CONTEXT, "select-all", (ExtendedAction)this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CmdHistoryWindow.this.fTree.setSelectionInterval(0, CmdHistoryWindow.this.fTree.getRowCount() - 1);
        }
    }

    private class CopyAction
    extends MJAbstractAction {
        CopyAction() {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo(CmdHistoryWindow.COMMAND_HISTORY_CONTEXT, "copy-to-clipboard", (ExtendedAction)this);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CmdHistoryWindow.this.copySelectedCommands();
        }
    }

    private class NodeRemovalList {
        private final Map<TreeNode, List<TreePath>> removals = new HashMap<TreeNode, List<TreePath>>();
        private final Set<Integer> rows = new TreeSet<Integer>();

        NodeRemovalList() {
        }

        public void add(TreePath treePath) {
            if (treePath.getLastPathComponent() == CmdHistoryWindow.this.fCurrentDateNode) {
                return;
            }
            this.add(treePath, CmdHistoryWindow.this.fTree.getRowForPath(treePath));
        }

        public void add(TreePath treePath, int n) {
            if (treePath.getLastPathComponent() == CmdHistoryWindow.this.fCurrentDateNode) {
                return;
            }
            this.rows.add(n);
            TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
            MutableTreeNode mutableTreeNode = (MutableTreeNode)treeNode.getParent();
            List<TreePath> list = this.removals.get(mutableTreeNode);
            if (list == null) {
                list = new LinkedList<TreePath>();
                this.removals.put(mutableTreeNode, list);
            }
            list.add(treePath);
        }

        public void fireAll() {
            Object object;
            Object object22;
            Iterator<Integer> iterator = this.rows.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                CmdHistoryWindow.this.fHistory.remove(iterator.next() - n);
                ++n;
            }
            Vector<Object> vector = new Vector<Object>();
            for (int i = 0; i < CmdHistoryWindow.this.fTopNode.getChildCount(); ++i) {
                object22 = (DefaultMutableTreeNode)CmdHistoryWindow.this.fTopNode.getChildAt(i);
                object = new TreePath(((DefaultMutableTreeNode)object22).getPath());
                if (!CmdHistoryWindow.this.fTree.isExpanded((TreePath)object)) continue;
                vector.add(object);
            }
            Iterator<TreeNode> iterator2 = this.removals.keySet().iterator();
            while (iterator2.hasNext()) {
                object = object22 = iterator2.next();
                List<TreePath> list = this.removals.get(object22);
                for (TreePath treePath : list) {
                    TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
                    int n2 = object22.getIndex(treeNode);
                    if (n2 < 0) continue;
                    ((DefaultMutableTreeNode)object).remove(n2);
                }
                CmdHistoryWindow.this.fModel.nodeStructureChanged((TreeNode)object22);
            }
            for (Object object22 : vector) {
                CmdHistoryWindow.this.fTree.expandPath((TreePath)object22);
            }
        }
    }

    private class CmdHistPropertyChangedListener
    implements PropertyChangeListener {
        private CmdHistPropertyChangedListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            CmdHistoryWindow.this.enableCommands();
        }
    }

    private class CmdHistoryMouseAdapter
    extends MouseAdapter {
        private CmdHistoryMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showPopupMenu(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showPopupMenu(mouseEvent);
            } else if (mouseEvent.getClickCount() == 2) {
                CmdHistoryWindow.this.executeSelectedCommands();
            }
        }

        private void showPopupMenu(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (object instanceof Component) {
                if (CmdHistoryWindow.this.fPopupMenu == null) {
                    CmdHistoryWindow.this.createPopupMenu();
                }
                CmdHistoryWindow.this.enableCommands();
                CmdHistoryWindow.this.fPopupMenu.show((Component)object, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    private class ReloadModelThread
    implements Runnable {
        private ReloadModelThread() {
        }

        @Override
        public void run() {
            CmdHistoryWindow.this.reloadModelMethod();
        }
    }

    private class AddTreeToPanelThread
    implements Runnable {
        private AddTreeToPanelThread() {
        }

        @Override
        public void run() {
            CmdHistoryWindow.this.addTreeToPanelMethod();
        }
    }

    private class HistoryTree
    extends MJTree {
        private HistoryTree() {
        }

        public void expandAllNodes() {
            for (int i = 0; i < this.getRowCount(); ++i) {
                TreePath treePath = this.getPathForRow(i);
                if (treePath == null) continue;
                this.expandRecursively(treePath);
            }
        }

        public TreePath getNextMatch(String string, int n, Position.Bias bias) {
            return null;
        }
    }

    private class MyHistoryChangedListener
    implements HistoryChangedListener {
        private MyHistoryChangedListener() {
        }

        @Override
        public void commandAdded(final int n, final boolean bl) {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MyHistoryChangedListener.this.commandAdded(n, bl);
                    }
                });
                return;
            }
            String string = (String)CmdHistoryWindow.this.fHistoryCommands.elementAt(n);
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string);
            TreePath[] treePathArray = CmdHistoryWindow.this.fTree.getSelectionPaths();
            CmdHistoryWindow.this.fCurrentDateNode.add(defaultMutableTreeNode);
            if (defaultMutableTreeNode.getLevel() == 1 && string.startsWith("%--")) {
                CmdHistoryWindow.this.fCurrentDateNode = defaultMutableTreeNode;
                if (bl) {
                    CmdHistoryWindow.this.fModel.nodesWereInserted(CmdHistoryWindow.this.fTopNode, new int[]{CmdHistoryWindow.this.fTopNode.getChildCount() - 1});
                }
            } else {
                if (bl) {
                    CmdHistoryWindow.this.fModel.reload(CmdHistoryWindow.this.fCurrentDateNode);
                }
                TreePath treePath = new TreePath(CmdHistoryWindow.this.fCurrentDateNode.getPath());
                CmdHistoryWindow.this.fTree.expandPath(treePath);
                if (treePathArray != null) {
                    CmdHistoryWindow.this.fTree.setSelectionPaths(treePathArray);
                    treePathArray = null;
                }
                if (CmdHistoryWindow.this.fPendingCommands == 0) {
                    CmdHistoryWindow.this.scrollToRow(CmdHistoryWindow.this.fTree.getRowCount() - 1);
                }
                if (CmdHistoryWindow.this.fPendingCommands > 0) {
                    CmdHistoryWindow.this.fPendingCommands--;
                }
            }
        }

        @Override
        public void commandRemoved(int n) {
        }

        @Override
        public void allCommandsRemoved() {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MyHistoryChangedListener.this.allCommandsRemoved();
                    }
                });
                return;
            }
            CmdHistoryWindow.this.deleteAllHistory();
        }
    }

    private class CmdHistColorListener
    implements PrefListener {
        private CmdHistColorListener() {
        }

        public void prefChanged(PrefEvent prefEvent) {
            if (prefEvent.getPrefKey().equals("ColorsBackground")) {
                CmdHistoryWindow.this.setBackgroundColor();
            }
            if (prefEvent.getPrefKey().equals("ColorsText")) {
                CmdHistoryWindow.this.setForegroundColor();
            }
            CmdHistoryWindow.this.fTree.repaint();
        }
    }

    private class CmdHistFontListener
    implements FontListener {
        private CmdHistFontListener() {
        }

        public void fontChanged(Font font) {
            CmdHistoryWindow.this.setFont(font);
        }
    }

    private class SetAnchorSelectionThread
    implements Runnable {
        private TreePath fAnchorPath;
        private TreePath fLeadPath;

        SetAnchorSelectionThread(TreePath treePath, TreePath treePath2) {
            this.fAnchorPath = treePath;
            this.fLeadPath = treePath2;
        }

        @Override
        public void run() {
            if (this.fAnchorPath != null) {
                CmdHistoryWindow.this.fTree.setAnchorSelectionPath(this.fAnchorPath);
            }
            if (this.fLeadPath != null) {
                CmdHistoryWindow.this.fTree.setLeadSelectionPath(this.fLeadPath);
            }
        }
    }

    private class ContentsTreeExpansionListener
    implements TreeExpansionListener {
        private ContentsTreeExpansionListener() {
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        }

        @Override
        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            TreePath treePath = treeExpansionEvent.getPath();
            TreePath[] treePathArray = CmdHistoryWindow.this.fTree.getSelectionPaths();
            if (treePathArray != null) {
                boolean bl = false;
                for (int i = 0; i < treePathArray.length; ++i) {
                    if (!treePathArray[i].equals(treePath)) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                    int n = CmdHistoryWindow.this.fTree.getRowForPath(treePath);
                    if (defaultMutableTreeNode.getLevel() == 1 && !defaultMutableTreeNode.isLeaf()) {
                        int n2 = defaultMutableTreeNode.getChildCount();
                        TreePath treePath2 = CmdHistoryWindow.this.fTree.getAnchorSelectionPath();
                        CmdHistoryWindow.this.fTree.addSelectionInterval(n + 1, n + n2);
                        SwingUtilities.invokeLater(new SetAnchorSelectionThread(treePath2, CmdHistoryWindow.this.fTree.getPathForRow(n + n2)));
                    }
                }
            }
        }
    }

    private class CmdHistTreeSelectionListener
    implements TreeSelectionListener {
        private CmdHistTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            CmdHistoryWindow.this.fPrintSelectionAction.setEnabled(CmdHistoryWindow.this.fTree != null && CmdHistoryWindow.this.fTree.getSelectionPaths() != null && CmdHistoryWindow.this.fTree.getSelectionPaths().length > 0);
            TreePath[] treePathArray = treeSelectionEvent.getPaths();
            if (treePathArray != null) {
                for (int i = 0; i < treePathArray.length; ++i) {
                    TreePath treePath = treePathArray[i];
                    if (!treeSelectionEvent.isAddedPath(treePath)) continue;
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                    int n = CmdHistoryWindow.this.fTree.getRowForPath(treePath);
                    if (!CmdHistoryWindow.this.isExpandedDateNode(treePath) || CmdHistoryWindow.this.fInFindSelection) continue;
                    int n2 = defaultMutableTreeNode.getChildCount();
                    boolean bl = false;
                    if (CmdHistoryWindow.this.fTree.getSelectionPaths().length == 1 && CmdHistoryWindow.this.fTree.isPathSelected(treePath)) {
                        bl = true;
                    }
                    CmdHistoryWindow.this.fTree.addSelectionInterval(n + 1, n + n2);
                    if (!bl) continue;
                    SwingUtilities.invokeLater(new SetAnchorSelectionThread(treePath, treePath));
                }
            }
        }
    }

    private class PopulateThread
    extends Thread {
        private PopulateThread() {
        }

        @Override
        public void run() {
            FindParentListener findParentListener;
            Serializable serializable;
            Object object;
            CmdHistoryWindow.this.fHistory = CmdHistory.getInstance();
            CmdHistoryWindow.this.fHistoryCommands = CmdHistoryWindow.this.fHistory.getHistoryCommands();
            CmdHistoryWindow.this.fHistory.addHistoryChangedListener(new MyHistoryChangedListener());
            CmdHistoryWindow.this.fCurrentDateNode = null;
            for (int i = 0; i < CmdHistoryWindow.this.fHistoryCommands.size(); ++i) {
                object = (String)CmdHistoryWindow.this.fHistoryCommands.elementAt(i);
                serializable = new DefaultMutableTreeNode(object);
                if (((String)object).startsWith("%--")) {
                    CmdHistoryWindow.this.fTopNode.add((MutableTreeNode)((Object)serializable));
                    CmdHistoryWindow.this.fCurrentDateNode = serializable;
                    continue;
                }
                CmdHistoryWindow.this.fCurrentDateNode.add((MutableTreeNode)((Object)serializable));
            }
            CmdHistoryWindow.this.addTreeToPanel();
            CmdHistoryWindow.this.fDropTargetListener = new DragListener();
            new DropTarget((Component)((Object)CmdHistoryWindow.this.fTree), CmdHistoryWindow.this.fDropTargetListener);
            CmdHistoryWindow.this.fDragSource = new DragSource();
            CmdHistoryWindow.this.fDragGestureListener = (DragGestureListener)((Object)CmdHistoryWindow.this.fDropTargetListener);
            CmdHistoryWindow.this.fDragSource.createDefaultDragGestureRecognizer((Component)((Object)CmdHistoryWindow.this.fTree), 3, CmdHistoryWindow.this.fDragGestureListener);
            MLDesktop.getInstance().addClientListener((Component)((Object)CmdHistoryWindow.this), (DTClientListener)new ClientListener());
            AppearanceFocusDispatcher appearanceFocusDispatcher = new AppearanceFocusDispatcher();
            appearanceFocusDispatcher.addAppearanceFocusListener((AppearanceFocusListener)new MyAppearanceFocusListener());
            CmdHistoryWindow.this.fTree.addFocusListener((FocusListener)appearanceFocusDispatcher);
            object = CmdHistoryWindow.this.fTree.getActionMap();
            serializable = CmdHistoryWindow.this.fTree.getInputMap(0);
            MInputMap mInputMap = new MInputMap();
            mInputMap.setParent((InputMap)serializable);
            CmdHistoryWindow.this.fTree.setInputMap(0, (InputMap)mInputMap);
            for (ExtendedAction extendedAction : findParentListener = new FindParentListener[]{CmdHistoryWindow.this.fCopyAction, CmdHistoryWindow.this.fCutAction, CmdHistoryWindow.this.fEvalAction, CmdHistoryWindow.this.fDeleteSelectionAction, CmdHistoryWindow.this.fDeleteToSelectionAction, CmdHistoryWindow.this.fFindAction, CmdHistoryWindow.this.fPrintAction, CmdHistoryWindow.this.fPrintSelectionAction, CmdHistoryWindow.this.fPageSetupAction, CmdHistoryWindow.this.fCreateMFileAction, CmdHistoryWindow.this.fCreateShortcutAction, CmdHistoryWindow.this.fProfileCodeAction, CmdHistoryWindow.this.fDeleteEntireHistoryAction}) {
                MatlabKeyBindings.getManager().addToActionMap(extendedAction, (ActionMap)object);
                MatlabKeyBindings.getManager().addKeyBindings(extendedAction, (ExtendedInputMap)mInputMap);
            }
            FindParentListener findParentListener2 = CmdHistoryWindow.this.fFindListener;
            if (findParentListener2 == null) {
                CmdHistoryWindow.this.registerWithFindDialog();
            }
            CmdHistoryWindow.this.fIsPopulated = true;
        }
    }
}

