/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.cmdwin;

import com.mathworks.jmi.AWTUtilities;
import com.mathworks.matlab.api.editor.Editor;
import com.mathworks.mde.cmdwin.CmdWinDocumentUtilities;
import com.mathworks.mde.cmdwin.CmdWinMLIF;
import com.mathworks.mde.cmdwin.CmdWinPrefs;
import com.mathworks.mde.cmdwin.CmdWinSyntaxWrapper;
import com.mathworks.mde.cmdwin.CmdWinUndoManager;
import com.mathworks.mde.cmdwin.Prompt;
import com.mathworks.mde.cmdwin.TypoSuggestionEvent;
import com.mathworks.mde.cmdwin.XCmdWndView;
import com.mathworks.mlservices.MLEditorServices;
import com.mathworks.mvm.context.MvmContext;
import com.mathworks.mvm.eventmgr.MvmListener;
import com.mathworks.mwswing.AttributedCharacters;
import com.mathworks.services.ColorPrefs;
import com.mathworks.util.CharBuffer;
import com.mathworks.util.FileUtils;
import com.mathworks.util.Log;
import com.mathworks.util.StringUtils;
import com.mathworks.widgets.TextPrintPanel;
import com.mathworks.widgets.incSearch.IncSearchData;
import com.mathworks.widgets.text.print.PrintableTextDocument;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.File;
import java.text.AttributedCharacterIterator;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.GapContent;
import javax.swing.text.PlainDocument;
import javax.swing.text.Segment;

public class CmdWinDocument
extends PlainDocument
implements PrintableTextDocument {
    private int fPromptOffset = -1;
    private Prompt fInUsePrompt = Prompt.NULL_PROMPT;
    private String fInUsePromptText = this.fInUsePrompt.toString();
    private Prompt fPrompt = Prompt.NULL_PROMPT;
    private boolean fUserInitialized = false;
    private static final Pattern REXEXP_HYPERLINK_START = Pattern.compile("<(a\\s+href\\s*=\\s*\"([^\"]*)\"([^>]*)|strong)>");
    private static final Pattern REXEXP_STRONG_ATTRIBUTE = Pattern.compile("\\bstyle\\s*=\\s*\"[^\"]*\\bfont-weight\\s*:\\s*bold\\b[^\"]*\"");
    private static final Pattern REGEXP_WARNING_START = Pattern.compile("\\[\b");
    private static final Pattern REGEXP_WARNING_END = Pattern.compile("\\]\b");
    static final String SYNTAX_TOKENS = "SyntaxTokens";
    static final String LINK_START_TOKENS = "LinkStartTokens";
    static final String BOLD_START_TOKENS = "BoldStartTokens";
    static final String HTML_LINK_TOKENS = "HtmlLink";
    private static boolean sBeforePrompt = false;
    private static int sPrintRangeStart = 0;
    private static int sPrintRangeEnd = 0;
    private static int sLastPrintEndPos = 0;
    private static boolean sPrintingDone = true;
    private static int sPrintLineCount = 1;
    private static int sPrintCurrentLine = 1;
    private static Segment sPrintingSegment;
    private int fLastIncLength = 0;
    private boolean fFirstInc = true;
    private int fFirstIncPos = -1;
    private boolean fWrapped = false;
    private boolean fShouldSyntaxColorize = false;
    private static int sMaxLines;
    private boolean fTruncated = false;
    private static final char[] sEmpty;
    private static Vector<SpecialCharacter> sSpecialCharacters;
    private static Vector<AnnotatedInfo> sAnnotatedInfo;
    private static final String LINK_ID = "CWLink";
    private static final String ERROR_ID;
    private static final String WARNING_ID;
    private static int sMaxLineLength;
    private int fUnmatchedLTPos = -1;
    private int fContinueOffset = -1;
    private boolean fAbortedWarning = false;
    private int fUnmatchedWarningStartSentinel = -1;
    private boolean fCommandsIsSuggestion = false;
    private static final AbstractDocument.Content sContent;
    private static ResourceBundle sRes;
    private static final CmdWinDocument sCWDoc;
    private static final String MATLABLINK_START = "matlab:";
    private static final String ERROR_LINK_START = "error:";
    private static final String OPENTOLINE = "opentoline";

    private CmdWinDocument(AbstractDocument.Content content) {
        super(content);
        String string = System.getProperty("mathworks.cmdwin.maxlinelen");
        if (string != null) {
            sMaxLineLength = new Integer(string);
        }
        this.addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                if (sBeforePrompt) {
                    AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = (AbstractDocument.DefaultDocumentEvent)documentEvent;
                    defaultDocumentEvent.die();
                }
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }
        });
        try {
            MvmContext.get().getEventMgr().addMvmListener((MvmListener)new MvmListener<TypoSuggestionEvent>(){

                public void mvmChanged(TypoSuggestionEvent typoSuggestionEvent) {
                    final String string = typoSuggestionEvent.getSuggestion();
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                String string2 = sRes.getString("cwts.DidYouMean") + '\n';
                                CmdWinDocument.this.insertBeforePrompt(string2.toCharArray(), string2.length(), false);
                                CmdWinDocument.this.insertAtPrompt(string);
                                CmdWinDocument.this.fCommandsIsSuggestion = true;
                            }
                            catch (BadLocationException badLocationException) {
                                Log.logException((Exception)badLocationException);
                            }
                        }
                    });
                }
            }, TypoSuggestionEvent.class);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void addAttributesToElements(int n, int n2, Object[] objectArray, boolean bl) {
        this.addAttributesToElements(n, n2, objectArray, null, null, null, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAttributesToElements(int n, int n2, Object[] objectArray, int[] nArray, int[] nArray2, Object[] objectArray2, boolean bl) {
        this.writeLock();
        try {
            Object object;
            int n3;
            Element element = this.getDefaultRootElement();
            assert (element != null) : "The root element of the document cannot be null";
            int n4 = element.getElementIndex(n);
            int n5 = element.getElementIndex(n2);
            int n6 = element.getElement(n4).getStartOffset();
            int n7 = this.getPromptOffset();
            int n8 = n7 - n6;
            if (objectArray != null) {
                n3 = element.getElementIndex(n7);
                object = (int[])objectArray[0];
                if (n3 == n4) {
                    for (int i = 0; i < ((Object)object).length; ++i) {
                        if (object[i] + n > n7) {
                            object[i] = object[i] + this.getInUsePromptLength() + n8;
                        }
                        if (nArray != null && nArray[i] != -1 && nArray[i] + n > n7) {
                            nArray[i] = nArray[i] + this.getInUsePromptLength() + n8;
                        }
                        if (nArray2 == null || nArray2[i] == -1 || nArray2[i] + n <= n7) continue;
                        nArray2[i] = nArray2[i] + this.getInUsePromptLength() + n8;
                    }
                }
            }
            for (n3 = n4; n3 <= n5; ++n3) {
                object = element.getElement(n3);
                if (!(object instanceof AbstractDocument.LeafElement)) continue;
                AbstractDocument.LeafElement leafElement = (AbstractDocument.LeafElement)object;
                if (bl && n8 >= 0) {
                    this.removeAttributesAfterPosition(n7, n8);
                } else if (bl && n8 < 0) {
                    this.removeAttributes(n);
                }
                this.addNewAttributesToElement(leafElement, objectArray, nArray, nArray2, objectArray2, n8);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    private void addHtmlAttribute(int n, int n2, String string, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4;
        if (n2 == 0) {
            return;
        }
        boolean bl5 = bl4 = string != null;
        String string2 = bl ? ERROR_ID : (bl3 ? WARNING_ID : (bl4 ? LINK_ID : null));
        Element element = this.getDefaultRootElement();
        assert (element != null) : "The root element of the document cannot be null";
        int n3 = element.getElementIndex(n);
        int n4 = n + n2;
        int n5 = element.getElementIndex(n4);
        for (int i = n3; i <= n5; ++i) {
            int[] nArray;
            int[] nArray2;
            int n6;
            Element element2 = element.getElement(i);
            int n7 = element2.getStartOffset();
            int n8 = element.getElement(n3).getStartOffset();
            int n9 = this.getPromptOffset();
            int n10 = n9 - n8;
            int n11 = n6 = !bl4 && !bl2 ? -1 : n - n7;
            if (!(element2 instanceof AbstractDocument.LeafElement)) continue;
            AbstractDocument.LeafElement leafElement = (AbstractDocument.LeafElement)element2;
            Object[] objectArray = new Object[]{new int[]{n - n7, n2 + n - n7}, new String[]{string2, null}};
            if (bl4) {
                int[] nArray3 = new int[2];
                nArray3[0] = n6;
                nArray2 = nArray3;
                nArray3[1] = -1;
            } else {
                int[] nArray4 = new int[2];
                nArray4[0] = -1;
                nArray2 = nArray4;
                nArray4[1] = -1;
            }
            int[] nArray5 = nArray2;
            if (bl2) {
                int[] nArray6 = new int[2];
                nArray6[0] = n6;
                nArray = nArray6;
                nArray6[1] = -1;
            } else {
                int[] nArray7 = new int[2];
                nArray7[0] = -1;
                nArray = nArray7;
                nArray7[1] = -1;
            }
            int[] nArray8 = nArray;
            String[] stringArray = new String[]{string, null};
            Object[] objectArray2 = new Object[]{objectArray[0], stringArray};
            this.addNewAttributesToElement(leafElement, objectArray, nArray5, nArray8, objectArray2, n10);
        }
    }

    private void addNewAttributesToElement(AbstractDocument.LeafElement leafElement, Object[] objectArray, int[] nArray, int[] nArray2, Object[] objectArray2, int n) {
        Object[] objectArray3 = (Object[])leafElement.getAttribute(SYNTAX_TOKENS);
        int[] nArray3 = (int[])leafElement.getAttribute(LINK_START_TOKENS);
        int[] nArray4 = (int[])leafElement.getAttribute(BOLD_START_TOKENS);
        Object[] objectArray4 = (Object[])leafElement.getAttribute(HTML_LINK_TOKENS);
        leafElement.removeAttributes(leafElement.getAttributes());
        if (objectArray3 != null && n != 0) {
            objectArray = CmdWinDocumentUtilities.mergeColors(objectArray3, (int[])objectArray[0], (String[])objectArray[1]);
        }
        if (nArray3 != null) {
            nArray = CmdWinDocumentUtilities.mergeUnderlines(nArray3, nArray, (int[])objectArray[0]);
        }
        if (nArray4 != null) {
            nArray2 = CmdWinDocumentUtilities.mergeUnderlines(nArray4, nArray2, (int[])objectArray[0]);
        }
        if (objectArray4 != null) {
            objectArray2 = CmdWinDocumentUtilities.mergeLinkLocs(objectArray4, objectArray2, (int[])objectArray[0]);
        }
        if (objectArray != null) {
            leafElement.addAttribute(SYNTAX_TOKENS, objectArray);
        }
        if (objectArray2 != null) {
            leafElement.addAttribute(HTML_LINK_TOKENS, objectArray2);
        }
        if (nArray != null) {
            leafElement.addAttribute(LINK_START_TOKENS, nArray);
        }
        if (nArray2 != null) {
            leafElement.addAttribute(BOLD_START_TOKENS, nArray2);
        }
    }

    void appendPrompt() throws BadLocationException {
        int n = this.getPromptLineEndOffset(true);
        if (n == -1) {
            throw new BadLocationException("Can't get offset for append prompt", n);
        }
        this.insertPrompt(n);
    }

    public void flushBuffer(char[] cArray, int n, int n2, boolean bl) {
        if (n2 == 0) {
            return;
        }
        FlushRunnable.addTextAndInvoke(cArray, n, n2, bl);
    }

    static void closeText() {
        FlushRunnable.finishCurrentRunnable();
    }

    void shouldSyntaxHighlight(boolean bl) {
        this.fShouldSyntaxColorize = bl;
    }

    void clear() {
        try {
            this.insertPrompt(0);
            sBeforePrompt = true;
            this.remove(this.getInUsePromptLength(), this.getLength() - this.getInUsePromptLength());
            sBeforePrompt = false;
            this.fUnmatchedLTPos = -1;
            this.fContinueOffset = -1;
        }
        catch (Exception exception) {
            Log.logException((Exception)exception);
        }
    }

    @Override
    protected Element createLeafElement(Element element, AttributeSet attributeSet, int n, int n2) {
        Element element2 = null;
        try {
            element2 = this.getParagraphElement(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (element2 != null && element2.getStartOffset() == n && element2.getEndOffset() - 1 >= n2) {
            attributeSet = element2.getAttributes();
        }
        return super.createLeafElement(element, attributeSet, n, n2);
    }

    public void startingPrinting(int n, int n2) {
        sPrintRangeStart = n;
        sPrintRangeEnd = n2;
        if (sPrintRangeEnd > sCWDoc.getLength()) {
            sPrintRangeEnd = sCWDoc.getLength();
        }
        sLastPrintEndPos = sPrintRangeStart;
        sPrintingDone = false;
        sPrintLineCount = -1;
        sPrintCurrentLine = 1;
        try {
            sPrintingSegment = new Segment();
            sCWDoc.getText(0, sPrintRangeEnd, sPrintingSegment);
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
            sPrintingDone = true;
            sPrintingSegment = null;
        }
    }

    public AttributedCharacterIterator[] createPrintIterators(int n) {
        boolean bl;
        if (sPrintingDone) {
            sPrintingSegment = null;
            return null;
        }
        LinkedList<AttributedCharacterIterator> linkedList = new LinkedList<AttributedCharacterIterator>();
        Font font = CmdWinPrefs.getPrintingBodyFont();
        boolean bl2 = bl = (CmdWinPrefs.getPrintOptions() & 4) != 0;
        if (bl && sPrintLineCount == -1) {
            int n2 = sPrintRangeStart;
            while (n2 != -1) {
                int[] nArray = CmdWinDocument.findPattern("\n", n2, sPrintingSegment);
                n2 = nArray[1];
                ++sPrintLineCount;
            }
        }
        Integer n3 = sPrintLineCount;
        int n4 = n3.toString().length();
        CmdWinDocument.sPrintingSegment.count = sPrintRangeEnd;
        char[] cArray = CmdWinDocument.sPrintingSegment.array;
        int n5 = sLastPrintEndPos;
        int n6 = sPrintRangeStart;
        cArray = CmdWinDocument.fixTabCharactersForPrinting(cArray);
        sPrintingSegment = new Segment(cArray, 0, sPrintRangeEnd);
        CmdWinDocument.sPrintingSegment.count = sPrintRangeEnd;
        int n7 = 0;
        char[] cArray2 = new char[]{' '};
        for (int i = 0; n6 != -1 && i < n; ++i) {
            int n8;
            Object object;
            Object object2;
            n7 = 0;
            int[] nArray = CmdWinDocument.findPattern("\n", sLastPrintEndPos, sPrintingSegment);
            n6 = nArray[1];
            if (sPrintingDone) continue;
            AttributedCharacters attributedCharacters = new AttributedCharacters();
            if (bl) {
                object2 = new char[n4 + 1];
                Arrays.fill(object2, ' ');
                Integer n9 = sPrintCurrentLine;
                object = n9.toString();
                n8 = n4 - ((String)object).length();
                for (int j = 0; j < ((String)object).length(); ++j) {
                    object2[n8] = ((String)object).charAt(j);
                    ++n8;
                }
                attributedCharacters.append(object2, font, Color.black);
                ++sPrintCurrentLine;
            }
            if (nArray[0] >= sPrintRangeEnd) {
                nArray[0] = sPrintRangeEnd;
                n6 = -1;
            }
            if (nArray[0] == -1) {
                nArray[0] = sPrintRangeEnd;
            }
            object2 = java.nio.CharBuffer.wrap(cArray);
            int n10 = CmdWinDocument.findPrecedingNewLine(n5, (java.nio.CharBuffer)object2) + 1;
            object = this.getDefaultRootElement();
            assert (object != null) : "The root element of the document cannot be null";
            n8 = object.getElementIndex(n5);
            Element element = object.getElement(n8);
            if (element instanceof AbstractDocument.LeafElement) {
                AbstractDocument.LeafElement leafElement = (AbstractDocument.LeafElement)element;
                Object[] objectArray = (Object[])leafElement.getAttribute(SYNTAX_TOKENS);
                if (objectArray != null) {
                    int n11;
                    char[] cArray3;
                    int n12;
                    int[] nArray2 = (int[])objectArray[0];
                    int[] nArray3 = new int[nArray2.length];
                    System.arraycopy(nArray2, 0, nArray3, 0, nArray2.length);
                    int n13 = 0;
                    while (n13 < nArray3.length) {
                        int n14 = n13++;
                        nArray3[n14] = nArray3[n14] + n10;
                    }
                    String[] stringArray = (String[])objectArray[1];
                    for (n12 = 0; n12 < stringArray.length - 1 && nArray3[n12] < n5 && nArray3[n12] < nArray[0] && nArray3[n12] < n5 && nArray3[n12] < nArray[0]; ++n12) {
                    }
                    if (n10 < n5 && i == 0) {
                        cArray3 = new char[n5 - n10];
                        Arrays.fill(cArray3, ' ');
                        attributedCharacters.append(cArray3, 0, cArray3.length, CmdWinDocument.getFontForID(null, font), CmdWinDocument.getPrintingColorFromPrefs(null));
                        n7 += cArray3.length;
                    }
                    if (nArray3[n12] > n5) {
                        cArray3 = n12 > 0 ? stringArray[n12 - 1] : null;
                        n11 = nArray[0] > nArray3[n12] ? nArray3[n12] : nArray[0];
                        attributedCharacters.append(cArray, n5, n11 - n5, font, CmdWinDocument.getPrintingColorFromPrefs((String)cArray3));
                        n5 = n11;
                        n7 += n11 - n5;
                    }
                    for (int j = n12; j < stringArray.length; ++j) {
                        if (j < stringArray.length - 1) {
                            int n15 = n11 = nArray[0] > nArray3[j + 1] ? nArray3[j + 1] : nArray[0];
                            if (nArray[0] < nArray3[j]) {
                                n5 = nArray[0];
                                n6 = nArray[1];
                                break;
                            }
                            attributedCharacters.append(cArray, nArray3[j], n11 - nArray3[j], CmdWinDocument.getFontForID(stringArray[j], font), CmdWinDocument.getPrintingColorFromPrefs(stringArray[j]));
                            n7 += nArray3[j + 1] - nArray3[j];
                            continue;
                        }
                        if (nArray[0] <= nArray3[j]) continue;
                        if (cArray[nArray3[j]] == '\n' && cArray.length >= nArray3[j] + 1) {
                            if (nArray3[j] + 1 == nArray[0] || sLastPrintEndPos >= nArray[0]) continue;
                            n11 = sLastPrintEndPos > nArray3[j] + 1 ? sLastPrintEndPos : nArray3[j] + 1;
                            attributedCharacters.append(cArray, n11, nArray[0] - n11, CmdWinDocument.getFontForID(stringArray[j], font), CmdWinDocument.getPrintingColorFromPrefs(stringArray[j]));
                            n7 += nArray[0] - (nArray3[j] + 1);
                            continue;
                        }
                        if (sLastPrintEndPos >= nArray[0]) continue;
                        n11 = sLastPrintEndPos > nArray3[j] ? sLastPrintEndPos : nArray3[j];
                        attributedCharacters.append(cArray, n11, nArray[0] - n11, CmdWinDocument.getFontForID(stringArray[j], font), CmdWinDocument.getPrintingColorFromPrefs(stringArray[j]));
                        n7 += nArray[0] - nArray3[j];
                    }
                } else if (nArray[0] > n5) {
                    attributedCharacters.append(cArray, n5, nArray[0] - n5, font, CmdWinDocument.getPrintingColorFromPrefs(null));
                    n7 += nArray[0] - n5;
                }
            } else {
                attributedCharacters.append(cArray, n5, nArray[0] - 1 - n5, font, CmdWinDocument.getPrintingColorFromPrefs(null));
                n7 += nArray[0] - 1 - n5;
            }
            if (n7 == 0) {
                attributedCharacters.append(cArray2, 0, 1, font, CmdWinDocument.getPrintingColorFromPrefs(null));
            }
            linkedList.add(attributedCharacters.iterator());
            sLastPrintEndPos = n6;
            n5 = n6;
            if (n6 != -1) continue;
            sPrintingDone = true;
        }
        sLastPrintEndPos = n6;
        return linkedList.toArray(new AttributedCharacterIterator[linkedList.size()]);
    }

    private static char[] fixTabCharactersForPrinting(char[] cArray) {
        CharBuffer charBuffer = new CharBuffer();
        charBuffer.append(cArray);
        java.nio.CharBuffer charBuffer2 = java.nio.CharBuffer.wrap(charBuffer.getRawBuf());
        int[] nArray = StringUtils.findPattern((String)"\t", (int)sPrintRangeStart, (CharSequence)charBuffer2);
        if (nArray[0] != -1) {
            int n = CmdWinDocument.findPrecedingNewLine(nArray[0], charBuffer2);
            int n2 = nArray[0];
            int n3 = CmdWinPrefs.getTabSize();
            char[] cArray2 = new char[n3];
            Arrays.fill(cArray2, 0, n3, ' ');
            int n4 = 0;
            while (n2 != -1 && n2 < sPrintRangeEnd) {
                int n5 = 0;
                if (n != -1) {
                    n5 = nArray[0] - n - 1;
                }
                int n6 = n5 / n3;
                n4 = n3 - (n5 - n6 * n3);
                charBuffer.replace(nArray[0], nArray[1], cArray2, 0, n4);
                charBuffer2 = java.nio.CharBuffer.wrap(charBuffer.getRawBuf());
                nArray = StringUtils.findPattern((String)"\t", (int)nArray[1], (CharSequence)charBuffer2);
                if (nArray[0] != -1) {
                    n = CmdWinDocument.findPrecedingNewLine(nArray[0], charBuffer2);
                }
                n2 = nArray[1];
                sPrintRangeEnd += n4 - 1;
            }
            cArray = charBuffer2.array();
        }
        return cArray;
    }

    private static int findPrecedingNewLine(int n, java.nio.CharBuffer charBuffer) {
        int n2 = -1;
        int n3 = n;
        if (n3 > 0) {
            int[] nArray = StringUtils.findPattern((String)"\n", (int)n3--, (CharSequence)charBuffer);
            while (nArray[0] >= n && nArray[0] != -1 && n3 != -1) {
                nArray = StringUtils.findPattern((String)"\n", (int)n3--, (CharSequence)charBuffer);
                n2 = nArray[0];
                if (n3 != -1 || nArray[0] < n || nArray[0] == -1) continue;
                n2 = -1;
            }
        } else {
            n2 = -1;
        }
        return n2;
    }

    private static Color getPrintingColorFromPrefs(String string) {
        if (!TextPrintPanel.isColored((int)CmdWinPrefs.getPrintOptions())) {
            return Color.black;
        }
        if (string == null) {
            Color color = ColorPrefs.getTextColor();
            if (color.equals(Color.white)) {
                return Color.black;
            }
            return color;
        }
        return ColorPrefs.getColorPref((String)string);
    }

    private static Font getFontForID(String string, Font font) {
        if (TextPrintPanel.isStylized((int)CmdWinPrefs.getPrintOptions()) && string != null) {
            if (string.endsWith(ColorPrefs.M_CATEGORIES[1])) {
                return font.deriveFont(2);
            }
            if (string.endsWith(ColorPrefs.M_CATEGORIES[0])) {
                return font.deriveFont(1);
            }
            return font;
        }
        return font;
    }

    private static int[] findPattern(String string, int n, Segment segment) {
        java.nio.CharBuffer charBuffer = java.nio.CharBuffer.wrap(segment.array, 0, segment.getEndIndex());
        return StringUtils.findPattern((String)string, (int)n, (CharSequence)charBuffer);
    }

    int getAfterThePrompt() {
        return this.getPromptOffset() + this.getInUsePromptLength();
    }

    Prompt getCurrentPrompt() {
        return this.fPrompt;
    }

    void getCurrentPromptLine(Segment segment) throws BadLocationException {
        this.getText(this.getAfterThePrompt(), this.getPromptLineEndOffset(false) - this.getAfterThePrompt(), segment);
    }

    void clearSuggestion() throws BadLocationException {
        if (this.fCommandsIsSuggestion) {
            this.removeCurrentPromptLine();
            this.fCommandsIsSuggestion = false;
        }
    }

    void clearSuggestionFlag() {
        this.fCommandsIsSuggestion = false;
    }

    public static CmdWinDocument getInstance() {
        return sCWDoc;
    }

    public Prompt getInUsePrompt() {
        return this.fInUsePrompt;
    }

    private void updateInUsePrompt() {
        this.fInUsePrompt = this.getCurrentPrompt();
        this.fInUsePromptText = this.fInUsePrompt.toString();
    }

    int getInUsePromptLength() {
        return this.fInUsePromptText.length();
    }

    int getPromptLineEndOffset(boolean bl) {
        int n = this.getLength();
        assert (n >= this.getAfterThePrompt()) : "End offset must be after the prompt";
        if (!bl) {
            if (n == this.getAfterThePrompt()) {
                return n;
            }
            Segment segment = new Segment();
            try {
                this.getText(n - 1, 1, segment);
            }
            catch (BadLocationException badLocationException) {
                Log.logException((Exception)badLocationException);
            }
            if (segment.first() == '\n') {
                --n;
            }
        }
        return n;
    }

    int getPromptOffset() {
        return this.fPromptOffset;
    }

    void insertAtPrompt(String string) throws BadLocationException {
        this.insertString(this.getAfterThePrompt(), string, null);
    }

    private void insertBeforePrompt(char[] cArray, int n, boolean bl) throws BadLocationException {
        block10: {
            Element element = this.getDefaultRootElement();
            assert (element != null) : "The root element of the document cannot be null";
            int n2 = element.getElementIndex(this.getPromptOffset());
            Element element2 = element.getElement(n2);
            if (element2.getEndOffset() - element2.getStartOffset() < sMaxLineLength) {
                this.fTruncated = false;
                try {
                    this.removeAttributesAfterPosition(this.getPromptOffset(), this.getPromptPositionOnLine(this.getPromptOffset()));
                    this.insertChars(this.getPromptOffset(), cArray, n, bl);
                    if (this.getAfterThePrompt() == this.getLength()) break block10;
                    char c = cArray[n - 1];
                    Prompt prompt = this.getInUsePrompt();
                    if (prompt == Prompt.NULL_PROMPT && c != '\n') {
                        this.setPrompt(Prompt.TYPEAHEAD_PROMPT);
                        this.replacePrompt();
                    }
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    if (sMaxLines > 1000) {
                        sMaxLines /= 2;
                    }
                    Element element3 = this.getDefaultRootElement();
                    int n3 = element3.getElementCount() - sMaxLines;
                    this.integralRemoveFromFront((CWContent)this.getContent(), element3, n3);
                    this.insertChars(this.getPromptOffset(), cArray, n, bl);
                }
                catch (BadLocationException badLocationException) {
                    this.setPromptOffset(this.getLength());
                    this.insertPrompt(this.fPromptOffset);
                }
            } else {
                if (!this.fTruncated) {
                    Object[] objectArray = new Object[]{sMaxLineLength};
                    String string = MessageFormat.format(sRes.getString("error.maxline"), objectArray);
                    this.insertChars(this.getPromptOffset(), string.toCharArray(), string.length(), false);
                    this.fTruncated = true;
                }
                if (cArray[n - 1] == '\n') {
                    this.fTruncated = false;
                    this.insertChars(this.getPromptOffset(), new char[]{'\n'}, 1, false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertChars(int n, char[] cArray, int n2, boolean bl) throws BadLocationException {
        assert (EventQueue.isDispatchThread()) : "This method must be called on the EDT";
        this.writeLock();
        sBeforePrompt = true;
        try {
            CmdWinUndoManager.getInstance().reset();
            CWContent cWContent = (CWContent)this.getContent();
            cWContent.insertChars(n, cArray, n2);
            AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = new AbstractDocument.DefaultDocumentEvent(this, n, n2, DocumentEvent.EventType.INSERT);
            this.insertUpdate(defaultDocumentEvent, null);
            defaultDocumentEvent.end();
            this.setPromptOffset(this.getPromptOffset() + n2);
            this.fireInsertUpdate(defaultDocumentEvent);
            this.updateAndAdjustSize(cWContent, n, n2, bl);
        }
        catch (Exception exception) {
            Log.logException((Exception)exception);
        }
        finally {
            sBeforePrompt = false;
            this.writeUnlock();
        }
    }

    @Override
    protected void insertUpdate(AbstractDocument.DefaultDocumentEvent defaultDocumentEvent, AttributeSet attributeSet) {
        super.insertUpdate(defaultDocumentEvent, attributeSet);
        if (!sBeforePrompt && this.fShouldSyntaxColorize) {
            this.syntaxUpdate();
        }
    }

    @Override
    protected void postRemoveUpdate(AbstractDocument.DefaultDocumentEvent defaultDocumentEvent) {
        if (!sBeforePrompt && this.fShouldSyntaxColorize) {
            this.removeAttributesAfterPosition(this.getPromptOffset(), this.getPromptPositionOnLine(defaultDocumentEvent.getOffset()));
            this.syntaxUpdate();
        }
    }

    private int getPromptPositionOnLine(int n) {
        Element element = this.getDefaultRootElement();
        int n2 = element.getElementIndex(n);
        int n3 = element.getElement(n2).getStartOffset();
        int n4 = this.getPromptOffset();
        return n4 - n3;
    }

    private void fixSpecialCharacters(CWContent cWContent, int n, int n2, boolean bl) {
        boolean bl2;
        int n3;
        int n4;
        if (n2 == 0) {
            return;
        }
        int n5 = 0;
        sSpecialCharacters.removeAllElements();
        sAnnotatedInfo.removeAllElements();
        if (this.fAbortedWarning) {
            n2 += n - this.fUnmatchedWarningStartSentinel;
            n = this.fUnmatchedWarningStartSentinel;
            this.fUnmatchedWarningStartSentinel = -1;
        }
        this.fAbortedWarning = false;
        if (this.fContinueOffset != n) {
            this.fUnmatchedLTPos = -1;
        }
        int n6 = n;
        if (this.fUnmatchedLTPos != -1) {
            n2 += n - this.fUnmatchedLTPos;
            n = this.fUnmatchedLTPos;
        }
        Segment segment = new Segment();
        try {
            cWContent.getChars(n, n2, segment);
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
        }
        Matcher matcher = REGEXP_WARNING_START.matcher(java.nio.CharBuffer.wrap(segment.array, 0, segment.getEndIndex()));
        boolean bl3 = matcher.find(n);
        Matcher matcher2 = REGEXP_WARNING_END.matcher(java.nio.CharBuffer.wrap(segment.array, 0, segment.getEndIndex()));
        boolean bl4 = bl3 ? matcher2.find(matcher.end()) : false;
        Matcher matcher3 = REXEXP_HYPERLINK_START.matcher(java.nio.CharBuffer.wrap(segment.array, 0, segment.getEndIndex()));
        boolean bl5 = matcher3.find(n);
        if (!(this.fUnmatchedLTPos == -1 || bl5 && matcher3.start() == this.fUnmatchedLTPos)) {
            n = n6;
            n2 -= n - this.fUnmatchedLTPos;
        }
        boolean bl6 = false;
        int n7 = -1;
        char c = segment.setIndex(n);
        block8: while (c != '\uffff') {
            switch (c) {
                case '[': {
                    if (!bl3 || segment.getIndex() != matcher.start()) break;
                    if (!bl4) {
                        this.fAbortedWarning = true;
                        this.fUnmatchedWarningStartSentinel = segment.getIndex() - n5;
                        segment.last();
                        n2 = this.fUnmatchedWarningStartSentinel - n + 1;
                        break;
                    }
                    n4 = matcher.end();
                    int n8 = matcher2.start() - 1;
                    bl3 = matcher.find();
                    if (bl3 && matcher.end() < n8) break;
                    Object object2 = new AnnotatedInfo(AnnotatedOutputType.WARNING, n4 - 2 - n5, n8 - n4 + 1);
                    sAnnotatedInfo.addElement((AnnotatedInfo)object2);
                    n7 = sAnnotatedInfo.size() - 1;
                    bl4 = matcher2.find();
                    c = segment.next();
                    continue block8;
                }
                case '\b': {
                    n4 = segment.getIndex();
                    while (c == '\b') {
                        n5 += 2;
                        c = segment.next();
                    }
                    this.addSpecialCharacter(SpecialType.BLSHB, n4, segment.getIndex() - n4);
                    continue block8;
                }
                case '\r': {
                    n4 = segment.getIndex();
                    while (c == '\r') {
                        c = segment.next();
                    }
                    this.addSpecialCharacter(SpecialType.BLSHR, n4, segment.getIndex() - n4);
                    continue block8;
                }
                case '<': {
                    Object object;
                    String string;
                    int n8;
                    n4 = segment.getIndex();
                    int n9 = n8 = bl5 ? matcher3.start() : -1;
                    if (n4 != n8) {
                        if (bl6) {
                            bl6 = false;
                            break;
                        }
                        this.fUnmatchedLTPos = n4;
                        break;
                    }
                    Object object2 = null;
                    n3 = matcher3.end();
                    bl2 = matcher3.group(1).equals("strong");
                    if (bl2) {
                        string = "</strong>";
                    } else {
                        object2 = matcher3.group(2);
                        string = "</a>";
                        object = REXEXP_STRONG_ATTRIBUTE.matcher(matcher3.group(3));
                        bl2 = ((Matcher)object).find();
                    }
                    object = CmdWinDocument.findPattern(string, n3, segment);
                    if (object[0] == -1) {
                        bl6 = true;
                        this.fUnmatchedLTPos = n4;
                        break;
                    }
                    Object object3 = object[0];
                    Object object4 = object[1];
                    this.fUnmatchedLTPos = -1;
                    bl5 = matcher3.find();
                    if (bl5 && matcher3.start() < object3) break;
                    int n10 = n3 - n8;
                    this.addSpecialCharacter(SpecialType.HTML, n8, n10);
                    AnnotatedOutputType annotatedOutputType = bl2 ? AnnotatedOutputType.STRONG : AnnotatedOutputType.HYPERLINK;
                    AnnotatedInfo annotatedInfo = new AnnotatedInfo(annotatedOutputType, n8 - n5, (int)(object3 - n3));
                    annotatedInfo.setHyperlinkAddress((String)object2);
                    sAnnotatedInfo.addElement(annotatedInfo);
                    reference var29_40 = object4 - object3;
                    this.addSpecialCharacter(SpecialType.HTML, (int)object3, (int)var29_40);
                    n5 += n10 + var29_40;
                    if (n7 != -1) {
                        AnnotatedInfo annotatedInfo2 = sAnnotatedInfo.elementAt(n7);
                        if (annotatedInfo.isContainedBy(annotatedInfo2)) {
                            annotatedInfo2.setLength(annotatedInfo2.getLength() - (n10 + var29_40));
                        } else {
                            n7 = -1;
                        }
                    }
                    c = segment.setIndex((int)object4);
                    continue block8;
                }
            }
            c = segment.next();
        }
        this.fContinueOffset = n + n2 - n5;
        if (sSpecialCharacters.isEmpty() && !bl) {
            return;
        }
        this.removeSpecialCharacters(cWContent);
        if (bl) {
            n4 = n2 - n5;
            AnnotatedInfo annotatedInfo = new AnnotatedInfo(AnnotatedOutputType.ERROR, n, n4 - 1);
            sAnnotatedInfo.insertElementAt(annotatedInfo, 0);
        }
        ListIterator<AnnotatedInfo> listIterator = sAnnotatedInfo.listIterator();
        while (listIterator.hasNext()) {
            AnnotatedInfo annotatedInfo = listIterator.next();
            if (annotatedInfo.getType().isContainer()) {
                int n11;
                int n12 = annotatedInfo.getOffset();
                n3 = annotatedInfo.getEndOffset();
                bl2 = annotatedInfo.getType().isWarning();
                int n13 = n12;
                while (listIterator.hasNext()) {
                    annotatedInfo = listIterator.next();
                    if (!annotatedInfo.getType().isContainer() && annotatedInfo.isContainedBy(n12, n3)) {
                        if (annotatedInfo.getOffset() > n13) {
                            n11 = annotatedInfo.getOffset() - n13;
                            this.addHtmlAttribute(n13, n11, null, bl, false, bl2);
                        }
                        this.addHtmlAttribute(annotatedInfo.getOffset(), annotatedInfo.getLength(), annotatedInfo.getHyperlinkAddress(), bl, annotatedInfo.getType().isStrong(), bl2);
                        n13 = annotatedInfo.getOffset() + annotatedInfo.getLength();
                        continue;
                    }
                    listIterator.previous();
                    break;
                }
                if (n13 >= n3) continue;
                n11 = n3 - n13;
                this.addHtmlAttribute(n13, n11, null, bl, false, bl2);
                continue;
            }
            this.addHtmlAttribute(annotatedInfo.getOffset(), annotatedInfo.getLength(), annotatedInfo.getHyperlinkAddress(), false, annotatedInfo.getType().isStrong(), false);
        }
    }

    private void dumpAnnotatedInfo() {
        for (int i = 0; i < sAnnotatedInfo.size(); ++i) {
            AnnotatedInfo annotatedInfo = sAnnotatedInfo.elementAt(i);
            AnnotatedOutputType annotatedOutputType = annotatedInfo.getType();
            boolean bl = annotatedInfo.getType().isStrong();
            String string = annotatedOutputType == AnnotatedOutputType.WARNING ? "Warning " : (annotatedOutputType == AnnotatedOutputType.ERROR ? "Error " : (bl ? "Bold " : "Hyperlink "));
            try {
                String string2 = this.getText(annotatedInfo.getOffset(), annotatedInfo.getLength());
                String string3 = String.format("Element %d: type = %s; text = %s", i, string, string2);
                Log.printLn((String)string3);
                continue;
            }
            catch (Exception exception) {
                Log.printLn((String)String.format("Problem with sAnnotatedInfo element %d of type %s", new Object[]{i, annotatedOutputType}));
            }
        }
    }

    private void addSpecialCharacter(SpecialType specialType, int n, int n2) {
        sSpecialCharacters.addElement(new SpecialCharacter(specialType, n, n2));
    }

    private void removeSpecialCharacters(CWContent cWContent) {
        ListIterator<SpecialCharacter> listIterator = sSpecialCharacters.listIterator();
        while (listIterator.hasNext()) {
            listIterator.next();
        }
        while (listIterator.hasPrevious()) {
            SpecialCharacter specialCharacter = listIterator.previous();
            SpecialType specialType = specialCharacter.getType();
            switch (specialType) {
                case HTML: 
                case BLSHB: {
                    int n = specialCharacter.getHowManyInARow();
                    int n2 = specialCharacter.getIndex();
                    int n3 = n2 + n;
                    if (specialType == SpecialType.BLSHB) {
                        n2 -= n;
                    }
                    if (n2 < 0) {
                        n2 = 0;
                    }
                    int n4 = n3 - n2;
                    AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = new AbstractDocument.DefaultDocumentEvent(this, n2, n4, DocumentEvent.EventType.REMOVE);
                    this.removeUpdate(defaultDocumentEvent);
                    this.fPromptOffset -= n4;
                    cWContent.replace(n2, n4, null, 0);
                    if (n2 < this.fUnmatchedLTPos) {
                        this.fUnmatchedLTPos -= n4;
                    }
                    this.postRemoveUpdate(defaultDocumentEvent);
                    defaultDocumentEvent.end();
                    this.fireRemoveUpdate(defaultDocumentEvent);
                    break;
                }
                case BLSHR: {
                    if (specialCharacter.getIndex() >= cWContent.length()) break;
                    char[] cArray = new char[specialCharacter.getHowManyInARow()];
                    for (int i = 0; i < specialCharacter.getHowManyInARow(); ++i) {
                        cArray[i] = 10;
                    }
                    AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = new AbstractDocument.DefaultDocumentEvent(this, specialCharacter.getIndex(), specialCharacter.getHowManyInARow(), DocumentEvent.EventType.REMOVE);
                    this.removeUpdate(defaultDocumentEvent);
                    cWContent.replace(specialCharacter.getIndex(), specialCharacter.getHowManyInARow(), null, 0);
                    this.postRemoveUpdate(defaultDocumentEvent);
                    defaultDocumentEvent.end();
                    this.fireRemoveUpdate(defaultDocumentEvent);
                    cWContent.replace(specialCharacter.getIndex(), 0, cArray, specialCharacter.getHowManyInARow());
                    defaultDocumentEvent = new AbstractDocument.DefaultDocumentEvent(this, specialCharacter.getIndex(), specialCharacter.getHowManyInARow(), DocumentEvent.EventType.INSERT);
                    this.insertUpdate(defaultDocumentEvent, null);
                    defaultDocumentEvent.end();
                    this.fireInsertUpdate(defaultDocumentEvent);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void insertPrompt(int n) throws BadLocationException {
        try {
            sBeforePrompt = true;
            this.setPromptOffset(n);
            this.updateInUsePrompt();
            this.insertString(n, this.getCurrentPrompt().toString(), null);
        }
        finally {
            sBeforePrompt = false;
        }
    }

    boolean isAfterThePrompt(int n) {
        return n >= this.getAfterThePrompt();
    }

    boolean isClickInHyperLink(Point point) {
        return this.getLinks(point) != null;
    }

    void goToHyperLink(Point point) {
        String string = this.getLinks(point);
        if (point != null && string != null) {
            if ((string = string.trim()).startsWith(MATLABLINK_START)) {
                if ((string = string.substring(MATLABLINK_START.length()).trim()).startsWith(OPENTOLINE)) {
                    int n = string.indexOf(40);
                    int n2 = string.lastIndexOf(41);
                    if (0 <= n && n < n2) {
                        this.openEditorAt(string.substring(n + 1, n2));
                    } else {
                        CmdWinMLIF.doConsoleEval(string);
                    }
                } else {
                    CmdWinMLIF.doConsoleEval(string);
                }
            } else if (string.startsWith(ERROR_LINK_START)) {
                this.openEditorAt(string.substring(ERROR_LINK_START.length()));
            } else {
                CmdWinMLIF.doConsoleEval("web('" + string + "')");
            }
        }
    }

    private void openEditorAt(String string) {
        int n = string.indexOf(44);
        String string2 = string.substring(0, n).trim();
        if (string2.startsWith("'") && string2.endsWith("'") && string2.length() >= 2) {
            string2 = string2.substring(1, string2.length() - 1);
        }
        string2 = string2.replace("''", "'");
        string2 = FileUtils.absolutePathname((String)string2);
        int n2 = 1;
        int n3 = 1;
        try {
            int n4 = string.indexOf(44, n + 1);
            String string3 = n4 != -1 ? string.substring(n + 1, n4) : string.substring(n + 1);
            n3 = Math.abs(Integer.parseInt(string3.trim()));
            if (n4 != -1) {
                n2 = Math.abs(Integer.parseInt(string.substring(n4 + 1).trim()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Editor editor = MLEditorServices.getEditorApplication().openEditor(new File(string2));
        if (editor != null) {
            editor.goToLine(n3, n2);
        }
    }

    String getLinks(Point point) {
        Rectangle rectangle;
        Element element = this.getDefaultRootElement();
        assert (element != null) : "The root element of the document cannot be null";
        Point point2 = new Point(point);
        int n = XCmdWndView.getInstance().getFontMetrics(XCmdWndView.getInstance().getFont()).charWidth('W');
        point2.x -= n / 2;
        int n2 = XCmdWndView.getInstance().viewToModel(point2);
        try {
            rectangle = XCmdWndView.getInstance().modelToView(n2);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        if (point2.x - rectangle.x > n) {
            return null;
        }
        int n3 = element.getElementIndex(n2);
        Element element2 = element.getElement(n3);
        String string = null;
        if (element2 instanceof AbstractDocument.LeafElement) {
            AbstractDocument.LeafElement leafElement = (AbstractDocument.LeafElement)element2;
            int n4 = leafElement.getStartOffset();
            Object[] objectArray = (Object[])leafElement.getAttribute(HTML_LINK_TOKENS);
            String[] stringArray = null;
            if (objectArray != null) {
                stringArray = (String[])objectArray[1];
            }
            int[] nArray = (int[])leafElement.getAttribute(LINK_START_TOKENS);
            Object[] objectArray2 = (Object[])leafElement.getAttribute(SYNTAX_TOKENS);
            int[] nArray2 = null;
            if (objectArray2 != null) {
                nArray2 = (int[])objectArray2[0];
            }
            if (stringArray != null && nArray2 != null) {
                for (int i = 0; i < nArray2.length; ++i) {
                    if (n2 < nArray2[i] + n4) continue;
                    string = nArray.length > i && nArray[i] != -1 ? stringArray[i] : null;
                }
            }
        }
        return string;
    }

    private void integralRemoveFromFront(CWContent cWContent, Element element, int n) {
        Element element2 = element.getElement(n - 1);
        int n2 = element2.getEndOffset();
        AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = new AbstractDocument.DefaultDocumentEvent(this, 0, n2, DocumentEvent.EventType.REMOVE);
        this.removeUpdate(defaultDocumentEvent);
        this.fPromptOffset -= n2;
        cWContent.replace(0, n2, sEmpty, 0);
        this.postRemoveUpdate(defaultDocumentEvent);
        defaultDocumentEvent.end();
        this.fireRemoveUpdate(defaultDocumentEvent);
        this.fContinueOffset -= n2;
        if (this.fContinueOffset < 0) {
            this.fContinueOffset = -1;
        }
        this.fUnmatchedLTPos -= n2;
        if (this.fUnmatchedLTPos < 0) {
            this.fUnmatchedLTPos = -1;
        }
        this.fUnmatchedWarningStartSentinel -= n2;
        if (this.fUnmatchedWarningStartSentinel < 0) {
            this.fUnmatchedWarningStartSentinel = -1;
        }
    }

    boolean isInOrBeforeThePrompt(int n) {
        return n < this.getAfterThePrompt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAttributes(int n) {
        this.writeLock();
        try {
            AbstractDocument.LeafElement leafElement;
            AttributeSet attributeSet;
            Element element = this.getParagraphElement(n);
            assert (element != null) : "The curElem of the document cannot be null";
            if (element instanceof AbstractDocument.LeafElement && (attributeSet = (leafElement = (AbstractDocument.LeafElement)element).getAttributes()) != null) {
                leafElement.removeAttributes(leafElement.getAttributes());
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAttributesAfterPosition(int n, int n2) {
        this.writeLock();
        try {
            AbstractDocument.LeafElement leafElement;
            AttributeSet attributeSet;
            Element element = this.getParagraphElement(n);
            assert (element != null) : "The curElem of the document cannot be null";
            if (element instanceof AbstractDocument.LeafElement && (attributeSet = (leafElement = (AbstractDocument.LeafElement)element).getAttributes()) != null) {
                Object[] objectArray = (Object[])leafElement.getAttribute(SYNTAX_TOKENS);
                int[] nArray = (int[])leafElement.getAttribute(LINK_START_TOKENS);
                int[] nArray2 = (int[])leafElement.getAttribute(BOLD_START_TOKENS);
                Object[] objectArray2 = (Object[])leafElement.getAttribute(HTML_LINK_TOKENS);
                if (objectArray != null) {
                    leafElement.removeAttributes(leafElement.getAttributes());
                    int[] nArray3 = (int[])objectArray[0];
                    int[] nArray4 = new int[nArray3.length];
                    String[] stringArray = (String[])objectArray[1];
                    String[] stringArray2 = new String[stringArray.length];
                    int n3 = 0;
                    for (int i = 0; i < nArray3.length; ++i) {
                        if (nArray3[i] > n2) continue;
                        nArray4[n3] = nArray3[i];
                        stringArray2[n3] = stringArray[i];
                        ++n3;
                    }
                    Object[] objectArray3 = new Object[]{nArray4, stringArray2};
                    if (n3 != 0) {
                        leafElement.addAttribute(SYNTAX_TOKENS, objectArray3);
                    }
                    if (objectArray2 != null) {
                        leafElement.addAttribute(HTML_LINK_TOKENS, objectArray2);
                    }
                    if (nArray != null) {
                        leafElement.addAttribute(LINK_START_TOKENS, nArray);
                    }
                    if (nArray2 != null) {
                        leafElement.addAttribute(BOLD_START_TOKENS, nArray2);
                    }
                }
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    public void removeCurrentPromptLine() throws BadLocationException {
        if (this.getAfterThePrompt() == this.getPromptLineEndOffset(false)) {
            return;
        }
        this.remove(this.getAfterThePrompt(), this.getPromptLineEndOffset(false) - this.getAfterThePrompt());
    }

    void replacePrompt() throws BadLocationException {
        int n = this.getPromptOffset();
        sBeforePrompt = true;
        this.remove(this.getPromptOffset(), this.getInUsePromptLength());
        sBeforePrompt = false;
        this.setPromptOffset(n);
        this.insertPrompt(this.getPromptOffset());
        this.syntaxUpdate();
    }

    static void setMaxLines(int n) {
        sMaxLines = n;
    }

    void setPrompt(Prompt prompt) {
        this.fPrompt = prompt == null ? Prompt.NULL_PROMPT : prompt;
    }

    void setPromptOffset(int n) throws BadLocationException {
        if (n > this.getLength()) {
            throw new BadLocationException("Prompt must be within document text", n);
        }
        this.fPromptOffset = n;
    }

    void setUserInitialized() {
        this.fUserInitialized = true;
    }

    void syntaxUpdate() {
        if (!this.fUserInitialized) {
            return;
        }
        int n = this.getAfterThePrompt();
        int n2 = this.getPromptLineEndOffset(false);
        int n3 = n2 - n;
        if (n > 0) {
            try {
                String string = this.getText(n, n3);
                StringTokenizer stringTokenizer = new StringTokenizer(string, "\n", true);
                int n4 = n;
                int n5 = n;
                while (stringTokenizer.hasMoreElements()) {
                    String string2 = stringTokenizer.nextToken();
                    n5 = stringTokenizer.hasMoreElements() ? (n5 += string2.length()) : n2;
                    if (!string2.equals("\n")) {
                        Object[] objectArray = CmdWinSyntaxWrapper.getInstance().getTokens(string2, 0);
                        this.addAttributesToElements(n4, n4 + string2.length(), objectArray, true);
                        CmdWinSyntaxWrapper.saveState();
                    }
                    n4 = n5;
                }
                if (!CmdWinMLIF.isWaitingForContinuation()) {
                    CmdWinSyntaxWrapper.cleanState();
                }
            }
            catch (BadLocationException badLocationException) {
                Log.logException((Exception)badLocationException);
            }
        } else {
            this.removeAttributes(n);
        }
    }

    private void updateAndAdjustSize(CWContent cWContent, int n, int n2, boolean bl) throws BadLocationException {
        int n3;
        this.fixSpecialCharacters(cWContent, n, n2, bl);
        Element element = this.getDefaultRootElement();
        if (element.getElementCount() > sMaxLines && sMaxLines / 10 < (n3 = element.getElementCount() - sMaxLines)) {
            this.integralRemoveFromFront(cWContent, element, n3);
        }
        this.syntaxUpdate();
    }

    @Deprecated
    void resetFindPos() {
    }

    void resetIncrementalSearch() {
        this.fFirstInc = true;
        this.fWrapped = false;
        this.fLastIncLength = -1;
    }

    boolean findString(String string, int n) {
        int n2;
        int n3;
        boolean bl = (n & 8) != 0;
        boolean bl2 = (n & 2) != 0;
        boolean bl3 = (n & 4) != 0;
        int n4 = n3 = XCmdWndView.getInstance().getSelectionStart();
        int n5 = XCmdWndView.getInstance().getSelectionEnd();
        boolean bl4 = n3 != n5;
        boolean bl5 = false;
        String string2 = XCmdWndView.getInstance().getSelectedText();
        if (bl4) {
            boolean bl6 = bl5 = (string2.contains(string) || string.contains(string2)) && !string2.equals(string);
        }
        if (bl && bl4) {
            n4 = n3 - 1;
            if (bl5) {
                n4 = n5;
            }
        } else if (bl4) {
            n4 = n5;
            if (bl5) {
                n4 = n3;
            }
        }
        boolean bl7 = false;
        while (true) {
            n2 = !bl ? this.findStringInContent(string, n4, (n & 1) != 0) : this.findStringInContentBackwards(string, n4, (n & 1) != 0);
            if (bl3 && n2 != -1 && !this.isWholeWord(n2, string.length())) {
                if (bl) {
                    n4 = n2 - 1;
                    continue;
                }
                n4 = n2 + string.length();
                continue;
            }
            if (n2 >= 0) {
                if (bl7 && (!bl && n2 >= n3 || bl && n2 < n5)) {
                    n2 = -1;
                }
                if (bl2 || n2 < sCWDoc.getLength()) break;
                n2 = -1;
                break;
            }
            if (!bl2 || bl7) break;
            n4 = bl ? sCWDoc.getLength() - 1 : 0;
            bl7 = true;
        }
        if (n2 != -1) {
            if (bl) {
                XCmdWndView.getInstance().getCaret().setDot(n2 + string.length());
                XCmdWndView.getInstance().getCaret().moveDot(n2);
            } else {
                XCmdWndView.getInstance().setSelectionStart(n2);
                XCmdWndView.getInstance().setSelectionEnd(n2 + string.length());
            }
            if (bl7) {
                Toolkit.getDefaultToolkit().beep();
            }
            return true;
        }
        Toolkit.getDefaultToolkit().beep();
        if (bl4 && !string2.equals(string)) {
            XCmdWndView.getInstance().select(n3, n3);
        }
        return false;
    }

    public int findStringInContent(String string, int n, boolean bl) {
        if (string.length() == 0) {
            return -1;
        }
        CWContent cWContent = (CWContent)this.getContent();
        Segment segment = new Segment();
        try {
            cWContent.getChars(0, cWContent.length(), segment);
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
        }
        char[] cArray = segment.array;
        java.nio.CharBuffer charBuffer = java.nio.CharBuffer.wrap(cArray);
        if (n < 0 || n > charBuffer.length() - 1) {
            return -1;
        }
        int n2 = string.length();
        int n3 = 0;
        int n4 = n;
        int n5 = charBuffer.length();
        boolean bl2 = false;
        while (!bl2) {
            char c = string.charAt(n3);
            char c2 = charBuffer.charAt(n4++);
            if (!bl) {
                c = Character.toLowerCase(c);
                c2 = Character.toLowerCase(c2);
            }
            if (c2 == c) {
                ++n3;
            } else if (c2 != '\r') {
                if (n3 > 0) {
                    n4 -= n3;
                }
                n3 = 0;
            }
            if (n3 < n2 && n4 < n5) continue;
            bl2 = true;
        }
        if (n3 >= n2) {
            return n4 - n2;
        }
        return -1;
    }

    public int findStringInContentBackwards(String string, int n, boolean bl) {
        if (string.length() == 0) {
            return -1;
        }
        CWContent cWContent = (CWContent)this.getContent();
        Segment segment = new Segment();
        try {
            cWContent.getChars(0, cWContent.length(), segment);
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
        }
        char[] cArray = segment.array;
        java.nio.CharBuffer charBuffer = java.nio.CharBuffer.wrap(cArray);
        int n2 = string.length();
        assert (n < charBuffer.length()) : "Start Position must be less than the document length";
        if (n < 0 || n > charBuffer.length() || n2 == 0) {
            return -1;
        }
        int n3 = n2 - 1;
        int n4 = n;
        boolean bl2 = false;
        while (!bl2) {
            char c = string.charAt(n3);
            char c2 = charBuffer.charAt(n4--);
            if (!bl) {
                c = Character.toLowerCase(c);
                c2 = Character.toLowerCase(c2);
            }
            if (c2 == c) {
                --n3;
            } else if (c2 != '\r') {
                if (n3 < n2) {
                    n4 += n2 - n3 - 1;
                }
                n3 = n2 - 1;
            }
            if (n4 >= 0 && n3 >= 0) continue;
            bl2 = true;
        }
        if (n3 < 0) {
            return n4 + 1;
        }
        return -1;
    }

    private boolean isWholeWord(int n, int n2) {
        char c;
        CWContent cWContent = (CWContent)this.getContent();
        Segment segment = new Segment();
        try {
            cWContent.getChars(0, cWContent.length(), segment);
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
        }
        char[] cArray = segment.array;
        java.nio.CharBuffer charBuffer = java.nio.CharBuffer.wrap(cArray);
        if (n > 0 && (Character.isLetterOrDigit(c = charBuffer.charAt(n - 1)) || c == '_')) {
            return false;
        }
        c = charBuffer.charAt(n);
        if (!Character.isLetterOrDigit(c) && c != '_') {
            return false;
        }
        c = charBuffer.charAt(n + n2 - 1);
        if (!Character.isLetterOrDigit(c) && c != '_') {
            return false;
        }
        return n + n2 >= charBuffer.length() || !Character.isLetterOrDigit(c = charBuffer.charAt(n + n2)) && c != '_';
    }

    IncSearchData doIncrementalSearch(String string, boolean bl) {
        boolean bl2;
        int n;
        if (string == null || string.length() == 0) {
            return new IncSearchData("", false, -1, 0, bl);
        }
        if (this.fLastIncLength != string.length()) {
            this.fWrapped = false;
        }
        this.fLastIncLength = string.length();
        if (!bl) {
            return this.doIncrementalSearchBackward(string);
        }
        int n2 = XCmdWndView.getInstance().getSelectionEnd();
        int n3 = XCmdWndView.getInstance().getSelectionStart();
        boolean bl3 = n3 != n2;
        int n4 = n2;
        if (bl3) {
            n4 = n3;
        }
        if (this.fFirstInc) {
            this.fFirstIncPos = n4;
        }
        if (this.fWrapped && n4 == this.fFirstIncPos) {
            n4 = 0;
        }
        if ((n = this.findStringInContent(string, n4, bl2 = !string.toLowerCase().equals(string))) == -1 && !this.fWrapped) {
            this.fWrapped = true;
            n4 = 0;
            n = this.findStringInContent(string, n4, true);
        }
        if (n != -1) {
            XCmdWndView.getInstance().setSelectionStart(n);
            XCmdWndView.getInstance().setSelectionEnd(n + string.length());
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
        this.fFirstInc = false;
        return new IncSearchData(string, n != -1, n, string.length(), bl);
    }

    public IncSearchData doIncrementalSearchBackward(String string) {
        boolean bl;
        int n;
        int n2 = XCmdWndView.getInstance().getSelectionEnd();
        int n3 = XCmdWndView.getInstance().getSelectionStart();
        boolean bl2 = n3 != n2;
        int n4 = n3;
        String string2 = XCmdWndView.getInstance().getSelectedText();
        if (bl2 && string.startsWith(string2)) {
            n4 = n2;
        } else if (bl2) {
            n4 = n2 - 1;
        }
        if (this.fFirstInc) {
            this.fFirstIncPos = n4;
        }
        if (this.fWrapped && n4 == this.fFirstIncPos) {
            n4 = this.fFirstIncPos + 1 == this.getContent().length() ? this.fFirstIncPos : this.fFirstIncPos + 1;
        }
        if ((n = this.findStringInContentBackwards(string, n4, bl = !string.toLowerCase().equals(string))) == -1 && !this.fWrapped) {
            this.fWrapped = true;
            n4 = sCWDoc.getLength() - 1;
            n = this.findStringInContentBackwards(string, n4, true);
        }
        if (n != -1) {
            XCmdWndView.getInstance().getCaret().setDot(n + string.length());
            XCmdWndView.getInstance().getCaret().moveDot(n);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
        this.fFirstInc = false;
        return new IncSearchData(string, n != -1, n, string.length(), false);
    }

    void doIncrementalSearchCtrlW() {
        int n;
        int n2 = XCmdWndView.getInstance().getSelectionStart();
        int n3 = n = XCmdWndView.getInstance().getSelectionEnd();
        if (n2 == this.getLength()) {
            Toolkit.getDefaultToolkit().beep();
        } else {
            CWContent cWContent = (CWContent)this.getContent();
            Segment segment = new Segment();
            try {
                cWContent.getChars(0, cWContent.length(), segment);
            }
            catch (BadLocationException badLocationException) {
                Log.logException((Exception)badLocationException);
            }
            char[] cArray = segment.array;
            n3 = this.findWordEndRight(n, cArray);
            if (n == n3 && n + 1 < cArray.length) {
                n3 = this.findWordEndRight(n + 1, cArray);
            }
        }
        XCmdWndView.getInstance().setSelectionStart(n2);
        XCmdWndView.getInstance().setSelectionEnd(n3);
    }

    protected int findWordEndRight(int n, char[] cArray) {
        boolean bl = n == 0 || CmdWinDocument.isWordBreakChar(cArray[n - 1]);
        int n2 = cArray.length;
        while (n < n2) {
            boolean bl2 = CmdWinDocument.isWordBreakChar(cArray[n]);
            if (!bl && bl2) {
                return n;
            }
            bl = bl2;
            ++n;
        }
        return n2;
    }

    protected static boolean isWordBreakChar(char c) {
        return !Character.isLetterOrDigit(c) && c != '_' && c != '\r';
    }

    private static void setPrintingTextSegmentForTesting(Segment segment) {
        sPrintingSegment = segment;
    }

    private static void setPrintingTextRangeForTesting(int n, int n2) {
        sLastPrintEndPos = sPrintRangeStart = n;
        sPrintingDone = false;
        sPrintLineCount = -1;
        sPrintCurrentLine = 1;
        sPrintRangeEnd = n2;
    }

    static {
        sMaxLines = 5000;
        sEmpty = new char[0];
        sSpecialCharacters = new Vector();
        sAnnotatedInfo = new Vector();
        ERROR_ID = ColorPrefs.MatlabColor.CW_ERROR.getKey();
        WARNING_ID = ColorPrefs.MatlabColor.CW_WARNING.getKey();
        sMaxLineLength = 25000;
        sContent = new CWContent();
        sRes = ResourceBundle.getBundle("com.mathworks.mde.cmdwin.resources.RES_CmdWin");
        sCWDoc = new CmdWinDocument(sContent);
    }

    private static class CWContent
    extends GapContent {
        private CWContent() {
        }

        void insertChars(int n, char[] cArray, int n2) throws BadLocationException {
            if (n >= this.length()) {
                throw new BadLocationException("Invalid insert", this.length());
            }
            this.replace(n, 0, cArray, n2);
        }

        void replace(int n, int n2, char[] cArray, int n3) {
            super.replace(n, n2, cArray, n3);
        }
    }

    private static class AnnotatedInfo {
        AnnotatedOutputType fType;
        private int fOffset;
        private int fLength;
        String fAddress;

        AnnotatedInfo(AnnotatedOutputType annotatedOutputType, int n, int n2) {
            this.fType = annotatedOutputType;
            this.fOffset = n;
            this.fLength = n2;
            this.fAddress = null;
        }

        private AnnotatedOutputType getType() {
            return this.fType;
        }

        private int getOffset() {
            return this.fOffset;
        }

        private int getLength() {
            return this.fLength;
        }

        private void setLength(int n) {
            this.fLength = n;
        }

        private String getHyperlinkAddress() {
            return this.fAddress;
        }

        private void setHyperlinkAddress(String string) {
            this.fAddress = string;
        }

        private int getEndOffset() {
            return this.fOffset + this.fLength;
        }

        private boolean isContainedBy(int n, int n2) {
            boolean bl = false;
            if (n <= this.getOffset() && n2 >= this.getEndOffset()) {
                bl = true;
            }
            return bl;
        }

        private boolean isContainedBy(AnnotatedInfo annotatedInfo) {
            boolean bl = false;
            if (!this.getType().isContainer() && this.isContainedBy(annotatedInfo.getOffset(), annotatedInfo.getEndOffset())) {
                bl = true;
            }
            return bl;
        }
    }

    private static enum AnnotatedOutputType {
        STRONG,
        HYPERLINK,
        WARNING,
        ERROR;


        boolean isContainer() {
            return this == WARNING || this == ERROR;
        }

        boolean isWarning() {
            return this == WARNING;
        }

        boolean isStrong() {
            return this == STRONG;
        }
    }

    private static class SpecialCharacter {
        private SpecialType fType;
        private int fIndex;
        private int fNumInARow;

        private SpecialCharacter(SpecialType specialType, int n, int n2) {
            this.fType = specialType;
            this.fIndex = n;
            this.fNumInARow = n2;
        }

        public SpecialType getType() {
            return this.fType;
        }

        public int getIndex() {
            return this.fIndex;
        }

        public int getHowManyInARow() {
            return this.fNumInARow;
        }
    }

    private static enum SpecialType {
        BLSHB,
        BLSHR,
        HTML;

    }

    private static class FlushRunnable
    implements Runnable {
        private static final int FLUSH_BUFFER_SIZE = 8092;
        private static final int MAX_NUMBER_RUNNABLES = 10;
        private static int sFlushRunnableInQueue = 0;
        private static FlushRunnable sFlushRunnableInstance = null;
        private static final AWTUtilities.MatlabWait waiter = new AWTUtilities.MatlabWait();
        private final char[] fBuffer;
        private int fSize = 0;
        private int fInvoke = 0;
        private final Type fType;

        private FlushRunnable(int n, Type type) {
            this.fBuffer = new char[n];
            this.fType = type;
        }

        private synchronized void addText(char[] cArray, int n, int n2) {
            assert (this.hasRoom(n2));
            System.arraycopy(cArray, n, this.fBuffer, this.fSize, n2);
            this.fSize += n2;
            this.invoke();
        }

        private synchronized boolean hasRoom(int n) {
            return this.fSize + n <= this.fBuffer.length;
        }

        private void invoke() {
            if (this.fInvoke++ == 0) {
                ++sFlushRunnableInQueue;
                EventQueue.invokeLater(this);
            }
        }

        public static synchronized void finishCurrentRunnable() {
            sFlushRunnableInstance = null;
        }

        public static void addTextAndInvoke(char[] cArray, int n, int n2, boolean bl) {
            FlushRunnable.addTextAndInvoke(cArray, n, n2, bl ? Type.ERROR : Type.PLAIN);
        }

        public static synchronized void addTextAndInvoke(char[] cArray, int n, int n2, Type type) {
            if (sFlushRunnableInQueue > 10) {
                try {
                    waiter.attempt(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            FlushRunnable.getCurrent(type, n2).addText(cArray, n, n2);
        }

        private static synchronized FlushRunnable getCurrent(Type type, int n) {
            if (sFlushRunnableInstance == null || FlushRunnable.sFlushRunnableInstance.fType != type || !sFlushRunnableInstance.hasRoom(n)) {
                sFlushRunnableInstance = new FlushRunnable(Math.max(n, 8092), type);
            }
            return sFlushRunnableInstance;
        }

        @Override
        public synchronized void run() {
            try {
                sCWDoc.insertBeforePrompt(this.fBuffer, this.fSize, this.fType == Type.ERROR);
            }
            catch (Exception exception) {
                Log.logException((Exception)exception);
            }
            this.fInvoke = 0;
            this.fSize = 0;
            if (--sFlushRunnableInQueue <= 10) {
                waiter.release();
            }
        }

        private static enum Type {
            PLAIN,
            ERROR;

        }
    }
}

