/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.cmdwin;

import com.mathworks.mde.cmdwin.CmdWinDocument;
import com.mathworks.mde.cmdwin.CmdWinMLIF;
import com.mathworks.mde.cmdwin.XCmdWndView;
import com.mathworks.mwswing.text.DocumentReader;
import com.mathworks.mwswing.text.DocumentSearch;
import com.mathworks.mwswing.text.StrikeThroughPainter;
import com.mathworks.mwswing.text.UnderlinePainter;
import com.mathworks.services.ColorPrefs;
import com.mathworks.services.KeyboardPrefs;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.util.Assert;
import com.mathworks.widgets.TokenizerFactory;
import com.mathworks.widgets.tokenmatch.TokenMatchPopup;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import javax.swing.SwingUtilities;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

public class TokenMatcher
implements KeyListener,
MouseListener,
PropertyChangeListener {
    public static final int ENTRY = 1;
    public static final int ARROW = 2;
    protected static Options sDefaultMatcherOptions = new Options();
    public static final int[] sMatchActions = new int[]{3, 1, 2};
    public static final int[] sMismatchActions = new int[]{6, 5, 4};
    public static final int NOMATCH = -1;
    public static final int NOMARK = -2;
    protected Options fOptions;
    protected boolean fEnabled;
    protected char[] fOpenChars;
    protected char[] fCloseChars;
    protected JTextComponent fComponent;
    protected Document fDocument;
    protected DocumentReader fReader = new DocumentReader();
    protected DocumentSearch fSearch = new DocumentSearch();
    protected SearchData fKeyPressedData = new SearchData();
    protected SearchData fKeyTypedData = new SearchData();
    protected Object fTokenHighlightKey;
    protected Object fMateHighlightKey;
    private CmdWinDocument fDoc;
    protected static Highlighter.HighlightPainter sUnderlinePainter = new UnderlinePainter(ColorPrefs.getTextColor());
    protected static Highlighter.HighlightPainter sStrikePainter = new StrikeThroughPainter(ColorPrefs.getTextColor());
    protected static Highlighter.HighlightPainter sHighlightPainter;

    public TokenMatcher(JTextComponent jTextComponent, CmdWinDocument cmdWinDocument) {
        this.fOptions = new Options();
        KeyboardPrefs.registerForDelimMatchingPrefs((PrefListener)new PrefListener(){

            public void prefChanged(PrefEvent prefEvent) {
                if (KeyboardPrefs.didDelimMatchingPrefChange((PrefEvent)prefEvent)) {
                    TokenMatcher.this.fOptions.setOptionsFromPrefs();
                }
            }
        });
        ColorPrefs.addColorListener((String)"ColorsText", (PrefListener)new PrefListener(){

            public void prefChanged(PrefEvent prefEvent) {
                sUnderlinePainter = new UnderlinePainter(ColorPrefs.getTextColor());
                sStrikePainter = new StrikeThroughPainter(ColorPrefs.getTextColor());
            }
        });
        this.fDoc = cmdWinDocument;
        this.attachTo(jTextComponent);
        this.fOpenChars = new char[]{'(', '[', '{'};
        this.fCloseChars = new char[]{')', ']', '}'};
    }

    public void setEnabled(boolean bl) {
        this.fEnabled = bl;
    }

    public void attachTo(JTextComponent jTextComponent) {
        if (this.fComponent != null) {
            this.detachFrom(this.fComponent);
        }
        this.fComponent = jTextComponent;
        this.fDocument = this.fComponent.getDocument();
        this.fReader.setDocument(this.fDocument);
        this.fSearch.setDocument(this.fDocument);
        this.fComponent.addKeyListener(this);
        this.fComponent.addMouseListener(this);
        this.fComponent.addPropertyChangeListener(this);
    }

    public void detachFrom(JTextComponent jTextComponent) {
        if (this.fComponent != jTextComponent) {
            return;
        }
        this.fComponent.removeKeyListener(this);
        this.fComponent.removeMouseListener(this);
        this.fComponent.removePropertyChangeListener(this);
        this.fComponent = null;
    }

    public JTextComponent getComponent() {
        return this.fComponent;
    }

    public Options getOptions() {
        return this.fOptions;
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (this.fOptions.fMatchOnEntry && this.fEnabled) {
            this.fKeyTypedData.reset();
            this.fKeyTypedData.token = keyEvent.getKeyChar();
            this.fKeyTypedData.chooseMate();
            if (this.fKeyTypedData.mate != '\u0000') {
                SwingUtilities.invokeLater(new DeferredMarker(1, this.fComponent.getCaretPosition()));
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        this.clearHighlights();
        int n = keyEvent.getKeyCode();
        if (this.fOptions.fMatchOnArrow && this.fEnabled && (n == 39 || n == 37)) {
            int n2 = this.fComponent.getCaretPosition();
            int n3 = this.fDocument.getLength();
            int n4 = -1;
            if (n == 39 && n2 < n3) {
                n4 = n2;
            } else if (n == 37 && n2 > 0) {
                n4 = n2 - 1;
            }
            if (n4 == -1) {
                return;
            }
            this.fKeyPressedData.reset();
            this.fReader.setPosition(n4);
            try {
                this.fKeyPressedData.token = (char)this.fReader.read();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.fKeyPressedData.chooseMate();
            if (this.fKeyPressedData.mate != '\u0000') {
                this.mark(2, n4, this.fKeyPressedData);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2 && this.fEnabled) {
            int n = this.fComponent.viewToModel(mouseEvent.getPoint());
            SearchData searchData = new SearchData();
            this.fReader.setPosition(n);
            try {
                searchData.token = (char)this.fReader.read();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            searchData.chooseMate();
            if (searchData.mate != '\u0000') {
                try {
                    int n2 = this.findMate(n, searchData);
                    if (n2 != -1 && n2 != -2) {
                        if (n2 > n) {
                            this.fComponent.setSelectionStart(n + 1);
                            this.fComponent.setSelectionEnd(n2);
                        } else {
                            this.fComponent.setSelectionStart(n2 + 1);
                            this.fComponent.setSelectionEnd(n);
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    private void mark(int n, int n2, SearchData searchData) {
        try {
            int n3 = this.findMate(n2, searchData);
            this.clearHighlights();
            Highlighter highlighter = this.fComponent.getHighlighter();
            Highlighter.HighlightPainter highlightPainter = null;
            Highlighter.HighlightPainter highlightPainter2 = null;
            if (n3 != -1 && n3 != -2) {
                int n4 = 6;
                n4 = n == 1 ? this.fOptions.fEntryMatchAction : this.fOptions.fArrowMatchAction;
                TokenMatchPopup.getInstance().startTimerAndShowPopupIfNecessary(this.fComponent, new int[]{n3, n3 + 1}, n4 == 1, -1, (TokenMatchPopup.TokenMatchListener)new CmdWindowTokenMatchListener(n3), TokenizerFactory.getMTokenizer());
                switch (n4) {
                    case 3: {
                        highlightPainter2 = sHighlightPainter;
                        break;
                    }
                    case 1: {
                        highlightPainter = sUnderlinePainter;
                        highlightPainter2 = sUnderlinePainter;
                        break;
                    }
                    case 2: {
                        highlightPainter = sHighlightPainter;
                        highlightPainter2 = sHighlightPainter;
                    }
                }
            } else if (n3 != -2 && (searchData.direction <= 0 || n != 1)) {
                int n5 = 6;
                n5 = n == 1 ? this.fOptions.fEntryMismatchAction : this.fOptions.fArrowMismatchAction;
                switch (n5) {
                    case 5: {
                        highlightPainter = sStrikePainter;
                        TokenMatchPopup.getInstance().startTimer(this.fComponent, (TokenMatchPopup.TokenMatchListener)new CmdWindowTokenMatchListener(n2));
                        break;
                    }
                    case 4: {
                        Toolkit.getDefaultToolkit().beep();
                    }
                }
            }
            if (highlightPainter != null) {
                this.fTokenHighlightKey = highlighter.addHighlight(n2, n2 + 1, highlightPainter);
            }
            if (highlightPainter2 != null) {
                this.fMateHighlightKey = highlighter.addHighlight(n3, n3 + 1, highlightPainter2);
            }
        }
        catch (BadLocationException badLocationException) {
            this.clearHighlights();
        }
    }

    private void clearHighlights() {
        Highlighter highlighter = this.fComponent.getHighlighter();
        if (this.fTokenHighlightKey != null) {
            highlighter.removeHighlight(this.fTokenHighlightKey);
            this.fTokenHighlightKey = null;
        }
        if (this.fMateHighlightKey != null) {
            highlighter.removeHighlight(this.fMateHighlightKey);
            this.fMateHighlightKey = null;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("document")) {
            this.fDocument = this.fComponent.getDocument();
            this.fReader.setDocument(this.fDocument);
            this.fSearch.setDocument(this.fDocument);
        }
    }

    protected int getStyle(int n) {
        Element element = this.fDoc.getDefaultRootElement();
        Assert._assert((element != null ? 1 : 0) != 0);
        int n2 = element.getElementIndex(n);
        Element element2 = element.getElement(n2);
        int n3 = element2.getStartOffset();
        n -= n3;
        if (element2 instanceof AbstractDocument.LeafElement) {
            AbstractDocument.LeafElement leafElement = (AbstractDocument.LeafElement)element2;
            String string = null;
            Object[] objectArray = (Object[])leafElement.getAttribute("SyntaxTokens");
            if (objectArray != null) {
                int[] nArray = (int[])objectArray[0];
                String[] stringArray = (String[])objectArray[1];
                for (int i = 0; i < nArray.length && nArray[i] <= n; ++i) {
                    string = stringArray[i];
                }
            }
            if (string != null && (string.indexOf(ColorPrefs.M_CATEGORIES[1]) != -1 || string.indexOf(ColorPrefs.M_CATEGORIES[2]) != -1 || string.indexOf(ColorPrefs.M_CATEGORIES[3]) != -1)) {
                return -2;
            }
            return string == null ? 0 : string.hashCode();
        }
        return -2;
    }

    protected int findMate(int n, SearchData searchData) throws BadLocationException {
        int n2;
        int n3;
        if (searchData.direction > 0) {
            n3 = this.fDocument.getLength();
            if (n >= n3 - 1) {
                return -1;
            }
            searchData.start = n + 1;
            searchData.end = n3;
        } else {
            if (n < 1) {
                return -1;
            }
            searchData.start = n - 1;
            searchData.end = 0;
        }
        searchData.style = this.getStyle(n);
        n3 = 1;
        if (searchData.style != -2) {
            for (n2 = searchData.start; n2 >= 0 && (n2 = this.fSearch.findAnyOf(searchData.pair, n2, searchData.end)) != -1; n2 += searchData.direction) {
                char c;
                int n4 = this.getStyle(n2);
                if (n4 != searchData.style) continue;
                this.fReader.setPosition(n2);
                try {
                    c = (char)this.fReader.read();
                }
                catch (IOException iOException) {
                    n2 = -1;
                    break;
                }
                n3 = c == searchData.mate ? --n3 : ++n3;
                if (n3 != 0) {
                    continue;
                }
                break;
            }
        } else {
            n2 = -2;
        }
        if (n2 != -1 && n2 != -2 && n > this.fDoc.getPromptOffset() && n2 < this.fDoc.getPromptOffset() && !CmdWinMLIF.isWaitingForContinuation()) {
            n2 = -1;
        }
        return n2;
    }

    private int testFindMate(char c, int n) throws BadLocationException {
        this.fKeyTypedData.reset();
        this.fKeyTypedData.token = c;
        this.fKeyTypedData.chooseMate();
        return this.findMate(n, this.fKeyTypedData);
    }

    static {
        TokenMatchPopup.getInstance();
        sHighlightPainter = new DefaultHighlighter.DefaultHighlightPainter(TokenMatchPopup.getHighlightBackgroundColor());
    }

    private class CmdWindowTokenMatchListener
    implements TokenMatchPopup.TokenMatchListener {
        private int iMatePos;

        CmdWindowTokenMatchListener(int n) {
            this.iMatePos = n;
        }

        public void clearMatchIndications(Rectangle rectangle) {
            TokenMatcher.this.clearHighlights();
        }

        public void userClickedOnPopup() {
            TokenMatcher.this.fComponent.select(this.iMatePos, this.iMatePos + 1);
            ((XCmdWndView)TokenMatcher.this.fComponent).scrollToOffset(this.iMatePos);
        }
    }

    public static class Options {
        public boolean fMatchOnEntry;
        public int fEntryMatchAction;
        public int fEntryMismatchAction;
        public boolean fMatchOnArrow;
        public int fArrowMatchAction;
        public int fArrowMismatchAction;

        public Options() {
            this.setOptionsFromPrefs();
        }

        public void setOptionsFromPrefs() {
            this.fArrowMatchAction = KeyboardPrefs.getDelimMatchTypeWhileMousing();
            this.fArrowMismatchAction = KeyboardPrefs.getDelimMismatchTypeWhileMousing();
            this.fEntryMatchAction = KeyboardPrefs.getDelimMatchTypeWhileTyping();
            this.fEntryMismatchAction = KeyboardPrefs.getDelimMismatchTypeWhileTyping();
            this.fMatchOnArrow = KeyboardPrefs.isDelimMatchingWhileMousing();
            this.fMatchOnEntry = KeyboardPrefs.isDelimMatchingWhileTyping();
        }
    }

    protected class SearchData {
        char token;
        char mate;
        char[] pair = new char[2];
        int direction;
        int start;
        int end;
        int style;

        protected SearchData() {
        }

        void reset() {
            this.mate = '\u0000';
            this.token = '\u0000';
            this.end = -1;
            this.start = -1;
            this.style = 0;
        }

        void chooseMate() {
            for (int i = 0; i < TokenMatcher.this.fOpenChars.length; ++i) {
                if (this.token == TokenMatcher.this.fOpenChars[i]) {
                    this.mate = TokenMatcher.this.fCloseChars[i];
                    this.direction = 1;
                    break;
                }
                if (this.token != TokenMatcher.this.fCloseChars[i]) continue;
                this.mate = TokenMatcher.this.fOpenChars[i];
                this.direction = -1;
                break;
            }
            this.pair[0] = this.token;
            this.pair[1] = this.mate;
        }
    }

    class DeferredMarker
    implements Runnable {
        private int fTrigger;
        private int fTokenPos;

        public DeferredMarker(int n, int n2) {
            this.fTrigger = n;
            this.fTokenPos = n2;
        }

        @Override
        public void run() {
            TokenMatcher.this.mark(this.fTrigger, this.fTokenPos, TokenMatcher.this.fKeyTypedData);
        }
    }
}

