/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.dataimport;

import com.mathworks.mde.dataimport.IVariableContentsOwner;
import com.mathworks.mde.dataimport.ImportProxy;
import com.mathworks.mde.dataimport.ImportUtils;
import com.mathworks.mde.dataimport.ValueSpecification;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJTextArea;
import com.mathworks.services.ColorPrefs;
import com.mathworks.services.FontPrefs;
import com.mathworks.widgets.spreadsheet.SpreadsheetScrollPane;
import com.mathworks.widgets.spreadsheet.SpreadsheetTable;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

class VariableContentsViewer
extends MJPanel {
    static final int NUMERIC_PREVIEW_LIMIT = 256;
    private ValueSpecification fSpec;
    private IVariableContentsOwner fVCO;
    private MJTextArea fTextPane;
    private SpreadsheetTable fSpreadsheetTable;
    private SpreadsheetScrollPane fSSP;
    private JScrollPane fStringScrollPane;

    VariableContentsViewer(IVariableContentsOwner iVariableContentsOwner, ValueSpecification valueSpecification) {
        this.fVCO = iVariableContentsOwner;
        this.fSpec = valueSpecification;
        this.setLayout(new BorderLayout());
    }

    VariableContentsViewer(ImportProxy importProxy, ValueSpecification valueSpecification) {
        this.fVCO = new LocalVCO(importProxy);
        this.fSpec = valueSpecification;
        this.setLayout(new BorderLayout());
    }

    public void addNotify() {
        super.addNotify();
        this.fVCO.getVariablePreviewData(this, this.fSpec);
    }

    void setContents(String string) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.fTextPane = new MJTextArea(string);
            this.fTextPane.setFont(FontPrefs.getCodeFont());
            this.fTextPane.setEditable(false);
            this.fTextPane.setName("VariableContentsTextPane");
            this.removeAll();
            this.fStringScrollPane = new MJScrollPane((Component)this.fTextPane);
            this.fStringScrollPane.setName("VariableContentsScrollPane");
            this.add(this.fStringScrollPane, "Center");
            this.resetColors();
            this.revalidate();
            this.repaint();
        } else {
            ContentSetter contentSetter = new ContentSetter(string);
            SwingUtilities.invokeLater(contentSetter);
        }
    }

    void resetColors() {
        if (this.fTextPane != null) {
            this.fTextPane.setForeground(ColorPrefs.getTextColor());
            this.fTextPane.setBackground(ColorPrefs.getBackgroundColor());
        }
        if (this.fSpreadsheetTable != null) {
            JViewport jViewport;
            this.fSpreadsheetTable.setForeground(ColorPrefs.getTextColor());
            this.fSpreadsheetTable.setBackground(ColorPrefs.getBackgroundColor());
            JViewport jViewport2 = this.fSSP.getColumnHeader();
            if (jViewport2 != null) {
                ((Component)jViewport2).setBackground(ColorPrefs.getBackgroundColor());
            }
            if ((jViewport = this.fSSP.getRowHeader()) != null) {
                ((Component)jViewport).setBackground(ColorPrefs.getBackgroundColor());
            }
            this.fSSP.getViewport().setBackground(ColorPrefs.getBackgroundColor());
        }
    }

    void setContents(double[][] dArray, double[][] dArray2) {
        this.setContents(new VCVTableModel(dArray, dArray2));
    }

    void setContents(int[][] nArray, int[][] nArray2) {
        this.setContents(new VCVTableModel(nArray, nArray2));
    }

    private synchronized void setContents(VCVTableModel vCVTableModel) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.cleanupSpreadsheetTable();
            this.fSpreadsheetTable = new SpreadsheetTable((TableModel)vCVTableModel);
            this.fSpreadsheetTable.setFont(FontPrefs.getTextFont());
            this.fSpreadsheetTable.setName("VariableContentsSpreadsheet");
            this.fSpreadsheetTable.setScheme(0);
            TableCellRenderer tableCellRenderer = this.fSpreadsheetTable.getDefaultRenderer(Object.class);
            if (tableCellRenderer instanceof DefaultTableCellRenderer) {
                DefaultTableCellRenderer defaultTableCellRenderer = (DefaultTableCellRenderer)tableCellRenderer;
                defaultTableCellRenderer.setHorizontalAlignment(4);
                this.fSpreadsheetTable.setDefaultRenderer(Object.class, (TableCellRenderer)defaultTableCellRenderer);
            }
            this.fSpreadsheetTable.setEditable(false);
            this.cleanupSpreadsheetSP();
            this.fSSP = new SpreadsheetScrollPane((JTable)this.fSpreadsheetTable);
            this.fSSP.setName("VariableContentsSpreadsheetScrollPane");
            this.removeAll();
            this.add((Component)this.fSSP, "Center");
            this.resetColors();
            this.revalidate();
        } else {
            ContentSetter contentSetter = new ContentSetter(vCVTableModel);
            SwingUtilities.invokeLater(contentSetter);
        }
    }

    synchronized void cleanup() {
        this.fVCO = null;
        this.fTextPane = null;
        this.cleanupSpreadsheetTable();
        this.cleanupSpreadsheetSP();
        this.cleanupStringSP();
    }

    private synchronized void cleanupSpreadsheetSP() {
        if (this.fSSP != null) {
            this.fSSP.cleanup();
            this.fSSP.setViewportView(null);
            this.fSSP = null;
        }
    }

    private synchronized void cleanupSpreadsheetTable() {
        if (this.fSpreadsheetTable != null) {
            this.fSpreadsheetTable.cleanup();
            this.fSpreadsheetTable = null;
        }
    }

    private synchronized void cleanupStringSP() {
        if (this.fStringScrollPane != null) {
            this.fStringScrollPane.setViewportView(null);
            this.fStringScrollPane = null;
        }
    }

    private class LocalVCO
    implements IVariableContentsOwner {
        private ImportProxy iImportProxy;

        LocalVCO(ImportProxy importProxy) {
            this.iImportProxy = importProxy;
        }

        @Override
        public void getVariablePreviewData(VariableContentsViewer variableContentsViewer, ValueSpecification valueSpecification) {
            this.iImportProxy.requestVariablePreviewData(this, valueSpecification);
        }

        @Override
        public void addVariablePreviewData(ValueSpecification valueSpecification, double[][] dArray, double[][] dArray2) {
            VariableContentsViewer.this.setContents(dArray, dArray2);
        }

        @Override
        public void addVariablePreviewData(ValueSpecification valueSpecification, int[][] nArray, int[][] nArray2) {
            VariableContentsViewer.this.setContents(nArray, nArray2);
        }

        @Override
        public void addVariablePreviewData(ValueSpecification valueSpecification, String string) {
            VariableContentsViewer.this.setContents(string);
        }
    }

    private class ContentSetter
    implements Runnable {
        private String fStringContents;
        private VCVTableModel fTM;

        ContentSetter(String string) {
            this.fStringContents = string;
        }

        ContentSetter(VCVTableModel vCVTableModel) {
            this.fTM = vCVTableModel;
        }

        @Override
        public void run() {
            if (this.fTM != null) {
                VariableContentsViewer.this.setContents(this.fTM);
            } else {
                VariableContentsViewer.this.setContents(this.fStringContents);
            }
        }
    }

    private static class VCVTableModel
    extends AbstractTableModel {
        private double[][] fDoubleReal;
        private double[][] fDoubleImag;
        private int[][] fIntReal;
        private int[][] fIntImag;

        VCVTableModel(double[][] dArray, double[][] dArray2) {
            this.fDoubleReal = dArray;
            this.fDoubleImag = dArray2;
            this.fIntReal = null;
            this.fIntImag = null;
        }

        VCVTableModel(int[][] nArray, int[][] nArray2) {
            this.fDoubleReal = null;
            this.fDoubleImag = null;
            this.fIntReal = nArray;
            this.fIntImag = nArray2;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            boolean bl = n == 256;
            boolean bl2 = n2 == 256;
            int n3 = this.getColumnCount();
            int n4 = this.getRowCount();
            if (bl || bl2) {
                if (bl && n2 % 10 == 0 && n2 <= n3) {
                    return ImportUtils.getResource("vcv.truncationRows", Integer.toString(256));
                }
                if (bl2 && n % 20 == 0 && n <= n4) {
                    return ImportUtils.getResource("vcv.truncationCols", Integer.toString(256));
                }
                return "";
            }
            if (this.fDoubleReal != null) {
                if (this.fDoubleImag == null) {
                    return this.fDoubleReal[n][n2];
                }
                return Double.toString(this.fDoubleReal[n][n2]) + " + " + Double.toString(this.fDoubleImag[n][n2]) + " i ";
            }
            if (this.fIntImag == null) {
                return this.fIntReal[n][n2];
            }
            return Integer.toString(this.fIntReal[n][n2]) + " + " + Integer.toString(this.fIntImag[n][n2]) + " i ";
        }

        @Override
        public int getRowCount() {
            int n = this.fDoubleReal != null ? this.fDoubleReal.length : this.fIntReal.length;
            if (n == 256) {
                ++n;
            }
            return n;
        }

        @Override
        public int getColumnCount() {
            int n = this.fDoubleReal != null ? this.fDoubleReal[0].length : this.fIntReal[0].length;
            if (n == 256) {
                ++n;
            }
            return n;
        }
    }
}

