/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.desk;

import com.mathworks.jmi.Matlab;
import com.mathworks.mde.desk.F10ConditionedAction;
import com.mathworks.mde.desk.MLDesktop;
import com.mathworks.mde.desk.MLMenuMergeTag;
import com.mathworks.mde.desk.ProjectActionFactory;
import com.mathworks.mde.vrd.LicenseActions;
import com.mathworks.mde.vrd.LicenseActionsFactory;
import com.mathworks.mde.webintegration.startpage.StartPageFactory;
import com.mathworks.mlwidgets.debug.DebugActions;
import com.mathworks.mwswing.ChildAction;
import com.mathworks.mwswing.ExtendedAction;
import com.mathworks.mwswing.ExtendedInputMap;
import com.mathworks.mwswing.MComponentInputMap;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJCheckBoxMenuItem;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.services.binding.MatlabKeyBindings;
import com.mathworks.util.FileUtils;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.action.AbstractPageSetupAction;
import com.mathworks.widgets.action.AbstractPrintAction;
import com.mathworks.widgets.action.AbstractPrintSelectionAction;
import com.mathworks.widgets.debug.DebuggerManager;
import com.mathworks.widgets.desk.DTClient;
import com.mathworks.widgets.desk.DTFrame;
import com.mathworks.widgets.desk.DTGroup;
import com.mathworks.widgets.desk.DTMenu;
import com.mathworks.widgets.desk.DTMenuBar;
import com.mathworks.widgets.desk.DTMenuMergeTag;
import com.mathworks.widgets.desk.DTUtilities;
import com.mathworks.widgets.desk.Desktop;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import java.util.List;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

class MLMenuBar
extends DTMenuBar {
    private static Action sPageSetupAction;
    private static Action sPrintAction;
    private static Action sPrintSelectionAction;
    private static Action sDeleteAction;
    private static Action sFindAction;
    private ChildAction[] fBlockingActions;
    private static final DTMenuMergeTag[] sEditItemTags;
    private static final String EDIT_MENU_ITEM_KEY = "DesktopEditMenuItem";

    MLMenuBar(Desktop desktop, DTFrame dTFrame, DTClient dTClient, DTGroup dTGroup) {
        super(desktop, dTFrame, dTClient, dTGroup);
    }

    protected void populate() {
        ActionMap actionMap;
        Object object;
        KeyStroke keyStroke;
        InputMap inputMap;
        Object object2;
        this.add((JMenu)((Object)new FileMenu()));
        if (this.fFrame.isMainFrame() || ((MLDesktop)this.fDesktop).includeEditMenuWhenUndocked(this.fClient)) {
            this.add((JMenu)((Object)new EditMenu()));
        }
        if ((object2 = (inputMap = this.getInputMap(2)).get(keyStroke = KeyStroke.getKeyStroke(121, 0))) != null && (object = (actionMap = this.getActionMap()).get(object2)) != null) {
            actionMap.put(object2, new F10ConditionedAction((Action)object));
        }
        if (this.fFrame.isMainFrame() || ((MLDesktop)this.fDesktop).includeDebugMenuWhenUndocked(this.fClient)) {
            this.add((JMenu)((Object)new DebugMenu()));
        } else {
            actionMap = new MComponentInputMap((JComponent)((Object)this));
            DebugActions.addDebugActionsToInputMap((ExtendedInputMap)actionMap, (boolean)false);
            actionMap.setParent(inputMap);
            this.setInputMap(2, (InputMap)((Object)actionMap));
            DebugActions.addDebugActionsToActionMap((ActionMap)this.getActionMap(), (boolean)false);
        }
        if (this.fFrame.isMainFrame() && !this.fDesktop.useToolstrip() && ((MLDesktop)this.fDesktop).hasDCTLicense()) {
            actionMap = new MJMenu(MLDesktop.sMLRes.getString("menu.Distributed"));
            ((Component)((Object)actionMap)).setName("DesktopDistributedMenu");
            try {
                object = Class.forName("com.mathworks.toolbox.distcomp.ui.desk.MLDesktopParallelMenu");
                Method method = ((Class)object).getMethod("populate", MJMenu.class);
                method.invoke(null, actionMap);
                this.add((JMenu)((Object)actionMap));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!this.fDesktop.useToolstrip() && (this.fFrame.isMainFrame() || this.fDesktop.hasMainFrame())) {
            this.add((JMenu)this.fFrame.getDesktopMenu());
        }
        this.add((JMenu)this.fFrame.getWindowMenu());
        this.add((JMenu)((Object)new HelpMenu((MLDesktop)this.fDesktop, this.fFrame, this.fClient, this.fGroup)));
    }

    void blockEditKeyBindings() {
        JMenu jMenu = DTMenuBar.findMenu((JMenuBar)((Object)this), (DTMenuMergeTag)DTMenuMergeTag.EDIT);
        if (jMenu == null) {
            return;
        }
        if (this.fBlockingActions != null) {
            this.unblockEditKeyBindings();
        }
        this.fBlockingActions = new ChildAction[sEditItemTags.length];
        for (int i = 0; i < sEditItemTags.length; ++i) {
            Action action;
            DTMenuMergeTag dTMenuMergeTag = sEditItemTags[i];
            JMenuItem jMenuItem = DTMenu.findItem((JMenu)jMenu, (DTMenuMergeTag)dTMenuMergeTag);
            if (jMenuItem == null || (action = jMenuItem.getAction()) == null) continue;
            this.fBlockingActions[i] = new ChildAction(action);
            this.fBlockingActions[i].setAccelerator(null);
            this.fBlockingActions[i].setAccelerators(null);
            this.fBlockingActions[i].putValue("AcceleratorList", ChildAction.NULL_VALUE);
            this.fBlockingActions[i].putValue(EDIT_MENU_ITEM_KEY, (Object)jMenuItem);
            jMenuItem.setAction((Action)this.fBlockingActions[i]);
        }
    }

    void unblockEditKeyBindings() {
        if (this.fBlockingActions != null) {
            for (ChildAction childAction : this.fBlockingActions) {
                if (childAction == null) continue;
                JMenuItem jMenuItem = (JMenuItem)childAction.getValue(EDIT_MENU_ITEM_KEY);
                if (jMenuItem != null && jMenuItem.getAction() == childAction) {
                    jMenuItem.setAction(childAction.getParent());
                }
                childAction.setParent(null);
            }
            this.fBlockingActions = null;
        }
    }

    private static boolean usingMacScreenMenus() {
        return PlatformInfo.isMacintosh() && "true".equalsIgnoreCase(System.getProperty("apple.laf.useScreenMenuBar"));
    }

    static {
        sEditItemTags = new DTMenuMergeTag[]{DTMenuMergeTag.CUT, DTMenuMergeTag.COPY, DTMenuMergeTag.PASTE, DTMenuMergeTag.SELECT_ALL};
    }

    private static class PlaceHolderAction
    extends MJAbstractAction {
        public PlaceHolderAction(String string, DTMenuMergeTag dTMenuMergeTag, String string2) {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("MATLABDesktop", string, (ExtendedAction)this);
            MatlabKeyBindings.getManager().clearKeyBinding((ExtendedAction)this);
            dTMenuMergeTag.setTag((Action)((Object)this));
            this.setComponentName(string2);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    static class HelpMenu
    extends DTMenu {
        private final MLDesktop iDesktop;
        private final DTFrame iFrame;
        private final DTClient iClient;
        private final DTGroup iGroup;

        HelpMenu(MLDesktop mLDesktop, DTFrame dTFrame, DTClient dTClient, DTGroup dTGroup) {
            super(MLDesktop.sMLRes.getString("menu.Help"), true);
            this.iDesktop = mLDesktop;
            this.iFrame = dTFrame;
            this.iClient = dTClient;
            this.iGroup = dTGroup;
            this.setName("DesktopHelpMenu");
            this.populateIfNecessary();
            MLMenuMergeTag.HELP.setTag((JMenuItem)((Object)this));
        }

        protected void populate() {
            Action action;
            if (!this.iDesktop.useToolstrip()) {
                this.add(this.iDesktop.getProductHelpAction());
                this.add(this.iDesktop.getFunctionBrowserAction());
            }
            if (!Matlab.isStudentVersion()) {
                this.add(this.iDesktop.getSupportRequestAction());
            }
            this.addSeparator();
            boolean bl = false;
            if (this.iFrame.isMainFrame()) {
                this.add(this.iDesktop.getDesktopHelpAction());
                bl = true;
            }
            if ((action = this.iDesktop.getComponentHelpAction(this.iClient, this.iGroup)) != null) {
                this.add(action);
                bl = true;
            }
            if (bl) {
                this.addSeparator();
            }
            this.add((JMenuItem)((Object)new WebMenu(this.iDesktop)));
            if (!Matlab.isStudentVersion()) {
                this.add(this.iDesktop.getVisitTrialsAction());
                this.add(this.iDesktop.getCheckForUpdatesAction());
            } else {
                this.add((JMenuItem)((Object)new TutorialsMenu(this.iDesktop)));
            }
            this.addSeparator();
            LicenseActions licenseActions = LicenseActionsFactory.getLicenseActions();
            if (licenseActions.isEnabled()) {
                LicensingMenu licensingMenu = new LicensingMenu(this.iDesktop, licenseActions);
                this.add((JMenuItem)((Object)licensingMenu));
                this.addSeparator();
            }
            if (StartPageFactory.getStartPage().isEnabled()) {
                this.add(this.iDesktop.getStartPageAction());
            }
            this.add(this.iDesktop.getDemosAction());
            this.addSeparator();
            if (Matlab.isStudentVersion()) {
                this.add(this.iDesktop.getStudentActivationAction());
            }
            this.add(this.iDesktop.getTermsOfUseAction());
            this.add(this.iDesktop.getPatentsAction());
            if (!MLMenuBar.usingMacScreenMenus()) {
                this.addSeparator();
                this.add(this.iDesktop.getAboutAction());
            }
        }
    }

    static class TutorialsMenu
    extends DTMenu {
        private final MLDesktop iDesktop;

        TutorialsMenu(MLDesktop mLDesktop) {
            super(MLDesktop.sMLRes.getString("menu.Tutorials"), true);
            this.iDesktop = mLDesktop;
            this.setName("DesktopTutorialsMenu");
            if (DTUtilities.usingMacScreenMenus()) {
                this.populateIfNecessary();
            }
            MLMenuMergeTag.TUTORIALS.setTag((JMenuItem)((Object)this));
        }

        protected void populate() {
            this.add(this.iDesktop.getVisitMLTutorialsAction());
            this.add(this.iDesktop.getVisitSLTutorialsAction());
        }
    }

    static class LicensingMenu
    extends DTMenu {
        private final MLDesktop iDesktop;
        private final Action[] fActions;
        private final LicenseActions fLicActions;

        LicensingMenu(MLDesktop mLDesktop, LicenseActions licenseActions) {
            super(MLDesktop.sMLRes.getString("menu.Licensing"), true);
            this.iDesktop = mLDesktop;
            this.fLicActions = licenseActions;
            this.fActions = this.fLicActions.getActions(MLDesktop.sMLRes);
            this.setName("DesktopLicensingMenu");
            if (DTUtilities.usingMacScreenMenus()) {
                this.populateIfNecessary();
            }
            MLMenuMergeTag.LICENSING.setTag((JMenuItem)((Object)this));
        }

        protected void populate() {
            for (Action action : this.fActions) {
                this.add(action);
                if (!this.fLicActions.doesSeparatorFollow(action)) continue;
                this.addSeparator();
            }
            if (this.iDesktop.isLicenseBorrowingEnabled()) {
                this.addSeparator();
                this.add(this.iDesktop.getLicenseBorrowAction());
            }
        }
    }

    static class WebMenu
    extends DTMenu {
        private final MLDesktop iDesktop;

        WebMenu(MLDesktop mLDesktop) {
            super(MLDesktop.sMLRes.getString("menu.Web"), true);
            this.iDesktop = mLDesktop;
            this.setName("DesktopWebMenu");
            if (DTUtilities.usingMacScreenMenus()) {
                this.populateIfNecessary();
            }
            DTMenuMergeTag.WEB.setTag((JMenuItem)((Object)this));
        }

        protected void populate() {
            this.add(this.iDesktop.getVisitWebSiteAction());
            if (Matlab.isStudentVersion()) {
                this.add(this.iDesktop.getVisitLoginAction());
            }
            this.add(this.iDesktop.getVisitNewProductsAction());
            this.add(this.iDesktop.getVisitTechSupportAction());
            this.add(this.iDesktop.getVisitTrainingAction());
            if (Matlab.isStudentVersion()) {
                this.add(this.iDesktop.getVisitStudentFAQAction());
                this.add(this.iDesktop.getVisitStudentCenterAction());
                this.add(this.iDesktop.getVisitStoreAction());
            } else {
                this.add(this.iDesktop.getVisitLoginAction());
            }
            this.addSeparator();
            this.add(this.iDesktop.getVisitMatlabCentralAction());
            this.add(this.iDesktop.getVisitFileExchangeAction());
            this.add(this.iDesktop.getVisitNewsGroupsAction());
            this.add(this.iDesktop.getVisitNewslettersAction());
        }
    }

    static class DebugMenu
    extends DTMenu {
        DebugMenu() {
            super(MLDesktop.sMLRes.getString("menu.Debug"), true);
            this.setName("DesktopDebugMenu");
            this.populateIfNecessary();
            MLMenuMergeTag.DEBUG.setTag((JMenuItem)((Object)this));
        }

        protected void populate() {
            MJCheckBoxMenuItem mJCheckBoxMenuItem = new MJCheckBoxMenuItem(DebugActions.getEnableGraphicalDebugAction());
            MLMenuMergeTag.ENABLE_GRAPHICAL_DEBUG.setTag(this.add((JMenuItem)mJCheckBoxMenuItem));
            this.addSeparator();
            DebuggerManager debuggerManager = DebuggerManager.getInstance();
            MLMenuMergeTag.STEP.setTag(this.add(debuggerManager.getStepAction()));
            MLMenuMergeTag.STEP_IN.setTag(this.add(debuggerManager.getStepInAction()));
            MLMenuMergeTag.STEP_OUT.setTag(this.add(debuggerManager.getStepOutAction()));
            MLMenuMergeTag.CONTINUE.setTag(this.add(debuggerManager.getContinueAction()));
            this.addSeparator();
            MLMenuMergeTag.CLEAR_BREAKPOINTS.setTag(this.add(DebugActions.getClearAllBkptsAction()));
            MLMenuMergeTag.SET_ERROR_BREAKPOINTS.setTag(this.add(DebugActions.getSetErrorBkptsAction()));
            this.addSeparator();
            MLMenuMergeTag.EXIT_DEBUG.setTag(this.add(debuggerManager.getExitDebugAction()));
        }
    }

    class EditMenu
    extends DTMenu {
        EditMenu() {
            super(MLMenuBar.this.fDesktop.getString("menu.Edit"), true);
            this.setName("DesktopEditMenu");
            DTMenuMergeTag.EDIT.setTag((JMenuItem)((Object)this));
        }

        protected void populate() {
            MLDesktop mLDesktop = (MLDesktop)MLMenuBar.this.fDesktop;
            this.add(DTMenuBar.sUndoAction);
            this.add(DTMenuBar.sRedoAction);
            this.addSeparator();
            this.add(DTMenuBar.sCutAction);
            this.add(DTMenuBar.sCopyAction);
            this.add(DTMenuBar.sPasteAction);
            this.add(mLDesktop.getPasteSpecialAction());
            this.addSeparator();
            this.add(DTMenuBar.sSelectAllAction);
            if (sDeleteAction == null) {
                sDeleteAction = (Action)((Object)new PlaceHolderAction("delete-next", MLMenuMergeTag.DELETE, "Delete"));
            }
            this.add(sDeleteAction);
            this.addSeparator();
            if (sFindAction == null) {
                sFindAction = (Action)((Object)new PlaceHolderAction("find-and-replace", MLMenuMergeTag.FIND, "Find"));
            }
            this.add(sFindAction);
            this.add(mLDesktop.getFindFilesAction());
            this.addSeparator();
            this.add(mLDesktop.getClearCommandAction());
            this.add(mLDesktop.getClearHistoryAction());
            this.add(mLDesktop.getClearWorkspaceAction());
        }
    }

    class NewMenu
    extends DTMenu {
        NewMenu() {
            super(MLDesktop.sMLRes.getString("menu.New"), true);
            this.setName("DesktopNewMenu");
            DTMenuMergeTag.NEW.setTag((JMenuItem)((Object)this));
            this.populateIfNecessary();
        }

        protected void populate() {
            Action action;
            block8: {
                block7: {
                    MLDesktop mLDesktop = (MLDesktop)MLMenuBar.this.fDesktop;
                    this.add(mLDesktop.getNewBlankMFileAction());
                    this.add(mLDesktop.getNewFunctionMFileAction());
                    this.add(mLDesktop.getNewClassMFileAction());
                    this.add(mLDesktop.getNewEnumerationMFileAction());
                    if (mLDesktop.hasSystemToolbox()) {
                        this.add(mLDesktop.getNewSystemMFileAction());
                    }
                    this.add(mLDesktop.getNewFigureAction());
                    this.add(mLDesktop.getNewVariableAction());
                    this.add(mLDesktop.getNewModelAction());
                    JMenuItem jMenuItem = this.add(mLDesktop.getNewGUIAction());
                    jMenuItem.getAccessibleContext().setAccessibleName(MLDesktop.sMLRes.getString("accessiblename.gui"));
                    if (mLDesktop.hasCompilerPlugin()) break block7;
                    if (!mLDesktop.hasCodeGenerationPlugin()) break block8;
                }
                this.addSeparator();
            }
            if (mLDesktop.hasCompilerPlugin() && (action = ProjectActionFactory.getAction("NewDeploymentProjectAction")) != null) {
                this.add(action);
            }
            if (mLDesktop.hasCodeGenerationPlugin() && (action = ProjectActionFactory.getAction("NewCodeGenerationProjectAction")) != null) {
                this.add(action);
            }
            if (mLDesktop.hasSimulinkProjectPlugin() && (action = this.createNewSimulinkProjectAction()) != null) {
                this.add(action);
            }
        }

        private Action createNewSimulinkProjectAction() {
            Class<?> clazz;
            try {
                clazz = Class.forName("com.mathworks.toolbox.slproject.project.GUI.canvas.actions.NewProjectFromMatlab");
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
            if (clazz == null) {
                return null;
            }
            Action action = null;
            try {
                Object obj = clazz.newInstance();
                if (obj instanceof MJAbstractAction) {
                    action = (Action)obj;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return action;
        }
    }

    class FileMenu
    extends DTMenu {
        FileMenu() {
            super(MLMenuBar.this.fDesktop.getString("menu.File"), true);
            this.setName("DesktopFileMenu");
            this.populateIfNecessary();
            DTMenuMergeTag.FILE.setTag((JMenuItem)((Object)this));
        }

        protected void populate() {
            MLDesktop mLDesktop = (MLDesktop)MLMenuBar.this.fDesktop;
            this.add((JMenuItem)((Object)new NewMenu()));
            this.add(mLDesktop.getOpenAction());
            if (MLMenuBar.this.fFrame.isMainFrame() && !mLDesktop.startedWithMainFrame()) {
                this.add(mLDesktop.getCloseDesktopAction());
            }
            MLMenuBar.this.addFileCloseItems((JMenu)((Object)this));
            this.addSeparator();
            this.add(mLDesktop.getImportAction());
            this.add(mLDesktop.getSaveWorkspaceAction());
            this.addSeparator();
            this.add(mLDesktop.getSetPathAction());
            if (!MLMenuBar.usingMacScreenMenus()) {
                this.add(mLDesktop.getPreferencesAction());
            }
            this.addSeparator();
            if (sPageSetupAction == null) {
                sPageSetupAction = (Action)new AbstractPageSetupAction(){

                    public void actionPerformed(ActionEvent actionEvent) {
                    }
                };
                sPageSetupAction.setEnabled(false);
                MLMenuMergeTag.PAGE_SETUP.setTag(sPageSetupAction);
            }
            this.add(sPageSetupAction);
            if (sPrintAction == null) {
                sPrintAction = (Action)new AbstractPrintAction(){

                    public void actionPerformed(ActionEvent actionEvent) {
                    }
                };
                MLMenuMergeTag.PRINT.setTag(sPrintAction);
            }
            this.add(sPrintAction);
            if (sPrintSelectionAction == null) {
                sPrintSelectionAction = (Action)new AbstractPrintSelectionAction(){

                    public void actionPerformed(ActionEvent actionEvent) {
                    }
                };
                sPrintSelectionAction.setEnabled(false);
                MLMenuMergeTag.PRINT_SELECTION.setTag(sPrintSelectionAction);
            }
            this.add(sPrintSelectionAction);
            List list = mLDesktop.getRecentFiles().getReopenActions("Editor");
            if (!list.isEmpty()) {
                this.addSeparator();
                for (int i = 0; i < list.size(); ++i) {
                    Action action = (Action)list.get(i);
                    String string = FileUtils.truncatePathname((String)((String)action.getValue("ShortDescription")), (int)25);
                    if (i < 9) {
                        string = "&" + (i + 1) + " " + string;
                    }
                    MJMenuItem mJMenuItem = new MJMenuItem(string);
                    mJMenuItem.setName("RecentFile" + (i + 1) + "MenuItem");
                    mJMenuItem.addActionListener((ActionListener)action);
                    this.add((JMenuItem)mJMenuItem);
                }
            }
            if (!MLMenuBar.usingMacScreenMenus()) {
                this.addSeparator();
                this.add(mLDesktop.getQuitAction());
            }
        }
    }
}

