/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor;

import com.mathworks.mde.editor.EditorDialogProvider;
import com.mathworks.mde.editor.EditorOptions;
import com.mathworks.mde.editor.EditorUiUtils;
import com.mathworks.mde.editor.EditorUtils;
import com.mathworks.mde.editor.GoToDialogPanel;
import com.mathworks.mde.editor.MFilePathUtil;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.widgets.Dialogs;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.text.MessageFormat;

public class DialogFactory {
    public static final int YES = 0;
    public static final int NO = 1;
    public static final int CANCEL = 2;
    public static final int SAVE_AS = 3;
    public static final String GOTO_DIALOG_WINDOW_NAME = "EditorGoToDialog";
    private static EditorDialogProvider sDialogProvider = new EditorDialogProviderImpl();

    private DialogFactory() {
    }

    public static EditorDialogProvider getEditorDialogProvider() {
        return sDialogProvider;
    }

    public static void setEditorDialogProvider(EditorDialogProvider editorDialogProvider) {
        if (editorDialogProvider == null) {
            throw new IllegalArgumentException("The given EditorDialogProvider cannot be null.");
        }
        sDialogProvider = editorDialogProvider;
    }

    static int showSaveWhileDebug(Component component, String string) {
        String string2 = MessageFormat.format(EditorUtils.lookup("msg.SaveWhileDebug"), string);
        int n = Dialogs.showOptionalConfirmDialog((Component)component, (Object)string2, (String)EditorUtils.EDITOR_TITLE, (int)2, (int)3, (String)EditorOptions.getPromptWhenSavingInDebugKey(), (int)0, (boolean)EditorOptions.getDefaultPromptWhenSavingInDebug());
        return n == 0 ? 0 : 1;
    }

    static int showCloseDirty(Component component, String string) {
        return Dialogs.showSaveDirtyFile((Component)component, (String)string, (String)EditorUtils.EDITOR_TITLE);
    }

    private static void showMessage(Component component, String string, int n) {
        MJOptionPane.showMessageDialog((Component)MJFrame.getFrame((Component)component), (Object)string, (String)EditorUtils.EDITOR_TITLE, (int)n);
    }

    public static void showErrorMessage(Component component, String string) {
        DialogFactory.showMessage(component, string, 0);
    }

    public static void showWarningMessage(Component component, String string) {
        DialogFactory.showMessage(component, string, 2);
    }

    static String showInputDialog(Component component, String string) {
        return MJOptionPane.showInputDialog((Component)component, (Object)string, (String)EditorUtils.EDITOR_TITLE, (int)3);
    }

    public static void showNotEnoughMemoryToOpenResourceDialog(String string, Component component) {
        Option[] optionArray;
        String string2 = MessageFormat.format(EditorUtils.lookup("msg.NotEnoughMemoryToOpenFile"), string);
        Frame frame = EditorUiUtils.getParentFrame(component);
        int n = MJOptionPane.showOptionDialog((Component)frame, (Object)string2, (String)EditorUtils.EDITOR_TITLE, (int)2, (int)0, null, (Object[])(optionArray = new Option[]{Option.OK, Option.HELP}), (Object)((Object)Option.OK));
        if (n >= 0 && optionArray[n] == Option.HELP) {
            String string3 = MLHelpServices.getMapfileName((String)"matlab", (String)"matlab_env_csh");
            MLHelpServices.cshDisplayTopic((Object)frame, (String)string3, (String)"editor_outofmemory");
        }
    }

    static int showPageSetup(Component component, String string, Component component2) {
        int n = MJOptionPane.showConfirmDialog((Component)component, (Object)component2, (String)string, (int)2, (int)-1);
        if (n == 0) {
            return 0;
        }
        return 1;
    }

    private static int showConfirm(Component component, String string, int n, int n2) {
        return MJOptionPane.showConfirmDialog((Component)component, (Object)string, (String)EditorUtils.EDITOR_TITLE, (int)n, (int)n2);
    }

    private static int showYesNoConfirm(Component component, String string, int n) {
        int n2 = DialogFactory.showConfirm(component, string, 0, n);
        return n2 == 0 ? 0 : 1;
    }

    public static class EditorDialogProviderImpl
    implements EditorDialogProvider {
        private static GoToDialogPanel sGoToDialogPanel;

        @Override
        public int shouldCreateNonExistentFile(Component component, File file) {
            String string = MFilePathUtil.getTruncatedFilename(file.getPath());
            String string2 = MessageFormat.format(EditorUtils.lookup("question.DoesnotexistCreate"), string);
            int n = EditorOptions.getNamedBufferOption();
            int n2 = n == 1 ? 0 : 1;
            int n3 = Dialogs.showOptionalConfirmDialog((Component)component, (Object)string2, (String)EditorUtils.EDITOR_TITLE, (int)0, (int)3, (String)EditorOptions.getShowNewFilePromptKey(), (int)n2, (boolean)EditorOptions.getDefaultShowNewFilePromptValue());
            if (n3 == 0) {
                return 0;
            }
            if (n3 == 1) {
                return 1;
            }
            return 2;
        }

        @Override
        public int shouldOpenUntitledEditor(Component component, String string) {
            return DialogFactory.showYesNoConfirm(component, string, 2);
        }

        @Override
        public int showReload(Component component, String string) {
            String string2 = MessageFormat.format(EditorUtils.lookup("question.ReloadModifiedFile"), string);
            return DialogFactory.showYesNoConfirm(component, string2, 2);
        }

        @Override
        public int showGotoDialog(Component component, int n, String[] stringArray, int[] nArray, Object[] objectArray, int[] nArray2, Object object) {
            if (stringArray.length != nArray.length) {
                throw new IllegalArgumentException("Must be the same number of function names and function line numbers.");
            }
            if (objectArray.length != nArray2.length) {
                throw new IllegalArgumentException("Must be the same number of cell divider names and cell divider line numbers.");
            }
            MJDialog mJDialog = EditorDialogProviderImpl.createGotoDialog(component, stringArray, nArray, objectArray, nArray2, n, object);
            mJDialog.show();
            return sGoToDialogPanel.getLineNumber();
        }

        public static MJDialog createGotoDialog(Component component, Object[] objectArray, int[] nArray, Object[] objectArray2, int[] nArray2, int n, Object object) {
            MJDialog mJDialog = new MJDialog((Frame)MJFrame.getFrame((Component)component), EditorUtils.lookup("dialog.gotoTitle"), true);
            mJDialog.setName(DialogFactory.GOTO_DIALOG_WINDOW_NAME);
            if (sGoToDialogPanel == null) {
                sGoToDialogPanel = new GoToDialogPanel(component, objectArray, nArray, objectArray2, nArray2, n, object, mJDialog);
            } else {
                sGoToDialogPanel.setTableInfo(component, objectArray, nArray, objectArray2, nArray2, n, object, mJDialog);
            }
            return mJDialog;
        }
    }

    private static enum Option implements MJOptionPane.Option
    {
        OK(EditorUtils.lookup("dialog.notEnoughMemoryToOpenResource.ok")),
        HELP(EditorUtils.lookup("dialog.notEnoughMemoryToOpenResource.help"));

        private final String fText;

        private Option(String string2) {
            this.fText = string2;
        }

        public String getText() {
            return this.fText;
        }
    }
}

