/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.functionbrowser;

import com.mathworks.mde.functionbrowser.FunctionTable;
import com.mathworks.mde.functionbrowser.FunctionTableModel;
import com.mathworks.mde.functionbrowser.SearchObserverGroup;
import com.mathworks.mlwidgets.help.HelpUtils;
import com.mathworks.mlwidgets.help.search.BooleanSearchOperator;
import com.mathworks.mlwidgets.help.search.CompoundSearchExpression;
import com.mathworks.mlwidgets.help.search.DocSearchEngine;
import com.mathworks.mlwidgets.help.search.DocSearchField;
import com.mathworks.mlwidgets.help.search.DocSearchResult;
import com.mathworks.mlwidgets.help.search.SearchCompletionObserver;
import com.mathworks.mlwidgets.help.search.SearchCriteria;
import com.mathworks.mlwidgets.help.search.SearchException;
import com.mathworks.mlwidgets.help.search.SearchExpression;
import com.mathworks.mlwidgets.help.search.SearchField;
import com.mathworks.mlwidgets.help.search.SearchResults;
import com.mathworks.mlwidgets.help.search.SearchStringParseException;
import com.mathworks.mlwidgets.help.search.SearchStringParser;
import com.mathworks.mlwidgets.help.search.SearchUtils;
import com.mathworks.util.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ResourceBundle;
import javax.swing.SwingUtilities;

final class FindFunction {
    static SearchExpression sFuncPageExpr;
    static SearchExpression sRefPageExpr;

    FindFunction() {
    }

    static void search(String string, FunctionTable functionTable, SearchObserverGroup searchObserverGroup) {
        if (sFuncPageExpr == null) {
            return;
        }
        SearchObserverGroup.CancellableSearchObserver cancellableSearchObserver = searchObserverGroup.addObserver(new ExactTitleSearchObserver(string, functionTable, searchObserverGroup));
        FindFunction.searchFunctionNameExact(string, cancellableSearchObserver);
    }

    private static void search(SearchCompletionObserver<DocSearchResult> searchCompletionObserver, SearchExpression ... searchExpressionArray) {
        if (sFuncPageExpr == null) {
            return;
        }
        ArrayList<SearchExpression> arrayList = new ArrayList<SearchExpression>();
        arrayList.addAll(Arrays.asList(searchExpressionArray));
        arrayList.add(sFuncPageExpr);
        arrayList.add(sRefPageExpr);
        SearchCriteria searchCriteria = new SearchCriteria((SearchExpression)new CompoundSearchExpression(arrayList));
        searchCriteria.setUseProductFilter(true);
        DocSearchEngine.getInstance().search(searchCriteria, searchCompletionObserver);
    }

    static void searchFunctionNameExact(String string, SearchCompletionObserver<DocSearchResult> searchCompletionObserver) {
        try {
            FindFunction.search(searchCompletionObserver, SearchStringParser.buildExpression((String)string, (BooleanSearchOperator)BooleanSearchOperator.MUST_OCCUR, (SearchField[])new SearchField[]{DocSearchField.TITLE}));
        }
        catch (SearchException searchException) {
            searchCompletionObserver.searchFailed(searchException);
        }
    }

    static void searchFunctionNameWild(String string, SearchCompletionObserver<DocSearchResult> searchCompletionObserver) {
        try {
            SearchExpression searchExpression = SearchStringParser.buildExpression((String)FindFunction.makeWildcardSearchTerm(string), (BooleanSearchOperator)BooleanSearchOperator.MUST_OCCUR, (SearchField[])new SearchField[]{DocSearchField.TITLE});
            SearchExpression searchExpression2 = SearchStringParser.buildExpression((String)string, (BooleanSearchOperator)BooleanSearchOperator.MUST_NOT_OCCUR, (SearchField[])new SearchField[]{DocSearchField.TITLE});
            FindFunction.search(searchCompletionObserver, searchExpression, searchExpression2);
        }
        catch (SearchException searchException) {
            searchCompletionObserver.searchFailed(searchException);
        }
    }

    static void searchH1Exact(String string, SearchCompletionObserver<DocSearchResult> searchCompletionObserver) {
        try {
            SearchExpression searchExpression = SearchStringParser.buildExpression((String)string, (BooleanSearchOperator)BooleanSearchOperator.MUST_OCCUR, (SearchField[])new SearchField[]{DocSearchField.REFPAGE_SUMMARY});
            SearchExpression searchExpression2 = SearchStringParser.buildExpression((String)FindFunction.makeWildcardSearchTerm(string), (BooleanSearchOperator)BooleanSearchOperator.MUST_NOT_OCCUR, (SearchField[])new SearchField[]{DocSearchField.TITLE});
            FindFunction.search(searchCompletionObserver, searchExpression, searchExpression2);
        }
        catch (SearchException searchException) {
            searchCompletionObserver.searchFailed(searchException);
        }
    }

    static void searchH1Wild(String string, SearchCompletionObserver<DocSearchResult> searchCompletionObserver) {
        try {
            SearchExpression searchExpression = SearchStringParser.buildExpression((String)FindFunction.makeWildcardSearchTerm(string), (BooleanSearchOperator)BooleanSearchOperator.MUST_OCCUR, (SearchField[])new SearchField[]{DocSearchField.REFPAGE_SUMMARY});
            SearchExpression searchExpression2 = SearchStringParser.buildExpression((String)string, (BooleanSearchOperator)BooleanSearchOperator.MUST_NOT_OCCUR, (SearchField[])new SearchField[]{DocSearchField.REFPAGE_SUMMARY});
            SearchExpression searchExpression3 = SearchStringParser.buildExpression((String)FindFunction.makeWildcardSearchTerm(string), (BooleanSearchOperator)BooleanSearchOperator.MUST_NOT_OCCUR, (SearchField[])new SearchField[]{DocSearchField.TITLE});
            FindFunction.search(searchCompletionObserver, searchExpression, searchExpression2, searchExpression3);
        }
        catch (SearchException searchException) {
            searchCompletionObserver.searchFailed(searchException);
        }
    }

    static void searchBodyExact(String string, SearchCompletionObserver<DocSearchResult> searchCompletionObserver) {
        try {
            SearchExpression searchExpression = SearchStringParser.buildExpression((String)string, (BooleanSearchOperator)BooleanSearchOperator.MUST_OCCUR, (SearchField[])new SearchField[]{DocSearchField.BODY});
            SearchExpression searchExpression2 = SearchStringParser.buildExpression((String)FindFunction.makeWildcardSearchTerm(string), (BooleanSearchOperator)BooleanSearchOperator.MUST_NOT_OCCUR, (SearchField[])new SearchField[]{DocSearchField.TITLE, DocSearchField.REFPAGE_SUMMARY});
            FindFunction.search(searchCompletionObserver, searchExpression, searchExpression2);
        }
        catch (SearchException searchException) {
            searchCompletionObserver.searchFailed(searchException);
        }
    }

    static void searchBodyWild(String string, SearchCompletionObserver<DocSearchResult> searchCompletionObserver) {
        try {
            SearchExpression searchExpression = SearchStringParser.buildExpression((String)FindFunction.makeWildcardSearchTerm(string), (BooleanSearchOperator)BooleanSearchOperator.MUST_OCCUR, (SearchField[])new SearchField[]{DocSearchField.BODY});
            SearchExpression searchExpression2 = SearchStringParser.buildExpression((String)string, (BooleanSearchOperator)BooleanSearchOperator.MUST_NOT_OCCUR, (SearchField[])new SearchField[]{DocSearchField.BODY});
            SearchExpression searchExpression3 = SearchStringParser.buildExpression((String)FindFunction.makeWildcardSearchTerm(string), (BooleanSearchOperator)BooleanSearchOperator.MUST_NOT_OCCUR, (SearchField[])new SearchField[]{DocSearchField.TITLE, DocSearchField.REFPAGE_SUMMARY});
            FindFunction.search(searchCompletionObserver, searchExpression, searchExpression2, searchExpression3);
        }
        catch (SearchException searchException) {
            searchCompletionObserver.searchFailed(searchException);
        }
    }

    private static boolean isWildcardable(String string) {
        if ((string = string.trim()).matches("^\".*\"$")) {
            return false;
        }
        String[] stringArray = HelpUtils.isEnglish() ? string.split("[^a-zA-Z0-9]") : string.split("[\\s\\_\\.]+");
        if (stringArray == null || stringArray.length == 0) {
            return false;
        }
        String string2 = stringArray[stringArray.length - 1];
        return string2.length() >= 3 || !HelpUtils.isEnglish() && string2.length() >= 2;
    }

    private static String makeWildcardSearchTerm(String string) {
        return FindFunction.isWildcardable(string) ? string + "*" : string;
    }

    static {
        try {
            if (!HelpUtils.isEnglish()) {
                ResourceBundle resourceBundle = ResourceBundle.getBundle("com.mathworks.mde.functionbrowser.resources.RES_FunctionBrowser");
                String string = "FUNCTIONS OR \"FUNCTION REFERENCE\"";
                if (!"FUNCTIONS".equals(resourceBundle.getString("FindFunction.Functions"))) {
                    string = string + " OR " + resourceBundle.getString("FindFunction.Functions");
                }
                if (!"FUNCTION REFERENCE".equals(resourceBundle.getString("FindFunction.FunctionRef"))) {
                    string = string + " OR \"" + resourceBundle.getString("FindFunction.FunctionRef") + "\"";
                }
                sFuncPageExpr = SearchStringParser.buildExpression((String)string, (BooleanSearchOperator)BooleanSearchOperator.MUST_OCCUR, (SearchField[])new SearchField[]{DocSearchField.SECTION});
            } else {
                sFuncPageExpr = SearchStringParser.buildExpression((String)"FUNCTIONS OR \"FUNCTION REFERENCE\"", (BooleanSearchOperator)BooleanSearchOperator.MUST_OCCUR, (SearchField[])new SearchField[]{DocSearchField.SECTION});
            }
        }
        catch (SearchStringParseException searchStringParseException) {
            Log.log((String)searchStringParseException.toString());
        }
        sRefPageExpr = SearchUtils.getRefPageExpression();
    }

    static class WildBodySearchObserver
    extends SearchObserver {
        WildBodySearchObserver(String string, FunctionTable functionTable, SearchObserverGroup searchObserverGroup) {
            super(string, functionTable, searchObserverGroup);
        }

        @Override
        protected void nextSearch() {
            FunctionTableModel functionTableModel = this.iFunctionTable.getFunctionTableModel();
            functionTableModel.clearPendingMessage();
            functionTableModel.maybeSetEmptyMessage();
        }
    }

    static class ExactBodySearchObserver
    extends SearchObserver {
        ExactBodySearchObserver(String string, FunctionTable functionTable, SearchObserverGroup searchObserverGroup) {
            super(string, functionTable, searchObserverGroup);
        }

        @Override
        protected void nextSearch() {
            if (FindFunction.isWildcardable(this.iSearchString)) {
                SearchObserverGroup.CancellableSearchObserver cancellableSearchObserver = this.iSearchObserverGroup.addObserver(new WildBodySearchObserver(this.iSearchString, this.iFunctionTable, this.iSearchObserverGroup));
                FindFunction.searchBodyWild(this.iSearchString, cancellableSearchObserver);
            } else {
                FunctionTableModel functionTableModel = this.iFunctionTable.getFunctionTableModel();
                functionTableModel.clearPendingMessage();
                if (!this.iSearchString.matches("\\b[a-zA-Z0-9 ]+\\b") && HelpUtils.isEnglish()) {
                    functionTableModel.maybeSetEmptyMessage();
                } else {
                    functionTableModel.setEmptyNoWildcardMessage();
                }
            }
        }
    }

    static class WildH1LineSearchObserver
    extends SearchObserver {
        WildH1LineSearchObserver(String string, FunctionTable functionTable, SearchObserverGroup searchObserverGroup) {
            super(string, functionTable, searchObserverGroup);
        }

        @Override
        protected void nextSearch() {
            SearchObserverGroup.CancellableSearchObserver cancellableSearchObserver = this.iSearchObserverGroup.addObserver(new ExactBodySearchObserver(this.iSearchString, this.iFunctionTable, this.iSearchObserverGroup));
            FindFunction.searchBodyExact(this.iSearchString, cancellableSearchObserver);
        }
    }

    private static class ExactH1LineSearchObserver
    extends SearchObserver {
        ExactH1LineSearchObserver(String string, FunctionTable functionTable, SearchObserverGroup searchObserverGroup) {
            super(string, functionTable, searchObserverGroup);
        }

        @Override
        protected void nextSearch() {
            if (FindFunction.isWildcardable(this.iSearchString)) {
                SearchObserverGroup.CancellableSearchObserver cancellableSearchObserver = this.iSearchObserverGroup.addObserver(new WildH1LineSearchObserver(this.iSearchString, this.iFunctionTable, this.iSearchObserverGroup));
                FindFunction.searchH1Wild(this.iSearchString, cancellableSearchObserver);
            } else {
                SearchObserverGroup.CancellableSearchObserver cancellableSearchObserver = this.iSearchObserverGroup.addObserver(new ExactBodySearchObserver(this.iSearchString, this.iFunctionTable, this.iSearchObserverGroup));
                FindFunction.searchBodyExact(this.iSearchString, cancellableSearchObserver);
            }
        }
    }

    private static class WildTitleSearchObserver
    extends SearchObserver {
        WildTitleSearchObserver(String string, FunctionTable functionTable, SearchObserverGroup searchObserverGroup) {
            super(string, functionTable, searchObserverGroup);
        }

        @Override
        protected void nextSearch() {
            SearchObserverGroup.CancellableSearchObserver cancellableSearchObserver = this.iSearchObserverGroup.addObserver(new ExactH1LineSearchObserver(this.iSearchString, this.iFunctionTable, this.iSearchObserverGroup));
            FindFunction.searchH1Exact(this.iSearchString, cancellableSearchObserver);
        }
    }

    static class ExactTitleSearchObserver
    extends SearchObserver {
        ExactTitleSearchObserver(String string, FunctionTable functionTable, SearchObserverGroup searchObserverGroup) {
            super(string, functionTable, searchObserverGroup);
        }

        @Override
        protected void nextSearch() {
            if (FindFunction.isWildcardable(this.iSearchString)) {
                SearchObserverGroup.CancellableSearchObserver cancellableSearchObserver = this.iSearchObserverGroup.addObserver(new WildTitleSearchObserver(this.iSearchString, this.iFunctionTable, this.iSearchObserverGroup));
                FindFunction.searchFunctionNameWild(this.iSearchString, cancellableSearchObserver);
            } else {
                SearchObserverGroup.CancellableSearchObserver cancellableSearchObserver = this.iSearchObserverGroup.addObserver(new ExactH1LineSearchObserver(this.iSearchString, this.iFunctionTable, this.iSearchObserverGroup));
                FindFunction.searchH1Exact(this.iSearchString, cancellableSearchObserver);
            }
        }
    }

    private static abstract class SearchObserver
    implements SearchCompletionObserver {
        protected FunctionTable iFunctionTable;
        protected String iSearchString;
        protected SearchObserverGroup iSearchObserverGroup;

        SearchObserver(String string, FunctionTable functionTable, SearchObserverGroup searchObserverGroup) {
            this.iFunctionTable = functionTable;
            this.iSearchString = string;
            this.iSearchObserverGroup = searchObserverGroup;
        }

        public void searchComplete(final SearchResults searchResults) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (searchResults != null) {
                        SearchObserver.this.iFunctionTable.getFunctionTableModel().addSearchResults(searchResults);
                        SearchObserver.this.iFunctionTable.updateTableModel();
                        SearchObserver.this.iFunctionTable.setHighlightText(SearchObserver.this.iSearchString);
                    }
                    SearchObserver.this.iFunctionTable.getFunctionTableModel().setPendingMessage();
                    SearchObserver.this.nextSearch();
                }
            });
        }

        public void searchFailed(SearchException searchException) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SearchObserver.this.iFunctionTable.getFunctionTableModel().clearPendingMessage();
                }
            });
        }

        protected void nextSearch() {
        }
    }
}

