/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.functionbrowser;

import com.mathworks.mde.functionbrowser.ClassicDocFunctionSearcher;
import com.mathworks.mde.functionbrowser.DocCenterFunctionSearcher;
import com.mathworks.mde.functionbrowser.FunctionCellRenderer;
import com.mathworks.mde.functionbrowser.FunctionSearchObserver;
import com.mathworks.mde.functionbrowser.FunctionSearcher;
import com.mathworks.mde.functionbrowser.FunctionTable;
import com.mathworks.mde.functionbrowser.FunctionTableModel;
import com.mathworks.mde.functionbrowser.SearchObserverGroup;
import com.mathworks.mde.functionbrowser.SearchStringStatus;
import com.mathworks.mlwidgets.help.HelpPrefs;
import com.mathworks.mlwidgets.help.search.SearchResults;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.services.ColorPrefs;
import com.mathworks.services.Prefs;
import com.mathworks.widgets.SearchTextField;
import com.mathworks.widgets.SearchTextFieldIntelliHints;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JScrollBar;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

final class FunctionBrowserPanel
extends MJPanel
implements ActionListener {
    private FunctionTable fTable;
    private SearchTextField fSearchBox;
    private SearchTextFieldIntelliHints fIntelliHints;
    private Timer fTimer;
    private MJScrollPane fSearchResultsPanel;
    private String fCurrentSearchString = "";
    private MouseWheelListener fScrollWheelListener;
    private SearchObserverGroup fSearchObserverGroup = new SearchObserverGroup();
    private static Color GRAY_FOREGROUND = new Color(191, 205, 219);
    private static final String resStr = "com.mathworks.mde.functionbrowser.resources.RES_FunctionBrowser";
    private static final String key = "FunctionBrowserPanel.";
    private static ResourceBundle resources = ResourceBundle.getBundle("com.mathworks.mde.functionbrowser.resources.RES_FunctionBrowser");
    static Color DEFAULT_TABLE_BACKGROUND_COLOR = new Color(240, 240, 240);

    FunctionBrowserPanel(String string) {
        super((LayoutManager)new BorderLayout(5, 0));
        this.init();
        if (string != null) {
            this.clear(string);
        }
    }

    FunctionBrowserPanel() {
        super((LayoutManager)new BorderLayout(5, 0));
        this.init();
    }

    String getDiagnostic() {
        Object object;
        String string = "LastTableRow: ";
        if (this.fTable != null && this.fTable.getRowCount() > 0 && (object = this.fTable.getRowAt(this.fTable.getRowCount() - 1).getValueAt(0)) != null && object instanceof FunctionTableModel.FunctionSearchResult) {
            string = string + ((FunctionTableModel.FunctionSearchResult)object).getTitle();
        }
        if (this.fSearchObserverGroup != null) {
            string = string + " Search thread count: " + Integer.toString(this.fSearchObserverGroup.getObserverCount());
        }
        return string;
    }

    void clear(String string) {
        this.cancelPendingSearches();
        if (string == null) {
            string = "";
        }
        if (string.length() >= 2) {
            this.fSearchBox.setSearchText(string);
        } else {
            this.fSearchBox.setSearchText("");
        }
        this.find(string);
        this.fCurrentSearchString = string;
        this.fSearchBox.getComponent().requestFocusInWindow();
    }

    void setInitialFocus() {
        this.fSearchBox.requestFocus();
    }

    private void cancelPendingSearches() {
        this.fSearchObserverGroup.cancel();
    }

    private void init() {
        if (MJUtilities.isHighContrast()) {
            GRAY_FOREGROUND = Color.black;
        }
        this.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, GRAY_FOREGROUND));
        this.fTable = new FunctionTable(new FunctionTableModel(""));
        this.fTable.setName("FunctionBrowserPanel:fTable");
        this.fSearchResultsPanel = new MJScrollPane((Component)((Object)this.fTable));
        JScrollBar jScrollBar = this.fSearchResultsPanel.getVerticalScrollBar();
        jScrollBar.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                if (adjustmentEvent.getValue() != 0) {
                    if (FunctionBrowserPanel.this.fTable.isToolTipShowing()) {
                        FunctionBrowserPanel.this.fTable.hideActionToolTip();
                    } else {
                        int n = FunctionBrowserPanel.this.fTable.getSelectedRow();
                        if (n < 0 || !SwingUtilities.isRectangleContainingRectangle(FunctionBrowserPanel.this.fTable.getVisibleRect(), FunctionBrowserPanel.this.fTable.getCellRect(n, 0, false))) {
                            FunctionBrowserPanel.this.fTable.hideActionToolTip();
                        }
                    }
                }
            }
        });
        this.fSearchResultsPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.fSearchResultsPanel.setWheelScrollingEnabled(false);
        this.fScrollWheelListener = new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                FunctionBrowserPanel.this.fSearchResultsPanel.setWheelScrollingEnabled(true);
                FunctionBrowserPanel.this.fSearchResultsPanel.removeMouseWheelListener(FunctionBrowserPanel.this.fScrollWheelListener);
                FunctionBrowserPanel.this.fTable.dispatchScrollEvent(mouseWheelEvent);
                FunctionBrowserPanel.this.fSearchResultsPanel.setWheelScrollingEnabled(false);
                FunctionBrowserPanel.this.fSearchResultsPanel.addMouseWheelListener(FunctionBrowserPanel.this.fScrollWheelListener);
            }
        };
        this.fSearchResultsPanel.addMouseWheelListener(this.fScrollWheelListener);
        this.addMouseWheelListener(this.fScrollWheelListener);
        this.fSearchBox = new SearchTextField(resources.getString("FunctionBrowserPanel.SearchMsg"));
        this.fIntelliHints = new SearchTextFieldIntelliHints(this.fSearchBox);
        this.fSearchBox.getComponent().setName("FunctionBrowserPanel:fSearchBox");
        this.fSearchBox.addSearchTextFieldListener(new SearchTextField.Listener(){
            private boolean iShouldCloseOnClear = true;

            public void search(String string) {
                this.iShouldCloseOnClear = false;
                FunctionBrowserPanel.this.fIntelliHints.hideHintsPopup();
                FunctionBrowserPanel.this.update();
            }

            public void searchCleared() {
                if (this.iShouldCloseOnClear) {
                    SwingUtilities.getWindowAncestor((Component)((Object)FunctionBrowserPanel.this)).setVisible(false);
                }
                this.iShouldCloseOnClear = true;
            }

            public void searchTextChanged(String string) {
                this.iShouldCloseOnClear = false;
                if (string == null || string.length() == 0) {
                    FunctionBrowserPanel.this.fTimer.stop();
                    FunctionBrowserPanel.this.clearPendingMessage();
                    FunctionBrowserPanel.this.update();
                    return;
                }
                if (FunctionBrowserPanel.this.fTimer.isRunning()) {
                    FunctionBrowserPanel.this.fTimer.restart();
                    return;
                }
                FunctionBrowserPanel.this.fTimer.start();
            }
        });
        this.initColors();
        MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout(5, 5));
        mJPanel.setBorder(BorderFactory.createEmptyBorder(4, 5, 4, 5));
        mJPanel.setBackground(GRAY_FOREGROUND);
        mJPanel.add((Component)this.fSearchBox.getComponent(), (Object)"Center");
        this.add((Component)mJPanel, "North");
        this.add((Component)this.fSearchResultsPanel, "Center");
        this.fTimer = new Timer(750, this);
        this.fTimer.setRepeats(false);
    }

    void selectAllSearchText() {
        this.fSearchBox.selectAllSearchText();
    }

    void update() {
        this.fTimer.stop();
        this.fCurrentSearchString = "";
        this.find(this.fSearchBox.getSearchText());
    }

    FunctionTable getFunctionTable() {
        return this.fTable;
    }

    void resetTableModel() {
        this.cancelPendingSearches();
    }

    boolean isSearchComplete() {
        return this.fTable.getFunctionTableModel() != null && this.fTable.getFunctionTableModel().isSearchComplete();
    }

    void initColors() {
        Color color;
        if (MJUtilities.isHighContrast()) {
            color = SystemColor.control.equals(Color.white) ? Color.white : Color.black;
            FunctionCellRenderer.setForegroundColor(SystemColor.textText);
        } else if (Prefs.getBooleanPref((String)"ColorsUseSystem", (boolean)true)) {
            color = DEFAULT_TABLE_BACKGROUND_COLOR;
            FunctionCellRenderer.setForegroundColor(SystemColor.textText);
        } else {
            color = ColorPrefs.getBackgroundColor();
            FunctionCellRenderer.setForegroundColor(ColorPrefs.getTextColor());
        }
        this.setBackground(color);
        this.fTable.setBackground(color);
        this.fSearchResultsPanel.setBackground(color);
        JViewport jViewport = this.fSearchResultsPanel.getViewport();
        if (jViewport != null) {
            jViewport.setBackground(color);
        }
        this.repaint();
    }

    private void makeVisible() {
        if (this.isVisible()) {
            return;
        }
        this.setVisible(true);
        this.fSearchResultsPanel.setColumnHeader(null);
        this.fTable.getColumnModel().getColumn(0).setPreferredWidth(30);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.fTimer.stop();
        String string = this.fSearchBox.getSearchText().trim();
        this.find(string);
        if (string != null && string.length() > 2) {
            this.fIntelliHints.addCurrentTextAsHint();
        }
    }

    public void find(String string) {
        assert (SwingUtilities.isEventDispatchThread());
        if (string == null) {
            return;
        }
        string = string.replaceAll("^\\**", "");
        String string2 = (string = string.replaceAll("\\**$", "")).trim();
        if (string2.length() <= 1) {
            this.emptyFindCallback();
            return;
        }
        if (this.fCurrentSearchString.equals(string2)) {
            return;
        }
        this.cancelPendingSearches();
        this.fCurrentSearchString = string2;
        this.updateCategories(string2);
        this.getFunctionSearcher(this.fCurrentSearchString).search(this.fCurrentSearchString);
    }

    private FunctionSearcher getFunctionSearcher(final String string) {
        if (!HelpPrefs.isUsingDocCenterBrowser()) {
            return new ClassicDocFunctionSearcher(this.fTable, this.fSearchObserverGroup);
        }
        return new DocCenterFunctionSearcher(new FunctionSearchObserver<FunctionTableModel.ReferenceDataResult>(){

            @Override
            public void searchComplete(Iterable<FunctionTableModel.ReferenceDataResult> iterable, SearchStringStatus searchStringStatus) {
                FunctionTableModel functionTableModel = FunctionBrowserPanel.this.fTable.getFunctionTableModel();
                functionTableModel.addResults(iterable);
                FunctionBrowserPanel.this.fTable.updateTableModel();
                FunctionBrowserPanel.this.fTable.setHighlightText(string);
                functionTableModel.clearPendingMessage();
                if (searchStringStatus == SearchStringStatus.TOO_FEW_CHARS) {
                    functionTableModel.maybeSetEmptyNoWildcardMessage();
                } else {
                    functionTableModel.maybeSetEmptyMessage();
                }
            }
        });
    }

    void clearPendingMessage() {
        this.fTable.getFunctionTableModel().clearPendingMessage();
    }

    void setPendingMessage() {
        this.fTable.getFunctionTableModel().setPendingMessage();
    }

    private void emptyFindCallback() {
        assert (SwingUtilities.isEventDispatchThread());
        this.cancelPendingSearches();
        this.fTable.getFunctionTableModel().reset("");
        this.fTable.hideActionToolTip();
        this.fTable.setHighlightText("");
        this.fCurrentSearchString = "";
    }

    private void updateCategories(String string) {
        this.cancelPendingSearches();
        this.fTable.getFunctionTableModel().reset(string);
        this.fTable.hideActionToolTip();
        this.fTable.getFunctionTableModel().setPendingMessage();
        this.fTable.setHighlightText(string);
        this.makeVisible();
    }

    void addSearchResultsToFunctionTable(SearchResults searchResults) {
        this.fTable.getFunctionTableModel().addSearchResults(searchResults);
        this.fTable.updateTableModel();
        this.fTable.setHighlightText(this.fCurrentSearchString);
        this.makeVisible();
    }
}

