/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.functionhints;

import java.util.ArrayList;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class Signature {
    private String fFunctionName;
    private String[] fCountableArgs;
    private String fOtherArgs;
    private int fMaxArgs;

    public Signature(String string, String string2, String string3) throws SignatureParseException {
        this(string2, string3);
        if (this.fCountableArgs != null && this.fCountableArgs.length > 0) {
            this.fCountableArgs[0] = string + " object";
        }
    }

    public Signature(String string, String string2) throws SignatureParseException {
        int n;
        this.fFunctionName = string;
        int n2 = string2.indexOf("(");
        int n3 = string2.lastIndexOf(")");
        String string3 = string2.substring(n2 + 1, n3);
        String[] stringArray = Signature.splitArgList(string3);
        Vector<String> vector = new Vector<String>();
        boolean bl = false;
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n] == null) {
                throw new SignatureParseException();
            }
            stringArray[n] = stringArray[n].trim();
            if (stringArray[n].length() == 0) {
                throw new SignatureParseException();
            }
            String string4 = Signature.parenReplace(stringArray[n], "x");
            if (string4.equals(".") || string4.equals("..") || string4.equals("...")) {
                bl = true;
                continue;
            }
            if (string4.matches(".*\\.\\.\\..*")) {
                string4 = string4.replaceAll("\\.\\.\\.", "").trim();
                stringArray[n] = stringArray[n].replaceAll("\\.\\.\\.", "").trim();
            }
            if (!string4.matches("\\'.*\\'") && !string4.matches("[\\@a-zA-Z0-9_]*") && !string4.equals("~") || bl) continue;
            vector.add(stringArray[n]);
        }
        if (vector.size() == stringArray.length) {
            this.fMaxArgs = stringArray.length;
            this.fCountableArgs = new String[this.fMaxArgs];
            for (n = 0; n < this.fMaxArgs; ++n) {
                this.fCountableArgs[n] = (String)vector.elementAt(n);
            }
            this.fOtherArgs = null;
        } else if (vector.size() > 0) {
            this.fMaxArgs = -1;
            this.fCountableArgs = new String[vector.size()];
            for (n = 0; n < this.fCountableArgs.length; ++n) {
                this.fCountableArgs[n] = (String)vector.elementAt(n);
            }
            this.fOtherArgs = "";
            for (n = this.fCountableArgs.length; n < stringArray.length - 1; ++n) {
                this.fOtherArgs = this.fOtherArgs + stringArray[n] + ",";
            }
            this.fOtherArgs = this.fOtherArgs + stringArray[stringArray.length - 1];
        } else {
            this.fMaxArgs = -1;
            this.fCountableArgs = null;
            this.fOtherArgs = string3;
        }
    }

    boolean areInputArgsEllipsis() {
        return this.fCountableArgs == null && "...".equals(this.fOtherArgs);
    }

    String createHTML(int n) {
        if (this.fMaxArgs >= 1 && this.fMaxArgs <= n) {
            return null;
        }
        if (this.fCountableArgs == null || this.fCountableArgs.length <= n) {
            return this.toString();
        }
        String string = this.fFunctionName + "(";
        for (int i = 0; i < this.fCountableArgs.length; ++i) {
            string = i == n ? string + "<b><font color=#3775B9>" + this.fCountableArgs[i] + "</font></b>," : string + this.fCountableArgs[i] + ",";
        }
        if (this.fOtherArgs != null) {
            string = string + this.fOtherArgs;
        }
        if (string.substring(string.length() - 1).equals(",")) {
            string = string.substring(0, string.length() - 1);
        }
        string = string + ")";
        return string;
    }

    public String toString() {
        String string = this.fFunctionName + "(";
        if (this.fCountableArgs != null && this.fCountableArgs.length >= 1) {
            for (String string2 : this.fCountableArgs) {
                string = string + string2 + ",";
            }
            if (this.fOtherArgs != null) {
                string = string + this.fOtherArgs;
            }
            if (string.substring(string.length() - 1).equals(",")) {
                string = string.substring(0, string.length() - 1);
            }
            string = string + ")";
            return string;
        }
        if (this.fOtherArgs != null) {
            string = string + this.fOtherArgs + ")";
            return string;
        }
        return "";
    }

    public static String[] splitArgList(String string) {
        String string2;
        if (string == null) {
            return new String[0];
        }
        string = string.trim();
        Pattern pattern = Pattern.compile(",");
        Matcher matcher = pattern.matcher(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (matcher.find() && (string2 = string.substring(n, matcher.start())) != null) {
            for (char c : string2.toCharArray()) {
                n2 = n2 + ('[' == c ? 1 : 0) + (']' == c ? -1 : 0);
            }
            for (char c : string2.toCharArray()) {
                n3 = n3 + ('{' == c ? 1 : 0) + ('}' == c ? -1 : 0);
            }
            if (n2 != 0 || n3 != 0) continue;
            arrayList.add(string.substring(n, matcher.start()));
            n = matcher.end();
        }
        if (n < string.length()) {
            arrayList.add(string.substring(n));
        }
        return arrayList.toArray(new String[]{""});
    }

    private static String parenReplace(String string, String string2) {
        String string3 = string.replaceAll("\\(.*\\)", string2);
        string3 = string3.replaceAll("\\[.*\\]", string2);
        string3 = string3.replaceAll("\\{.*\\}", string2);
        return string3;
    }

    static class SignatureParseException
    extends Exception {
    }
}

