/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.help;

import com.mathworks.help.helpui.DocLocation;
import com.mathworks.mde.help.DocCenterSettingListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.Validate;

class DocCenterSettingChangedEventDispatcher {
    private static DocCenterSettingChangedEventDispatcher sInstance = new DocCenterSettingChangedEventDispatcher();
    private Set<DocCenterSettingListener> fDocCenterSettingListeners = Collections.synchronizedSet(new HashSet());

    private DocCenterSettingChangedEventDispatcher() {
    }

    static DocCenterSettingChangedEventDispatcher getInstance() {
        return sInstance;
    }

    void addDocCenterSettingListener(DocCenterSettingListener docCenterSettingListener) {
        Validate.notNull((Object)docCenterSettingListener, (String)"Doc Center Seting Listeners may not be null.");
        this.fDocCenterSettingListeners.add(docCenterSettingListener);
    }

    void removeDocCenterSettingListener(DocCenterSettingListener docCenterSettingListener) {
        if (docCenterSettingListener != null) {
            this.fDocCenterSettingListeners.remove(docCenterSettingListener);
        }
    }

    void docCenterShowUninstalledProductsChanged(boolean bl) {
        DocCenterSettingChangedEvent docCenterSettingChangedEvent = bl ? DocCenterSettingChangedEvent.SHOW_UNINSTALLED_PRODUCTS_TRUE : DocCenterSettingChangedEvent.SHOW_UNINSTALLED_PRODUCTS_FALSE;
        this.dispatchDocCenterSettingChangedEvent(docCenterSettingChangedEvent);
    }

    void docCenterLocationChanged(String string) {
        if (string == null) {
            return;
        }
        this.docCenterLocationChanged(this.getDocLocation(string));
    }

    private DocLocation getDocLocation(String string) {
        try {
            return DocLocation.valueOf((String)string.toUpperCase(Locale.ENGLISH));
        }
        catch (Exception exception) {
            return null;
        }
    }

    void docCenterLocationChanged(DocLocation docLocation) {
        if (docLocation == null) {
            return;
        }
        switch (docLocation) {
            case WEB: {
                DocCenterSettingChangedEvent docCenterSettingChangedEvent = DocCenterSettingChangedEvent.LOCATION_WEB;
                this.dispatchDocCenterSettingChangedEvent(docCenterSettingChangedEvent);
                break;
            }
            case INSTALLED: {
                DocCenterSettingChangedEvent docCenterSettingChangedEvent = DocCenterSettingChangedEvent.LOCATION_INSTALLED;
                this.dispatchDocCenterSettingChangedEvent(docCenterSettingChangedEvent);
            }
        }
    }

    private void dispatchDocCenterSettingChangedEvent(final DocCenterSettingChangedEvent docCenterSettingChangedEvent) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ArrayList arrayList = new ArrayList(DocCenterSettingChangedEventDispatcher.this.fDocCenterSettingListeners);
                for (DocCenterSettingListener docCenterSettingListener : arrayList) {
                    docCenterSettingListener.docCenterSettingChanged(docCenterSettingChangedEvent);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    static enum DocCenterSettingChangedEvent {
        LOCATION_WEB,
        LOCATION_INSTALLED,
        SHOW_UNINSTALLED_PRODUCTS_TRUE,
        SHOW_UNINSTALLED_PRODUCTS_FALSE;

    }
}

