/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.licensing.borrowing;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.jmi.Support;
import com.mathworks.mde.licensing.borrowing.controller.BorrowController;
import com.mathworks.mde.licensing.borrowing.controller.BorrowControllerImpl;
import com.mathworks.mde.licensing.borrowing.model.BorrowManager;
import com.mathworks.mde.licensing.borrowing.model.BorrowManagerImpl;
import com.mathworks.mde.licensing.borrowing.view.ViewFactoryImpl;
import com.mathworks.services.Prefs;
import javax.swing.JPanel;

public class BorrowUI {
    private static final String BASE_KEY = "com.mathworks.mde.licensing.borrowing.BorrowUI";
    private static final String ENABLE_KEY = "com.mathworks.mde.licensing.borrowing.BorrowUI.enabled";
    private static boolean sPrefEnabled = Prefs.getBooleanPref((String)"com.mathworks.mde.licensing.borrowing.BorrowUI.enabled", (boolean)false);
    private BorrowController mc;
    private BorrowManager fBorrowMgr = new BorrowManagerImpl(Matlab.matlabRoot(), Support.arch());
    private JPanel fStatusPanel = null;

    private BorrowUI() {
    }

    public static BorrowUI getInstance() {
        return LazyHolder.instance;
    }

    private static boolean checkMatlabMode() {
        boolean bl = Matlab.isMatlabAvailable() && Matlab.isCommercialMode();
        return bl;
    }

    public static synchronized void enableFeature(boolean bl) {
        boolean bl2 = BorrowUI.checkMatlabMode();
        if (!bl2) {
            return;
        }
        Prefs.setBooleanPref((String)ENABLE_KEY, (boolean)bl);
    }

    public synchronized boolean isBorrowingEnabled() {
        return sPrefEnabled;
    }

    public synchronized void addStatus(JPanel jPanel) {
        this.fStatusPanel = jPanel;
        if (this.mc != null) {
            this.mc.setStatusPanel(this.fStatusPanel);
        }
    }

    public synchronized void showGUI() {
        MatlabWorker matlabWorker = new MatlabWorker(){

            public Object runOnMatlabThread() throws Exception {
                return BorrowUI.this.isBorrowingEnabled();
            }

            public void runOnAWTEventDispatchThread(Object object) {
                boolean bl = (Boolean)object;
                if (bl) {
                    if (BorrowUI.this.mc == null) {
                        ViewFactoryImpl viewFactoryImpl = new ViewFactoryImpl();
                        BorrowUI.this.mc = new BorrowControllerImpl(viewFactoryImpl, BorrowUI.this.fBorrowMgr);
                        BorrowUI.this.mc.setStatusPanel(BorrowUI.this.fStatusPanel);
                    }
                    BorrowUI.this.mc.showUI();
                }
            }
        };
        matlabWorker.start();
    }

    private static class LazyHolder {
        static final BorrowUI instance = new BorrowUI();

        private LazyHolder() {
        }
    }
}

