/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.licensing.borrowing.model;

import com.mathworks.mde.licensing.borrowing.model.Feature;
import com.mathworks.mde.licensing.borrowing.model.FeatureStatus;
import com.mathworks.product.util.ProductIdentifier;
import com.mathworks.services.lmgr.FeatureData;

public class FeatureImpl
implements Feature {
    private FeatureData featureDataRef;
    private String fProductName = null;
    private Integer fProductBitnum;

    public FeatureImpl(FeatureData featureData) {
        this.featureDataRef = featureData;
        String string = this.featureDataRef.getFeatureName();
        this.fProductName = this.getFlexProductName(string);
        this.fProductBitnum = this.getProductBitnum(string);
    }

    @Override
    public String getCurrentFeatureStatus() {
        FeatureStatus featureStatus = FeatureStatus.getFeatureStatus(this.featureDataRef.getFeatureStatus());
        return featureStatus.toString();
    }

    @Override
    public boolean isLicenseInUse() {
        return this.featureDataRef.getFeatureInuse();
    }

    @Override
    public boolean isBorrowed() {
        FeatureStatus featureStatus = FeatureStatus.getFeatureStatus(this.featureDataRef.getFeatureStatus());
        return featureStatus == FeatureStatus.BORROWED;
    }

    @Override
    public String getReturnDate() {
        return this.featureDataRef.getReturnDate();
    }

    @Override
    public String getFeatureName() {
        return this.featureDataRef.getFeatureName();
    }

    @Override
    public String getProductName() {
        return this.fProductName;
    }

    @Override
    public boolean canBorrow() {
        FeatureStatus featureStatus = FeatureStatus.getFeatureStatus(this.featureDataRef.getFeatureStatus());
        return featureStatus == FeatureStatus.BORROW_ENABLED || featureStatus == FeatureStatus.BORROW_FAILED;
    }

    @Override
    public boolean canReturn() {
        FeatureStatus featureStatus = FeatureStatus.getFeatureStatus(this.featureDataRef.getFeatureStatus());
        return featureStatus == FeatureStatus.BORROWED || featureStatus == FeatureStatus.RETURN_FAILED;
    }

    @Override
    public boolean isFeatureBorrowDisabled() {
        FeatureStatus featureStatus = FeatureStatus.getFeatureStatus(this.featureDataRef.getFeatureStatus());
        return featureStatus == FeatureStatus.BORROW_DISABLED;
    }

    @Override
    public Integer getBitnumber() {
        return this.fProductBitnum;
    }

    private String getFlexProductName(String string) {
        ProductIdentifier productIdentifier = ProductIdentifier.get((String)string);
        if (productIdentifier != null) {
            return productIdentifier.getName();
        }
        return string;
    }

    private Integer getProductBitnum(String string) {
        ProductIdentifier productIdentifier = ProductIdentifier.get((String)string);
        if (productIdentifier != null) {
            return productIdentifier.getBitNum();
        }
        return null;
    }
}

