/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.CheckBoxListCellRenderer;
import com.jidesoft.swing.DefaultSelectable;
import com.jidesoft.swing.Selectable;
import java.awt.ItemSelectable;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.text.Position;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckBoxListWithSelectable
extends JList
implements ItemSelectable {
    protected CheckBoxListCellRenderer _listCellRenderer;
    public static final String PROPERTY_CHECKBOX_ENABLED = "checkBoxEnabled";
    public static final String PROPERTY_CLICK_IN_CHECKBOX_ONLY = "clickInCheckBoxOnly";
    private boolean _checkBoxEnabled = true;
    private boolean _clickInCheckBoxOnly = true;

    public CheckBoxListWithSelectable() {
        this.init();
    }

    public CheckBoxListWithSelectable(Vector<?> vector) {
        super(CheckBoxListWithSelectable.wrap(vector));
        this.init();
    }

    public CheckBoxListWithSelectable(Object[] objectArray) {
        super(CheckBoxListWithSelectable.wrap(objectArray));
        this.init();
    }

    public CheckBoxListWithSelectable(ListModel listModel) {
        super(CheckBoxListWithSelectable.wrap(listModel));
        this.init();
    }

    protected void init() {
        this.setSelectionMode(2);
        this._listCellRenderer = this.createCellRenderer();
        Handler handler = this.createHandler();
        this.addMouseListener(handler);
        this.addKeyListener(handler);
    }

    protected CheckBoxListCellRenderer createCellRenderer() {
        return new CheckBoxListCellRenderer();
    }

    protected Handler createHandler() {
        return new Handler(this);
    }

    public void setSelectedObjects(Object[] objectArray) {
        HashMap<Object, String> hashMap = new HashMap<Object, String>();
        for (Object object : objectArray) {
            hashMap.put(object, "");
        }
        this.setSelectedObjects(hashMap);
    }

    public void setSelectedObjects(Vector<?> vector) {
        HashMap<Object, String> hashMap = new HashMap<Object, String>();
        for (Object obj : vector) {
            hashMap.put(obj, "");
        }
        this.setSelectedObjects(hashMap);
    }

    public ListCellRenderer getCellRenderer() {
        if (this._listCellRenderer != null) {
            this._listCellRenderer.setActualListRenderer(super.getCellRenderer());
            return this._listCellRenderer;
        }
        return super.getCellRenderer();
    }

    public ListCellRenderer getActualCellRenderer() {
        if (this._listCellRenderer != null) {
            return this._listCellRenderer.getActualListRenderer();
        }
        return super.getCellRenderer();
    }

    private void setSelectedObjects(Map<Object, String> map) {
        for (int i = 0; i < this.getModel().getSize(); ++i) {
            Object object = this.getModel().getElementAt(i);
            if (!(object instanceof Selectable)) continue;
            Selectable selectable = (Selectable)object;
            if (selectable instanceof DefaultSelectable) {
                object = ((DefaultSelectable)selectable).getObject();
            }
            if (map.get(object) != null) {
                selectable.setSelected(true);
                this.fireItemStateChanged(new ItemEvent(this, 701, selectable, 1));
                map.remove(object);
                if (map.size() != 0) continue;
                break;
            }
            if (!selectable.isSelected()) continue;
            selectable.setSelected(false);
            this.fireItemStateChanged(new ItemEvent(this, 701, selectable, 2));
        }
        this.repaint();
    }

    private static ListModel wrap(ListModel listModel) {
        for (int i = 0; i < listModel.getSize(); ++i) {
            if (listModel.getElementAt(i) instanceof Selectable) continue;
            throw new IllegalArgumentException("The ListModel contains an element which is not an instance of Selectable at index " + i + ".");
        }
        return listModel;
    }

    private static Selectable[] wrap(Object[] objectArray) {
        if (objectArray instanceof Selectable[]) {
            return (Selectable[])objectArray;
        }
        Selectable[] selectableArray = new Selectable[objectArray.length];
        for (int i = 0; i < selectableArray.length; ++i) {
            selectableArray[i] = new DefaultSelectable(objectArray[i]);
        }
        return selectableArray;
    }

    private static Vector<?> wrap(Vector<?> vector) {
        Vector<Selectable> vector2 = new Vector<Selectable>();
        for (Object obj : vector) {
            if (obj instanceof Selectable) {
                vector2.add((Selectable)obj);
                continue;
            }
            vector2.add(new DefaultSelectable(obj));
        }
        return vector2;
    }

    public boolean isClickInCheckBoxOnly() {
        return this._clickInCheckBoxOnly;
    }

    public void setClickInCheckBoxOnly(boolean bl) {
        if (bl != this._clickInCheckBoxOnly) {
            boolean bl2 = this._clickInCheckBoxOnly;
            this._clickInCheckBoxOnly = bl;
            this.firePropertyChange(PROPERTY_CLICK_IN_CHECKBOX_ONLY, bl2, this._clickInCheckBoxOnly);
        }
    }

    @Override
    public void addItemListener(ItemListener itemListener) {
        this.listenerList.add(ItemListener.class, itemListener);
    }

    @Override
    public void removeItemListener(ItemListener itemListener) {
        this.listenerList.remove(ItemListener.class, itemListener);
    }

    public ItemListener[] getItemListeners() {
        return (ItemListener[])this.listenerList.getListeners(ItemListener.class);
    }

    protected void fireItemStateChanged(ItemEvent itemEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        ItemEvent itemEvent2 = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ItemListener.class) continue;
            if (itemEvent2 == null) {
                itemEvent2 = new ItemEvent(this, 701, itemEvent.getItem(), itemEvent.getStateChange());
            }
            ((ItemListener)objectArray[i + 1]).itemStateChanged(itemEvent2);
        }
    }

    @Override
    public Object[] getSelectedObjects() {
        Vector<Object> vector = new Vector<Object>();
        for (int i = 0; i < this.getModel().getSize(); ++i) {
            Selectable selectable;
            Object e = this.getModel().getElementAt(i);
            if (!(e instanceof Selectable) || !(selectable = (Selectable)e).isSelected()) continue;
            if (selectable instanceof DefaultSelectable) {
                vector.add(((DefaultSelectable)selectable).getObject());
                continue;
            }
            vector.add(selectable);
        }
        return vector.toArray();
    }

    public void selectAll() {
        for (int i = 0; i < this.getModel().getSize(); ++i) {
            Selectable selectable;
            Object e = this.getModel().getElementAt(i);
            if (!(e instanceof Selectable) || !(selectable = (Selectable)e).isEnabled() || selectable.isSelected()) continue;
            selectable.setSelected(true);
            this.fireItemStateChanged(new ItemEvent(this, 701, selectable, 1));
        }
        this.repaint();
    }

    public void selectNone() {
        for (int i = 0; i < this.getModel().getSize(); ++i) {
            Selectable selectable;
            Object e = this.getModel().getElementAt(i);
            if (!(e instanceof Selectable) || !(selectable = (Selectable)e).isEnabled() || !selectable.isSelected()) continue;
            selectable.setSelected(false);
            this.fireItemStateChanged(new ItemEvent(this, 701, selectable, 2));
        }
        this.repaint();
    }

    public void setListData(Vector vector) {
        super.setListData(CheckBoxListWithSelectable.wrap(vector));
    }

    public void setListData(Object[] objectArray) {
        super.setListData(CheckBoxListWithSelectable.wrap(objectArray));
    }

    @Override
    public int getNextMatch(String string, int n, Position.Bias bias) {
        return -1;
    }

    public boolean isCheckBoxEnabled() {
        return this._checkBoxEnabled;
    }

    public boolean isCheckBoxVisible(int n) {
        return true;
    }

    public void setCheckBoxEnabled(boolean bl) {
        if (bl != this._checkBoxEnabled) {
            Boolean bl2 = this._checkBoxEnabled ? Boolean.TRUE : Boolean.FALSE;
            Boolean bl3 = bl ? Boolean.TRUE : Boolean.FALSE;
            this._checkBoxEnabled = bl;
            this.firePropertyChange(PROPERTY_CHECKBOX_ENABLED, bl2, bl3);
            this.repaint();
        }
    }

    protected static class Handler
    implements MouseListener,
    KeyListener {
        protected CheckBoxListWithSelectable _list;
        int _hotspot;

        public Handler(CheckBoxListWithSelectable checkBoxListWithSelectable) {
            this._hotspot = new JCheckBox().getPreferredSize().width;
            this._list = checkBoxListWithSelectable;
        }

        protected boolean clicksInCheckBox(MouseEvent mouseEvent) {
            int n = this._list.locationToIndex(mouseEvent.getPoint());
            Rectangle rectangle = this._list.getCellBounds(n, n);
            if (rectangle != null) {
                if (this._list.getComponentOrientation().isLeftToRight()) {
                    return mouseEvent.getX() < rectangle.x + this._hotspot;
                }
                return mouseEvent.getX() > rectangle.x + rectangle.width - this._hotspot;
            }
            return false;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!this._list.isCheckBoxEnabled() || !this._list.isEnabled()) {
                return;
            }
            if (!this._list.isClickInCheckBoxOnly() || this.clicksInCheckBox(mouseEvent)) {
                int n = this._list.locationToIndex(mouseEvent.getPoint());
                this.toggleSelection(n);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (!this._list.isCheckBoxEnabled() || !this._list.isEnabled()) {
                return;
            }
            if (keyEvent.getModifiers() == 0 && keyEvent.getKeyChar() == ' ') {
                this.toggleSelections();
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        protected void toggleSelections() {
            int[] nArray = this._list.getSelectedIndices();
            ListModel listModel = this._list.getModel();
            for (int n : nArray) {
                Object e = listModel.getElementAt(n);
                if (!(e instanceof Selectable) || !((Selectable)e).isEnabled()) continue;
                ((Selectable)e).invertSelected();
                boolean bl = ((Selectable)e).isSelected();
                this._list.fireItemStateChanged(new ItemEvent(this._list, 701, e, bl ? 1 : 2));
            }
            this._list.repaint();
        }

        protected void toggleSelection(int n) {
            ListModel listModel = this._list.getModel();
            if (n >= 0) {
                Object e = listModel.getElementAt(n);
                if (e instanceof Selectable && ((Selectable)e).isEnabled()) {
                    ((Selectable)e).invertSelected();
                    boolean bl = ((Selectable)e).isSelected();
                    this._list.fireItemStateChanged(new ItemEvent(this._list, 701, e, bl ? 1 : 2));
                }
                this._list.repaint();
            }
        }

        protected void toggleSelection() {
            int n = this._list.getSelectedIndex();
            this.toggleSelection(n);
        }
    }
}

