/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.discovery;

import com.sun.jini.collection.SoftCache;
import com.sun.jini.discovery.ClientSubjectChecker;
import com.sun.jini.discovery.DatagramBufferFactory;
import com.sun.jini.discovery.Discovery;
import com.sun.jini.discovery.DiscoveryFormatProvider;
import com.sun.jini.discovery.DiscoveryProtocolException;
import com.sun.jini.discovery.EncodeIterator;
import com.sun.jini.discovery.MulticastAnnouncement;
import com.sun.jini.discovery.MulticastAnnouncementDecoder;
import com.sun.jini.discovery.MulticastAnnouncementEncoder;
import com.sun.jini.discovery.MulticastRequest;
import com.sun.jini.discovery.MulticastRequestDecoder;
import com.sun.jini.discovery.MulticastRequestEncoder;
import com.sun.jini.discovery.UnicastDiscoveryClient;
import com.sun.jini.discovery.UnicastDiscoveryServer;
import com.sun.jini.discovery.UnicastResponse;
import com.sun.jini.logging.Levels;
import com.sun.jini.resource.Service;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.discovery.Constants;
import net.jini.io.UnsupportedConstraintException;

class DiscoveryV2
extends Discovery {
    private static final byte MULTICAST_ANNOUNCEMENT = 0;
    private static final byte MULTICAST_REQUEST = 1;
    private static final long NULL_FORMAT_ID = 0L;
    private static final int FORMAT_ID_LEN = 8;
    private static final int MULTICAST_HEADER_LEN = 13;
    private static final int UNICAST_REQUEST_HEADER_LEN = 6;
    private static final int UNICAST_RESPONSE_HEADER_LEN = 12;
    private static final int MULTICAST_REQUEST_ENCODER = 0;
    private static final int MULTICAST_REQUEST_DECODER = 1;
    private static final int MULTICAST_ANNOUNCEMENT_ENCODER = 2;
    private static final int MULTICAST_ANNOUNCEMENT_DECODER = 3;
    private static final int UNICAST_DISCOVERY_CLIENT = 4;
    private static final int UNICAST_DISCOVERY_SERVER = 5;
    private static final int NUM_PROVIDER_TYPES = 6;
    private static final Class[] providerTypes;
    private static final SoftCache instances;
    private static final Logger logger;
    private final Map[] formatIdMaps = new Map[6];
    static /* synthetic */ Class class$com$sun$jini$discovery$DiscoveryFormatProvider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DiscoveryV2 getInstance(ClassLoader classLoader) {
        DiscoveryV2 discoveryV2;
        if (classLoader == null) {
            classLoader = DiscoveryV2.getContextClassLoader();
        }
        IdentityKey identityKey = new IdentityKey(classLoader);
        SoftCache softCache = instances;
        synchronized (softCache) {
            discoveryV2 = (DiscoveryV2)instances.get(identityKey);
        }
        if (discoveryV2 == null) {
            discoveryV2 = new DiscoveryV2(DiscoveryV2.getProviders(classLoader));
            softCache = instances;
            synchronized (softCache) {
                instances.put(identityKey, discoveryV2);
            }
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "returning {0}", new Object[]{discoveryV2});
        }
        return discoveryV2;
    }

    static DiscoveryV2 getInstance(MulticastRequestEncoder[] multicastRequestEncoderArray, MulticastRequestDecoder[] multicastRequestDecoderArray, MulticastAnnouncementEncoder[] multicastAnnouncementEncoderArray, MulticastAnnouncementDecoder[] multicastAnnouncementDecoderArray, UnicastDiscoveryClient[] unicastDiscoveryClientArray, UnicastDiscoveryServer[] unicastDiscoveryServerArray) {
        List[] listArray = new List[]{DiscoveryV2.asList(multicastRequestEncoderArray), DiscoveryV2.asList(multicastRequestDecoderArray), DiscoveryV2.asList(multicastAnnouncementEncoderArray), DiscoveryV2.asList(multicastAnnouncementDecoderArray), DiscoveryV2.asList(unicastDiscoveryClientArray), DiscoveryV2.asList(unicastDiscoveryServerArray)};
        DiscoveryV2 discoveryV2 = new DiscoveryV2(listArray);
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "returning {0}", new Object[]{discoveryV2});
        }
        return discoveryV2;
    }

    private DiscoveryV2(List[] listArray) {
        for (int i = 0; i < this.formatIdMaps.length; ++i) {
            this.formatIdMaps[i] = DiscoveryV2.makeFormatIdMap(listArray[i]);
        }
    }

    public EncodeIterator encodeMulticastRequest(final MulticastRequest multicastRequest, final int n, InvocationConstraints invocationConstraints) {
        if (n < 512) {
            throw new IllegalArgumentException("maxPacketSize too small");
        }
        final InvocationConstraints invocationConstraints2 = invocationConstraints != null ? invocationConstraints.makeAbsolute() : null;
        return new EncodeIterator(){
            private final Iterator entries;
            {
                this.entries = DiscoveryV2.this.formatIdMaps[0].entrySet().iterator();
            }

            public DatagramPacket[] next() throws IOException {
                Map.Entry entry = (Map.Entry)this.entries.next();
                long l = (Long)entry.getKey();
                MulticastRequestEncoder multicastRequestEncoder = (MulticastRequestEncoder)entry.getValue();
                DatagramBuffers datagramBuffers = new DatagramBuffers(Constants.getRequestAddress(), n, 1, l);
                multicastRequestEncoder.encodeMulticastRequest(multicastRequest, datagramBuffers, invocationConstraints2);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "encoded {0} using {1}, {2}", new Object[]{multicastRequest, multicastRequestEncoder, invocationConstraints2});
                }
                return datagramBuffers.getDatagrams();
            }

            public boolean hasNext() {
                return this.entries.hasNext();
            }
        };
    }

    public MulticastRequest decodeMulticastRequest(DatagramPacket datagramPacket, InvocationConstraints invocationConstraints, ClientSubjectChecker clientSubjectChecker) throws IOException {
        ByteBuffer byteBuffer;
        if (invocationConstraints != null) {
            invocationConstraints = invocationConstraints.makeAbsolute();
        }
        if ((byteBuffer = ByteBuffer.wrap(datagramPacket.getData(), datagramPacket.getOffset(), datagramPacket.getLength())).remaining() < 13) {
            throw new DiscoveryProtocolException("incomplete header");
        }
        int n = byteBuffer.getInt();
        if (n != 2) {
            throw new DiscoveryProtocolException("wrong protocol version: " + n);
        }
        byte by = byteBuffer.get();
        if (by != 1) {
            throw new DiscoveryProtocolException("wrong packet type: " + by);
        }
        long l = byteBuffer.getLong();
        MulticastRequestDecoder multicastRequestDecoder = (MulticastRequestDecoder)this.formatIdMaps[1].get(new Long(l));
        if (multicastRequestDecoder == null) {
            throw new DiscoveryProtocolException("unsupported format ID: " + l);
        }
        MulticastRequest multicastRequest = multicastRequestDecoder.decodeMulticastRequest(byteBuffer, invocationConstraints, clientSubjectChecker);
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "decoded {0} using {1}, {2}, {3}", new Object[]{multicastRequest, multicastRequestDecoder, invocationConstraints, clientSubjectChecker});
        }
        return multicastRequest;
    }

    public EncodeIterator encodeMulticastAnnouncement(final MulticastAnnouncement multicastAnnouncement, final int n, InvocationConstraints invocationConstraints) {
        if (n < 512) {
            throw new IllegalArgumentException("maxPacketSize too small");
        }
        final InvocationConstraints invocationConstraints2 = invocationConstraints != null ? invocationConstraints.makeAbsolute() : null;
        return new EncodeIterator(){
            private final Iterator entries;
            {
                this.entries = DiscoveryV2.this.formatIdMaps[2].entrySet().iterator();
            }

            public DatagramPacket[] next() throws IOException {
                Map.Entry entry = (Map.Entry)this.entries.next();
                long l = (Long)entry.getKey();
                MulticastAnnouncementEncoder multicastAnnouncementEncoder = (MulticastAnnouncementEncoder)entry.getValue();
                DatagramBuffers datagramBuffers = new DatagramBuffers(Constants.getAnnouncementAddress(), n, 0, l);
                multicastAnnouncementEncoder.encodeMulticastAnnouncement(multicastAnnouncement, datagramBuffers, invocationConstraints2);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "encoded {0} using {1}, {2}", new Object[]{multicastAnnouncement, multicastAnnouncementEncoder, invocationConstraints2});
                }
                return datagramBuffers.getDatagrams();
            }

            public boolean hasNext() {
                return this.entries.hasNext();
            }
        };
    }

    public MulticastAnnouncement decodeMulticastAnnouncement(DatagramPacket datagramPacket, InvocationConstraints invocationConstraints) throws IOException {
        ByteBuffer byteBuffer;
        if (invocationConstraints != null) {
            invocationConstraints = invocationConstraints.makeAbsolute();
        }
        if ((byteBuffer = ByteBuffer.wrap(datagramPacket.getData(), datagramPacket.getOffset(), datagramPacket.getLength())).remaining() < 13) {
            throw new DiscoveryProtocolException("incomplete header");
        }
        int n = byteBuffer.getInt();
        if (n != 2) {
            throw new DiscoveryProtocolException("wrong protocol version: " + n);
        }
        byte by = byteBuffer.get();
        if (by != 0) {
            throw new DiscoveryProtocolException("wrong packet type: " + by);
        }
        long l = byteBuffer.getLong();
        MulticastAnnouncementDecoder multicastAnnouncementDecoder = (MulticastAnnouncementDecoder)this.formatIdMaps[3].get(new Long(l));
        if (multicastAnnouncementDecoder == null) {
            throw new DiscoveryProtocolException("unsupported format ID: " + l);
        }
        MulticastAnnouncement multicastAnnouncement = multicastAnnouncementDecoder.decodeMulticastAnnouncement(byteBuffer, invocationConstraints);
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "decoded {0} using {1}, {2}", new Object[]{multicastAnnouncement, multicastAnnouncementDecoder, invocationConstraints});
        }
        return multicastAnnouncement;
    }

    public UnicastResponse doUnicastDiscovery(Socket socket, InvocationConstraints invocationConstraints, ClassLoader classLoader, ClassLoader classLoader2, Collection collection) throws IOException, ClassNotFoundException {
        Object object;
        Object object2;
        if (invocationConstraints != null) {
            invocationConstraints = invocationConstraints.makeAbsolute();
        }
        Map map = this.formatIdMaps[4];
        HashSet hashSet = new HashSet();
        Exception exception = null;
        Object object3 = map.entrySet().iterator();
        while (object3.hasNext()) {
            object2 = object3.next();
            object = (UnicastDiscoveryClient)object2.getValue();
            try {
                object.checkUnicastDiscoveryConstraints(invocationConstraints);
                hashSet.add(object2.getKey());
                if (hashSet.size() != 65535) continue;
                logger.log(Level.WARNING, "truncating format ID list");
                break;
            }
            catch (Exception exception2) {
                if (exception2 instanceof UnsupportedConstraintException || exception2 instanceof SecurityException) {
                    exception = exception2;
                    logger.log(Levels.HANDLED, "constraint check failed", exception2);
                    continue;
                }
                throw (RuntimeException)exception2;
            }
        }
        if (hashSet.isEmpty()) {
            if (exception == null) {
                throw new DiscoveryProtocolException("no supported formats");
            }
            if (exception instanceof UnsupportedConstraintException) {
                throw (UnsupportedConstraintException)exception;
            }
            throw (SecurityException)exception;
        }
        object3 = ByteBuffer.allocate(6 + 8 * hashSet.size());
        ((ByteBuffer)object3).putInt(2);
        ((ByteBuffer)object3).putShort((short)hashSet.size());
        object2 = hashSet.iterator();
        while (object2.hasNext()) {
            ((ByteBuffer)object3).putLong((Long)object2.next());
        }
        object2 = socket.getOutputStream();
        ((OutputStream)object2).write(((ByteBuffer)object3).array(), ((ByteBuffer)object3).arrayOffset(), ((Buffer)object3).position());
        ((OutputStream)object2).flush();
        object = ByteBuffer.allocate(12);
        new DataInputStream(socket.getInputStream()).readFully(((ByteBuffer)object).array(), ((ByteBuffer)object).arrayOffset() + ((Buffer)object).position(), ((Buffer)object).remaining());
        int n = ((ByteBuffer)object).getInt();
        if (n != 2) {
            throw new DiscoveryProtocolException("wrong protocol version: " + n);
        }
        Long l = new Long(((ByteBuffer)object).getLong());
        if (l == 0L) {
            throw new DiscoveryProtocolException("format negotiation failed");
        }
        if (!hashSet.contains(l)) {
            throw new DiscoveryProtocolException("response format ID not proposed: " + l);
        }
        UnicastDiscoveryClient unicastDiscoveryClient = (UnicastDiscoveryClient)map.get(l);
        UnicastResponse unicastResponse = unicastDiscoveryClient.doUnicastDiscovery(socket, invocationConstraints, classLoader, classLoader2, collection, (ByteBuffer)((ByteBuffer)object3).flip(), (ByteBuffer)((ByteBuffer)object).flip());
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "received {0} using {1}, {2}", new Object[]{unicastResponse, unicastDiscoveryClient, invocationConstraints});
        }
        return unicastResponse;
    }

    public void handleUnicastDiscovery(UnicastResponse unicastResponse, Socket socket, InvocationConstraints invocationConstraints, ClientSubjectChecker clientSubjectChecker, Collection collection) throws IOException {
        Object object;
        DataInputStream dataInputStream;
        int n;
        if (invocationConstraints != null) {
            invocationConstraints = invocationConstraints.makeAbsolute();
        }
        if ((n = (dataInputStream = new DataInputStream(socket.getInputStream())).readUnsignedShort()) < 0) {
            throw new DiscoveryProtocolException("invalid format ID count: " + n);
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(6 + 8 * n);
        byteBuffer.putInt(2);
        byteBuffer.putShort((short)n);
        dataInputStream.readFully(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
        Object object2 = null;
        long l = 0L;
        Map map = this.formatIdMaps[5];
        while (byteBuffer.hasRemaining()) {
            l = byteBuffer.getLong();
            object = (UnicastDiscoveryServer)map.get(new Long(l));
            if (object == null) continue;
            try {
                object.checkUnicastDiscoveryConstraints(invocationConstraints);
                object2 = object;
                break;
            }
            catch (Exception exception) {
                logger.log(Levels.HANDLED, "constraint check failed", exception);
            }
        }
        object = ByteBuffer.allocate(12);
        ((ByteBuffer)object).putInt(2);
        ((ByteBuffer)object).putLong(object2 != null ? l : 0L);
        OutputStream outputStream = socket.getOutputStream();
        outputStream.write(((ByteBuffer)object).array(), ((ByteBuffer)object).arrayOffset(), ((Buffer)object).position());
        outputStream.flush();
        if (object2 == null) {
            throw new DiscoveryProtocolException("format negotiation failed");
        }
        object2.handleUnicastDiscovery(unicastResponse, socket, invocationConstraints, clientSubjectChecker, collection, (ByteBuffer)byteBuffer.flip(), (ByteBuffer)((ByteBuffer)object).flip());
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "sent {0} using {1}, {2}, {3}", new Object[]{unicastResponse, object2, invocationConstraints, clientSubjectChecker});
        }
    }

    public String toString() {
        ArrayList arrayList = new ArrayList(6);
        for (int i = 0; i < 6; ++i) {
            arrayList.add(this.formatIdMaps[i].values());
        }
        return "DiscoveryV2" + arrayList;
    }

    private static ClassLoader getContextClassLoader() {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    private static List[] getProviders(final ClassLoader classLoader) {
        return (List[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                List[] listArray = new List[6];
                for (int i = 0; i < listArray.length; ++i) {
                    listArray[i] = new ArrayList();
                }
                Iterator iterator = Service.providers(class$com$sun$jini$discovery$DiscoveryFormatProvider == null ? (class$com$sun$jini$discovery$DiscoveryFormatProvider = DiscoveryV2.class$("com.sun.jini.discovery.DiscoveryFormatProvider")) : class$com$sun$jini$discovery$DiscoveryFormatProvider, classLoader);
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    boolean bl = false;
                    for (int i = 0; i < providerTypes.length; ++i) {
                        if (!providerTypes[i].isInstance(e)) continue;
                        listArray[i].add(e);
                        bl = true;
                    }
                    if (bl) continue;
                    logger.log(Level.WARNING, "unusable format provider {0}", new Object[]{e});
                }
                return listArray;
            }
        });
    }

    private static Map makeFormatIdMap(List list) {
        HashMap<Long, DiscoveryFormatProvider> hashMap = new HashMap<Long, DiscoveryFormatProvider>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            DiscoveryFormatProvider discoveryFormatProvider = (DiscoveryFormatProvider)iterator.next();
            Long l = new Long(DiscoveryV2.computeFormatID(discoveryFormatProvider.getFormatName()));
            if (hashMap.keySet().contains(l)) {
                logger.log(Level.WARNING, "ignoring provider {0} ({1}) with conflicting format ID {2}", new Object[]{discoveryFormatProvider, discoveryFormatProvider.getFormatName(), l});
                continue;
            }
            hashMap.put(l, discoveryFormatProvider);
        }
        return hashMap;
    }

    private static long computeFormatID(String string) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            byte[] byArray = messageDigest.digest(string.getBytes("UTF-8"));
            return (((long)byArray[7] & 0xFFL) << 0) + (((long)byArray[6] & 0xFFL) << 8) + (((long)byArray[5] & 0xFFL) << 16) + (((long)byArray[4] & 0xFFL) << 24) + (((long)byArray[3] & 0xFFL) << 32) + (((long)byArray[2] & 0xFFL) << 40) + (((long)byArray[1] & 0xFFL) << 48) + (((long)byArray[0] & 0xFFL) << 56);
        }
        catch (Exception exception) {
            throw new AssertionError((Object)exception);
        }
    }

    private static List asList(Object[] objectArray) {
        return objectArray != null ? Arrays.asList(objectArray) : Collections.EMPTY_LIST;
    }

    static {
        Class[] classArray = new Class[]{MulticastRequestEncoder.class, MulticastRequestDecoder.class, MulticastAnnouncementEncoder.class, MulticastAnnouncementDecoder.class, UnicastDiscoveryClient.class, UnicastDiscoveryServer.class};
        providerTypes = classArray;
        instances = new SoftCache();
        logger = Logger.getLogger(DiscoveryV2.class.getName());
    }

    private static class DatagramBuffers
    implements DatagramBufferFactory {
        private static final int TRIM_THRESHOLD = 512;
        private final List datagrams = new ArrayList();
        private final InetAddress addr;
        private final int maxPacketSize;
        private final byte packetType;
        private final long formatId;

        DatagramBuffers(InetAddress inetAddress, int n, byte by, long l) {
            this.addr = inetAddress;
            this.maxPacketSize = n;
            this.packetType = by;
            this.formatId = l;
        }

        public ByteBuffer newBuffer() {
            DatagramInfo datagramInfo = new DatagramInfo();
            this.datagrams.add(datagramInfo);
            return datagramInfo.getBuffer();
        }

        DatagramPacket[] getDatagrams() {
            DatagramPacket[] datagramPacketArray = new DatagramPacket[this.datagrams.size()];
            for (int i = 0; i < datagramPacketArray.length; ++i) {
                datagramPacketArray[i] = ((DatagramInfo)this.datagrams.get(i)).getDatagram();
            }
            return datagramPacketArray;
        }

        private class DatagramInfo {
            private final DatagramPacket datagram;
            private final ByteBuffer buf;

            DatagramInfo() {
                this.datagram = new DatagramPacket(new byte[DatagramBuffers.this.maxPacketSize], 0, DatagramBuffers.this.addr, 4160);
                this.buf = ByteBuffer.wrap(this.datagram.getData());
                this.buf.putInt(2);
                this.buf.put(DatagramBuffers.this.packetType);
                this.buf.putLong(DatagramBuffers.this.formatId);
            }

            ByteBuffer getBuffer() {
                return this.buf;
            }

            DatagramPacket getDatagram() {
                int n = this.buf.position();
                if (this.buf.remaining() > 512) {
                    byte[] byArray = new byte[n];
                    System.arraycopy(this.datagram.getData(), 0, byArray, 0, n);
                    this.datagram.setData(byArray);
                }
                this.datagram.setLength(n);
                return this.datagram;
            }
        }
    }

    private static class IdentityKey {
        private final Object obj;
        private final int hash;

        IdentityKey(Object object) {
            this.obj = object;
            this.hash = System.identityHashCode(object);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            return object instanceof IdentityKey && ((IdentityKey)object).obj == this.obj;
        }
    }
}

