/*
 * Decompiled with CFR 0.152.
 */
package net.jini.config;

import com.sun.jini.logging.Levels;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.NoSuchEntryException;
import net.jini.config.Utilities;

public abstract class AbstractConfiguration
implements Configuration {
    private static final String[] reservedNames = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"};
    static final Logger logger = Logger.getLogger("net.jini.config");

    protected AbstractConfiguration() {
    }

    public Object getEntry(String string, String string2, Class clazz) throws ConfigurationException {
        return this.getEntryInternal(string, string2, clazz, NO_DEFAULT, NO_DATA);
    }

    public Object getEntry(String string, String string2, Class clazz, Object object) throws ConfigurationException {
        return this.getEntryInternal(string, string2, clazz, object, NO_DATA);
    }

    public Object getEntry(String string, String string2, Class clazz, Object object, Object object2) throws ConfigurationException {
        return this.getEntryInternal(string, string2, clazz, object, object2);
    }

    protected abstract Object getEntryInternal(String var1, String var2, Class var3, Object var4) throws ConfigurationException;

    private Object getEntryInternal(String string, String string2, Class clazz, Object object, Object object2) throws ConfigurationException {
        ConfigurationException configurationException;
        if (string == null) {
            throw new NullPointerException("component cannot be null");
        }
        if (!AbstractConfiguration.validQualifiedIdentifier(string)) {
            throw new IllegalArgumentException("component must be a valid qualified identifier");
        }
        if (string2 == null) {
            throw new NullPointerException("name cannot be null");
        }
        if (!AbstractConfiguration.validIdentifier(string2)) {
            throw new IllegalArgumentException("name must be a valid identifier");
        }
        if (clazz == null) {
            throw new NullPointerException("type cannot be null");
        }
        if (object != NO_DEFAULT && (clazz.isPrimitive() ? object == null || Utilities.getPrimitiveType(object.getClass()) != clazz : object != null && !clazz.isAssignableFrom(object.getClass()))) {
            throw new IllegalArgumentException("defaultValue is of wrong type");
        }
        try {
            Class<Object> clazz2;
            Object object3 = this.getEntryInternal(string, string2, clazz, object2);
            if (object3 instanceof Primitive) {
                clazz2 = ((Primitive)object3).getType();
                object3 = ((Primitive)object3).getValue();
            } else {
                clazz2 = object3 != null ? object3.getClass() : null;
            }
            if (clazz2 == null ? clazz.isPrimitive() : !clazz.isAssignableFrom(clazz2)) {
                throw new ConfigurationException("entry for component " + string + ", name " + string2 + " is of wrong type: " + Utilities.typeString(clazz2));
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "{0}, component {1}, name {2}{3,choice,0#|1#, data {4}}: returns {5}", new Object[]{this, string, string2, new Double(object2 == NO_DATA ? 0.0 : 1.0), object2, object3});
            }
            return object3;
        }
        catch (NoSuchEntryException noSuchEntryException) {
            if (object == NO_DEFAULT) {
                if (logger.isLoggable(Levels.FAILED)) {
                    logger.log(Levels.FAILED, "{0}, component {1}, name {2}: entry not found", new Object[]{this, string, string2});
                }
                throw noSuchEntryException;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "{0}, component {1}, name {2}: returns default {3}", new Object[]{this, string, string2, object});
            }
            return object;
        }
        catch (ConfigurationException configurationException2) {
            configurationException = configurationException2;
        }
        catch (RuntimeException runtimeException) {
            configurationException = new ConfigurationException("problem getting entry for component " + string + ", name " + string2, runtimeException);
        }
        if (logger.isLoggable(Levels.FAILED)) {
            this.logThrow("getEntry", "{0}, component {1}, name {2}{3,choice,0#|1#, data {4}}: throws", new Object[]{this, string, string2, new Double(object2 == NO_DATA ? 0.0 : 1.0), object2}, configurationException);
        }
        throw configurationException;
    }

    void logThrow(String string, String string2, Object[] objectArray, Throwable throwable) {
        LogRecord logRecord = new LogRecord(Levels.FAILED, string2);
        logRecord.setLoggerName(logger.getName());
        logRecord.setSourceClassName(this.getClass().getName());
        logRecord.setSourceMethodName(string);
        logRecord.setParameters(objectArray);
        logRecord.setThrown(throwable);
        logger.log(logRecord);
    }

    protected static boolean validIdentifier(String string) {
        if (string == null || string.length() == 0 || !Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        int n = string.length();
        while (--n > 0) {
            if (Character.isJavaIdentifierPart(string.charAt(n))) continue;
            return false;
        }
        return Arrays.binarySearch(reservedNames, string) < 0;
    }

    protected static boolean validQualifiedIdentifier(String string) {
        int n;
        if (string == null) {
            return false;
        }
        int n2 = 0;
        do {
            String string2;
            if (!AbstractConfiguration.validIdentifier(string2 = string.substring(n2, (n = string.indexOf(46, n2)) < 0 ? string.length() : n))) {
                return false;
            }
            n2 = n + 1;
        } while (n >= 0);
        return true;
    }

    public static final class Primitive {
        private final Object value;
        private final Class type;

        public Primitive(Object object) {
            this.value = object;
            Class clazz = this.type = object != null ? Utilities.getPrimitiveType(object.getClass()) : null;
            if (this.type == null) {
                throw new IllegalArgumentException("value is not a primitive: " + object);
            }
        }

        public Object getValue() {
            return this.value;
        }

        public Class getType() {
            return this.type;
        }

        public String toString() {
            return "Primitive[(" + this.type + ") " + this.value + "]";
        }

        public boolean equals(Object object) {
            return object instanceof Primitive && this.value.equals(((Primitive)object).value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

