/*
 * Decompiled with CFR 0.152.
 */
package net.jini.jeri.kerberos;

import com.sun.jini.action.GetIntegerAction;
import com.sun.jini.discovery.internal.EndpointInternals;
import com.sun.jini.discovery.kerberos.EndpointInternalsAccess;
import com.sun.jini.jeri.internal.connection.BasicConnManagerFactory;
import com.sun.jini.jeri.internal.connection.ConnManager;
import com.sun.jini.jeri.internal.connection.ConnManagerFactory;
import com.sun.jini.jeri.internal.connection.ServerConnManager;
import com.sun.jini.jeri.internal.runtime.Util;
import com.sun.jini.logging.Levels;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.SocketFactory;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import net.jini.core.constraint.ConnectionAbsoluteTime;
import net.jini.core.constraint.ConstraintAlternatives;
import net.jini.core.constraint.Delegation;
import net.jini.core.constraint.Integrity;
import net.jini.core.constraint.InvocationConstraint;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.io.UnsupportedConstraintException;
import net.jini.jeri.Endpoint;
import net.jini.jeri.OutboundRequestIterator;
import net.jini.jeri.ServerEndpoint;
import net.jini.jeri.connection.Connection;
import net.jini.jeri.connection.ConnectionEndpoint;
import net.jini.jeri.connection.OutboundRequestHandle;
import net.jini.jeri.kerberos.KerberosServerEndpoint;
import net.jini.jeri.kerberos.KerberosUtil;
import net.jini.security.AuthenticationPermission;
import net.jini.security.Security;
import net.jini.security.proxytrust.TrustEquivalence;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;

public final class KerberosEndpoint
implements Endpoint,
TrustEquivalence,
Serializable {
    private static final long serialVersionUID = -880347439811805543L;
    private static final Logger logger = Logger.getLogger("net.jini.jeri.kerberos.client");
    private final String serverHost;
    private final int serverPort;
    private final KerberosPrincipal serverPrincipal;
    private final SocketFactory csf;
    private static final GSSManager gssManager = GSSManager.getInstance();
    private static final int maxCacheSize = (Integer)AccessController.doPrivileged(new GetIntegerAction("com.sun.jini.jeri.kerberos.KerberosEndpoint.maxCacheSize", 64));
    private static final int minGssContextLifetime = (Integer)AccessController.doPrivileged(new GetIntegerAction("com.sun.jini.jeri.kerberos.KerberosEndpoint.minGssContextLifetime", 30));
    private static final int maxGssContextRetries = (Integer)AccessController.doPrivileged(new GetIntegerAction("com.sun.jini.jeri.kerberos.KerberosEndpoint.maxGssContextRetries", 3));
    private transient KerberosUtil.SoftCache softCache;
    private transient ConnectionEndpointImpl connectionEndpoint;
    private transient ConnManager connManager;
    private transient boolean disableSocketConnect;
    private static final Map internTable = new WeakHashMap(5);
    private static final int NO_ERROR = -1;
    private static final int UNSUPPORTABLE_CONSTRAINT_REQUIRED = 0;
    private static final int NULL_SUBJECT = 1;
    private static final int NO_CLIENT_PRINCIPAL = 2;
    private static final int UNSATISFIABLE_CONSTRAINT_REQUIRED = 3;
    private static final String[] ERROR_STRINGS;

    private KerberosEndpoint(String string, int n, KerberosPrincipal kerberosPrincipal, SocketFactory socketFactory) {
        if (string == null) {
            throw new NullPointerException("serverHost is null");
        }
        if (n <= 0 || n > 65535) {
            throw new IllegalArgumentException("server port number out of range 1-65535: serverPort = " + n);
        }
        if (kerberosPrincipal == null) {
            throw new NullPointerException("serverPrincipal is null");
        }
        this.serverHost = string;
        this.serverPort = n;
        this.serverPrincipal = kerberosPrincipal;
        this.csf = socketFactory;
        logger.log(Level.FINE, "created {0}", this);
    }

    public static KerberosEndpoint getInstance(String string, int n, KerberosPrincipal kerberosPrincipal) {
        return KerberosEndpoint.intern(new KerberosEndpoint(string, n, kerberosPrincipal, null));
    }

    public static KerberosEndpoint getInstance(String string, int n, KerberosPrincipal kerberosPrincipal, SocketFactory socketFactory) {
        return KerberosEndpoint.intern(new KerberosEndpoint(string, n, kerberosPrincipal, socketFactory));
    }

    public String getHost() {
        return this.serverHost;
    }

    public int getPort() {
        return this.serverPort;
    }

    public KerberosPrincipal getPrincipal() {
        return this.serverPrincipal;
    }

    public SocketFactory getSocketFactory() {
        return this.csf;
    }

    public OutboundRequestIterator newRequest(InvocationConstraints invocationConstraints) {
        if (invocationConstraints == null) {
            throw new NullPointerException("constraints cannot be null");
        }
        logger.log(Level.FINE, "newRequest requested with constraints:\n{0}", invocationConstraints);
        Subject subject = (Subject)Security.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Subject.getSubject(AccessController.getContext());
            }
        });
        CacheKey cacheKey = new CacheKey(subject, invocationConstraints);
        RequestHandleImpl requestHandleImpl = (RequestHandleImpl)this.softCache.get(cacheKey);
        if (requestHandleImpl == null || !requestHandleImpl.reusable(subject)) {
            requestHandleImpl = new RequestHandleImpl(subject, invocationConstraints);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "new request handle has been constructed:\n{0}", new Object[]{requestHandleImpl});
            }
            this.softCache.put(cacheKey, requestHandleImpl);
        }
        return this.connManager.newRequest(requestHandleImpl);
    }

    public boolean checkTrustEquivalence(Object object) {
        return this.equals(object);
    }

    public int hashCode() {
        return this.getClass().getName().hashCode() ^ this.serverPrincipal.hashCode() ^ this.serverHost.hashCode() ^ this.serverPort ^ (this.csf != null ? this.csf.hashCode() : 0);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof KerberosEndpoint)) {
            return false;
        }
        KerberosEndpoint kerberosEndpoint = (KerberosEndpoint)object;
        return this.serverPrincipal.equals(kerberosEndpoint.serverPrincipal) && this.serverHost.equals(kerberosEndpoint.serverHost) && this.serverPort == kerberosEndpoint.serverPort && Util.sameClassAndEquals(this.csf, kerberosEndpoint.csf);
    }

    public String toString() {
        return "KerberosEndpoint[serverHost=" + this.serverHost + " serverPort=" + this.serverPort + " serverPrincipal=" + this.serverPrincipal + (this.csf == null ? "" : "csf = " + this.csf.toString()) + "]";
    }

    private Object readResolve() {
        return KerberosEndpoint.intern(this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.serverHost == null) {
            throw new InvalidObjectException("serverHost is null");
        }
        if (this.serverPort <= 0 || this.serverPort > 65535) {
            throw new InvalidObjectException("server port number out of range 1-65535: serverPort = : " + this.serverPort);
        }
        if (this.serverPrincipal == null) {
            throw new InvalidObjectException("serverPrincipal is null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KerberosEndpoint intern(KerberosEndpoint kerberosEndpoint) {
        Map map = internTable;
        synchronized (map) {
            KerberosEndpoint kerberosEndpoint2;
            WeakReference weakReference = (WeakReference)internTable.get(kerberosEndpoint);
            if (weakReference != null && (kerberosEndpoint2 = (KerberosEndpoint)weakReference.get()) != null) {
                return kerberosEndpoint2;
            }
            kerberosEndpoint.softCache = new KerberosUtil.SoftCache(maxCacheSize);
            KerberosEndpoint kerberosEndpoint3 = kerberosEndpoint;
            kerberosEndpoint3.getClass();
            kerberosEndpoint.connectionEndpoint = kerberosEndpoint3.new ConnectionEndpointImpl();
            kerberosEndpoint.connManager = new BasicConnManagerFactory().create(kerberosEndpoint.connectionEndpoint);
            internTable.put(kerberosEndpoint, new WeakReference<KerberosEndpoint>(kerberosEndpoint));
            return kerberosEndpoint;
        }
    }

    private void checkEndpoint(KerberosEndpoint kerberosEndpoint) {
        if (!this.equals(kerberosEndpoint)) {
            throw new IllegalArgumentException("endpoint mismatch, this endpoint is: " + this + ", passed in endpoint is: " + kerberosEndpoint);
        }
    }

    private RequestHandleImpl checkRequestHandleImpl(Object object) {
        if (object == null) {
            throw new NullPointerException("Handle cannot be null");
        }
        if (!(object instanceof RequestHandleImpl)) {
            throw new IllegalArgumentException("Unexpected handle type: " + object);
        }
        RequestHandleImpl requestHandleImpl = (RequestHandleImpl)object;
        this.checkEndpoint(requestHandleImpl.getEndpoint());
        return requestHandleImpl;
    }

    private ConnectionImpl checkConnection(Object object) {
        if (!(object instanceof ConnectionImpl)) {
            throw new IllegalArgumentException("Expected connection type is " + ConnectionImpl.class + ", while " + object + " is passed in.");
        }
        ConnectionImpl connectionImpl = (ConnectionImpl)object;
        this.checkEndpoint(connectionImpl.getEndpoint());
        return connectionImpl;
    }

    static {
        KerberosEndpointInternals.registerDiscoveryBackDoor();
        ERROR_STRINGS = new String[]{"UNSUPPORTABLE_CONSTRAINT_REQUIRED", "NULL_SUBJECT", "NO_CLIENT_PRINCIPAL", "UNSATISFIABLE_CONSTRAINT_REQUIRED"};
    }

    private static final class CacheKey {
        private final Subject subject;
        private final InvocationConstraints constraints;

        CacheKey(Subject subject, InvocationConstraints invocationConstraints) {
            this.subject = subject;
            this.constraints = invocationConstraints;
        }

        public int hashCode() {
            return System.identityHashCode(this.subject) ^ System.identityHashCode(this.constraints);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof CacheKey)) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)object;
            return this.subject == cacheKey.subject && this.constraints == cacheKey.constraints;
        }
    }

    private final class ConnectionImpl
    extends KerberosUtil.Connection
    implements Connection {
        private static final int KRB_AP_ERR_REPEAT = 34;
        private InputStream istream;
        private OutputStream ostream;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        ConnectionImpl(Socket socket, KerberosUtil.Config config) throws IOException {
            super(socket);
            this.clientPrincipal = config.clientPrincipal;
            this.doEncryption = config.encry;
            this.doDelegation = config.deleg;
            this.connectionLogger = logger;
            boolean bl = false;
            try {
                try {
                    Security.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws IOException, GSSException {
                            ConnectionImpl.this.establishContext();
                            return null;
                        }
                    });
                    this.ostream = new KerberosUtil.ConnectionOutputStream(this);
                    this.istream = new KerberosUtil.ConnectionInputStream(this);
                    return;
                }
                catch (PrivilegedActionException privilegedActionException) {
                    Exception exception = privilegedActionException.getException();
                    if (logger.isLoggable(Levels.FAILED)) {
                        KerberosUtil.logThrow(logger, Levels.FAILED, this.getClass(), "constructor", "failed to establish GSSContext for this connection with {0}.", new Object[]{config}, exception);
                    }
                    if (!(exception instanceof GSSException)) throw (IOException)exception;
                    IOException iOException = new IOException("Failed to establish GSS context for this connection.");
                    iOException.initCause(exception);
                    throw iOException;
                }
            }
            catch (Throwable throwable) {
                Object var9_6 = null;
                if (bl) throw throwable;
                this.close();
                throw throwable;
            }
        }

        public OutputStream getOutputStream() throws IOException {
            return this.ostream;
        }

        public InputStream getInputStream() throws IOException {
            return this.istream;
        }

        public SocketChannel getChannel() {
            return null;
        }

        public void populateContext(OutboundRequestHandle outboundRequestHandle, Collection collection) {
            if (outboundRequestHandle == null) {
                throw new NullPointerException("handle is null");
            }
            if (collection == null) {
                throw new NullPointerException("context is null");
            }
        }

        public InvocationConstraints getUnfulfilledConstraints(OutboundRequestHandle outboundRequestHandle) {
            RequestHandleImpl requestHandleImpl = KerberosEndpoint.this.checkRequestHandleImpl(outboundRequestHandle);
            return requestHandleImpl.unfulfilledConstraints;
        }

        public void writeRequestData(OutboundRequestHandle outboundRequestHandle, OutputStream outputStream) {
        }

        public IOException readResponseData(OutboundRequestHandle outboundRequestHandle, InputStream inputStream) {
            return null;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("KerberosEndpoint.ConnectionImpl");
            stringBuffer.append("[clientPrincipal=" + this.clientPrincipal);
            stringBuffer.append(" serverPrincipal=" + KerberosEndpoint.this.serverPrincipal);
            stringBuffer.append(" doEncryption=" + this.doEncryption);
            stringBuffer.append(" doDelegation=" + this.doDelegation);
            stringBuffer.append(" client=" + this.sock.getLocalAddress().getHostName());
            stringBuffer.append(":" + this.sock.getLocalPort());
            stringBuffer.append(" server=" + this.sock.getInetAddress().getHostName());
            stringBuffer.append(":" + this.sock.getPort());
            stringBuffer.append(']');
            return stringBuffer.toString();
        }

        boolean satisfies(KerberosUtil.Config config) {
            return this.gssContext.getLifetime() >= minGssContextLifetime && this.clientPrincipal.equals(config.clientPrincipal) && this.doEncryption == config.encry && this.doDelegation == config.deleg;
        }

        boolean switchTo(KerberosUtil.Config config) {
            if (this.gssContext.getLifetime() < minGssContextLifetime) {
                return false;
            }
            if (this.clientPrincipal.equals(config.clientPrincipal) && this.doDelegation == config.deleg) {
                this.doEncryption = config.encry;
                return true;
            }
            return false;
        }

        KerberosEndpoint getEndpoint() {
            return KerberosEndpoint.this;
        }

        private void establishContext() throws IOException, GSSException {
            GSSName gSSName = gssManager.createName(this.clientPrincipal.getName(), KerberosUtil.krb5NameType);
            GSSCredential gSSCredential = gssManager.createCredential(gSSName, Integer.MAX_VALUE, KerberosUtil.krb5MechOid, 1);
            GSSName gSSName2 = gssManager.createName(KerberosEndpoint.this.serverPrincipal.getName(), KerberosUtil.krb5NameType);
            block2: for (int i = maxGssContextRetries; i > 0; --i) {
                this.gssContext = gssManager.createContext(gSSName2, KerberosUtil.krb5MechOid, gSSCredential, 0);
                this.gssContext.requestMutualAuth(true);
                this.gssContext.requestInteg(true);
                this.gssContext.requestConf(true);
                this.gssContext.requestCredDeleg(this.doDelegation);
                this.gssContext.requestReplayDet(true);
                this.gssContext.requestSequenceDet(true);
                byte[] byArray = new byte[]{};
                try {
                    while (true) {
                        if ((byArray = this.gssContext.initSecContext(byArray, 0, byArray.length)) != null) {
                            this.dos.writeInt(byArray.length);
                            this.dos.write(byArray);
                            this.dos.flush();
                        }
                        if (this.gssContext.isEstablished()) break block2;
                        byArray = new byte[this.dis.readInt()];
                        this.dis.readFully(byArray);
                    }
                }
                catch (GSSException gSSException) {
                    if ((gSSException.getMessage().indexOf("34") >= 0 || gSSException.getMajor() == 19 || gSSException.getMinor() == 34 || gSSException.getMessage().indexOf("Request is a replay") >= 0) && i != 1) continue;
                    throw gSSException;
                }
            }
            if (!this.gssContext.getIntegState() || this.doEncryption && !this.gssContext.getConfState() || this.doDelegation && !this.gssContext.getCredDelegState() || !((Object)this.gssContext.getTargName()).toString().equals(KerberosEndpoint.this.serverPrincipal.getName())) {
                throw new IOException("Failed to establish gss context for connection");
            }
            logger.log(Level.FINE, "GSSContext established for {0}", this);
        }
    }

    private final class ConnectionEndpointImpl
    implements ConnectionEndpoint {
        private ConnectionEndpointImpl() {
        }

        public Connection connect(OutboundRequestHandle outboundRequestHandle) throws IOException {
            Object object;
            KerberosUtil.Config config;
            RequestHandleImpl requestHandleImpl;
            block26: {
                block25: {
                    requestHandleImpl = KerberosEndpoint.this.checkRequestHandleImpl(outboundRequestHandle);
                    config = null;
                    Exception exception = null;
                    try {
                        object = requestHandleImpl.getConfigs();
                        config = (KerberosUtil.Config)object.get(0);
                        if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.FINE, "Passed in request handle is:\n{0},\nconfiguration list returned by getConfigs is:\n{1},\nin which the first one will be used.", new Object[]{requestHandleImpl, object});
                        }
                    }
                    catch (UnsupportedConstraintException unsupportedConstraintException) {
                        exception = unsupportedConstraintException;
                    }
                    catch (SecurityException securityException) {
                        exception = securityException;
                    }
                    if (exception != null) {
                        if (logger.isLoggable(Levels.FAILED)) {
                            KerberosUtil.logThrow(logger, Levels.FAILED, this.getClass(), "connect", "failed to find a supportable connection configuration for the request", null, exception);
                        }
                        if (requestHandleImpl.errorCode == 0) {
                            throw exception;
                        }
                        object = new UnsupportedConstraintException("Either there are conflicting or unsatisfiable constraint requirements, or the JAAS login has not been done (Subject.getSubject(AccessController.getContext()) returns null), or no appropriate Kerberos principal and corresponding TGT allowed by the requirements can be found in the current subject. " + requestHandleImpl.constraints);
                        KerberosUtil.secureThrow(exception, (UnsupportedConstraintException)object);
                    }
                    if (KerberosEndpoint.this.csf != null) {
                        try {
                            object = KerberosEndpoint.this.csf.createSocket();
                        }
                        catch (IOException iOException) {
                            if (logger.isLoggable(Levels.FAILED)) {
                                KerberosUtil.logThrow(logger, Levels.FAILED, this.getClass(), "connect", "failed to create socket using the given SocketFactory {0}", new Object[]{KerberosEndpoint.this.csf}, iOException);
                            }
                            throw iOException;
                        }
                        if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.FINE, "created socket {0} using factory {1}", new Object[]{object, KerberosEndpoint.this.csf});
                        }
                    } else {
                        object = new Socket();
                        logger.log(Level.FINE, "created socket {0}", object);
                    }
                    try {
                        ((Socket)object).setTcpNoDelay(true);
                    }
                    catch (SocketException socketException) {
                        if (!logger.isLoggable(Levels.HANDLED)) break block25;
                        KerberosUtil.logThrow(logger, Levels.HANDLED, this.getClass(), "connect", "failed to setTcpNoDelay option for {0}", new Object[]{object}, socketException);
                    }
                }
                try {
                    ((Socket)object).setKeepAlive(true);
                }
                catch (SocketException socketException) {
                    if (!logger.isLoggable(Levels.HANDLED)) break block26;
                    KerberosUtil.logThrow(logger, Levels.HANDLED, this.getClass(), "connect", "failed to setKeepAlive options for {0}", new Object[]{object}, socketException);
                }
            }
            if (!KerberosEndpoint.this.disableSocketConnect) {
                try {
                    long l = requestHandleImpl.connectionAbsoluteTime - System.currentTimeMillis();
                    if (l <= 0L) {
                        throw new SocketTimeoutException("connection timeout passed before socket.connect is called");
                    }
                    if (l > Integer.MAX_VALUE) {
                        ((Socket)object).connect(new InetSocketAddress(KerberosEndpoint.this.serverHost, KerberosEndpoint.this.serverPort));
                    } else {
                        ((Socket)object).connect(new InetSocketAddress(KerberosEndpoint.this.serverHost, KerberosEndpoint.this.serverPort), (int)l);
                    }
                }
                catch (IOException iOException) {
                    if (logger.isLoggable(Levels.FAILED)) {
                        KerberosUtil.logThrow(logger, Levels.FAILED, this.getClass(), "connect", "failed to connect to server", null, iOException);
                    }
                    throw iOException;
                }
            }
            ConnectionImpl connectionImpl = new ConnectionImpl((Socket)object, config);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "New connection established:\n{0}", new Object[]{connectionImpl});
            }
            return connectionImpl;
        }

        public Connection connect(OutboundRequestHandle outboundRequestHandle, Collection collection, Collection collection2) {
            ConnectionImpl connectionImpl;
            Iterator iterator;
            KerberosUtil.Config config;
            List list;
            RequestHandleImpl requestHandleImpl = KerberosEndpoint.this.checkRequestHandleImpl(outboundRequestHandle);
            if (collection == null) {
                throw new NullPointerException("active collection cannot be null");
            }
            if (collection2 == null) {
                throw new NullPointerException("idle collection cannot be null");
            }
            try {
                list = requestHandleImpl.getConfigs();
            }
            catch (Exception exception) {
                return null;
            }
            SecurityManager securityManager = System.getSecurityManager();
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                config = (KerberosUtil.Config)iterator2.next();
                iterator = collection.iterator();
                while (iterator.hasNext()) {
                    connectionImpl = KerberosEndpoint.this.checkConnection(iterator.next());
                    if (!connectionImpl.satisfies(config)) continue;
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "found an active connection for reusing:\n{0}\n{1}", new Object[]{connectionImpl, config});
                    }
                    if (securityManager != null) {
                        securityManager.checkConnect(KerberosEndpoint.this.serverHost, KerberosEndpoint.this.serverPort);
                    }
                    return connectionImpl;
                }
            }
            iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                config = (KerberosUtil.Config)iterator2.next();
                iterator = collection2.iterator();
                while (iterator.hasNext()) {
                    connectionImpl = KerberosEndpoint.this.checkConnection(iterator.next());
                    if (!connectionImpl.switchTo(config)) continue;
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "found an idle connection for reusing:\n{0}\n{1}", new Object[]{connectionImpl, config});
                    }
                    if (securityManager != null) {
                        securityManager.checkConnect(KerberosEndpoint.this.serverHost, KerberosEndpoint.this.serverPort);
                    }
                    return connectionImpl;
                }
            }
            return null;
        }
    }

    private final class RequestHandleImpl
    implements OutboundRequestHandle {
        private Subject clientSubject;
        private InvocationConstraints constraints;
        private boolean subjectReadOnly;
        private Set subjectClientPrincipals;
        private Set clientPrincipals;
        private int errorCode = -1;
        private String detailedExceptionMsg;
        private KerberosUtil.Config[] configs;
        private InvocationConstraints unfulfilledConstraints;
        long connectionAbsoluteTime;

        RequestHandleImpl(Subject subject, InvocationConstraints invocationConstraints) {
            Object object;
            Object object2;
            Object object3;
            Iterator iterator = invocationConstraints.requirements().iterator();
            while (iterator.hasNext()) {
                object3 = (InvocationConstraint)iterator.next();
                if (KerberosUtil.isSupportableConstraint((InvocationConstraint)object3)) continue;
                this.errorCode = 0;
                this.detailedExceptionMsg = "A constraint unsupportable by this endpoint has been required: " + object3;
                return;
            }
            this.clientPrincipals = new HashSet();
            iterator = invocationConstraints.requirements().iterator();
            while (iterator.hasNext()) {
                if (KerberosUtil.collectCpCandidates((InvocationConstraint)iterator.next(), this.clientPrincipals)) continue;
                this.errorCode = 0;
                this.detailedExceptionMsg = "Client principal constraint related conflicts found in the given set of constraints: " + invocationConstraints;
                return;
            }
            if (subject == null) {
                this.errorCode = 1;
                this.detailedExceptionMsg = "JAAS login has not been done properly, the subject associated with the current AccessControlContext is null.";
                return;
            }
            this.clientSubject = subject;
            this.constraints = invocationConstraints;
            this.subjectReadOnly = subject.isReadOnly();
            this.subjectClientPrincipals = this.getClientPrincipals(subject);
            if (this.subjectClientPrincipals.size() == 0) {
                this.errorCode = 2;
                this.detailedExceptionMsg = "JAAS login has not been done properly, the subject associated with the current AccessControlContext contains no KerberosPrincipal.";
                return;
            }
            if (this.clientPrincipals.size() > 0) {
                this.clientPrincipals.retainAll(this.subjectClientPrincipals);
            } else {
                this.clientPrincipals = this.subjectClientPrincipals;
            }
            boolean bl = false;
            if (KerberosUtil.containsConstraint(invocationConstraints.requirements(), Delegation.YES) || KerberosUtil.containsConstraint(invocationConstraints.preferences(), Delegation.YES)) {
                bl = true;
            }
            object3 = new ArrayList();
            KerberosUtil.ConfigIter configIter = new KerberosUtil.ConfigIter(this.clientPrincipals, KerberosEndpoint.this.serverPrincipal, bl);
            block2: while (configIter.hasNext()) {
                object2 = configIter.next();
                object = invocationConstraints.requirements().iterator();
                while (object.hasNext()) {
                    InvocationConstraint invocationConstraint = (InvocationConstraint)object.next();
                    if (KerberosUtil.isSatisfiable((KerberosUtil.Config)object2, invocationConstraint)) continue;
                    continue block2;
                }
                ((ArrayList)object3).add(object2);
            }
            if (((ArrayList)object3).size() == 0) {
                this.errorCode = 3;
                this.detailedExceptionMsg = "Constraints unsatisfiable by this endpoint with the current subject have been required: " + invocationConstraints + ", while the KerberosPrincipal set of " + "the subject is: " + this.subjectClientPrincipals;
                return;
            }
            this.configs = ((ArrayList)object3).toArray(new KerberosUtil.Config[((ArrayList)object3).size()]);
            for (int i = 0; i < this.configs.length; ++i) {
                object2 = invocationConstraints.preferences().iterator();
                while (object2.hasNext()) {
                    object = (InvocationConstraint)object2.next();
                    if (!KerberosUtil.isSatisfiable(this.configs[i], (InvocationConstraint)object)) continue;
                    ++this.configs[i].prefCount;
                }
            }
            Arrays.sort(this.configs, new Comparator(){

                public int compare(Object object, Object object2) {
                    KerberosUtil.Config config = (KerberosUtil.Config)object;
                    KerberosUtil.Config config2 = (KerberosUtil.Config)object2;
                    return config2.prefCount - config.prefCount;
                }
            });
            this.unfulfilledConstraints = KerberosUtil.containsConstraint(invocationConstraints.requirements(), Integrity.YES) ? KerberosUtil.INTEGRITY_REQUIRED_CONSTRAINTS : (KerberosUtil.containsConstraint(invocationConstraints.preferences(), Integrity.YES) ? KerberosUtil.INTEGRITY_PREFERRED_CONSTRAINTS : InvocationConstraints.EMPTY);
            this.connectionAbsoluteTime = Math.min(this.computeConnectionTimeLimit(invocationConstraints.requirements()), this.computeConnectionTimeLimit(invocationConstraints.preferences()));
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("KerberosEndpoint.RequestHandleImpl[\n");
            if (this.errorCode != -1) {
                stringBuffer.append("errorCode=" + ERROR_STRINGS[this.errorCode]);
                stringBuffer.append(" errorExceptionMsg=" + this.detailedExceptionMsg);
            } else {
                stringBuffer.append("constraints=" + this.constraints);
                stringBuffer.append("\nprincipalsInSubject=" + this.subjectClientPrincipals);
                stringBuffer.append("\nallowedConfigs=[\n");
                if (this.configs.length > 0) {
                    stringBuffer.append(this.configs[0]);
                }
                for (int i = 1; i < this.configs.length; ++i) {
                    stringBuffer.append(",\n" + this.configs[i]);
                }
                stringBuffer.append("],");
                stringBuffer.append("\nunfulfilledConstraints=" + this.unfulfilledConstraints);
                stringBuffer.append("\nconnectionAbsoluteTime=");
                if (this.connectionAbsoluteTime == Long.MAX_VALUE) {
                    stringBuffer.append("NO_LIMIT");
                } else {
                    stringBuffer.append(new Date(this.connectionAbsoluteTime));
                }
            }
            stringBuffer.append(']');
            return stringBuffer.toString();
        }

        boolean reusable(Subject subject) {
            if (subject == null || this.subjectReadOnly) {
                return true;
            }
            Set set = this.getClientPrincipals(subject);
            return ((Object)set).equals(this.subjectClientPrincipals);
        }

        List getConfigs() throws UnsupportedConstraintException {
            if (this.errorCode != -1) {
                throw new UnsupportedConstraintException(this.detailedExceptionMsg);
            }
            KerberosTicket[] kerberosTicketArray = (KerberosTicket[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return RequestHandleImpl.this.getTickets();
                }
            });
            ArrayList<KerberosUtil.Config> arrayList = new ArrayList<KerberosUtil.Config>(this.configs.length);
            int n = 3;
            KerberosPrincipal kerberosPrincipal = null;
            int n2 = 2;
            KerberosPrincipal kerberosPrincipal2 = null;
            HashMap<AuthenticationPermission, Boolean> hashMap = new HashMap<AuthenticationPermission, Boolean>();
            for (int i = 0; i < this.configs.length; ++i) {
                block19: {
                    AuthenticationPermission authenticationPermission = this.getAuthenticationPermission(this.configs[i].clientPrincipal, this.configs[i].deleg);
                    Boolean bl = (Boolean)hashMap.get(authenticationPermission);
                    if (bl == null) {
                        try {
                            KerberosUtil.checkAuthPermission(authenticationPermission);
                            hashMap.put(authenticationPermission, Boolean.TRUE);
                            break block19;
                        }
                        catch (SecurityException securityException) {
                            hashMap.put(authenticationPermission, Boolean.FALSE);
                            continue;
                        }
                    }
                    if (bl == Boolean.FALSE) continue;
                }
                if (this.configs[i].deleg) {
                    KerberosTicket kerberosTicket;
                    if (n > 2) {
                        n = 2;
                        kerberosPrincipal = this.configs[i].clientPrincipal;
                    }
                    if ((kerberosTicket = this.findTicket(kerberosTicketArray, this.configs[i].clientPrincipal)) == null) continue;
                    if (n > 1) {
                        n = 1;
                        kerberosPrincipal = this.configs[i].clientPrincipal;
                    }
                    if (!kerberosTicket.isForwardable()) continue;
                    arrayList.add(this.configs[i]);
                    continue;
                }
                if (n2 > 1) {
                    n2 = 1;
                    kerberosPrincipal2 = this.configs[i].clientPrincipal;
                }
                if (this.findTicket(kerberosTicketArray, this.configs[i].clientPrincipal) == null) continue;
                arrayList.add(this.configs[i]);
            }
            if (arrayList.size() == 0) {
                if (n2 < n) {
                    switch (n2) {
                        case 1: {
                            throw new UnsupportedConstraintException("JAAS login has not been done properly, the subject associated with the current AccessControlContext does not contain a valid TGT for " + kerberosPrincipal2.getName());
                        }
                        case 2: {
                            throw new SecurityException("Caller does not have any of the following acceptable permissions: " + hashMap.keySet());
                        }
                    }
                    throw new AssertionError((Object)"should not reach here");
                }
                switch (n) {
                    case 1: {
                        throw new UnsupportedConstraintException("JAAS login has not been done properly, the subject associated with the current AccessControlContext contains a valid TGT for " + kerberosPrincipal.getName() + ", but the TGT is not " + "forwardable.");
                    }
                    case 2: {
                        throw new UnsupportedConstraintException("JAAS login has not been done properly, the subject associated with the current AccessControlContext does not contain a valid TGT for " + kerberosPrincipal.getName());
                    }
                }
                throw new AssertionError((Object)"should not reach here");
            }
            return arrayList;
        }

        KerberosEndpoint getEndpoint() {
            return KerberosEndpoint.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set getClientPrincipals(Subject subject) {
            Set<Principal> set;
            Set<Principal> set2 = set = subject.getPrincipals();
            synchronized (set2) {
                HashSet<Principal> hashSet = new HashSet<Principal>(set.size());
                Iterator<Principal> iterator = set.iterator();
                while (iterator.hasNext()) {
                    Principal principal = iterator.next();
                    if (!(principal instanceof KerberosPrincipal)) continue;
                    hashSet.add(principal);
                }
                return hashSet;
            }
        }

        private long computeConnectionTimeLimit(Set set) {
            long l = Long.MAX_VALUE;
            Iterator iterator = set.iterator();
            block0: while (iterator.hasNext()) {
                Object e = iterator.next();
                long l2 = Long.MIN_VALUE;
                if (e instanceof ConstraintAlternatives) {
                    Set set2 = ((ConstraintAlternatives)e).elements();
                    Iterator iterator2 = set2.iterator();
                    while (iterator2.hasNext()) {
                        Object e2 = iterator2.next();
                        if (!(e2 instanceof ConnectionAbsoluteTime)) continue block0;
                        long l3 = ((ConnectionAbsoluteTime)e2).getTime();
                        if (l2 >= l3) continue;
                        l2 = l3;
                    }
                } else {
                    if (!(e instanceof ConnectionAbsoluteTime)) continue;
                    l2 = ((ConnectionAbsoluteTime)e).getTime();
                }
                if (l2 >= l) continue;
                l = l2;
            }
            return l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private KerberosTicket[] getTickets() {
            Set<Object> set;
            ArrayList<KerberosTicket> arrayList = new ArrayList<KerberosTicket>();
            Set<Object> set2 = set = this.clientSubject.getPrivateCredentials();
            synchronized (set2) {
                Iterator<Object> iterator = set.iterator();
                while (iterator.hasNext()) {
                    KerberosTicket kerberosTicket;
                    Object object = iterator.next();
                    if (!(object instanceof KerberosTicket) || !(kerberosTicket = (KerberosTicket)object).getServer().getName().startsWith("krbtgt/") || kerberosTicket.isDestroyed() || !kerberosTicket.isCurrent()) continue;
                    arrayList.add(kerberosTicket);
                }
            }
            return arrayList.toArray(new KerberosTicket[arrayList.size()]);
        }

        private KerberosTicket findTicket(KerberosTicket[] kerberosTicketArray, KerberosPrincipal kerberosPrincipal) {
            String string = kerberosPrincipal.getRealm();
            String string2 = KerberosEndpoint.this.serverPrincipal.getRealm();
            String string3 = "krbtgt/" + string2 + "@" + string;
            for (int i = 0; i < kerberosTicketArray.length; ++i) {
                if (!kerberosTicketArray[i].getClient().equals(kerberosPrincipal) || !kerberosTicketArray[i].getServer().getName().equals(string3)) continue;
                return kerberosTicketArray[i];
            }
            return null;
        }

        private AuthenticationPermission getAuthenticationPermission(KerberosPrincipal kerberosPrincipal, boolean bl) {
            String string = bl ? "delegate" : "connect";
            Set<KerberosPrincipal> set = Collections.singleton(kerberosPrincipal);
            Set<KerberosPrincipal> set2 = Collections.singleton(KerberosEndpoint.this.serverPrincipal);
            return new AuthenticationPermission(set, set2, string);
        }
    }

    private static final class KerberosEndpointInternals
    implements EndpointInternals {
        private KerberosEndpointInternals() {
        }

        static void registerDiscoveryBackDoor() {
            final KerberosEndpointInternals kerberosEndpointInternals = new KerberosEndpointInternals();
            try {
                Security.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        EndpointInternalsAccess.set(kerberosEndpointInternals);
                        return null;
                    }
                });
            }
            catch (Throwable throwable) {
                logger.log(Level.WARNING, "Problem registering with discovery provider", throwable);
            }
        }

        public void disableSocketConnect(Endpoint endpoint) {
            ((KerberosEndpoint)endpoint).disableSocketConnect = true;
        }

        public void setConnManagerFactory(Endpoint endpoint, ConnManagerFactory connManagerFactory) {
            KerberosEndpoint kerberosEndpoint = (KerberosEndpoint)endpoint;
            kerberosEndpoint.connManager = connManagerFactory.create(kerberosEndpoint.connectionEndpoint);
        }

        public void setServerConnManager(ServerEndpoint serverEndpoint, ServerConnManager serverConnManager) {
            KerberosServerEndpoint kerberosServerEndpoint = (KerberosServerEndpoint)serverEndpoint;
            kerberosServerEndpoint.serverConnManager = serverConnManager;
        }

        public InvocationConstraints getUnfulfilledConstraints(OutboundRequestHandle outboundRequestHandle) {
            return ((RequestHandleImpl)outboundRequestHandle).unfulfilledConstraints;
        }
    }
}

