/*
 * Decompiled with CFR 0.152.
 */
package net.jini.jeri.tcp;

import com.sun.jini.action.GetBooleanAction;
import com.sun.jini.jeri.internal.runtime.Util;
import com.sun.jini.logging.Levels;
import com.sun.jini.thread.Executor;
import com.sun.jini.thread.GetThreadPoolAction;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.io.UnsupportedConstraintException;
import net.jini.jeri.Endpoint;
import net.jini.jeri.RequestDispatcher;
import net.jini.jeri.ServerEndpoint;
import net.jini.jeri.connection.InboundRequestHandle;
import net.jini.jeri.connection.ServerConnection;
import net.jini.jeri.connection.ServerConnectionManager;
import net.jini.jeri.tcp.Constraints;
import net.jini.jeri.tcp.TcpEndpoint;
import net.jini.security.Security;
import net.jini.security.SecurityContext;

public final class TcpServerEndpoint
implements ServerEndpoint {
    private static final Executor systemThreadPool = (Executor)AccessController.doPrivileged(new GetThreadPoolAction(false));
    private static final ServerConnectionManager serverConnectionManager = new ServerConnectionManager();
    private static final Logger logger = Logger.getLogger("net.jini.jeri.tcp.server");
    private static final boolean useNIO = (Boolean)AccessController.doPrivileged(new GetBooleanAction("com.sun.jini.jeri.tcp.useNIO"));
    private final String host;
    private final int port;
    private final SocketFactory sf;
    private final ServerSocketFactory ssf;

    public static TcpServerEndpoint getInstance(int n) {
        return TcpServerEndpoint.getInstance(null, n, null, null);
    }

    public static TcpServerEndpoint getInstance(String string, int n) {
        return TcpServerEndpoint.getInstance(string, n, null, null);
    }

    public static TcpServerEndpoint getInstance(String string, int n, SocketFactory socketFactory, ServerSocketFactory serverSocketFactory) {
        return new TcpServerEndpoint(string, n, socketFactory, serverSocketFactory);
    }

    private TcpServerEndpoint(String string, int n, SocketFactory socketFactory, ServerSocketFactory serverSocketFactory) {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("port number out of range: " + n);
        }
        this.host = string;
        this.port = n;
        this.sf = socketFactory;
        this.ssf = serverSocketFactory;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public SocketFactory getSocketFactory() {
        return this.sf;
    }

    public ServerSocketFactory getServerSocketFactory() {
        return this.ssf;
    }

    public InvocationConstraints checkConstraints(InvocationConstraints invocationConstraints) throws UnsupportedConstraintException {
        return Constraints.check(invocationConstraints, true);
    }

    public Endpoint enumerateListenEndpoints(ServerEndpoint.ListenContext listenContext) throws IOException {
        Object object;
        Object object2;
        if (listenContext == null) {
            throw new NullPointerException();
        }
        String string = this.host;
        if (string == null) {
            try {
                object2 = (InetAddress)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws UnknownHostException {
                        return InetAddress.getLocalHost();
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (UnknownHostException)privilegedActionException.getCause();
            }
            object = System.getSecurityManager();
            if (object != null) {
                try {
                    ((SecurityManager)object).checkConnect(((InetAddress)object2).getHostName(), -1);
                }
                catch (SecurityException securityException) {
                    throw new SecurityException("access to resolve local host denied");
                }
            }
            string = ((InetAddress)object2).getHostAddress();
        }
        if (!((object = listenContext.addListenEndpoint((ServerEndpoint.ListenEndpoint)(object2 = new LE()))) instanceof LE.Cookie)) {
            throw new IllegalArgumentException();
        }
        LE.Cookie cookie = (LE.Cookie)object;
        if (!((LE)object2).equals(cookie.getLE())) {
            throw new IllegalArgumentException();
        }
        return TcpEndpoint.getInstance(string, cookie.getPort(), this.sf);
    }

    public int hashCode() {
        return this.port ^ (this.host != null ? this.host.hashCode() : 0) ^ (this.sf != null ? this.sf.hashCode() : 0) ^ (this.ssf != null ? this.ssf.hashCode() : 0);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof TcpServerEndpoint)) {
            return false;
        }
        TcpServerEndpoint tcpServerEndpoint = (TcpServerEndpoint)object;
        return Util.equals(this.host, tcpServerEndpoint.host) && this.port == tcpServerEndpoint.port && Util.sameClassAndEquals(this.sf, tcpServerEndpoint.sf) && Util.sameClassAndEquals(this.ssf, tcpServerEndpoint.ssf);
    }

    public String toString() {
        return "TcpServerEndpoint[" + (this.host != null ? this.host + ":" : "") + this.port + (this.ssf != null ? "," + this.ssf : "") + (this.sf != null ? "," + this.sf : "") + "]";
    }

    private static class LH
    implements ServerEndpoint.ListenHandle {
        private final RequestDispatcher requestDispatcher;
        private final ServerSocket serverSocket;
        private final SecurityContext securityContext;
        private final ServerEndpoint.ListenCookie cookie;
        private long acceptFailureTime = 0L;
        private int acceptFailureCount;
        private final Object lock = new Object();
        private boolean closed = false;
        private final Set connections = new HashSet();

        LH(RequestDispatcher requestDispatcher, ServerSocket serverSocket, SecurityContext securityContext, ServerEndpoint.ListenCookie listenCookie) {
            this.requestDispatcher = requestDispatcher;
            this.serverSocket = serverSocket;
            this.securityContext = securityContext;
            this.cookie = listenCookie;
        }

        void startAccepting() {
            systemThreadPool.execute(new Runnable(){

                public void run() {
                    LH.this.executeAcceptLoop();
                }
            }, this.toString() + " accept loop");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void executeAcceptLoop() {
            while (true) {
                Socket socket = null;
                try {
                    block17: {
                        LogRecord logRecord;
                        block16: {
                            socket = this.serverSocket.accept();
                            if (logger.isLoggable(Level.FINE)) {
                                logger.log(Level.FINE, "accepted socket {0} from server socket {1}", new Object[]{socket, this.serverSocket});
                            }
                            try {
                                socket.setTcpNoDelay(true);
                            }
                            catch (SocketException socketException) {
                                if (!logger.isLoggable(Levels.HANDLED)) break block16;
                                logRecord = new LogRecord(Levels.HANDLED, "exception setting TCP_NODELAY on socket {0}");
                                logRecord.setLoggerName(logger.getName());
                                logRecord.setSourceClassName(this.getClass().getName());
                                logRecord.setSourceMethodName("executeAcceptLoop");
                                logRecord.setParameters(new Object[]{socket});
                                logRecord.setThrown(socketException);
                                logger.log(logRecord);
                            }
                        }
                        try {
                            socket.setKeepAlive(true);
                        }
                        catch (SocketException socketException) {
                            if (!logger.isLoggable(Levels.HANDLED)) break block17;
                            logRecord = new LogRecord(Levels.HANDLED, "exception setting SO_KEEPALIVE on socket {0}");
                            logRecord.setLoggerName(logger.getName());
                            logRecord.setSourceClassName(this.getClass().getName());
                            logRecord.setSourceMethodName("executeAcceptLoop");
                            logRecord.setParameters(new Object[]{socket});
                            logRecord.setThrown(socketException);
                            logger.log(logRecord);
                        }
                    }
                    final ServerConnectionImpl serverConnectionImpl = new ServerConnectionImpl(socket);
                    AccessController.doPrivileged(this.securityContext.wrap(new PrivilegedAction(){

                        public Object run() {
                            serverConnectionManager.handleConnection(serverConnectionImpl, LH.this.requestDispatcher);
                            return null;
                        }
                    }), this.securityContext.getAccessControlContext());
                    continue;
                }
                catch (Throwable throwable) {
                    boolean bl;
                    Object object = this;
                    synchronized (object) {
                        bl = this.closed;
                    }
                    if (!bl && logger.isLoggable(Level.INFO)) {
                        object = new LogRecord(Level.INFO, "accept loop for {0} throws");
                        ((LogRecord)object).setLoggerName(logger.getName());
                        ((LogRecord)object).setSourceClassName(this.getClass().getName());
                        ((LogRecord)object).setSourceMethodName("executeAcceptLoop");
                        ((LogRecord)object).setParameters(new Object[]{this.serverSocket});
                        ((LogRecord)object).setThrown(throwable);
                        logger.log((LogRecord)object);
                    }
                    if (socket != null) {
                        try {
                            socket.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (bl) return;
                    if (!(throwable instanceof SecurityException)) {
                        // empty if block
                    }
                    if (!(throwable instanceof IOException) && !(throwable instanceof SecurityException) && !(throwable instanceof RuntimeException) && !(throwable instanceof OutOfMemoryError) && !(throwable instanceof NoClassDefFoundError)) throw (Error)throwable;
                    if (!this.continueAfterAcceptFailure(throwable)) return;
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Iterator iterator = this.lock;
            synchronized (iterator) {
                if (this.closed) {
                    return;
                }
                this.closed = true;
            }
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "closed server socket {0}", new Object[]{this.serverSocket});
            }
            iterator = this.connections.iterator();
            while (iterator.hasNext()) {
                ((ServerConnectionImpl)iterator.next()).close();
            }
        }

        public ServerEndpoint.ListenCookie getCookie() {
            return this.cookie;
        }

        public String toString() {
            return "TcpServerEndpoint.LH[" + this.serverSocket + "]";
        }

        private boolean continueAfterAcceptFailure(Throwable throwable) {
            long l = System.currentTimeMillis();
            if (this.acceptFailureTime == 0L || l - this.acceptFailureTime > 5000L) {
                this.acceptFailureTime = l;
                this.acceptFailureCount = 0;
            } else {
                ++this.acceptFailureCount;
                if (this.acceptFailureCount >= 10) {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            return true;
        }

        private class ServerConnectionImpl
        implements ServerConnection {
            private final Socket socket;

            ServerConnectionImpl(Socket socket) {
                this.socket = socket;
                this.addToConnectionSet();
            }

            public InputStream getInputStream() throws IOException {
                return this.socket.getInputStream();
            }

            public OutputStream getOutputStream() throws IOException {
                return this.socket.getOutputStream();
            }

            public SocketChannel getChannel() {
                return this.socket.getChannel();
            }

            public InboundRequestHandle processRequestData(InputStream inputStream, OutputStream outputStream) {
                return new InboundRequestHandle(){};
            }

            public void checkPermissions(InboundRequestHandle inboundRequestHandle) {
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager != null) {
                    securityManager.checkAccept(this.socket.getInetAddress().getHostAddress(), this.socket.getPort());
                }
            }

            public InvocationConstraints checkConstraints(InboundRequestHandle inboundRequestHandle, InvocationConstraints invocationConstraints) throws UnsupportedConstraintException {
                return Constraints.check(invocationConstraints, true);
            }

            public void populateContext(InboundRequestHandle inboundRequestHandle, Collection collection) {
                Util.populateContext(collection, this.socket.getInetAddress());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void close() {
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "closed socket {0}", new Object[]{this.socket});
                }
                Object object = LH.this.lock;
                synchronized (object) {
                    if (!LH.this.closed) {
                        LH.this.connections.remove(this);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void addToConnectionSet() {
                boolean bl = false;
                Object object = LH.this.lock;
                synchronized (object) {
                    if (LH.this.closed) {
                        bl = true;
                    } else {
                        LH.this.connections.add(this);
                    }
                }
                if (bl) {
                    this.close();
                }
            }
        }
    }

    private class LE
    implements ServerEndpoint.ListenEndpoint {
        LE() {
        }

        public void checkPermissions() {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkListen(TcpServerEndpoint.this.port);
            }
        }

        public ServerEndpoint.ListenHandle listen(RequestDispatcher requestDispatcher) throws IOException {
            ServerSocket serverSocket;
            if (requestDispatcher == null) {
                throw new NullPointerException();
            }
            if (TcpServerEndpoint.this.ssf != null) {
                serverSocket = TcpServerEndpoint.this.ssf.createServerSocket(TcpServerEndpoint.this.port);
            } else if (useNIO) {
                serverSocket = ServerSocketChannel.open().socket();
                serverSocket.bind(new InetSocketAddress(TcpServerEndpoint.this.port));
            } else {
                serverSocket = new ServerSocket(TcpServerEndpoint.this.port);
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "created server socket {0}" + (TcpServerEndpoint.this.ssf != null ? " using factory {1}" : ""), new Object[]{serverSocket, TcpServerEndpoint.this.ssf});
            }
            Cookie cookie = new Cookie(serverSocket.getLocalPort());
            LH lH = new LH(requestDispatcher, serverSocket, Security.getContext(), cookie);
            lH.startAccepting();
            return lH;
        }

        private int getPort() {
            return TcpServerEndpoint.this.port;
        }

        private ServerSocketFactory getSSF() {
            return TcpServerEndpoint.this.ssf;
        }

        public int hashCode() {
            return TcpServerEndpoint.this.port ^ (TcpServerEndpoint.this.ssf != null ? TcpServerEndpoint.this.ssf.hashCode() : 0);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof LE)) {
                return false;
            }
            LE lE = (LE)object;
            return TcpServerEndpoint.this.port == lE.getPort() && Util.sameClassAndEquals(TcpServerEndpoint.this.ssf, lE.getSSF());
        }

        public String toString() {
            return "TcpServerEndpoint.LE[" + TcpServerEndpoint.this.port + (TcpServerEndpoint.this.ssf != null ? "," + TcpServerEndpoint.this.ssf : "") + "]";
        }

        private class Cookie
        implements ServerEndpoint.ListenCookie {
            private final int port;

            Cookie(int n) {
                this.port = n;
            }

            LE getLE() {
                return LE.this;
            }

            int getPort() {
                return this.port;
            }

            public String toString() {
                return "TcpServerEndpoint.LE.Cookie[" + this.port + "]";
            }
        }
    }
}

