/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.debug.Debug;
import ice.pilots.html4.DCSSRule;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.DOMBuilder;
import ice.pilots.html4.DStyleDeclaration;
import ice.pilots.html4.DStyleSheet;
import ice.pilots.html4.Lex2;
import ice.pilots.html4.StormData;
import ice.pilots.html4.ThePilot;
import ice.pilots.html4.TransformerFactory;
import ice.storm.DynEnv;
import ice.storm.DynamicObject;
import ice.storm.StormBase;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.html.HTMLDocument;

public class DOM
extends DynamicObject
implements DOMImplementation,
Cloneable {
    StormData sdata;
    DDocument _masterDocument;

    public static void setInstance(StormBase stormBase, DOM dOM) {
        StormData stormData = StormData.get(stormBase);
        if (dOM == null || stormData.domImplementation != null) {
            throw new IllegalArgumentException();
        }
        dOM.sdata = stormData;
        stormData.domImplementation = dOM;
    }

    public static DOM getInstance(StormBase stormBase) {
        return DOM.getInstance(StormData.get(stormBase));
    }

    static DOM getInstance(StormData stormData) {
        if (stormData.domImplementation == null) {
            DOM dOM = new DOM();
            dOM.sdata = stormData;
            stormData.domImplementation = dOM;
        }
        return stormData.domImplementation;
    }

    public static void setInstance(DOM dOM) {
        throw new RuntimeException("Upgrade your code to use DOM.setInstance(StormBase, DOM)");
    }

    public static DOM getInstance() {
        throw new RuntimeException("Upgrade your code to use DOM.getInstance(StormBase)");
    }

    public static TransformerFactory getTransformFactory(StormBase stormBase) {
        return DOM.getInstance().getTransformFactory();
    }

    TransformerFactory getTransformFactory() {
        return this.sdata.transformerFactory;
    }

    public static void setTransformFactory(StormBase stormBase, TransformerFactory transformerFactory) {
        StormData stormData = StormData.get(stormBase);
        if (transformerFactory == null || stormData.transformerFactory != null) {
            throw new IllegalArgumentException();
        }
        stormData.transformerFactory = transformerFactory;
    }

    public static TransformerFactory getTransformerFactory() {
        throw new RuntimeException("Upgrade your code to use DOM.getTransformerFactory(StormBase)");
    }

    public static void setTransformerFactory(TransformerFactory transformerFactory) {
        throw new RuntimeException("Upgrade your code to use DOM.setTransformerFactory(StormBase, factory)");
    }

    protected DOM() {
    }

    final StormData getStormData() {
        return this.sdata;
    }

    DOM createDocumentSlave(DDocument dDocument) {
        DOM dOM = this.makeClone();
        dOM._masterDocument = dDocument;
        return dOM;
    }

    protected final DOM makeClone() {
        DOM dOM;
        try {
            dOM = (DOM)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            dOM = null;
        }
        dOM.afterClone();
        return dOM;
    }

    protected void afterClone() {
        this._masterDocument = null;
    }

    protected DDocument getMasterDocument() {
        return this._masterDocument;
    }

    public DDocument parseEmbeddedDocumentFromString(String string) {
        StringReader stringReader = new StringReader(string);
        try {
            return this.parseEmbeddedDocumentFromReader(stringReader);
        }
        catch (IOException iOException) {
            Debug.bug();
            return null;
        }
    }

    public DDocument parseEmbeddedDocumentFromReader(Reader reader) throws IOException {
        DDocument dDocument = this.createDDocument(this._masterDocument.pilot, false);
        DOMBuilder dOMBuilder = new DOMBuilder(dDocument, null);
        Lex2 lex2 = new Lex2(dOMBuilder);
        lex2.setReader(reader);
        lex2.parse();
        return dDocument;
    }

    public boolean hasFeature(String string, String string2) {
        int n = Integer.MAX_VALUE;
        if (string2 != null) {
            if (string2.equals("1.0")) {
                n = 1;
            } else if (string2.equals("2.0")) {
                n = 2;
            }
        }
        if (string.equals("Core") ? n >= 2 : (string.equals("Views") ? n >= 2 : (string.equals("Events") ? n >= 2 : (string.equals("StyleSheets") ? n >= 2 : (string.equals("CSS") ? n >= 2 : string.equals("HTML") && n >= 2))))) {
            return true;
        }
        return string.equalsIgnoreCase("xml") ? n >= 1 : string.equalsIgnoreCase("html") && n >= 1;
    }

    public DocumentType createDocumentType(String string, String string2, String string3, String string4) {
        return null;
    }

    public Document createDocument(String string, String string2, DocumentType documentType) {
        DDocument dDocument = this.createDDocument(this._masterDocument.pilot, false);
        dDocument.defaultNamespace = string != null ? this.sdata.names.getNamespace(string) : 0;
        return dDocument;
    }

    public HTMLDocument createHTMLDocument(String string) {
        ThePilot thePilot = this._masterDocument != null ? this._masterDocument.pilot : null;
        DDocument dDocument = this.createDDocument(thePilot, true);
        DElement dElement = dDocument.createElement(43);
        DElement dElement2 = dDocument.createElement(86);
        DElement dElement3 = dDocument.createElement(41);
        DElement dElement4 = dDocument.createElement(13);
        if (string == null) {
            string = "";
        }
        dElement2.appendDChild(dDocument.createDTextNode(string));
        dElement3.appendDChild(dElement2);
        dElement.appendDChild(dElement3);
        dElement.appendDChild(dElement4);
        dDocument.appendDChild(dElement);
        return dDocument;
    }

    public CSSStyleSheet createCSSStyleSheet(String string, String string2) {
        DStyleSheet dStyleSheet = this.createDStyleSheet(3, null, null, null);
        if (string != null) {
            dStyleSheet.setTitle(string);
        }
        return dStyleSheet;
    }

    public DStyleSheet createDStyleSheet(int n, DNode dNode, DStyleSheet dStyleSheet, DCSSRule dCSSRule) {
        DStyleSheet dStyleSheet2 = new DStyleSheet(n, dNode, dStyleSheet, dCSSRule);
        return dStyleSheet2;
    }

    public DDocument createDDocument(ThePilot thePilot, boolean bl) {
        DDocument dDocument = new DDocument(thePilot, this);
        dDocument.setHtmlMode(bl);
        return dDocument;
    }

    public DStyleDeclaration createDStyleDeclaration(DCSSRule dCSSRule, DElement dElement) {
        return new DStyleDeclaration(this, dCSSRule, dElement);
    }

    public DocumentType createDocumentType(String string, String string2, String string3) {
        return null;
    }

    public Object getDynamicValue(String string, DynEnv dynEnv) {
        int n = DOM.OEAB(string);
        if (n < 0) {
            return dynEnv.wrapMethod(this, string);
        }
        return super.getDynamicValue(string, dynEnv);
    }

    public int setDynamicValue(String string, Object object, DynEnv dynEnv) {
        int n = DOM.OEAB(string);
        if (n < 0) {
            return 2;
        }
        return super.setDynamicValue(string, object, dynEnv);
    }

    public Object execDynamicMethod(String string, Object[] objectArray, DynEnv dynEnv) {
        int n = DOM.OEAB(string);
        if (n < 0) {
            return this.I(n, objectArray, dynEnv);
        }
        return super.execDynamicMethod(string, objectArray, dynEnv);
    }

    private Object I(int n, Object[] objectArray, DynEnv dynEnv) {
        switch (n) {
            case -1: {
                return this.createCSSStyleSheet(dynEnv.toStr(objectArray, 0), dynEnv.toStr(objectArray, 1));
            }
            case -2: {
                return this.createDocument(dynEnv.toStr(objectArray, 0), dynEnv.toStr(objectArray, 1), (DocumentType)dynEnv.toNative(objectArray, 2));
            }
            case -3: {
                return this.createDocumentType(dynEnv.toStr(objectArray, 0), dynEnv.toStr(objectArray, 1), dynEnv.toStr(objectArray, 2), dynEnv.toStr(objectArray, 3));
            }
            case -4: {
                return this.createHTMLDocument(dynEnv.toStr(objectArray, 0));
            }
            case -5: {
                return dynEnv.wrapBoolean(this.hasFeature(dynEnv.toStr(objectArray, 0), dynEnv.toStr(objectArray, 1)));
            }
        }
        return dynEnv.wrapVoid();
    }

    private static int OEAB(String string) {
        int n = 0;
        String string2 = null;
        switch (string.length()) {
            case 10: {
                string2 = "hasFeature";
                n = -5;
                break;
            }
            case 14: {
                string2 = "createDocument";
                n = -2;
                break;
            }
            case 18: {
                char c = string.charAt(6);
                if (c == 'D') {
                    string2 = "createDocumentType";
                    n = -3;
                    break;
                }
                if (c != 'H') break;
                string2 = "createHTMLDocument";
                n = -4;
                break;
            }
            case 19: {
                string2 = "createCSSStyleSheet";
                n = -1;
            }
        }
        if (string2 != null && (string2 == string || string2.equals(string))) {
            return n;
        }
        return 0;
    }
}

