/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.instutil.licensefiles;

import com.mathworks.instutil.InstallerUtilities;
import com.mathworks.instutil.InstutilResourceKeys;
import com.mathworks.instutil.licensefiles.AbstractMarkerUtility;
import com.mathworks.instutil.licensefiles.ActivationEntry;
import com.mathworks.instutil.licensefiles.LicenseFileLocation;
import com.mathworks.instutil.licensefiles.LicenseLocationFactory;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class MarkerUtility
extends AbstractMarkerUtility {
    private String enteredUsername;
    private Element rootEle;
    private String hostName;
    private String rootDir;
    private String loggedInUsername;
    private LicenseLocationFactory licenseLocationFactory;

    public MarkerUtility(String string, String string2, String string3, LicenseLocationFactory licenseLocationFactory, String string4) {
        this.hostName = string;
        this.rootDir = string2;
        this.loggedInUsername = string4;
        this.enteredUsername = string3;
        this.licenseLocationFactory = licenseLocationFactory;
    }

    @Override
    public void editRequiredEntry(Node node) {
        if (node != null) {
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i <= nodeList.getLength(); ++i) {
                if (!nodeList.item(i).getNodeName().equals("licmode")) continue;
                nodeList.item(i).setTextContent("online");
                return;
            }
        }
    }

    @Override
    public void installMarkerFile() throws Exception {
        Document document;
        String string = this.getMarkerFileLocation();
        if (this.checkMarkerFileExists(string)) {
            document = this.readXMLFile(string);
            Node node = this.checkIfNodePresent(document, this.enteredUsername, this.hostName, this.rootDir);
            if (node != null) {
                this.editRequiredEntry(node);
            } else {
                this.addElementToDocument(document);
            }
        } else {
            document = this.createDocument();
        }
        this.printToFile(document, string);
    }

    private String getMarkerFileLocation() {
        String string = InstutilResourceKeys.RELEASE.getBundleString();
        LicenseFileLocation licenseFileLocation = this.loggedInUsername.trim().toLowerCase(Locale.getDefault()).equals(this.enteredUsername) ? this.licenseLocationFactory.getUserLicenseLocation(InstallerUtilities.getLibDirPath(this.rootDir), string, "") : this.licenseLocationFactory.getOtherUserLicenseLocation(this.rootDir, string, "");
        return licenseFileLocation.getLicenseLocation();
    }

    private Document createDocument() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        this.rootEle = document.createElement("root");
        document.appendChild(this.rootEle);
        this.addElementToDocument(document);
        return document;
    }

    private void addElementToDocument(Document document) {
        if (this.rootEle == null) {
            this.rootEle = document.getDocumentElement();
        }
        ActivationEntry activationEntry = new ActivationEntry(1, this.enteredUsername, this.rootDir, this.hostName, "online");
        Element element = this.createActivationEntry(activationEntry, document);
        this.rootEle.appendChild(element);
    }

    private Element createActivationEntry(ActivationEntry activationEntry, Document document) {
        Element element = document.createElement("ActivationEntry");
        element.setAttribute("idnumber", String.valueOf(activationEntry.getIdNumber()));
        element.setAttribute("user", activationEntry.getLicensedUser());
        element.setAttribute("matlabroot", activationEntry.getMatlabRoot());
        element.setAttribute("hostname", activationEntry.getHostname());
        Element element2 = document.createElement("licmode");
        Text text = document.createTextNode(activationEntry.getLicMode());
        element2.appendChild(text);
        element.appendChild(element2);
        return element;
    }
}

