/*
 * Decompiled with CFR 0.152.
 */
package ice.demo;

import ice.cert.X500Name;
import ice.cert.X509Certificate;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;

public class ViewCertificateDialog
extends Dialog
implements ActionListener {
    private Button okButton;
    private Button saveCertButton;
    private X509Certificate cert;
    private static final Font font = new Font("SansSerif", 0, 10);

    public ViewCertificateDialog(X509Certificate cert, Frame parent) {
        super(parent, "Certificate Information", true);
        this.cert = cert;
        Panel buttonPanel = new Panel();
        this.setFont(font);
        this.saveCertButton = new Button("Save certificate");
        this.saveCertButton.addActionListener(this);
        buttonPanel.add(this.saveCertButton);
        this.okButton = new Button("OK");
        this.okButton.addActionListener(this);
        buttonPanel.add(this.okButton);
        buttonPanel.setLayout(new FlowLayout());
        this.add((Component)buttonPanel, "South");
        Panel datePanel = new Panel();
        datePanel.add(new Label("Certificate valid from : " + cert.getNotBefore().toString()));
        datePanel.add(new Label("Certificate valid to : " + cert.getNotAfter().toString()));
        datePanel.setLayout(new GridLayout(2, 1));
        this.add((Component)datePanel, "North");
        Panel issuerPanel = new Panel();
        issuerPanel.add(new Label("Certificate issued by: "));
        X500Name issuer = (X500Name)cert.getIssuerDN();
        Enumeration enumeration = issuer.getAllElements();
        while (enumeration.hasMoreElements()) {
            String attribute = (String)enumeration.nextElement();
            String[] values = issuer.getElementArray(attribute);
            int i = 0;
            while (i < values.length) {
                issuerPanel.add(new Label(values[i]));
                ++i;
            }
        }
        Panel subjectPanel = new Panel();
        subjectPanel.add(new Label("Certificate issued for: "));
        X500Name subject = (X500Name)cert.getSubjectDN();
        enumeration = subject.getAllElements();
        while (enumeration.hasMoreElements()) {
            String attribute = (String)enumeration.nextElement();
            String[] values = subject.getElementArray(attribute);
            int i = 0;
            while (i < values.length) {
                subjectPanel.add(new Label(values[i]));
                ++i;
            }
        }
        int nbComponents = Math.max(subjectPanel.getComponentCount(), issuerPanel.getComponentCount());
        subjectPanel.setLayout(new GridLayout(nbComponents, 1));
        issuerPanel.setLayout(new GridLayout(nbComponents, 1));
        Panel certPanel = new Panel();
        certPanel.add(issuerPanel);
        certPanel.add(subjectPanel);
        certPanel.setLayout(new GridLayout(1, 2));
        this.add((Component)certPanel, "Center");
    }

    public void actionPerformed(ActionEvent ev) {
        if (ev.getSource() == this.okButton) {
            ((Component)this).setVisible(false);
        } else if (ev.getSource() == this.saveCertButton) {
            FileDialog fd = new FileDialog((Frame)this.getParent(), "Save certificate", 1);
            fd.setFile("*.der");
            ((Component)fd).setVisible(true);
            String dir = fd.getDirectory();
            String file = fd.getFile();
            if (dir == null || file == null) {
                return;
            }
            try {
                FileOutputStream fos = new FileOutputStream(dir + File.separator + file);
                this.cert.save(fos);
                fos.close();
            }
            catch (IOException ex) {
                final Dialog dlg = new Dialog((Frame)this.getParent(), "Error", true);
                dlg.add((Component)new Label("Error while saving file."), "Center");
                Button okB = new Button("OK");
                dlg.add((Component)okB, "South");
                okB.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent ev2) {
                        dlg.dispose();
                    }
                });
                dlg.pack();
                ((Component)dlg).setVisible(true);
            }
        }
    }
}

