/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.help.helpui;

import com.mathworks.help.helpui.HelpBrowserToolBar;
import com.mathworks.html.HtmlActions;
import com.mathworks.html.HtmlComponent;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class HelpBrowserComponent {
    private final JPanel fPanel;
    private final HtmlComponent<? extends HtmlActions> fHtmlComponent;

    public HelpBrowserComponent(HtmlComponent<? extends HtmlActions> htmlComponent, HelpBrowserToolBar helpBrowserToolBar) {
        assert (SwingUtilities.isEventDispatchThread()) : "HelpBrowserComponent must be created on the EDT.";
        this.fHtmlComponent = htmlComponent;
        this.fPanel = HelpBrowserComponent.createPanel(helpBrowserToolBar, this.fHtmlComponent);
        this.fHtmlComponent.getComponent().requestFocusInWindow();
    }

    private static JPanel createPanel(HelpBrowserToolBar helpBrowserToolBar, HtmlComponent<? extends HtmlActions> htmlComponent) {
        JPanel jPanel = new JPanel();
        jPanel.setName("HelpBrowserPanel");
        jPanel.getAccessibleContext().setAccessibleName("HelpBrowserPanel");
        jPanel.setLayout(new BorderLayout());
        if (helpBrowserToolBar != null) {
            jPanel.add((Component)helpBrowserToolBar.getComponent(), "North");
        }
        jPanel.add(htmlComponent.getComponent(), "Center");
        return jPanel;
    }

    public Component getComponent() {
        return this.getPanel();
    }

    JPanel getPanel() {
        return this.fPanel;
    }

    public HtmlComponent<? extends HtmlActions> getHtmlComponent() {
        return this.fHtmlComponent;
    }

    public void setCurrentLocation(String string) {
        if (string == null) {
            return;
        }
        this.fHtmlComponent.setCurrentLocation(string);
    }

    public String getCurrentLocation() {
        return this.fHtmlComponent.getCurrentLocation();
    }

    public void dispose() {
        this.fHtmlComponent.dispose();
    }
}

