/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.mwswing.ClipboardListener;
import com.mathworks.util.NativeJava;
import com.mathworks.util.PlatformInfo;
import java.awt.datatransfer.DataFlavor;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.SwingUtilities;

public class ClipboardMonitor {
    private boolean fHasText = false;
    private List fListeners = new ArrayList();
    private static ClipboardMonitor sTheMonitor = new ClipboardMonitor();
    private Timer fTimer;
    private static final int POLL_PERIOD = 500;
    private static final DataFlavor[] sStringFlavor = new DataFlavor[]{DataFlavor.stringFlavor};

    private ClipboardMonitor() {
    }

    private void startTimer() {
        if (!PlatformInfo.isUnix()) {
            this.fTimer = new Timer(true);
            this.fTimer.scheduleAtFixedRate((TimerTask)sTheMonitor.new ClipboardTT(), 0L, 500L);
        }
    }

    private void stopTimer() {
        if (this.fTimer != null) {
            this.fTimer.cancel();
            this.fTimer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(ClipboardListener clipboardListener) {
        ClipboardMonitor clipboardMonitor = sTheMonitor;
        synchronized (clipboardMonitor) {
            boolean bl = ClipboardMonitor.sTheMonitor.fListeners.size() == 0;
            ClipboardMonitor.sTheMonitor.fListeners.add(new WeakReference<ClipboardListener>(clipboardListener));
            if (bl) {
                sTheMonitor.startTimer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeListener(ClipboardListener clipboardListener) {
        ClipboardMonitor clipboardMonitor = sTheMonitor;
        synchronized (clipboardMonitor) {
            int n = ClipboardMonitor.sTheMonitor.fListeners.size();
            for (int i = 0; i < n; ++i) {
                WeakReference weakReference = (WeakReference)ClipboardMonitor.sTheMonitor.fListeners.get(i);
                if (weakReference.get() != clipboardListener) continue;
                ClipboardMonitor.sTheMonitor.fListeners.remove(weakReference);
                break;
            }
            if (ClipboardMonitor.sTheMonitor.fListeners.size() == 0) {
                sTheMonitor.stopTimer();
            }
        }
    }

    public static DataFlavor[] getFlavors() {
        return ClipboardMonitor.sTheMonitor.fHasText ? sStringFlavor : null;
    }

    public static void dataPlacedOnClipboard() {
        if (PlatformInfo.isUnix()) {
            return;
        }
        sTheMonitor.notifyListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners() {
        boolean bl;
        boolean bl2 = bl = NativeJava.nativeLibraryExists() ? NativeJava.winClipboardHasText() : true;
        if (bl != this.fHasText) {
            this.fHasText = bl;
            ClipboardMonitor clipboardMonitor = sTheMonitor;
            synchronized (clipboardMonitor) {
                Iterator iterator = ClipboardMonitor.sTheMonitor.fListeners.iterator();
                while (iterator.hasNext()) {
                    WeakReference weakReference = (WeakReference)iterator.next();
                    ClipboardListener clipboardListener = (ClipboardListener)weakReference.get();
                    if (clipboardListener == null) {
                        iterator.remove();
                        continue;
                    }
                    SwingUtilities.invokeLater(new TypeChangedNotifier(clipboardListener, ClipboardMonitor.getFlavors()));
                }
                if (ClipboardMonitor.sTheMonitor.fListeners.size() == 0) {
                    sTheMonitor.stopTimer();
                }
            }
        }
    }

    class TypeChangedNotifier
    implements Runnable {
        private ClipboardListener lListener;
        private DataFlavor[] lFlavors;

        TypeChangedNotifier(ClipboardListener clipboardListener, DataFlavor[] dataFlavorArray) {
            this.lListener = clipboardListener;
            this.lFlavors = dataFlavorArray;
        }

        @Override
        public void run() {
            this.lListener.clipboardContentTypeChanged(this.lFlavors);
        }
    }

    class ClipboardTT
    extends TimerTask {
        ClipboardTT() {
        }

        @Override
        public void run() {
            ClipboardMonitor.this.notifyListeners();
        }
    }
}

