/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.mwswing.FileExtensionFilterUtils;
import com.mathworks.mwswing.FilePatternFilter;
import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.lang.StringUtils;

public class FileExtensionFilter
extends FileFilter
implements FilePatternFilter,
Serializable {
    private List<String> fExtensions;
    private String fDescription;
    private final String fSimpleFilterExtension;
    private static final String ILLEGAL_EXTENSION_CHARS = "|<>\\^=?/[]\";*.";
    private boolean fAcceptPattern = false;

    public FileExtensionFilter(String string, String string2, boolean bl) {
        this(string, string2, bl, false);
    }

    public FileExtensionFilter(String string, String string2, boolean bl, boolean bl2) {
        this.fExtensions = Arrays.asList(string2);
        this.fAcceptPattern = bl2;
        if (this.fAcceptPattern) {
            this.fDescription = string;
            if (bl) {
                this.fDescription = this.fDescription + " (" + string2 + ")";
            }
        } else {
            this.fDescription = bl ? string + " (*." + string2 + ")" : string;
        }
        this.fSimpleFilterExtension = FileExtensionFilter.computeSimpleFilterExtension(string2, bl2);
    }

    public FileExtensionFilter(String string, String[] stringArray, boolean bl) {
        this(string, Arrays.asList(stringArray), bl);
    }

    public FileExtensionFilter(String string, List<String> list, boolean bl) {
        this.fDescription = string;
        if (bl) {
            this.fDescription = this.fDescription + " (";
            for (int i = 0; i < list.size(); ++i) {
                this.fDescription = this.fDescription + "*." + list.get(i);
                if (i >= list.size() - 1) continue;
                this.fDescription = this.fDescription + ", ";
            }
            this.fDescription = this.fDescription + ")";
        }
        this.fExtensions = list;
        this.fSimpleFilterExtension = "";
    }

    public FileExtensionFilter(String string, String[] stringArray, boolean bl, boolean bl2) {
        this(string, Arrays.asList(stringArray), bl);
        this.fAcceptPattern = bl2;
        if (this.fAcceptPattern) {
            this.fDescription = string;
            if (bl) {
                this.fDescription = this.fDescription + " (";
                for (int i = 0; i < stringArray.length; ++i) {
                    this.fDescription = this.fDescription + stringArray[i];
                    if (i >= stringArray.length - 1) continue;
                    this.fDescription = this.fDescription + ", ";
                }
                this.fDescription = this.fDescription + ")";
            }
        }
    }

    private static String computeSimpleFilterExtension(String string, boolean bl) {
        String string2 = "";
        if (bl && string.startsWith("*.")) {
            String string3 = string.substring(string.indexOf(46) + 1);
            if (FileExtensionFilter.isValidExtension(string3)) {
                string2 = "." + string3;
            }
        } else {
            string2 = FileExtensionFilter.isValidExtension(string) ? "." + string : "";
        }
        return string2;
    }

    private static boolean isValidExtension(String string) {
        return StringUtils.indexOfAny((String)string, (String)ILLEGAL_EXTENSION_CHARS) == -1;
    }

    public String getSimpleFilterExtension() {
        assert (this.fSimpleFilterExtension.length() == 0 || this.fSimpleFilterExtension.startsWith("."));
        return this.fSimpleFilterExtension;
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        String string = FileExtensionFilter.getExtension(file);
        if (string != null) {
            for (String string2 : this.fExtensions) {
                if (!string.equals(string2)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String getDescription() {
        return this.fDescription;
    }

    @Override
    public String[] getPatterns() {
        String[] stringArray = new String[this.fExtensions.size()];
        String string = this.fAcceptPattern ? "" : "*.";
        for (int i = 0; i < this.fExtensions.size(); ++i) {
            stringArray[i] = string + this.fExtensions.get(i);
        }
        return stringArray;
    }

    public List<String> getPlainExtension() {
        return this.fExtensions;
    }

    static String getExtension(File file) {
        String string = file.getName();
        int n = string.lastIndexOf(46);
        if (n > 0 && n < string.length() - 1) {
            return string.substring(n + 1).toLowerCase();
        }
        return null;
    }

    public static FileExtensionFilter getMFileFilter() {
        return FileExtensionFilterUtils.getMatlabFileFilter();
    }

    public static FileExtensionFilter getSimscapeFileFilter() {
        return FileExtensionFilterUtils.getSimscapeFileFilter();
    }

    public static FileExtensionFilter getMatlabProductFilter() {
        return FileExtensionFilterUtils.getMatlabProductFilter();
    }

    public static FileExtensionFilter getMatFileFilter() {
        return FileExtensionFilterUtils.getMatFileFilter();
    }

    public static FileExtensionFilter getFigFileFilter() {
        return FileExtensionFilterUtils.getFigFileFilter();
    }
}

