/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.mwswing.ColorUtils;
import com.mathworks.mwswing.ContrastingIcon;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.MPopup;
import com.mathworks.mwswing.SimpleElement;
import com.mathworks.mwswing.SimpleNodeList;
import com.mathworks.util.PlatformInfo;
import java.awt.AWTEventMulticaster;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.zip.DataFormatException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MJTiledPane
extends JComponent
implements ItemSelectable {
    public static final int DEFAULT_BORDER_THICKNESS = 2;
    public static final int DEFAULT_CELL_SPACING = 5;
    public static final int DEFAULT_MINIMUM_WIDTH = 16;
    public static final int DEFAULT_MINIMUM_HEIGHT = 16;
    public static final int NO_TILE = -1;
    public static final int TILE_BORDERS_NEVER = 0;
    public static final int TILE_BORDERS_ALWAYS = 1;
    public static final int TILE_BORDERS_WHEN_EMPTY = 2;
    protected Dimension fGridSize = new Dimension();
    protected int fBorderThickness;
    protected int fCellSpacing;
    protected int fTileBordersOption;
    protected Dimension fMinimumCellSize = new Dimension(16, 16);
    protected boolean fContinuousLayout = true;
    protected boolean fCloseButtonsEnabled = true;
    protected int fTileCount;
    protected int fSelectedTile = -1;
    protected int fCursorType = 0;
    protected boolean fInRemove;
    protected boolean fIsDragging;
    protected boolean fIsShowingPopup;
    protected Component[] fComponents;
    protected Rectangle[] fTileCellRect;
    protected int[][] fTileInCell;
    protected int[] fColumnLeft;
    protected int[] fRowTop;
    protected float[] fColumnWeight;
    protected float[] fRowWeight;
    protected Rectangle[][] fHorizontalDividerCloseBox;
    protected Rectangle[][] fVerticalDividerCloseBox;
    protected ItemListener fSelectionListener;
    protected List<GridListener> fGridListeners;
    protected ItemListener fComponentListener = new ComponentItemListener();
    protected PopupMenuListener fPopupListener = new PopupStateListener();
    protected MPopup fDividerClosePopup;
    protected Timer fCloseButtonHideTimer;
    protected AbstractAction fMergeNorthSouthAction;
    protected AbstractAction fMergeEastWestAction;
    protected AbstractAction fSplitNorthSouthAction;
    protected AbstractAction fSplitEastWestAction;
    protected static final int NO_ELEMENT = 0;
    protected static final int HORIZONTAL_DIVIDER = 1;
    protected static final int VERTICAL_DIVIDER = 2;
    protected static final int DIVIDER_INTERSECTION = 3;
    protected static final int TILE_ELEMENT = 4;
    protected static final int SELECTION_BOX_THICKNESS = 5;
    protected static final int CLOSE_BUTTON_SIZE = 20;
    protected static final int MOUSE_ENTER_DELAY = 100;
    protected static Icon sMergeNorthSouthIcon;
    protected static Icon sMergeEastWestIcon;
    protected static Icon sSplitNorthSouthIcon;
    protected static Icon sSplitEastWestIcon;
    protected static Icon sCloseIcon;
    protected static InputMap sInputMap;
    protected static final String LEFT_ACTION_KEY = "select-tile-to-left";
    protected static final String RIGHT_ACTION_KEY = "select-tile-to-right";
    protected static final String UP_ACTION_KEY = "select-tile-above";
    protected static final String DOWN_ACTION_KEY = "select-tile-to-below";
    protected ElementData fElementData = new ElementData();
    private ElementData fScratchData = new ElementData();
    private static final ElementData sNoElementData;
    public static final String TILES_TAG = "Tiles";
    private static final String COLUMNS_ATTRIBUTE = "Columns";
    private static final String ROWS_ATTRIBUTE = "Rows";
    private static final String COUNT_ATTRIBUTE = "Count";
    private static final String WEIGHT_ATTRIBUTE = "Weight";
    private static final String COLUMN_TAG = "Column";
    private static final String LEFT_ATTRIBUTE = "Left";
    private static final String ROW_TAG = "Row";
    private static final String TOP_ATTRIBUTE = "Top";
    private static final String TILE_TAG = "Tile";
    private static final String X_ATTRIBUTE = "X";
    private static final String Y_ATTRIBUTE = "Y";
    private static final String WIDTH_ATTRIBUTE = "Width";
    private static final String HEIGHT_ATTRIBUTE = "Height";

    public MJTiledPane() {
        this(new Dimension(1, 1));
    }

    public MJTiledPane(Dimension dimension) {
        this(dimension, 2, 5, 1);
    }

    public MJTiledPane(Dimension dimension, int n, int n2, int n3) {
        this.setLayout(null);
        this.fGridSize.setSize(dimension);
        this.fBorderThickness = n;
        this.fCellSpacing = n2;
        this.fTileBordersOption = n3;
        this.initTables();
        this.setFocusable(true);
        TiledPaneMouseListener tiledPaneMouseListener = new TiledPaneMouseListener();
        this.addMouseListener(tiledPaneMouseListener);
        this.addMouseMotionListener(tiledPaneMouseListener);
        this.addFocusListener(new LocalFocusListener());
        this.setKeyBindings();
    }

    protected void initTables() {
        int n;
        int n2 = 0;
        this.fTileCount = this.fGridSize.width * this.fGridSize.height;
        this.fComponents = new Component[this.fTileCount];
        this.fTileCellRect = new Rectangle[this.fTileCount];
        this.fTileInCell = new int[this.fGridSize.height][];
        for (int i = 0; i < this.fGridSize.height; ++i) {
            this.fTileInCell[i] = new int[this.fGridSize.width];
            n = 0;
            while (n < this.fGridSize.width) {
                this.fTileInCell[i][n] = n2;
                this.fTileCellRect[n2] = new Rectangle(n, i, 1, 1);
                ++n;
                ++n2;
            }
        }
        this.fRowTop = new int[this.fGridSize.height + 1];
        this.fColumnLeft = new int[this.fGridSize.width + 1];
        this.fRowWeight = new float[this.fGridSize.height];
        this.fColumnWeight = new float[this.fGridSize.width];
        float f = 1.0f / (float)this.fGridSize.height;
        for (n = 0; n < this.fGridSize.height; ++n) {
            this.fRowWeight[n] = f;
        }
        f = 1.0f / (float)this.fGridSize.width;
        for (n = 0; n < this.fGridSize.width; ++n) {
            this.fColumnWeight[n] = f;
        }
        this.fHorizontalDividerCloseBox = null;
        this.fVerticalDividerCloseBox = null;
    }

    protected void setKeyBindings() {
        if (sInputMap == null) {
            sInputMap = new InputMap();
            sInputMap.put(KeyStroke.getKeyStroke(37, 2), LEFT_ACTION_KEY);
            sInputMap.put(KeyStroke.getKeyStroke(39, 2), RIGHT_ACTION_KEY);
            sInputMap.put(KeyStroke.getKeyStroke(38, 2), UP_ACTION_KEY);
            sInputMap.put(KeyStroke.getKeyStroke(40, 2), DOWN_ACTION_KEY);
        }
        this.setInputMap(1, sInputMap);
        ActionMap actionMap = this.getActionMap();
        actionMap.put(LEFT_ACTION_KEY, new NavigationAction(37));
        actionMap.put(RIGHT_ACTION_KEY, new NavigationAction(39));
        actionMap.put(UP_ACTION_KEY, new NavigationAction(38));
        actionMap.put(DOWN_ACTION_KEY, new NavigationAction(40));
    }

    public void setGridSize(Dimension dimension) {
        Dimension dimension2 = new Dimension(this.fGridSize);
        Dimension dimension3 = new Dimension(dimension);
        this.fGridSize.setSize(dimension);
        Component[] componentArray = this.fComponents;
        this.initTables();
        if (this.fSelectedTile >= this.fTileCount) {
            this.setSelectedTile(-1);
        }
        int n = 0;
        for (int i = 0; i < componentArray.length && n < this.fComponents.length; ++i) {
            if (componentArray[i] == null) continue;
            this.fComponents[n++] = componentArray[i];
        }
        this.fireGridSizeChange(dimension2, dimension3);
        this.revalidate();
        this.repaint();
    }

    public Dimension getGridSize() {
        return new Dimension(this.fGridSize);
    }

    public int getTileCount() {
        return this.fTileCount;
    }

    public void setColumnWidths(float[] fArray) {
        int n;
        float f = 0.0f;
        for (n = 0; n < Math.min(fArray.length, this.fGridSize.width - 1) && f < 1.0f; f += fArray[n], ++n) {
            this.fColumnWeight[n] = fArray[n];
        }
        int n2 = this.fGridSize.width - n;
        float f2 = 1.0f - f;
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        float f3 = f2 / (float)n2;
        while (n < this.fGridSize.width) {
            this.fColumnWeight[n] = f3;
            ++n;
        }
        this.revalidate();
        this.repaint();
    }

    public void setRowHeights(float[] fArray) {
        int n;
        float f = 0.0f;
        for (n = 0; n < Math.min(fArray.length, this.fGridSize.height - 1) && f < 1.0f; f += fArray[n], ++n) {
            this.fRowWeight[n] = fArray[n];
        }
        int n2 = this.fGridSize.height - n;
        float f2 = 1.0f - f;
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        float f3 = f2 / (float)n2;
        while (n < this.fGridSize.height) {
            this.fRowWeight[n] = f3;
            ++n;
        }
        this.revalidate();
        this.repaint();
    }

    public void setColumnSpan(int n, int n2, int n3) {
        if (n >= this.fGridSize.height || n2 >= this.fGridSize.width) {
            throw new IllegalArgumentException("Row = " + n + ", Col = " + n2 + " is not within " + this.fGridSize.toString());
        }
        if (n3 < 1) {
            throw new IllegalArgumentException("Span = " + n3 + " must be at least 1");
        }
        int n4 = this.fTileInCell[n][n2];
        Rectangle rectangle = this.fTileCellRect[n4];
        if (rectangle.width == n3) {
            return;
        }
        if (rectangle.width < n3) {
            int n5;
            if (rectangle.x + n3 > this.fGridSize.width) {
                n3 = this.fGridSize.width - rectangle.x;
            }
            boolean bl = true;
            for (n2 = rectangle.x + rectangle.width; n2 < rectangle.x + n3 && bl; n2 += this.fTileCellRect[n5].width) {
                n5 = this.fTileInCell[rectangle.y][n2];
                bl = this.fTileCellRect[n5].height == rectangle.height;
            }
            if (!bl) {
                return;
            }
            n5 = n3 - rectangle.width;
            int n6 = 0;
            int n7 = n4 + 1;
            while (n5 > 0) {
                int n8 = this.fTileCellRect[n7].width;
                if (n8 <= n5) {
                    n5 -= n8;
                    ++n6;
                    this.remove(n7);
                } else {
                    this.fTileCellRect[n7].x += n5;
                    this.fTileCellRect[n7].width -= n5;
                    n5 = 0;
                }
                ++n7;
            }
            rectangle.width = n3;
            this.recordOccupyingTile(rectangle, n4);
            if (n6 > 0) {
                for (n7 = n4 + 1; n7 < this.fTileCount - n6; ++n7) {
                    this.fComponents[n7] = this.fComponents[n7 + n6];
                    this.fTileCellRect[n7] = this.fTileCellRect[n7 + n6];
                    this.recordOccupyingTile(this.fTileCellRect[n7], n7);
                }
                this.fTileCount -= n6;
                if (this.fSelectedTile != -1 && this.fSelectedTile >= n4) {
                    this.setSelectedTile(this.fSelectedTile - n6);
                }
            }
            this.coalesceColumn(rectangle.x);
            if (n6 > 0) {
                this.fireTilesMerged(n4, n4 + 1);
            }
        } else {
            int n9 = n4 + 1;
            int n10 = rectangle.width - n3;
            rectangle.width = n3;
            for (int i = this.fTileCount - 1; i >= n9; --i) {
                this.fComponents[i + 1] = this.fComponents[i];
                this.fTileCellRect[i + 1] = this.fTileCellRect[i];
                this.recordOccupyingTile(this.fTileCellRect[i + 1], i + 1);
            }
            this.fTileCellRect[n9] = new Rectangle(rectangle);
            this.fTileCellRect[n9].x += n3;
            this.fTileCellRect[n9].width = n10;
            this.recordOccupyingTile(this.fTileCellRect[n9], n9);
            ++this.fTileCount;
            if (this.fSelectedTile != -1 && this.fSelectedTile > n4) {
                this.setSelectedTile(this.fSelectedTile + 1);
            }
            this.fireTileSplit(n4, 1);
        }
        this.revalidate();
        this.repaint();
    }

    public void setRowSpan(int n, int n2, int n3) {
        if (n >= this.fGridSize.height || n2 >= this.fGridSize.width) {
            throw new IllegalArgumentException("Row = " + n + ", Col = " + n2 + " is not within " + this.fGridSize.toString());
        }
        if (n3 < 1) {
            throw new IllegalArgumentException("Span = " + n3 + " must be at least 1");
        }
        int n4 = this.fTileInCell[n][n2];
        Rectangle rectangle = this.fTileCellRect[n4];
        if (rectangle.height == n3) {
            return;
        }
        if (rectangle.height < n3) {
            int n5;
            int n6;
            int n7;
            if (rectangle.y + n3 > this.fGridSize.height) {
                n3 = this.fGridSize.height - rectangle.y;
            }
            boolean bl = true;
            for (n = rectangle.y + rectangle.height; n < rectangle.y + n3 && bl; n += this.fTileCellRect[n7].height) {
                n7 = this.fTileInCell[n][rectangle.x];
                bl = this.fTileCellRect[n7].width == rectangle.width;
            }
            if (!bl) {
                return;
            }
            n7 = n3 - rectangle.height;
            int[] nArray = new int[n7];
            int n8 = 0;
            for (n = rectangle.y + rectangle.height; n < rectangle.y + n3; n += this.fTileCellRect[n6].height) {
                n6 = this.fTileInCell[n][rectangle.x];
                n5 = this.fTileCellRect[n6].height;
                if (n5 <= n7) {
                    n7 -= n5;
                    nArray[n8++] = n6;
                    this.remove(n6);
                    continue;
                }
                this.fTileCellRect[n6].y += n7;
                this.fTileCellRect[n6].height -= n7;
                n7 = 0;
            }
            rectangle.height = n3;
            this.recordOccupyingTile(rectangle, n4);
            if (n8 > 0) {
                n5 = 0;
                for (n6 = n4 + 1; n6 < this.fTileCount - n8; ++n6) {
                    if (n5 < n8 && n6 == nArray[n5]) {
                        ++n5;
                    }
                    this.fComponents[n6] = this.fComponents[n6 + n5];
                    this.fTileCellRect[n6] = this.fTileCellRect[n6 + n5];
                    this.recordOccupyingTile(this.fTileCellRect[n6], n6);
                    if (this.fSelectedTile != n6 + n5) continue;
                    this.setSelectedTile(n6);
                }
                this.fTileCount -= n8;
            }
            this.coalesceRow(rectangle.y);
            if (n8 > 0) {
                this.fireTilesMerged(n4, nArray[0]);
            }
        } else {
            int n9 = this.fTileInCell[rectangle.y + n3][rectangle.x + rectangle.width];
            int n10 = rectangle.height - n3;
            rectangle.height = n3;
            for (int i = this.fTileCount - 1; i >= n9; --i) {
                this.fComponents[i + 1] = this.fComponents[i];
                this.fTileCellRect[i + 1] = this.fTileCellRect[i];
                this.recordOccupyingTile(this.fTileCellRect[i + 1], i + 1);
            }
            this.fTileCellRect[n9] = new Rectangle(rectangle);
            this.fTileCellRect[n9].y += n3;
            this.fTileCellRect[n9].height = n10;
            this.recordOccupyingTile(this.fTileCellRect[n9], n9);
            ++this.fTileCount;
            if (this.fSelectedTile != -1 && this.fSelectedTile > n4) {
                this.setSelectedTile(this.fSelectedTile + 1);
            }
            this.fireTileSplit(n4, 0);
        }
        this.revalidate();
        this.repaint();
    }

    public void ensureAtLeastSize(int n, Dimension dimension) {
        int n2;
        int n3;
        int n4;
        Rectangle rectangle = this.fTileCellRect[n];
        Rectangle rectangle2 = this.getTilePixelRect(n);
        boolean bl = false;
        if (rectangle2.width < dimension.width && rectangle.width < this.fGridSize.width) {
            n4 = dimension.width - rectangle2.width;
            for (n3 = rectangle.x + rectangle.width; n4 > 0 && n3 < this.fGridSize.width; ++n3) {
                n2 = this.fColumnLeft[n3 + 1] - this.fColumnLeft[n3] - this.fCellSpacing - this.fMinimumCellSize.width;
                if (n2 >= n4) {
                    int n5 = n3;
                    this.fColumnLeft[n5] = this.fColumnLeft[n5] + n4;
                    n4 = 0;
                    continue;
                }
                int n6 = n3;
                this.fColumnLeft[n6] = this.fColumnLeft[n6] + n2;
                n4 -= n2;
            }
            for (n3 = rectangle.x; n4 > 0 && n3 > 0; --n3) {
                n2 = this.fColumnLeft[n3] - this.fColumnLeft[n3 - 1] - this.fCellSpacing - this.fMinimumCellSize.width;
                if (n2 >= n4) {
                    int n7 = n3;
                    this.fColumnLeft[n7] = this.fColumnLeft[n7] - n4;
                    n4 = 0;
                    continue;
                }
                int n8 = n3;
                this.fColumnLeft[n8] = this.fColumnLeft[n8] - n2;
                n4 -= n2;
            }
            bl = true;
        }
        if (rectangle2.height < dimension.height && rectangle.height < this.fGridSize.height) {
            n4 = dimension.height - rectangle2.height;
            for (n3 = rectangle.y + rectangle.height; n4 > 0 && n3 < this.fGridSize.height; ++n3) {
                n2 = this.fRowTop[n3 + 1] - this.fRowTop[n3] - this.fCellSpacing - this.fMinimumCellSize.height;
                if (n2 >= n4) {
                    int n9 = n3;
                    this.fRowTop[n9] = this.fRowTop[n9] + n4;
                    n4 = 0;
                    continue;
                }
                int n10 = n3;
                this.fRowTop[n10] = this.fRowTop[n10] + n2;
                n4 -= n2;
            }
            for (n3 = rectangle.y; n4 > 0 && n3 > 0; --n3) {
                n2 = this.fRowTop[n3] - this.fRowTop[n3 - 1] - this.fCellSpacing - this.fMinimumCellSize.height;
                if (n2 >= n4) {
                    int n11 = n3;
                    this.fRowTop[n11] = this.fRowTop[n11] - n4;
                    n4 = 0;
                    continue;
                }
                int n12 = n3;
                this.fRowTop[n12] = this.fRowTop[n12] - n2;
                n4 -= n2;
            }
            bl = true;
        }
        if (bl) {
            this.updateWeights();
            this.revalidate();
            this.repaint();
        }
    }

    public void setMinimumCellSize(Dimension dimension) {
        this.fMinimumCellSize.setSize(dimension);
    }

    public Dimension getMinimumCellSize() {
        return new Dimension(this.fMinimumCellSize);
    }

    public void setContinuousLayout(boolean bl) {
        this.fContinuousLayout = bl;
    }

    public boolean getContinuousLayout() {
        return this.fContinuousLayout;
    }

    public void setCloseButtonsEnabled(boolean bl) {
        if (bl != this.fCloseButtonsEnabled) {
            this.fCloseButtonsEnabled = bl;
            this.repaint();
        }
    }

    public boolean getCloseButtonsEnabled() {
        return this.fCloseButtonsEnabled;
    }

    @Override
    public Component add(Component component) {
        int n = this.getFirstEmptyTile();
        if (n == this.fTileCount) {
            return null;
        }
        return this.add(component, n);
    }

    @Override
    public Component add(Component component, int n) {
        Object object;
        if (this.fComponents[n] != null) {
            this.remove(n);
        }
        this.fComponents[n] = component;
        super.add(component);
        if (component instanceof ItemSelectable) {
            object = (ItemSelectable)((Object)component);
            object.addItemListener(this.fComponentListener);
            Object[] objectArray = object.getSelectedObjects();
            if (objectArray != null && Arrays.asList(objectArray).contains(component)) {
                this.setSelectedTile(n);
            }
        }
        object = this.getTilePixelRect(n);
        component.setBounds((Rectangle)object);
        this.repaint((Rectangle)object);
        return component;
    }

    @Override
    public void remove(Component component) {
        int n = this.getTileContaining(component);
        if (n != -1) {
            this.remove(n);
        }
    }

    @Override
    public void remove(int n) {
        if (this.fInRemove) {
            super.remove(n);
            return;
        }
        this.fInRemove = true;
        Component component = this.fComponents[n];
        if (component != null) {
            if (component instanceof ItemSelectable) {
                ((ItemSelectable)((Object)component)).removeItemListener(this.fComponentListener);
            }
            this.fComponents[n] = null;
            super.remove(component);
            Rectangle rectangle = this.getTilePixelRect(n);
            this.repaint(rectangle);
        }
        this.fInRemove = false;
    }

    @Override
    public void removeAll() {
        for (int i = 0; i < this.fTileCount; ++i) {
            if (this.fComponents[i] != null && this.fComponents[i] instanceof ItemSelectable) {
                ((ItemSelectable)((Object)this.fComponents[i])).removeItemListener(this.fComponentListener);
            }
            this.fComponents[i] = null;
        }
        super.removeAll();
        this.repaint();
    }

    public int getSelectedTile() {
        return this.fSelectedTile;
    }

    public void setSelectedTile(int n) {
        Rectangle rectangle;
        if (this.fSelectedTile == n) {
            return;
        }
        int n2 = this.fSelectedTile;
        this.fSelectedTile = n;
        if (n2 != -1 && n2 < this.fTileCount) {
            rectangle = this.getTilePixelRect(n2);
            this.repaint(rectangle);
        }
        if (n != -1) {
            rectangle = this.getTilePixelRect(n);
            this.repaint(rectangle);
        }
        if (this.fSelectionListener != null) {
            ItemEvent itemEvent;
            if (n2 != -1) {
                itemEvent = new ItemEvent(this, 701, n2, 2);
                this.fSelectionListener.itemStateChanged(itemEvent);
            }
            if (this.fSelectedTile != -1) {
                itemEvent = new ItemEvent(this, 701, this.fSelectedTile, 1);
                this.fSelectionListener.itemStateChanged(itemEvent);
            }
        }
    }

    public Component getComponentInTile(int n) {
        if (n < 0) {
            return null;
        }
        return n >= this.fComponents.length ? null : this.fComponents[n];
    }

    public boolean isTileEmpty(int n) {
        return this.getComponentInTile(n) == null;
    }

    public int getTileContaining(Component component) {
        int n;
        for (n = 0; n < this.fTileCount && this.fComponents[n] != component; ++n) {
        }
        return n == this.fTileCount ? -1 : n;
    }

    public int getFirstEmptyTile() {
        int n;
        for (n = 0; n < this.fTileCount && this.fComponents[n] != null; ++n) {
        }
        return n == this.fTileCount ? -1 : n;
    }

    public int getTileAt(int n, int n2) {
        ElementData elementData = this.getScratchData();
        this.getElementAt(n, n2, 0, elementData);
        return elementData.fElement == 4 ? elementData.fIndex : -1;
    }

    public int getTileAt(Point point) {
        ElementData elementData = this.getScratchData();
        this.getElementAt(point, 0, elementData);
        return elementData.fElement == 4 ? elementData.fIndex : -1;
    }

    private ElementData getScratchData() {
        if (SwingUtilities.isEventDispatchThread()) {
            return this.fScratchData;
        }
        return new ElementData();
    }

    @Override
    public synchronized void addItemListener(ItemListener itemListener) {
        this.fSelectionListener = AWTEventMulticaster.add(this.fSelectionListener, itemListener);
    }

    @Override
    public synchronized void removeItemListener(ItemListener itemListener) {
        this.fSelectionListener = AWTEventMulticaster.remove(this.fSelectionListener, itemListener);
    }

    @Override
    public Object[] getSelectedObjects() {
        if (this.fSelectedTile == -1) {
            return null;
        }
        Object[] objectArray = new Object[]{this.fSelectedTile};
        return objectArray;
    }

    public synchronized void addGridListener(GridListener gridListener) {
        if (this.fGridListeners == null) {
            this.fGridListeners = new ArrayList<GridListener>();
        }
        this.fGridListeners.add(gridListener);
    }

    public synchronized void removeGridListener(GridListener gridListener) {
        if (this.fGridListeners != null) {
            this.fGridListeners.remove(gridListener);
        }
    }

    protected synchronized void fireGridSizeChange(Dimension dimension, Dimension dimension2) {
        if (this.fGridListeners == null) {
            return;
        }
        int n = this.fGridListeners.size();
        for (int i = 0; i < n; ++i) {
            GridListener gridListener = this.fGridListeners.get(i);
            gridListener.gridSizeChanged(this, dimension, dimension2);
        }
    }

    protected synchronized void fireTilesMerged(int n, int n2) {
        if (this.fGridListeners == null) {
            return;
        }
        int n3 = this.fGridListeners.size();
        for (int i = 0; i < n3; ++i) {
            GridListener gridListener = this.fGridListeners.get(i);
            gridListener.tilesMerged(this, n, n2);
        }
    }

    protected synchronized void fireTileSplit(int n, int n2) {
        if (this.fGridListeners == null) {
            return;
        }
        int n3 = this.fGridListeners.size();
        for (int i = 0; i < n3; ++i) {
            GridListener gridListener = this.fGridListeners.get(i);
            gridListener.tileSplit(this, n, n2);
        }
    }

    protected Action getMergeEastWestAction() {
        if (this.fMergeEastWestAction == null) {
            this.fMergeEastWestAction = new MergeEastWestAction();
        }
        return this.fMergeEastWestAction;
    }

    protected Action getMergeNorthSouthAction() {
        if (this.fMergeNorthSouthAction == null) {
            this.fMergeNorthSouthAction = new MergeNorthSouthAction();
        }
        return this.fMergeNorthSouthAction;
    }

    protected Action getSplitEastWestAction() {
        if (this.fSplitEastWestAction == null) {
            this.fSplitEastWestAction = new SplitEastWestAction();
        }
        return this.fSplitEastWestAction;
    }

    protected Action getSplitNorthSouthAction() {
        if (this.fSplitNorthSouthAction == null) {
            this.fSplitNorthSouthAction = new SplitNorthSouthAction();
        }
        return this.fSplitNorthSouthAction;
    }

    @Override
    public void doLayout() {
        if (!this.fIsDragging) {
            int n;
            Dimension dimension = this.getSize();
            Insets insets = this.getInsets();
            dimension.width -= insets.left + insets.right;
            dimension.height -= insets.top + insets.bottom;
            int n2 = dimension.width - 2 * this.fBorderThickness - (this.fGridSize.width - 1) * this.fCellSpacing;
            int n3 = dimension.height - 2 * this.fBorderThickness - (this.fGridSize.height - 1) * this.fCellSpacing;
            if (n2 <= 0) {
                for (n = 0; n <= this.fGridSize.width; ++n) {
                    this.fColumnLeft[n] = 0;
                }
            } else {
                this.fColumnLeft[0] = this.fBorderThickness;
                for (n = 1; n <= this.fGridSize.width; ++n) {
                    this.fColumnLeft[n] = this.fColumnLeft[n - 1] + (int)(this.fColumnWeight[n - 1] * (float)n2) + this.fCellSpacing;
                }
            }
            if (n3 <= 0) {
                for (n = 0; n <= this.fGridSize.height; ++n) {
                    this.fRowTop[n] = 0;
                }
            } else {
                this.fRowTop[0] = this.fBorderThickness;
                for (n = 1; n <= this.fGridSize.height; ++n) {
                    this.fRowTop[n] = this.fRowTop[n - 1] + (int)(this.fRowWeight[n - 1] * (float)n3) + this.fCellSpacing;
                }
            }
        }
        for (int i = 0; i < this.fTileCount; ++i) {
            if (this.fComponents[i] == null) continue;
            this.fComponents[i].setBounds(this.getTilePixelRect(i));
        }
        this.computeCloseBoxes();
    }

    private void computeCloseBoxes() {
        int n;
        int n2;
        Rectangle rectangle;
        Rectangle rectangle2;
        int n3;
        int n4;
        int n5;
        int n6;
        if (this.fHorizontalDividerCloseBox == null) {
            this.fHorizontalDividerCloseBox = new Rectangle[this.fGridSize.height - 1][];
        }
        for (n6 = 0; n6 < this.fGridSize.height - 1; ++n6) {
            if (this.fHorizontalDividerCloseBox[n6] == null) {
                this.fHorizontalDividerCloseBox[n6] = new Rectangle[this.fGridSize.width];
            }
            for (n5 = 0; n5 < this.fGridSize.width; ++n5) {
                n4 = this.fTileInCell[n6][n5];
                n3 = this.fTileInCell[n6 + 1][n5];
                if (n4 == n3) {
                    this.fHorizontalDividerCloseBox[n6][n5] = null;
                    continue;
                }
                rectangle2 = this.fTileCellRect[n4];
                rectangle = this.fTileCellRect[n3];
                if (rectangle2.x != rectangle.x || rectangle2.width != rectangle.width) {
                    this.fHorizontalDividerCloseBox[n6][n5] = null;
                    continue;
                }
                n2 = this.fRowTop[n6 + 1] - this.fCellSpacing;
                n = (this.fColumnLeft[rectangle2.x] + this.fColumnLeft[rectangle2.x + rectangle2.width] >> 1) - this.fCellSpacing;
                if (this.fHorizontalDividerCloseBox[n6][n5] == null) {
                    this.fHorizontalDividerCloseBox[n6][n5] = new Rectangle(n, n2, this.fCellSpacing, this.fCellSpacing);
                    continue;
                }
                this.fHorizontalDividerCloseBox[n6][n5].setBounds(n, n2, this.fCellSpacing, this.fCellSpacing);
            }
        }
        if (this.fVerticalDividerCloseBox == null) {
            this.fVerticalDividerCloseBox = new Rectangle[this.fGridSize.height][];
        }
        for (n6 = 0; n6 < this.fGridSize.height; ++n6) {
            if (this.fVerticalDividerCloseBox[n6] == null) {
                this.fVerticalDividerCloseBox[n6] = new Rectangle[this.fGridSize.width - 1];
            }
            for (n5 = 0; n5 < this.fGridSize.width - 1; ++n5) {
                n4 = this.fTileInCell[n6][n5];
                n3 = this.fTileInCell[n6][n5 + 1];
                if (n4 == n3) {
                    this.fVerticalDividerCloseBox[n6][n5] = null;
                    continue;
                }
                rectangle2 = this.fTileCellRect[n4];
                rectangle = this.fTileCellRect[n3];
                if (rectangle2.y != rectangle.y || rectangle2.height != rectangle.height) {
                    this.fVerticalDividerCloseBox[n6][n5] = null;
                    continue;
                }
                n2 = this.fColumnLeft[n5 + 1] - this.fCellSpacing;
                n = (this.fRowTop[rectangle2.y] + this.fRowTop[rectangle2.y + rectangle2.height] >> 1) - this.fCellSpacing;
                if (this.fVerticalDividerCloseBox[n6][n5] == null) {
                    this.fVerticalDividerCloseBox[n6][n5] = new Rectangle(n2, n, this.fCellSpacing, this.fCellSpacing);
                    continue;
                }
                this.fVerticalDividerCloseBox[n6][n5].setBounds(n2, n, this.fCellSpacing, this.fCellSpacing);
            }
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Color color = graphics2D.getColor();
        Stroke stroke = graphics2D.getStroke();
        for (int i = 0; i < this.fTileCount; ++i) {
            Color color2;
            Rectangle rectangle = this.getTilePixelRect(i);
            if (i == this.fSelectedTile) {
                boolean bl = this.isFocusable() && this.isTileEmpty(i) && !this.hasFocus();
                Color color3 = bl ? UIManager.getColor("inactiveCaption") : UIManager.getColor("List.selectionBackground");
                graphics2D.setColor(color3);
                graphics2D.setStroke(new BasicStroke(5.0f));
                int n = 3;
                int n2 = 7;
                graphics2D.drawRect(rectangle.x + n, rectangle.y + n, rectangle.width - n2, rectangle.height - n2);
            }
            if ((color2 = this.getBackground()).equals(Color.black) || color2.equals(Color.white)) {
                color2 = Color.gray;
            }
            graphics2D.setColor(color2);
            if (this.fTileBordersOption != 1 && (this.fTileBordersOption != 2 || !this.isTileEmpty(i))) continue;
            graphics.draw3DRect(rectangle.x - 1, rectangle.y - 1, rectangle.width + 1, rectangle.height + 1, false);
        }
        if (this.fCloseButtonsEnabled) {
            graphics2D.setColor(ColorUtils.getBlackOrWhiteContrasting(this.getBackground()));
            graphics2D.setStroke(new BasicStroke(1.0f));
            Object object = null;
            if (this.fCellSpacing > 5) {
                object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            if (!this.fIsDragging && this.fHorizontalDividerCloseBox != null && this.fVerticalDividerCloseBox != null) {
                int n;
                for (n = 0; n < this.fGridSize.height - 1; ++n) {
                    for (int i = 0; i < this.fGridSize.width; ++i) {
                        if (this.fHorizontalDividerCloseBox[n][i] == null) continue;
                        this.paintCloseBox(graphics2D, this.fHorizontalDividerCloseBox[n][i]);
                    }
                }
                for (n = 0; n < this.fGridSize.height; ++n) {
                    for (int i = 0; i < this.fGridSize.width - 1; ++i) {
                        if (this.fVerticalDividerCloseBox[n][i] == null) continue;
                        this.paintCloseBox(graphics2D, this.fVerticalDividerCloseBox[n][i]);
                    }
                }
            }
            if (object != null) {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
            }
        }
        graphics2D.setColor(color);
        graphics2D.setStroke(stroke);
        super.paintComponent(graphics);
    }

    private void paintCloseBox(Graphics2D graphics2D, Rectangle rectangle) {
        if (this.fCellSpacing > 5) {
            graphics2D.fillOval(rectangle.x + 1, rectangle.y + 1, rectangle.width - 2, rectangle.height - 2);
        } else if (this.fCellSpacing == 5) {
            graphics2D.fillRect(rectangle.x + 1, rectangle.y + 1, rectangle.width - 2, rectangle.height - 2);
        } else {
            graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    protected Rectangle getTilePixelRect(int n) {
        Rectangle rectangle = this.fTileCellRect[n];
        int n2 = this.fColumnLeft[rectangle.x];
        int n3 = this.fColumnLeft[rectangle.x + rectangle.width] - this.fCellSpacing;
        int n4 = this.fRowTop[rectangle.y];
        int n5 = this.fRowTop[rectangle.y + rectangle.height] - this.fCellSpacing;
        return new Rectangle(n2, n4, n3 - n2, n5 - n4);
    }

    protected final void getElementAt(Point point, int n, ElementData elementData) {
        this.getElementAt(point.x, point.y, n, elementData);
    }

    protected void getElementAt(int n, int n2, int n3, ElementData elementData) {
        boolean bl;
        int n4;
        int n5;
        elementData.fElement = 0;
        if (n2 < this.fRowTop[0]) {
            return;
        }
        int n6 = this.fGridSize.height;
        for (n5 = 0; n5 < n6 && n2 > this.fRowTop[n5 + 1]; ++n5) {
        }
        if (n5 == n6) {
            return;
        }
        if (n < this.fColumnLeft[0]) {
            return;
        }
        int n7 = this.fGridSize.width;
        for (n4 = 0; n4 < n7 && n > this.fColumnLeft[n4 + 1]; ++n4) {
        }
        if (n4 == n7) {
            return;
        }
        boolean bl2 = n5 < n6 - 1 && n2 >= this.fRowTop[n5 + 1] - this.fCellSpacing && (this.fTileInCell[n5][n4] != this.fTileInCell[n5 + 1][n4] || n4 < n7 - 1 && this.fTileInCell[n5][n4 + 1] != this.fTileInCell[n5 + 1][n4 + 1]);
        boolean bl3 = bl = n4 < n7 - 1 && n >= this.fColumnLeft[n4 + 1] - this.fCellSpacing && (this.fTileInCell[n5][n4] != this.fTileInCell[n5][n4 + 1] || n5 < n6 - 1 && this.fTileInCell[n5 + 1][n4] != this.fTileInCell[n5 + 1][n4 + 1]);
        if (bl2 && bl) {
            elementData.fElement = 3;
        } else if (bl2) {
            elementData.fElement = 1;
        } else if (bl) {
            elementData.fElement = 2;
        } else {
            elementData.fElement = 4;
            elementData.fIndex = this.fTileInCell[n5][n4];
        }
        elementData.fRow = n5;
        elementData.fColumn = n4;
    }

    protected void updateCursor(ElementData elementData) {
        int n = 0;
        if (elementData.fElement == 1) {
            n = 8;
        } else if (elementData.fElement == 2) {
            n = 11;
        } else if (elementData.fElement == 3) {
            n = 13;
        }
        if (n != this.fCursorType) {
            this.setCursor(Cursor.getPredefinedCursor(n));
            this.fCursorType = n;
        }
    }

    protected void showPopup(Point point) {
        int n = this.fElementData.fRow;
        int n2 = this.fElementData.fColumn;
        MJPopupMenu mJPopupMenu = null;
        if (this.fElementData.fElement == 1) {
            mJPopupMenu = this.createHorizontalMenu();
            this.fMergeNorthSouthAction.setEnabled(this.fHorizontalDividerCloseBox[n][n2] != null);
        } else if (this.fElementData.fElement == 2) {
            mJPopupMenu = this.createVerticalMenu();
            this.fMergeEastWestAction.setEnabled(this.fVerticalDividerCloseBox[n][n2] != null);
        } else if (this.fElementData.fElement == 4) {
            mJPopupMenu = this.createCellMenu();
        }
        if (mJPopupMenu != null) {
            mJPopupMenu.show(this, point.x, point.y);
        }
    }

    protected MJPopupMenu createVerticalMenu() {
        MJPopupMenu mJPopupMenu = new MJPopupMenu();
        mJPopupMenu.setCleanupUponClose(true);
        mJPopupMenu.add(this.getMergeEastWestAction());
        mJPopupMenu.addPopupMenuListener(this.fPopupListener);
        return mJPopupMenu;
    }

    protected MJPopupMenu createHorizontalMenu() {
        MJPopupMenu mJPopupMenu = new MJPopupMenu();
        mJPopupMenu.setCleanupUponClose(true);
        mJPopupMenu.add(this.getMergeNorthSouthAction());
        mJPopupMenu.addPopupMenuListener(this.fPopupListener);
        return mJPopupMenu;
    }

    protected MJPopupMenu createCellMenu() {
        MJPopupMenu mJPopupMenu = new MJPopupMenu();
        mJPopupMenu.setCleanupUponClose(true);
        mJPopupMenu.add(this.getSplitNorthSouthAction());
        mJPopupMenu.add(this.getSplitEastWestAction());
        mJPopupMenu.addPopupMenuListener(this.fPopupListener);
        return mJPopupMenu;
    }

    protected void updateWeights() {
        int n;
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < this.fGridSize.height; ++n2) {
            n = this.fRowTop[n2 + 1] - this.fRowTop[n2] - this.fCellSpacing;
            n3 += n;
            this.fRowWeight[n2] = n;
        }
        for (n2 = 0; n2 < this.fGridSize.height; ++n2) {
            if (n3 > 0) {
                int n4 = n2;
                this.fRowWeight[n4] = this.fRowWeight[n4] / (float)n3;
                continue;
            }
            this.fRowWeight[n2] = 1.0f / (float)this.fGridSize.height;
        }
        n2 = 0;
        for (n = 0; n < this.fGridSize.width; ++n) {
            int n5 = this.fColumnLeft[n + 1] - this.fColumnLeft[n] - this.fCellSpacing;
            n2 += n5;
            this.fColumnWeight[n] = n5;
        }
        for (n = 0; n < this.fGridSize.width; ++n) {
            if (n2 > 0) {
                int n6 = n;
                this.fColumnWeight[n6] = this.fColumnWeight[n6] / (float)n2;
                continue;
            }
            this.fColumnWeight[n] = 1.0f / (float)this.fGridSize.width;
        }
    }

    protected void mergeTiles(int n, int n2) {
        int n3;
        this.remove(n);
        int n4 = n < n2 ? n : n2;
        this.fTileCellRect[n4] = this.fTileCellRect[n].union(this.fTileCellRect[n2]);
        this.recordOccupyingTile(this.fTileCellRect[n4], n4);
        this.fComponents[n4] = this.fComponents[n2];
        --this.fTileCount;
        for (int i = n3 = n > n2 ? n : n2; i < this.fTileCount; ++i) {
            this.fComponents[i] = this.fComponents[i + 1];
            this.fTileCellRect[i] = this.fTileCellRect[i + 1];
            this.recordOccupyingTile(this.fTileCellRect[i], i);
        }
        this.fComponents[this.fTileCount] = null;
        if (this.fSelectedTile != -1 && this.fSelectedTile >= n) {
            this.setSelectedTile(this.fSelectedTile - 1);
        }
    }

    protected void coalesceRow(int n) {
        int n2;
        int n3;
        int n4 = this.fTileInCell[n][0];
        int n5 = this.fTileCellRect[n4].y;
        int n6 = n5 + this.fTileCellRect[n4].height;
        int n7 = n6 - n5;
        for (n3 = 1; n3 < this.fGridSize.width && n7 > 1; ++n3) {
            int n8;
            n4 = this.fTileInCell[n][n3];
            n2 = this.fTileCellRect[n4].y;
            if (n2 > n5) {
                n5 = n2;
            }
            if ((n8 = n2 + this.fTileCellRect[n4].height) < n6) {
                n6 = n8;
            }
            n7 = n6 - n5;
        }
        if (n7 > 1) {
            n2 = -1;
            for (n3 = 0; n3 < this.fGridSize.width; ++n3) {
                n4 = this.fTileInCell[n5][n3];
                if (n4 == n2) continue;
                this.fTileCellRect[n4].height -= n7 - 1;
                n2 = n4;
            }
            Dimension dimension = new Dimension(this.fGridSize.width, this.fGridSize.height - n7 + 1);
            int[][] nArrayArray = new int[dimension.height][];
            int[] nArray = new int[dimension.height + 1];
            for (n = 0; n <= n5; ++n) {
                nArrayArray[n] = this.fTileInCell[n];
                nArray[n] = this.fRowTop[n];
            }
            int[] nArray2 = new int[dimension.width];
            for (n3 = 0; n3 < nArray2.length; ++n3) {
                nArray2[n3] = -1;
            }
            while (n < dimension.height) {
                nArrayArray[n] = this.fTileInCell[n + n7 - 1];
                nArray[n] = this.fRowTop[n + n7 - 1];
                int n9 = -1;
                for (n3 = 0; n3 < this.fGridSize.width; ++n3) {
                    n4 = nArrayArray[n][n3];
                    if (n4 == n9 || n4 == nArray2[n3] || n4 == this.fTileInCell[n5][n3]) continue;
                    this.fTileCellRect[n4].y -= n7 - 1;
                    n9 = n4;
                    nArray2[n3] = n4;
                }
                ++n;
            }
            nArray[dimension.height] = this.fRowTop[this.fGridSize.height];
            Dimension dimension2 = this.fGridSize;
            this.fGridSize = dimension;
            this.fTileInCell = nArrayArray;
            this.fRowTop = nArray;
            this.updateWeights();
            this.fireGridSizeChange(dimension2, dimension);
        }
    }

    protected void coalesceColumn(int n) {
        int n2;
        int n3;
        Object object = this.fTileInCell[0][n];
        int n4 = this.fTileCellRect[object].x;
        int n5 = n4 + this.fTileCellRect[object].width;
        int n6 = n5 - n4;
        for (n3 = 1; n3 < this.fGridSize.height && n6 > 1; ++n3) {
            int n7;
            object = this.fTileInCell[n3][n];
            n2 = this.fTileCellRect[object].x;
            if (n2 > n4) {
                n4 = n2;
            }
            if ((n7 = n2 + this.fTileCellRect[object].width) < n5) {
                n5 = n7;
            }
            n6 = n5 - n4;
        }
        if (n6 > 1) {
            Object object2;
            n2 = -1;
            for (n3 = 0; n3 < this.fGridSize.height; ++n3) {
                object = this.fTileInCell[n3][n4];
                if (object == n2) continue;
                this.fTileCellRect[object].width -= n6 - 1;
                n2 = object;
            }
            Dimension dimension = new Dimension(this.fGridSize.width - n6 + 1, this.fGridSize.height);
            int[] nArray = new int[dimension.width + 1];
            for (n = 0; n <= n4; ++n) {
                nArray[n] = this.fColumnLeft[n];
            }
            while (n <= dimension.width) {
                nArray[n] = this.fColumnLeft[n + n6 - 1];
                ++n;
            }
            this.fColumnLeft = nArray;
            int[] nArray2 = new int[dimension.width];
            for (n = n4; n < nArray2.length; ++n) {
                nArray2[n] = -1;
            }
            for (n3 = 0; n3 < this.fGridSize.height; ++n3) {
                object2 = new int[dimension.width];
                for (n = 0; n <= n4; ++n) {
                    object2[n] = this.fTileInCell[n3][n];
                }
                Object object3 = -1;
                while (n < dimension.width) {
                    object2[n] = this.fTileInCell[n3][n + n6 - 1];
                    object = object2[n];
                    if (object != object3 && object != nArray2[n] && object != this.fTileInCell[n3][n4]) {
                        this.fTileCellRect[object].x -= n6 - 1;
                        nArray2[n] = object;
                        object3 = object;
                    }
                    ++n;
                }
                this.fTileInCell[n3] = (int[])object2;
            }
            object2 = this.fGridSize;
            this.fGridSize = dimension;
            this.updateWeights();
            this.fireGridSizeChange((Dimension)object2, dimension);
        }
    }

    protected void recordOccupyingTile(Rectangle rectangle, int n) {
        int n2 = rectangle.y + rectangle.height;
        int n3 = rectangle.x + rectangle.width;
        for (int i = rectangle.y; i < n2; ++i) {
            for (int j = rectangle.x; j < n3; ++j) {
                this.fTileInCell[i][j] = n;
            }
        }
    }

    protected void mergeNorthSouth(int n, int n2) {
        int n3 = this.fTileInCell[n][n2];
        int n4 = this.fTileInCell[n + 1][n2];
        if (this.fComponents[n4] != null && (this.fComponents[n3] == null || n4 == this.fSelectedTile)) {
            this.mergeTiles(n3, n4);
        } else {
            this.mergeTiles(n4, n3);
        }
        this.coalesceRow(n);
        this.invalidate();
        this.validate();
        this.repaint();
        this.fireTilesMerged(n3, n4);
    }

    protected void mergeEastWest(int n, int n2) {
        int n3 = this.fTileInCell[n][n2];
        int n4 = this.fTileInCell[n][n2 + 1];
        if (this.fComponents[n4] != null && (this.fComponents[n3] == null || n4 == this.fSelectedTile)) {
            this.mergeTiles(n3, n4);
        } else {
            this.mergeTiles(n4, n3);
        }
        this.coalesceColumn(n2);
        this.invalidate();
        this.validate();
        this.repaint();
        this.fireTilesMerged(n3, n4);
    }

    protected void splitNorthSouth(int n, int n2) {
        int n3 = this.fTileInCell[n][n2];
        Rectangle rectangle = this.fTileCellRect[n3];
        Rectangle rectangle2 = new Rectangle(rectangle);
        boolean bl = false;
        if (rectangle.height > 1) {
            rectangle2.y = n > rectangle.y ? n : n + 1;
            rectangle.height = rectangle2.y - rectangle.y;
            rectangle2.height -= rectangle.height;
        } else {
            int n4;
            int n5;
            bl = true;
            rectangle2.y = n + 1;
            rectangle2.height = 1;
            Dimension dimension = new Dimension(this.fGridSize.width, this.fGridSize.height + 1);
            int[][] nArrayArray = new int[dimension.height][];
            int[] nArray = new int[dimension.height + 1];
            for (n5 = 0; n5 <= n; ++n5) {
                nArrayArray[n5] = this.fTileInCell[n5];
                nArray[n5] = this.fRowTop[n5];
            }
            nArrayArray[n5] = new int[this.fGridSize.width];
            int n6 = -1;
            int n7 = -1;
            for (int i = 0; i < this.fGridSize.width; ++i) {
                nArrayArray[n5][i] = n4 = this.fTileInCell[n5 - 1][i];
                if (n4 != n3 && n4 != n6) {
                    ++this.fTileCellRect[n4].height;
                }
                n6 = n4;
                if (i >= n2) continue;
                n7 = n4;
            }
            nArray[n5] = this.fRowTop[n5 - 1] + this.fRowTop[n5] >> 1;
            for (n4 = n7 + 1; n4 < this.fTileCount; ++n4) {
                if (n4 == n3 || this.fTileCellRect[n4].y <= n) continue;
                ++this.fTileCellRect[n4].y;
            }
            ++n5;
            while (n5 < dimension.height) {
                nArrayArray[n5] = this.fTileInCell[n5 - 1];
                nArray[n5] = this.fRowTop[n5 - 1];
                ++n5;
            }
            nArray[dimension.height] = this.fRowTop[this.fGridSize.height];
            Dimension dimension2 = this.fGridSize;
            this.fGridSize = dimension;
            this.fTileInCell = nArrayArray;
            this.fRowTop = nArray;
            this.fRowWeight = new float[this.fGridSize.height];
            this.updateWeights();
            this.fHorizontalDividerCloseBox = null;
            this.fVerticalDividerCloseBox = null;
            this.fireGridSizeChange(dimension2, dimension);
        }
        this.insertTile(rectangle2);
        if (!bl) {
            this.coalesceRow(n);
        }
        this.fireTileSplit(n3, 0);
        this.revalidate();
        this.repaint();
    }

    protected void splitEastWest(int n, int n2) {
        int n3 = this.fTileInCell[n][n2];
        Rectangle rectangle = this.fTileCellRect[n3];
        Rectangle rectangle2 = new Rectangle(rectangle);
        boolean bl = false;
        if (rectangle.width > 1) {
            rectangle2.x = n2 > rectangle.x ? n2 : n2 + 1;
            rectangle.width = rectangle2.x - rectangle.x;
            rectangle2.width -= rectangle.width;
        } else {
            int n4;
            int[] nArray;
            bl = true;
            rectangle2.x = n2 + 1;
            rectangle2.width = 1;
            Dimension dimension = new Dimension(this.fGridSize.width + 1, this.fGridSize.height);
            int n5 = -1;
            for (int i = 0; i < this.fGridSize.height; ++i) {
                int n6;
                nArray = new int[dimension.width];
                for (n4 = 0; n4 <= n2; ++n4) {
                    nArray[n4] = this.fTileInCell[i][n4];
                }
                nArray[n4] = n6 = this.fTileInCell[i][n4 - 1];
                if (n6 != n3 && n6 != n5) {
                    ++this.fTileCellRect[n6].width;
                    n5 = n6;
                }
                int n7 = n6;
                ++n4;
                while (n4 < dimension.width) {
                    nArray[n4] = n6 = this.fTileInCell[i][n4 - 1];
                    if (n6 != n7 && this.fTileCellRect[n6].y == i) {
                        ++this.fTileCellRect[n6].x;
                    }
                    n7 = n6;
                    ++n4;
                }
                this.fTileInCell[i] = nArray;
            }
            nArray = new int[dimension.width + 1];
            for (n4 = 0; n4 <= n2; ++n4) {
                nArray[n4] = this.fColumnLeft[n4];
            }
            nArray[n4] = this.fColumnLeft[n4 - 1] + this.fColumnLeft[n4] >> 1;
            ++n4;
            while (n4 <= dimension.width) {
                nArray[n4] = this.fColumnLeft[n4 - 1];
                ++n4;
            }
            this.fColumnLeft = nArray;
            this.fColumnWeight = new float[dimension.width];
            Dimension dimension2 = this.fGridSize;
            this.fGridSize = dimension;
            this.updateWeights();
            this.fHorizontalDividerCloseBox = null;
            this.fVerticalDividerCloseBox = null;
            this.fireGridSizeChange(dimension2, dimension);
        }
        this.insertTile(rectangle2);
        if (!bl) {
            this.coalesceColumn(n2);
        }
        this.fireTileSplit(n3, 1);
        this.revalidate();
        this.repaint();
    }

    protected void insertTile(Rectangle rectangle) {
        int n;
        int n2 = this.fGridSize.width * this.fGridSize.height;
        Component[] componentArray = new Component[n2];
        Rectangle[] rectangleArray = new Rectangle[n2];
        int n3 = -1;
        int n4 = -1;
        if (rectangle.x > 0) {
            n3 = this.fTileInCell[rectangle.y][rectangle.x - 1];
        }
        if (rectangle.y > 0) {
            n4 = this.fTileInCell[rectangle.y - 1][rectangle.x];
        }
        int n5 = n3 > n4 ? n3 : n4;
        for (n = 0; n <= n5; ++n) {
            componentArray[n] = this.fComponents[n];
            rectangleArray[n] = this.fTileCellRect[n];
        }
        rectangleArray[n] = rectangle;
        this.recordOccupyingTile(rectangle, n);
        while (n < this.fTileCount) {
            componentArray[n + 1] = this.fComponents[n];
            rectangleArray[n + 1] = this.fTileCellRect[n];
            this.recordOccupyingTile(this.fTileCellRect[n], n + 1);
            ++n;
        }
        this.fTileCellRect = rectangleArray;
        this.fComponents = componentArray;
        ++this.fTileCount;
    }

    private void showDividerCloseButton(Rectangle rectangle) {
        if (sCloseIcon == null) {
            sCloseIcon = new ContrastingIcon(MJTiledPane.class.getResource("resources/whiteclosebox.gif"), MJTiledPane.class.getResource("resources/closebox.gif"));
        }
        MJButton mJButton = new MJButton(sCloseIcon);
        mJButton.setPreferredSize(new Dimension(20, 20));
        mJButton.setFocusTraversable(false);
        mJButton.setDefaultCapable(false);
        if (PlatformInfo.isMacintosh()) {
            mJButton.setBorderPainted(false);
        }
        CloseButtonHandler closeButtonHandler = new CloseButtonHandler();
        mJButton.addActionListener(closeButtonHandler);
        mJButton.addMouseListener(closeButtonHandler);
        Point point = rectangle.getLocation();
        int n = 20 - this.fCellSpacing >> 1;
        point.x -= n;
        point.y -= n;
        SwingUtilities.convertPointToScreen(point, this);
        if (this.fDividerClosePopup != null) {
            this.fDividerClosePopup.hide();
            this.fDividerClosePopup = null;
        }
        if (this.fCloseButtonHideTimer == null) {
            this.fCloseButtonHideTimer = new Timer(100, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (MJTiledPane.this.fDividerClosePopup != null) {
                        MJTiledPane.this.fDividerClosePopup.hide();
                        MJTiledPane.this.fDividerClosePopup = null;
                    }
                }
            });
            this.fCloseButtonHideTimer.setRepeats(false);
        }
        this.fDividerClosePopup = MPopup.getPopup(this, mJButton, point.x, point.y);
        this.fCloseButtonHideTimer.restart();
        this.fDividerClosePopup.show();
    }

    public Object getState() {
        return new State(this);
    }

    public void restoreState(Object object) {
        int n;
        if (!(object instanceof State)) {
            throw new IllegalArgumentException("Argument must be of class MJTiledPane.State");
        }
        State state = (State)object;
        this.fGridSize = state.fGridSize;
        this.fTileCount = state.fTileCount;
        this.fTileCellRect = state.fTileCellRect;
        this.fColumnLeft = state.fColumnLeft;
        this.fRowTop = state.fRowTop;
        this.fColumnWeight = state.fColumnWeight;
        this.fRowWeight = state.fRowWeight;
        this.fComponents = new Component[this.fGridSize.width * this.fGridSize.height];
        this.fTileInCell = new int[this.fGridSize.height][];
        for (n = 0; n < this.fGridSize.height; ++n) {
            this.fTileInCell[n] = new int[this.fGridSize.width];
        }
        for (n = 0; n < this.fTileCount; ++n) {
            this.recordOccupyingTile(this.fTileCellRect[n], n);
        }
    }

    public static int getTileCountFromState(Object object) {
        if (!(object instanceof State)) {
            throw new IllegalArgumentException("Argument must be of class MJTiledPane.State");
        }
        return ((State)object).fTileCount;
    }

    public static Element stateToXML(Object object, Document document) {
        return ((State)object).toXML(document);
    }

    public static Object stateFromXML(SimpleElement simpleElement) throws DataFormatException {
        return new State(simpleElement);
    }

    static {
        sNoElementData = new ElementData(0);
    }

    private static class State {
        Dimension fGridSize;
        int fTileCount;
        Rectangle[] fTileCellRect;
        int[] fColumnLeft;
        int[] fRowTop;
        float[] fColumnWeight;
        float[] fRowWeight;

        State(MJTiledPane mJTiledPane) {
            this.fGridSize = new Dimension(mJTiledPane.fGridSize);
            this.fTileCount = mJTiledPane.fTileCount;
            this.fTileCellRect = new Rectangle[mJTiledPane.fTileCellRect.length];
            for (int i = 0; i < this.fTileCellRect.length; ++i) {
                if (mJTiledPane.fTileCellRect[i] == null) continue;
                this.fTileCellRect[i] = new Rectangle(mJTiledPane.fTileCellRect[i]);
            }
            this.fColumnLeft = new int[mJTiledPane.fColumnLeft.length];
            System.arraycopy(mJTiledPane.fColumnLeft, 0, this.fColumnLeft, 0, this.fColumnLeft.length);
            this.fRowTop = new int[mJTiledPane.fRowTop.length];
            System.arraycopy(mJTiledPane.fRowTop, 0, this.fRowTop, 0, this.fRowTop.length);
            this.fColumnWeight = new float[mJTiledPane.fColumnWeight.length];
            System.arraycopy(mJTiledPane.fColumnWeight, 0, this.fColumnWeight, 0, this.fColumnWeight.length);
            this.fRowWeight = new float[mJTiledPane.fRowWeight.length];
            System.arraycopy(mJTiledPane.fRowWeight, 0, this.fRowWeight, 0, this.fRowWeight.length);
        }

        State(SimpleElement simpleElement) throws DataFormatException {
            SimpleElement simpleElement2;
            int n;
            assert (MJTiledPane.TILES_TAG.equals(simpleElement.getTagName()));
            this.fGridSize = new Dimension();
            String string = simpleElement.getAttribute(MJTiledPane.COLUMNS_ATTRIBUTE);
            try {
                this.fGridSize.width = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new DataFormatException("Invalid Columns: " + string);
            }
            string = simpleElement.getAttribute(MJTiledPane.ROWS_ATTRIBUTE);
            try {
                this.fGridSize.height = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new DataFormatException("Invalid Rows: " + string);
            }
            string = simpleElement.getAttribute(MJTiledPane.COUNT_ATTRIBUTE);
            try {
                this.fTileCount = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new DataFormatException("Invalid Count: " + string);
            }
            this.fColumnLeft = new int[this.fGridSize.width + 1];
            this.fColumnWeight = new float[this.fGridSize.width];
            SimpleNodeList simpleNodeList = simpleElement.getChildrenByTagName(MJTiledPane.COLUMN_TAG);
            int n2 = simpleNodeList.getLength();
            for (n = 0; n < n2 && n <= this.fGridSize.width; ++n) {
                simpleElement2 = (SimpleElement)simpleNodeList.item(n);
                string = simpleElement2.getAttribute(MJTiledPane.LEFT_ATTRIBUTE);
                try {
                    this.fColumnLeft[n] = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new DataFormatException("Invalid Left: " + string);
                }
                if (n >= this.fColumnWeight.length) continue;
                string = simpleElement2.getAttribute(MJTiledPane.WEIGHT_ATTRIBUTE);
                try {
                    this.fColumnWeight[n] = Float.parseFloat(string);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new DataFormatException("Invalid Weight: " + string);
                }
            }
            this.fRowTop = new int[this.fGridSize.height + 1];
            this.fRowWeight = new float[this.fGridSize.height];
            simpleNodeList = simpleElement.getChildrenByTagName(MJTiledPane.ROW_TAG);
            n2 = simpleNodeList.getLength();
            for (n = 0; n < n2 && n <= this.fGridSize.height; ++n) {
                simpleElement2 = (SimpleElement)simpleNodeList.item(n);
                string = simpleElement2.getAttribute(MJTiledPane.TOP_ATTRIBUTE);
                try {
                    this.fRowTop[n] = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new DataFormatException("Invalid Top: " + string);
                }
                if (n >= this.fRowWeight.length) continue;
                string = simpleElement2.getAttribute(MJTiledPane.WEIGHT_ATTRIBUTE);
                try {
                    this.fRowWeight[n] = Float.parseFloat(string);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new DataFormatException("Invalid Weight: " + string);
                }
            }
            this.fTileCellRect = new Rectangle[this.fGridSize.width * this.fGridSize.height];
            simpleNodeList = simpleElement.getChildrenByTagName(MJTiledPane.TILE_TAG);
            n2 = simpleNodeList.getLength();
            for (n = 0; n < n2 && n < this.fTileCount; ++n) {
                simpleElement2 = (SimpleElement)simpleNodeList.item(n);
                this.fTileCellRect[n] = new Rectangle();
                string = simpleElement2.getAttribute(MJTiledPane.X_ATTRIBUTE);
                try {
                    this.fTileCellRect[n].x = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new DataFormatException("Invalid X: " + string);
                }
                string = simpleElement2.getAttribute(MJTiledPane.Y_ATTRIBUTE);
                try {
                    this.fTileCellRect[n].y = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new DataFormatException("Invalid Y: " + string);
                }
                string = simpleElement2.getAttribute(MJTiledPane.WIDTH_ATTRIBUTE);
                try {
                    this.fTileCellRect[n].width = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new DataFormatException("Invalid Width: " + string);
                }
                string = simpleElement2.getAttribute(MJTiledPane.HEIGHT_ATTRIBUTE);
                try {
                    this.fTileCellRect[n].height = Integer.parseInt(string);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new DataFormatException("Invalid Height: " + string);
                }
            }
        }

        public Element toXML(Document document) {
            Element element;
            int n;
            Element element2 = document.createElement(MJTiledPane.TILES_TAG);
            element2.setAttribute(MJTiledPane.COLUMNS_ATTRIBUTE, Integer.toString(this.fGridSize.width));
            element2.setAttribute(MJTiledPane.ROWS_ATTRIBUTE, Integer.toString(this.fGridSize.height));
            element2.setAttribute(MJTiledPane.COUNT_ATTRIBUTE, Integer.toString(this.fTileCount));
            NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.US);
            numberFormat.setMaximumFractionDigits(4);
            for (n = 0; n <= this.fGridSize.width; ++n) {
                element = document.createElement(MJTiledPane.COLUMN_TAG);
                element.setAttribute(MJTiledPane.LEFT_ATTRIBUTE, Integer.toString(this.fColumnLeft[n]));
                if (n < this.fColumnWeight.length) {
                    element.setAttribute(MJTiledPane.WEIGHT_ATTRIBUTE, numberFormat.format(this.fColumnWeight[n]));
                }
                element2.appendChild(element);
            }
            for (n = 0; n <= this.fGridSize.height; ++n) {
                element = document.createElement(MJTiledPane.ROW_TAG);
                element.setAttribute(MJTiledPane.TOP_ATTRIBUTE, Integer.toString(this.fRowTop[n]));
                if (n < this.fRowWeight.length) {
                    element.setAttribute(MJTiledPane.WEIGHT_ATTRIBUTE, numberFormat.format(this.fRowWeight[n]));
                }
                element2.appendChild(element);
            }
            for (n = 0; n < this.fTileCount; ++n) {
                element = document.createElement(MJTiledPane.TILE_TAG);
                Rectangle rectangle = this.fTileCellRect[n];
                element.setAttribute(MJTiledPane.X_ATTRIBUTE, Integer.toString(rectangle.x));
                element.setAttribute(MJTiledPane.Y_ATTRIBUTE, Integer.toString(rectangle.y));
                element.setAttribute(MJTiledPane.WIDTH_ATTRIBUTE, Integer.toString(rectangle.width));
                element.setAttribute(MJTiledPane.HEIGHT_ATTRIBUTE, Integer.toString(rectangle.height));
                element2.appendChild(element);
            }
            return element2;
        }
    }

    protected class NavigationAction
    extends MJAbstractAction {
        int fDirection;

        public NavigationAction(int n) {
            this.fDirection = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (MJTiledPane.this.fSelectedTile == -1) {
                return;
            }
            Rectangle rectangle = MJTiledPane.this.fTileCellRect[MJTiledPane.this.fSelectedTile];
            int n = -1;
            switch (this.fDirection) {
                case 37: {
                    if (rectangle.x <= 0) break;
                    n = MJTiledPane.this.fTileInCell[rectangle.y][rectangle.x - 1];
                    break;
                }
                case 39: {
                    int n2 = rectangle.x + rectangle.width;
                    if (n2 >= MJTiledPane.this.fGridSize.width) break;
                    n = MJTiledPane.this.fTileInCell[rectangle.y][n2];
                    break;
                }
                case 38: {
                    if (rectangle.y <= 0) break;
                    n = MJTiledPane.this.fTileInCell[rectangle.y - 1][rectangle.x];
                    break;
                }
                case 40: {
                    int n3 = rectangle.y + rectangle.height;
                    if (n3 >= MJTiledPane.this.fGridSize.height) break;
                    n = MJTiledPane.this.fTileInCell[n3][rectangle.x];
                }
            }
            if (n != -1) {
                MJTiledPane.this.setSelectedTile(n);
                if (MJTiledPane.this.isFocusable() && MJTiledPane.this.isTileEmpty(n)) {
                    MJTiledPane.this.requestFocus();
                }
            }
        }
    }

    protected class SplitEastWestAction
    extends MJAbstractAction {
        public SplitEastWestAction() {
            super(MJUtilities.intlString("action.SplitEastWest"));
            if (sSplitEastWestIcon == null) {
                sSplitEastWestIcon = new ImageIcon(MJTiledPane.class.getResource("resources/spliteastwest.gif"));
            }
            this.putValue("SmallIcon", sSplitEastWestIcon);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MJTiledPane.this.splitEastWest(MJTiledPane.this.fElementData.fRow, MJTiledPane.this.fElementData.fColumn);
        }
    }

    protected class SplitNorthSouthAction
    extends MJAbstractAction {
        public SplitNorthSouthAction() {
            super(MJUtilities.intlString("action.SplitNorthSouth"));
            if (sSplitNorthSouthIcon == null) {
                sSplitNorthSouthIcon = new ImageIcon(MJTiledPane.class.getResource("resources/splitnorthsouth.gif"));
            }
            this.putValue("SmallIcon", sSplitNorthSouthIcon);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MJTiledPane.this.splitNorthSouth(MJTiledPane.this.fElementData.fRow, MJTiledPane.this.fElementData.fColumn);
        }
    }

    protected class MergeEastWestAction
    extends MJAbstractAction {
        public MergeEastWestAction() {
            super(MJUtilities.intlString("action.Merge"));
            if (sMergeEastWestIcon == null) {
                sMergeEastWestIcon = new ImageIcon(MJTiledPane.class.getResource("resources/mergeeastwest.gif"));
            }
            this.putValue("SmallIcon", sMergeEastWestIcon);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MJTiledPane.this.mergeEastWest(MJTiledPane.this.fElementData.fRow, MJTiledPane.this.fElementData.fColumn);
        }
    }

    protected class MergeNorthSouthAction
    extends MJAbstractAction {
        public MergeNorthSouthAction() {
            super(MJUtilities.intlString("action.Merge"));
            if (sMergeNorthSouthIcon == null) {
                sMergeNorthSouthIcon = new ImageIcon(MJTiledPane.class.getResource("resources/mergenorthsouth.gif"));
            }
            this.putValue("SmallIcon", sMergeNorthSouthIcon);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MJTiledPane.this.mergeNorthSouth(MJTiledPane.this.fElementData.fRow, MJTiledPane.this.fElementData.fColumn);
        }
    }

    class LocalFocusListener
    implements FocusListener {
        LocalFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            this.repaintSelectedTile();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            this.repaintSelectedTile();
        }

        void repaintSelectedTile() {
            if (MJTiledPane.this.fSelectedTile != -1) {
                MJTiledPane.this.repaint(MJTiledPane.this.getTilePixelRect(MJTiledPane.this.fSelectedTile));
            }
        }
    }

    class PopupStateListener
    implements PopupMenuListener {
        PopupStateListener() {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            MJTiledPane.this.fIsShowingPopup = true;
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            MJTiledPane.this.fIsShowingPopup = false;
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            MJTiledPane.this.fIsShowingPopup = false;
        }
    }

    class ComponentItemListener
    implements ItemListener {
        ComponentItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            Component component = (Component)itemEvent.getSource();
            int n = MJTiledPane.this.getTileContaining(component);
            if (itemEvent.getStateChange() == 1) {
                MJTiledPane.this.setSelectedTile(n);
            }
        }
    }

    class CloseButtonHandler
    extends MouseAdapter
    implements ActionListener {
        CloseButtonHandler() {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            MJTiledPane.this.fCloseButtonHideTimer.stop();
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (MJTiledPane.this.fDividerClosePopup != null) {
                MJTiledPane.this.fDividerClosePopup.hide();
                MJTiledPane.this.fDividerClosePopup = null;
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (MJTiledPane.this.fDividerClosePopup != null) {
                MJTiledPane.this.fDividerClosePopup.hide();
                MJTiledPane.this.fDividerClosePopup = null;
            }
            if (MJTiledPane.this.fElementData.fElement == 1) {
                MJTiledPane.this.mergeNorthSouth(MJTiledPane.this.fElementData.fRow, MJTiledPane.this.fElementData.fColumn);
            } else if (MJTiledPane.this.fElementData.fElement == 2) {
                MJTiledPane.this.mergeEastWest(MJTiledPane.this.fElementData.fRow, MJTiledPane.this.fElementData.fColumn);
            }
        }
    }

    class TiledPaneMouseListener
    extends MouseInputAdapter {
        boolean iDragArmed;
        boolean iIsGroupDrag;
        Point iLastPoint = new Point();
        Point iDragPosition = new Point();
        Point iDragLowerLimit = new Point();
        Point iDragUpperLimit = new Point();

        TiledPaneMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (MJTiledPane.this.fIsShowingPopup && !MJUtilities.isPopupPrecursor(mouseEvent)) {
                return;
            }
            Point point = mouseEvent.getPoint();
            MJTiledPane.this.getElementAt(point, 0, MJTiledPane.this.fElementData);
            if (MJTiledPane.this.fElementData.fElement == 3) {
                this.iLastPoint.setLocation(point);
                this.iDragArmed = true;
            } else if (mouseEvent.isPopupTrigger()) {
                MJTiledPane.this.showPopup(point);
            } else if (MJTiledPane.this.fElementData.fElement == 4) {
                if (MJTiledPane.this.isFocusable() && MJTiledPane.this.isTileEmpty(MJTiledPane.this.fElementData.fIndex)) {
                    MJTiledPane.this.requestFocus();
                }
                if (MJTiledPane.this.fSelectedTile != MJTiledPane.this.fElementData.fIndex) {
                    MJTiledPane.this.setSelectedTile(MJTiledPane.this.fElementData.fIndex);
                } else if ((mouseEvent.getModifiers() & 2) != 0) {
                    MJTiledPane.this.setSelectedTile(-1);
                }
            } else if (MJTiledPane.this.fElementData.fElement == 1 || MJTiledPane.this.fElementData.fElement == 2) {
                if (MJUtilities.isPopupPrecursor(mouseEvent)) {
                    MJTiledPane.this.setCursor(Cursor.getDefaultCursor());
                } else {
                    this.iLastPoint.setLocation(point);
                    this.iDragArmed = true;
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                MJTiledPane.this.showPopup(mouseEvent.getPoint());
            } else if (MJTiledPane.this.fIsDragging) {
                MJTiledPane.this.updateWeights();
                MJTiledPane.this.revalidate();
                MJTiledPane.this.repaint();
                MJTiledPane.this.fIsDragging = false;
            }
            this.iDragArmed = false;
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            int n;
            int n2;
            if (MJTiledPane.this.fIsShowingPopup) {
                return;
            }
            if (!MJTiledPane.this.fIsDragging && this.iDragArmed) {
                this.iDragArmed = false;
                MJTiledPane.this.fIsDragging = true;
                this.iIsGroupDrag = mouseEvent.isAltDown();
                if (MJTiledPane.this.fElementData.fElement == 1 || MJTiledPane.this.fElementData.fElement == 3) {
                    n2 = MJTiledPane.this.fElementData.fRow + 1;
                    this.iDragPosition.y = MJTiledPane.this.fRowTop[n2] - MJTiledPane.this.fCellSpacing;
                    if (this.iIsGroupDrag) {
                        n = MJTiledPane.this.fGridSize.height;
                        this.iDragLowerLimit.y = this.iDragPosition.y - MJTiledPane.this.fRowTop[1] + MJTiledPane.this.fRowTop[0] + MJTiledPane.this.fMinimumCellSize.height;
                        this.iDragUpperLimit.y = this.iDragPosition.y + MJTiledPane.this.fRowTop[n] - MJTiledPane.this.fRowTop[n - 1] - MJTiledPane.this.fMinimumCellSize.height - MJTiledPane.this.fCellSpacing;
                    } else {
                        this.iDragLowerLimit.y = MJTiledPane.this.fRowTop[n2 - 1] + MJTiledPane.this.fMinimumCellSize.height;
                        this.iDragUpperLimit.y = MJTiledPane.this.fRowTop[n2 + 1] - MJTiledPane.this.fCellSpacing - MJTiledPane.this.fMinimumCellSize.height;
                    }
                }
                if (MJTiledPane.this.fElementData.fElement == 2 || MJTiledPane.this.fElementData.fElement == 3) {
                    n2 = MJTiledPane.this.fElementData.fColumn + 1;
                    this.iDragPosition.x = MJTiledPane.this.fColumnLeft[n2] - MJTiledPane.this.fCellSpacing;
                    if (this.iIsGroupDrag) {
                        n = MJTiledPane.this.fGridSize.width;
                        this.iDragLowerLimit.x = this.iDragPosition.x - MJTiledPane.this.fColumnLeft[1] + MJTiledPane.this.fColumnLeft[0] + MJTiledPane.this.fMinimumCellSize.width;
                        this.iDragUpperLimit.x = this.iDragPosition.x + MJTiledPane.this.fColumnLeft[n] - MJTiledPane.this.fColumnLeft[n - 1] - MJTiledPane.this.fMinimumCellSize.width - MJTiledPane.this.fCellSpacing;
                    } else {
                        this.iDragLowerLimit.x = MJTiledPane.this.fColumnLeft[n2 - 1] + MJTiledPane.this.fMinimumCellSize.width;
                        this.iDragUpperLimit.x = MJTiledPane.this.fColumnLeft[n2 + 1] - MJTiledPane.this.fCellSpacing - MJTiledPane.this.fMinimumCellSize.width;
                    }
                }
            }
            if (MJTiledPane.this.fIsDragging) {
                int n3;
                n2 = MJTiledPane.this.fGridSize.width;
                n = MJTiledPane.this.fGridSize.height;
                Point point = mouseEvent.getPoint();
                int n4 = 0;
                int n5 = 0;
                int n6 = point.y;
                int n7 = point.x;
                if (MJTiledPane.this.fElementData.fElement == 1 || MJTiledPane.this.fElementData.fElement == 3) {
                    n5 = point.y - this.iLastPoint.y;
                    n6 = this.iDragPosition.y + n5;
                    if (n6 < this.iDragLowerLimit.y) {
                        n6 = this.iDragLowerLimit.y;
                    } else if (n6 > this.iDragUpperLimit.y) {
                        n6 = this.iDragUpperLimit.y;
                    }
                    n5 = n6 - this.iDragPosition.y;
                    if (n5 != 0) {
                        if (!this.iIsGroupDrag) {
                            int n8 = MJTiledPane.this.fElementData.fRow + 1;
                            MJTiledPane.this.fRowTop[n8] = MJTiledPane.this.fRowTop[n8] + n5;
                        } else if (n5 > 0) {
                            n3 = MJTiledPane.this.fElementData.fRow + 1;
                            while (n3 < n) {
                                int n9 = n3++;
                                MJTiledPane.this.fRowTop[n9] = MJTiledPane.this.fRowTop[n9] + n5;
                            }
                        } else if (n5 < 0) {
                            n3 = MJTiledPane.this.fElementData.fRow + 1;
                            while (n3 > 0) {
                                int n10 = n3--;
                                MJTiledPane.this.fRowTop[n10] = MJTiledPane.this.fRowTop[n10] + n5;
                            }
                        }
                    }
                }
                if (MJTiledPane.this.fElementData.fElement == 2 || MJTiledPane.this.fElementData.fElement == 3) {
                    n4 = point.x - this.iLastPoint.x;
                    n7 = this.iDragPosition.x + n4;
                    if (n7 < this.iDragLowerLimit.x) {
                        n7 = this.iDragLowerLimit.x;
                    } else if (n7 > this.iDragUpperLimit.x) {
                        n7 = this.iDragUpperLimit.x;
                    }
                    n4 = n7 - this.iDragPosition.x;
                    if (n4 != 0) {
                        if (!this.iIsGroupDrag) {
                            int n11 = MJTiledPane.this.fElementData.fColumn + 1;
                            MJTiledPane.this.fColumnLeft[n11] = MJTiledPane.this.fColumnLeft[n11] + n4;
                        } else if (n4 > 0) {
                            n3 = MJTiledPane.this.fElementData.fColumn + 1;
                            while (n3 < n2) {
                                int n12 = n3++;
                                MJTiledPane.this.fColumnLeft[n12] = MJTiledPane.this.fColumnLeft[n12] + n4;
                            }
                        } else if (n4 < 0) {
                            n3 = MJTiledPane.this.fElementData.fColumn + 1;
                            while (n3 > 0) {
                                int n13 = n3--;
                                MJTiledPane.this.fColumnLeft[n13] = MJTiledPane.this.fColumnLeft[n13] + n4;
                            }
                        }
                    }
                }
                if (n4 == 0 && n5 == 0) {
                    return;
                }
                if (MJTiledPane.this.fContinuousLayout) {
                    int n14;
                    Rectangle rectangle = new Rectangle();
                    rectangle.x = MJTiledPane.this.fColumnLeft[0];
                    rectangle.width = MJTiledPane.this.fColumnLeft[n2] - rectangle.x;
                    rectangle.y = MJTiledPane.this.fRowTop[0] - 1;
                    rectangle.height = MJTiledPane.this.fRowTop[n] - rectangle.y;
                    if (MJTiledPane.this.fElementData.fElement == 1) {
                        n14 = MJTiledPane.this.fElementData.fRow + 1;
                        if (n5 > 0) {
                            rectangle.y = this.iDragPosition.y;
                            rectangle.height = (this.iIsGroupDrag ? MJTiledPane.this.fRowTop[n] : MJTiledPane.this.fRowTop[n14 + 1]) - rectangle.y;
                        } else {
                            rectangle.y = this.iIsGroupDrag ? MJTiledPane.this.fRowTop[1] - MJTiledPane.this.fCellSpacing : n6;
                            rectangle.height = MJTiledPane.this.fRowTop[n14 + 1] - rectangle.y;
                        }
                        if (MJTiledPane.this.fSelectedTile != -1) {
                            rectangle.y -= 6;
                            rectangle.height += 6;
                        }
                    }
                    if (MJTiledPane.this.fElementData.fElement == 2) {
                        n14 = MJTiledPane.this.fElementData.fColumn + 1;
                        if (n4 > 0) {
                            rectangle.x = this.iDragPosition.x;
                            rectangle.width = (this.iIsGroupDrag ? MJTiledPane.this.fColumnLeft[n2] : MJTiledPane.this.fColumnLeft[n14 + 1]) - rectangle.x;
                        } else {
                            rectangle.x = this.iIsGroupDrag ? MJTiledPane.this.fColumnLeft[1] - MJTiledPane.this.fCellSpacing : n7;
                            rectangle.width = MJTiledPane.this.fColumnLeft[n14 + 1] - rectangle.x;
                        }
                        if (MJTiledPane.this.fSelectedTile != -1) {
                            rectangle.x -= 6;
                            rectangle.width += 6;
                        }
                    }
                    MJTiledPane.this.revalidate();
                    MJTiledPane.this.repaint(rectangle);
                }
                this.iLastPoint.setLocation(point);
                this.iDragPosition.setLocation(n7, n6);
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (MJTiledPane.this.fIsShowingPopup) {
                return;
            }
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            MJTiledPane.this.getElementAt(n, n2, MJTiledPane.this.fElementData.fElement, MJTiledPane.this.fElementData);
            if (MJTiledPane.this.fCloseButtonsEnabled) {
                Rectangle rectangle;
                if (MJTiledPane.this.fElementData.fElement == 1) {
                    Rectangle rectangle2 = MJTiledPane.this.fHorizontalDividerCloseBox[MJTiledPane.this.fElementData.fRow][MJTiledPane.this.fElementData.fColumn];
                    if (rectangle2 != null && n >= rectangle2.x && n <= rectangle2.x + rectangle2.width) {
                        MJTiledPane.this.setCursor(Cursor.getDefaultCursor());
                        MJTiledPane.this.showDividerCloseButton(rectangle2);
                        return;
                    }
                } else if (MJTiledPane.this.fElementData.fElement == 2 && (rectangle = MJTiledPane.this.fVerticalDividerCloseBox[MJTiledPane.this.fElementData.fRow][MJTiledPane.this.fElementData.fColumn]) != null && n2 >= rectangle.y && n2 <= rectangle.y + rectangle.height) {
                    MJTiledPane.this.setCursor(Cursor.getDefaultCursor());
                    MJTiledPane.this.showDividerCloseButton(rectangle);
                    return;
                }
            }
            MJTiledPane.this.updateCursor(MJTiledPane.this.fElementData);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (!MJTiledPane.this.fIsDragging && !this.iDragArmed) {
                MJTiledPane.this.updateCursor(sNoElementData);
            }
        }
    }

    protected static class ElementData {
        int fElement;
        int fIndex;
        int fRow;
        int fColumn;

        ElementData() {
        }

        ElementData(int n) {
            this.fElement = n;
        }
    }

    public static interface GridListener {
        public void gridSizeChanged(MJTiledPane var1, Dimension var2, Dimension var3);

        public void tilesMerged(MJTiledPane var1, int var2, int var3);

        public void tileSplit(MJTiledPane var1, int var2, int var3);
    }
}

