/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.mwswing.MJTree;
import com.mathworks.mwswing.MJTreeTable;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;

public class TreeTableCellRenderer
extends MJTree
implements TableCellRenderer {
    protected int visibleRow;
    private MJTreeTable fTreeTable;

    public TreeTableCellRenderer(MJTreeTable mJTreeTable, TreeModel treeModel) {
        super(treeModel);
        this.fTreeTable = mJTreeTable;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        TreeCellRenderer treeCellRenderer = this.getCellRenderer();
        if (treeCellRenderer instanceof DefaultTreeCellRenderer) {
            DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)treeCellRenderer;
            defaultTreeCellRenderer.setTextSelectionColor(UIManager.getColor("Table.selectionForeground"));
            defaultTreeCellRenderer.setBackgroundSelectionColor(UIManager.getColor("Table.selectionBackground"));
        }
    }

    @Override
    public void setRowHeight(int n) {
        if (n > 0) {
            super.setRowHeight(n);
            if (this.fTreeTable != null && this.fTreeTable.getRowHeight() != n) {
                this.fTreeTable.setRowHeight(this.getRowHeight());
            }
        }
    }

    void fireTreeModelChanged() {
        this.firePropertyChange("model", null, this.treeModel);
    }

    @Override
    public void requestFocus() {
        this.fTreeTable.requestFocus();
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, 0, n3, this.fTreeTable.getHeight());
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.translate(0, -this.visibleRow * this.getRowHeight());
        super.paint(graphics);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (bl) {
            this.setBackground(jTable.getSelectionBackground());
        } else {
            this.setBackground(jTable.getBackground());
        }
        this.visibleRow = n;
        return this;
    }

    public void expandAllNodes() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.expandRecursively(this.getPathForRow(i));
        }
    }
}

