/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class WeakPropertyChangeCoupler {
    static ReferenceQueue<? super PropertyChangeListener> sQueue = new ReferenceQueue();

    private WeakPropertyChangeCoupler() {
    }

    public static void attach(Action action, PropertyChangeListener propertyChangeListener) {
        new ProxyListener(action, propertyChangeListener);
    }

    public static void detach(Action action, PropertyChangeListener propertyChangeListener) {
        if (!(action instanceof AbstractAction)) {
            return;
        }
        for (PropertyChangeListener propertyChangeListener2 : ((AbstractAction)action).getPropertyChangeListeners()) {
            ProxyListener proxyListener;
            if (!(propertyChangeListener2 instanceof ProxyListener) || (proxyListener = (ProxyListener)propertyChangeListener2).get() != propertyChangeListener) continue;
            proxyListener.remove();
            break;
        }
    }

    static {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (true) {
                        final ProxyListener proxyListener = (ProxyListener)sQueue.remove();
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                proxyListener.remove();
                            }
                        });
                    }
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        });
        thread.setDaemon(true);
        thread.setPriority(1);
        thread.start();
    }

    private static class ProxyListener
    extends WeakReference<PropertyChangeListener>
    implements PropertyChangeListener {
        private Action fAction;

        private ProxyListener(Action action, PropertyChangeListener propertyChangeListener) {
            super(propertyChangeListener, sQueue);
            this.fAction = action;
            this.fAction.addPropertyChangeListener(this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)this.get();
            if (propertyChangeListener == null) {
                this.remove();
            } else {
                propertyChangeListener.propertyChange(propertyChangeEvent);
            }
        }

        private void remove() {
            if (this.fAction != null) {
                this.fAction.removePropertyChangeListener(this);
                this.fAction = null;
            }
        }
    }
}

