/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing.checkboxtree;

import com.mathworks.mwswing.checkboxtree.Selectable;
import com.mathworks.mwswing.checkboxtree.SelectionState;
import javax.swing.tree.TreeModel;

public class CheckBoxTreeUtils {
    private CheckBoxTreeUtils() {
    }

    public static void synchronizeNodes(TreeModel treeModel) {
        CheckBoxTreeUtils.synchronizeParents(treeModel, treeModel.getRoot());
    }

    public static void synchronizeParents(TreeModel treeModel, Object object) {
        if (!treeModel.isLeaf(object)) {
            for (int i = 0; i < treeModel.getChildCount(object); ++i) {
                Object object2 = treeModel.getChild(object, i);
                CheckBoxTreeUtils.synchronizeParents(treeModel, object2);
            }
            CheckBoxTreeUtils.updateParentBasedOnChildren(treeModel, object);
        }
    }

    static boolean updateParentBasedOnChildren(TreeModel treeModel, Object object) {
        Selectable selectable;
        SelectionState selectionState;
        boolean bl = false;
        if (object instanceof Selectable && (selectionState = CheckBoxTreeUtils.computeCombinedStateOfChildren(treeModel, selectable = (Selectable)object)) != null && selectable.getSelectionState() != selectionState) {
            selectable.setSelectionState(selectionState);
            bl = true;
        }
        return bl;
    }

    private static SelectionState computeCombinedStateOfChildren(TreeModel treeModel, Selectable selectable) {
        SelectionState selectionState = null;
        for (int i = 0; i < treeModel.getChildCount(selectable); ++i) {
            Object object = treeModel.getChild(selectable, i);
            if (!(object instanceof Selectable)) continue;
            Selectable selectable2 = (Selectable)object;
            if (selectionState == null) {
                selectionState = selectable2.getSelectionState();
                continue;
            }
            if (selectable2.getSelectionState() == selectionState) continue;
            selectionState = SelectionState.MIXED;
            break;
        }
        return selectionState;
    }
}

