/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.appmanagement;

import com.mathworks.appmanagement.AppManagementView;
import com.mathworks.appmanagement.AppMetadata;
import com.mathworks.appmanagement.ConfirmDowngradeRunnable;
import com.mathworks.appmanagement.ConfirmInstallRunnable;
import com.mathworks.appmanagement.ConfirmReinstallRunnable;
import com.mathworks.appmanagement.ConfirmUpgradeRunnable;
import com.mathworks.appmanagement.DependencyWarningRunnable;
import com.mathworks.appmanagement.ProductDependency;
import com.mathworks.appmanagement.ShowNotificationRunnable;
import com.mathworks.appmanagement.resources.ResourceKey;
import com.mathworks.mlservices.MatlabDesktopServices;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.widgets.desk.DTFrame;
import com.mathworks.widgets.desk.Desktop;
import java.awt.Component;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.SwingUtilities;

final class AppManagementViewMatlab
implements AppManagementView {
    AppManagementViewMatlab() {
    }

    @Override
    public final void handleInstallException(Throwable throwable) {
        this.handleException(throwable);
    }

    @Override
    public final void handleUninstallException(Throwable throwable) {
        this.handleException(throwable);
    }

    @Override
    public final boolean showDependencyWarning(AppMetadata appMetadata, ProductDependency[] productDependencyArray) {
        AtomicInteger atomicInteger = new AtomicInteger();
        DependencyWarningRunnable dependencyWarningRunnable = new DependencyWarningRunnable((Component)this.getParent(), atomicInteger, appMetadata, productDependencyArray);
        return this.runOnEdt(atomicInteger, dependencyWarningRunnable);
    }

    @Override
    public final void showInstallNotification(AppMetadata appMetadata) {
        this.showNotification(appMetadata, ResourceKey.NOTIFICATION_INSTALL);
    }

    @Override
    public final void showUpgradeNotification(AppMetadata appMetadata) {
        this.showNotification(appMetadata, ResourceKey.NOTIFICATION_UPGRADE);
    }

    @Override
    public void showDowngradeNotification(AppMetadata appMetadata) {
        this.showNotification(appMetadata, ResourceKey.NOTIFICATION_DOWNGRADE);
    }

    @Override
    public boolean confirmInstall() {
        AtomicInteger atomicInteger = new AtomicInteger();
        ConfirmInstallRunnable confirmInstallRunnable = new ConfirmInstallRunnable((Component)this.getParent(), atomicInteger);
        return this.runOnEdt(atomicInteger, confirmInstallRunnable);
    }

    @Override
    public boolean confirmUpgrade(AppMetadata appMetadata, String string) {
        AtomicInteger atomicInteger = new AtomicInteger();
        ConfirmUpgradeRunnable confirmUpgradeRunnable = new ConfirmUpgradeRunnable((Component)this.getParent(), atomicInteger, appMetadata, string);
        return this.runOnEdt(atomicInteger, confirmUpgradeRunnable);
    }

    @Override
    public boolean confirmDowngrade(AppMetadata appMetadata, String string) {
        AtomicInteger atomicInteger = new AtomicInteger();
        ConfirmDowngradeRunnable confirmDowngradeRunnable = new ConfirmDowngradeRunnable((Component)this.getParent(), atomicInteger, appMetadata, string);
        return this.runOnEdt(atomicInteger, confirmDowngradeRunnable);
    }

    @Override
    public boolean confirmReinstall(AppMetadata appMetadata) {
        AtomicInteger atomicInteger = new AtomicInteger();
        ConfirmReinstallRunnable confirmReinstallRunnable = new ConfirmReinstallRunnable((Component)this.getParent(), atomicInteger, appMetadata);
        return this.runOnEdt(atomicInteger, confirmReinstallRunnable);
    }

    @Override
    public void showAppInstallerInAppInstallFolderError(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MJOptionPane.showMessageDialog((Component)AppManagementViewMatlab.this.getParent(), (Object)ResourceKey.MESSAGE_ERROR.getString(string), (String)ResourceKey.APPS_ERROR_TITLE.getString(new Object[0]), (int)0);
            }
        });
    }

    private boolean runOnEdt(AtomicInteger atomicInteger, Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return atomicInteger.get() == 0;
    }

    private void handleException(Throwable throwable) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MJOptionPane.showMessageDialog((Component)AppManagementViewMatlab.this.getParent(), (Object)ResourceKey.MESSAGE_EXCEPTION.getString(new Object[0]), (String)ResourceKey.TITLE_EXCEPTION.getString(new Object[0]), (int)0);
            }
        });
        throwable.printStackTrace();
    }

    private DTFrame getParent() {
        Desktop desktop = MatlabDesktopServices.getDesktop();
        return desktop.getMainFrame();
    }

    private void showNotification(AppMetadata appMetadata, ResourceKey resourceKey) {
        DTFrame dTFrame = this.getParent();
        if (!dTFrame.isMinimized()) {
            SwingUtilities.invokeLater(new ShowNotificationRunnable(dTFrame, appMetadata, resourceKey));
        }
    }
}

