/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import net.sf.saxon.Configuration;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.s9api.ItemType;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;

public abstract class XdmItem
extends XdmValue {
    protected XdmItem() {
    }

    protected XdmItem(Item item) {
        super((ValueRepresentation)item);
    }

    protected static XdmItem wrapItem(Item item) {
        return item == null ? null : (XdmItem)XdmValue.wrap((ValueRepresentation)item);
    }

    public static XdmItem newAtomicValue(String value, ItemType type) throws SaxonApiException {
        net.sf.saxon.type.ItemType it = type.getUnderlyingItemType();
        if (!it.isAtomicType()) {
            throw new SaxonApiException("Requested type is not atomic");
        }
        Configuration config = type.getProcessor().getUnderlyingConfiguration();
        ConversionResult result = new StringValue((CharSequence)value).convert((AtomicType)it, true, config.getConversionContext());
        try {
            return (XdmItem)XdmItem.wrap((ValueRepresentation)result.asAtomic());
        }
        catch (ValidationException e) {
            throw new SaxonApiException(e);
        }
    }

    public String getStringValue() {
        return ((Item)this.getUnderlyingValue()).getStringValue();
    }

    public boolean isAtomicValue() {
        return (Item)this.getUnderlyingValue() instanceof AtomicValue;
    }

    public int size() {
        return 1;
    }
}

