/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt;

import com.mathworks.mwt.MWCanvas;
import com.mathworks.mwt.MWComponent;
import com.mathworks.mwt.MWDragListener;
import com.mathworks.mwt.MWExclusiveGroup;
import com.mathworks.mwt.MWExclusiveGroupItem;
import com.mathworks.mwt.MWFrame;
import com.mathworks.mwt.MWImageResource;
import com.mathworks.mwt.command.MWCommandSource;
import com.mathworks.mwt.command.MWCommandTarget;
import com.mathworks.mwt.decorations.Decorations;
import com.mathworks.mwt.dialog.MWDialog;
import com.mathworks.util.PlatformInfo;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Locale;
import java.util.TooManyListenersException;

public class MWButton
extends MWCanvas
implements MouseListener,
MouseMotionListener,
ItemSelectable,
MWExclusiveGroupItem,
MWCommandSource,
ActionListener {
    public static final int BEHAVIOR_NORMAL = 0;
    public static final int BEHAVIOR_TOGGLE = 1;
    public static final int BEHAVIOR_STICKY = 2;
    public static final int BEHAVIOR_TOGGLE_SPECIAL = 3;
    public static final int V_ALIGN_MASK = 240;
    public static final int H_ALIGN_MASK = 15;
    public static final int V_ALIGN_CENTER = 0;
    public static final int V_ALIGN_TOP = 16;
    public static final int V_ALIGN_BOTTOM = 32;
    public static final int H_ALIGN_CENTER = 0;
    public static final int H_ALIGN_LEFT = 1;
    public static final int H_ALIGN_RIGHT = 2;
    public static final int GRAPHIC_ALIGN_CENTER = 0;
    public static final int GRAPHIC_ALIGN_LEFT = 1;
    public static final int GRAPHIC_ALIGN_RIGHT = 2;
    public static final int GRAPHIC_ALIGN_TOP = 16;
    public static final int GRAPHIC_ALIGN_BOTTOM = 32;
    public static final int GRAPHIC_ALIGN_TOP_LEFT = 17;
    public static final int GRAPHIC_ALIGN_BOTTOM_LEFT = 33;
    public static final int GRAPHIC_ALIGN_TOP_RIGHT = 18;
    public static final int GRAPHIC_ALIGN_BOTTOM_RIGHT = 34;
    public static final int TEXT_PLACE_NORMAL = 0;
    public static final int TEXT_PLACE_BELOW = 1;
    public static final int TEXT_PLACE_ABOVE = 2;
    public static final int TEXT_PLACE_LEFT = 3;
    public static final int TEXT_PLACE_RIGHT = 4;
    private static int BEVEL_SIZE = 2;
    private static final int BORDER_MARGIN = 2;
    private static final int MIN_TEXT_WIDTH_NOT_XP = 80;
    private static final int MIN_TEXT_WIDTH_XP = 75;
    private static int MIN_TEXT_WIDTH = 80;
    private static final int MIN_WIDTH = 16;
    private static final int MIN_HEIGHT = 16;
    private String fLabel;
    private MWImageResource fImageResource;
    private boolean fState;
    private boolean fHideBevel;
    private boolean fToolbarBevel;
    private boolean fActiveToggle;
    private boolean fRollover;
    private int fBehavior;
    private int fGraphicAlignment;
    private int fTextPlacement;
    private int fTextAlignment;
    private String fActionCommand;
    private MWDragListener fDragListener;
    protected MWExclusiveGroup fGroup;
    private boolean fMouseIn;
    private boolean fTracking;
    private boolean fWantsToShow;
    private boolean fSupportsFocus;
    private boolean fHasFocus;
    private MWImageResource[] fDecorationCache;
    private int fCachedAppearance;
    private int fImageX;
    private int fImageY;
    private int fImageW;
    private int fImageH;
    private int fTextX;
    private int fTextY;
    private int fTextW;
    private int fTextH;
    private int fTextBase;
    private int fTextMargin;
    private char fMnemonic;
    private char[] fAltLead;
    private int fAltWidth;
    private int fAltX;
    private int fAltY;
    private MWCommandTarget fTarget;
    private int fCommand;
    private static final Color[] sXPBlueTopOuter = new Color[]{new Color(206, 227, 247), new Color(194, 209, 143), new Color(206, 201, 255)};
    private static final Color[] sXPBlueTopInner = new Color[]{new Color(173, 199, 239), new Color(177, 203, 128), new Color(188, 212, 246)};
    private static final Color[] sXPBlueBottomInner = new Color[]{new Color(115, 158, 222), new Color(144, 193, 84), new Color(137, 173, 128)};
    private static final Color[] sXPBlueBottomOuter = new Color[]{new Color(82, 109, 231), new Color(128, 167, 102), new Color(105, 130, 238)};
    private transient boolean fDefault;
    transient ItemListener fItemListener;
    transient ActionListener fActionListener;

    private MWButton(MWImageResource mWImageResource, String string, int n, int n2, int n3, int n4, String string2) {
        this.fImageResource = mWImageResource;
        this.fBehavior = n;
        this.fGraphicAlignment = n2;
        this.fTextPlacement = n3;
        this.fTextAlignment = n4;
        this.fActionCommand = string2;
        this.fHideBevel = false;
        this.fDefault = false;
        this.fDecorationCache = null;
        this.fCachedAppearance = -1;
        if (PlatformInfo.getAppearance() != 0) {
            this.fSupportsFocus = true;
        }
        if (PlatformInfo.useWindowsXPAppearance()) {
            this.fRollover = true;
        }
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setFont(Decorations.getFont(0));
        this.setLabel(string);
    }

    public MWButton(Image image, String string, int n, int n2, int n3, int n4, String string2) {
        this(new MWImageResource(image), string, n, n2, n3, n4, string2);
    }

    public MWButton(Image image) {
        this(new MWImageResource(image));
    }

    public MWButton(MWImageResource mWImageResource) {
        this(mWImageResource, "", 0, 0, 0, 0, null);
    }

    public MWButton(String string) {
        this((MWImageResource)null, string, 0, 0, 0, 0, null);
    }

    public MWButton(Image image, String string) {
        this(new MWImageResource(image), string, 0, 0, 4, 0, null);
    }

    public MWButton(Image image, MWExclusiveGroup mWExclusiveGroup) {
        this(image);
        this.fGroup = mWExclusiveGroup;
        if (this.fGroup != null) {
            this.fBehavior = 2;
        }
    }

    public MWButton(String string, MWExclusiveGroup mWExclusiveGroup) {
        this(string);
        this.fGroup = mWExclusiveGroup;
        if (this.fGroup != null) {
            this.fBehavior = 2;
        }
    }

    public MWButton(Image image, String string, MWExclusiveGroup mWExclusiveGroup) {
        this(image, string);
        this.fGroup = mWExclusiveGroup;
        if (this.fGroup != null) {
            this.fBehavior = 2;
        }
    }

    public MWButton() {
        this((MWImageResource)null, "", 0, 0, 4, 0, null);
    }

    public void setDefault(boolean bl) {
        if (this.fBehavior != 1) {
            this.fDefault = bl;
        }
    }

    public boolean isDefault() {
        return this.fDefault;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.invalidate();
        this.repaint();
    }

    @Override
    public void setEnabled(boolean bl) {
        if (bl != this.isEnabled()) {
            super.setEnabled(bl);
            this.repaint();
        }
    }

    public void setFocusBehavior(boolean bl) {
        this.fSupportsFocus = bl;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = this.getMinimumSize();
        if (this.fImageResource == null && this.fLabel != null && this.fLabel.length() > 0 && dimension.width < MIN_TEXT_WIDTH) {
            dimension.width = MIN_TEXT_WIDTH;
        }
        return dimension;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dimension = new Dimension();
        this.calcLocations();
        this.calcTextMargin();
        switch (this.fTextPlacement) {
            case 0: {
                dimension.width = this.fTextW > this.fImageW ? this.fTextW : this.fImageW;
                dimension.height = this.fTextH > this.fImageH ? this.fTextH + 1 : this.fImageH;
                break;
            }
            case 1: 
            case 2: {
                dimension.width = this.fTextW > this.fImageW ? this.fTextW : this.fImageW;
                dimension.height = this.fImageH + this.fTextH;
                break;
            }
            case 3: 
            case 4: {
                dimension.width = this.fTextW + this.fImageW + this.fTextMargin;
                dimension.height = this.fTextH > this.fImageH ? this.fTextH + 1 : this.fImageH;
            }
        }
        dimension.width += 2 * (BEVEL_SIZE + 2);
        dimension.height += 2 * (BEVEL_SIZE + 2);
        return dimension;
    }

    public String getLabel() {
        return this.fLabel;
    }

    public void setLabel(String string) {
        this.fMnemonic = '\u0000';
        this.fAltLead = null;
        if (string != null) {
            int n = 0;
            n = string.indexOf(38, n);
            while (n != -1) {
                if (++n >= string.length() || string.charAt(n) == '&') continue;
                this.fMnemonic = Character.toLowerCase(string.charAt(n));
                String string2 = null;
                if (n > 1) {
                    string2 = string.substring(0, n - 1);
                    this.fAltLead = string2.toCharArray();
                }
                String string3 = string.substring(n, string.length());
                string = string2 != null ? string2 + string3 : string3;
                break;
            }
        }
        this.fLabel = string;
        this.invalidate();
    }

    public MWImageResource getImageResource() {
        return this.fImageResource;
    }

    public void setImageResource(MWImageResource mWImageResource) {
        this.flushImages();
        this.fImageResource = mWImageResource;
        this.fDecorationCache = null;
        this.invalidate();
    }

    public Image getImage() {
        if (this.fImageResource != null) {
            return this.fImageResource.getImage(this);
        }
        return null;
    }

    public void setImage(Image image) {
        this.setImageResource(new MWImageResource(image));
    }

    @Override
    public boolean getState() {
        return this.fState;
    }

    @Override
    public void setState(boolean bl) {
        if (this.fGroup != null) {
            if (bl) {
                this.fGroup.setSelectedItem(this);
            } else if (this.fGroup.getSelectedItem() == this) {
                bl = true;
            }
        }
        this.setStateInternal(bl);
    }

    synchronized void setStateInternal(boolean bl) {
        if (this.fState != bl) {
            this.fState = this.fBehavior == 0 ? false : bl;
            ItemEvent itemEvent = this.fState ? new ItemEvent(this, 701, this, 1) : new ItemEvent(this, 701, this, 2);
            this.processItemEvent(itemEvent);
            this.repaint();
        }
    }

    @Override
    public MWExclusiveGroup getGroup() {
        return this.fGroup;
    }

    @Override
    public void setGroup(MWExclusiveGroup mWExclusiveGroup) {
        if (this.fGroup != null) {
            this.fGroup.setSelectedItem(null);
        }
        if (mWExclusiveGroup != null) {
            this.fBehavior = 2;
        }
        this.fGroup = mWExclusiveGroup;
    }

    public int getBehavior() {
        return this.fBehavior;
    }

    public void setBehavior(int n) {
        if (this.fGroup == null) {
            this.fBehavior = n < 0 || n > 2 ? (n == 3 ? 1 : 0) : n;
            this.fActiveToggle = n == 1;
        }
    }

    public boolean getHideBevel() {
        return this.fHideBevel;
    }

    public void setHideBevel(boolean bl) {
        this.fHideBevel = bl;
    }

    public boolean getToolbarBevel() {
        return this.fToolbarBevel;
    }

    public void setToolbarBevel(boolean bl) {
        this.fToolbarBevel = bl;
    }

    public int getGraphicAlignment() {
        return this.fGraphicAlignment;
    }

    public void setGraphicAlignment(int n) {
        int n2 = n & 0xF0;
        int n3 = n & 0xF;
        if (n2 < 0 || n2 > 32) {
            n2 = 0;
        }
        if (n3 < 0 || n3 > 2) {
            n3 = 0;
        }
        this.fGraphicAlignment = n3 + n2;
        this.invalidate();
    }

    public int getTextPlacement() {
        return this.fTextPlacement;
    }

    public void setTextPlacement(int n) {
        this.fTextPlacement = n < 0 || n > 4 || this.fImageResource == null ? 0 : n;
        this.invalidate();
    }

    public int getTextAlignment() {
        return this.fTextAlignment;
    }

    public void setTextAlignment(int n) {
        this.fTextAlignment = n < 0 || n > 2 ? 0 : n;
        this.invalidate();
    }

    public String getActionCommand() {
        return this.fActionCommand != null ? this.fActionCommand : this.fLabel;
    }

    public void setActionCommand(String string) {
        this.fActionCommand = string;
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.fActionListener = AWTEventMulticaster.add(this.fActionListener, actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.fActionListener = AWTEventMulticaster.remove(this.fActionListener, actionListener);
    }

    private void processItemEvent(ItemEvent itemEvent) {
        if (this.fItemListener != null) {
            this.fItemListener.itemStateChanged(itemEvent);
        }
    }

    @Override
    public boolean isFocusTraversable() {
        if (this.fSupportsFocus) {
            return this.isEnabled();
        }
        return false;
    }

    @Override
    public void processKeyEvent(KeyEvent keyEvent) {
        boolean bl = false;
        if (keyEvent.getID() == 401 && this.isEnabled()) {
            boolean bl2;
            boolean bl3 = (keyEvent.getModifiers() & 0xFFFFFFFE) == 8;
            boolean bl4 = bl2 = (keyEvent.getModifiers() & 0xFFFFFFFE) == 0;
            if (this.fMnemonic != '\u0000' && (bl3 || bl2) && Character.toLowerCase(keyEvent.getKeyChar()) == this.fMnemonic) {
                bl = true;
            } else if (bl2 && keyEvent.getKeyCode() == 10) {
                bl = true;
            } else if (bl2 && keyEvent.getKeyCode() == 32) {
                bl = true;
            } else if (bl3 && !this.fHasFocus) {
                return;
            }
        }
        if (bl) {
            keyEvent.consume();
            this.toggleState();
        } else {
            super.processKeyEvent(keyEvent);
        }
    }

    @Override
    public void processFocusEvent(FocusEvent focusEvent) {
        boolean bl = focusEvent.getID() != 1005;
        if (bl != this.fHasFocus) {
            this.fHasFocus = bl;
            this.setDefault(bl);
            this.repaint();
        }
        super.processFocusEvent(focusEvent);
    }

    private void toggleState() {
        switch (this.fBehavior) {
            case 0: {
                this.repaint();
                if (this.fActionListener != null) {
                    this.fActionListener.actionPerformed(new ActionEvent(this, 0, this.getActionCommand()));
                }
                if (this.fTarget == null) break;
                this.fTarget.doCommand(this.fCommand);
                break;
            }
            case 1: {
                this.setState(!this.fState);
                this.repaint();
                break;
            }
            case 2: {
                if (!this.fState) {
                    this.setState(true);
                }
                this.repaint();
            }
        }
    }

    @Override
    public Object[] getSelectedObjects() {
        if (this.fState) {
            Object[] objectArray = new Object[]{this.fLabel};
            return objectArray;
        }
        return null;
    }

    @Override
    public synchronized void addItemListener(ItemListener itemListener) {
        this.fItemListener = AWTEventMulticaster.add(this.fItemListener, itemListener);
    }

    @Override
    public synchronized void removeItemListener(ItemListener itemListener) {
        this.fItemListener = AWTEventMulticaster.remove(this.fItemListener, itemListener);
    }

    public synchronized void addDragListener(MWDragListener mWDragListener) throws TooManyListenersException {
        if (this.fDragListener != null) {
            throw new TooManyListenersException();
        }
        this.fDragListener = mWDragListener;
    }

    public synchronized void removeDragListener(MWDragListener mWDragListener) {
        if (this.fDragListener == mWDragListener) {
            this.fDragListener = null;
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.fHideBevel && this.isShowing() && PlatformInfo.getAppearance() == 1) {
            int n = 28;
            if ((mouseEvent.getModifiers() & n) == 0 && this.fWantsToShow) {
                this.fMouseIn = true;
                if (this.isEnabled()) {
                    this.repaint();
                }
            }
        }
        if (this.fRollover && !this.fMouseIn) {
            this.fMouseIn = true;
            if (this.isEnabled()) {
                this.repaint();
            }
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.fWantsToShow = false;
        if (this.fHideBevel && this.isShowing() && PlatformInfo.getAppearance() == 1 && this.fMouseIn) {
            this.fMouseIn = false;
            if (this.isEnabled()) {
                this.repaint();
            }
        }
        if (this.fRollover && this.fMouseIn) {
            this.fMouseIn = false;
            if (this.isEnabled()) {
                this.repaint();
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        Rectangle rectangle = new Rectangle(0, 0, this.getSize().width, this.getSize().height);
        if (this.isEnabled() && rectangle.contains(mouseEvent.getPoint())) {
            this.fTracking = true;
            this.fMouseIn = true;
            if (this.fSupportsFocus) {
                this.requestFocus();
            }
            this.repaint();
            if (this.fDragListener != null) {
                this.fDragListener.startDrag(mouseEvent);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        Rectangle rectangle = new Rectangle(0, 0, this.getSize().width, this.getSize().height);
        if (this.fTracking) {
            this.fTracking = false;
            if (this.fMouseIn != rectangle.contains(mouseEvent.getPoint())) {
                this.fMouseIn = rectangle.contains(mouseEvent.getPoint());
                this.repaint();
            }
            if (this.fMouseIn) {
                switch (this.fBehavior) {
                    case 0: {
                        this.fMouseIn = rectangle.contains(mouseEvent.getPoint());
                        this.repaint();
                        if (this.fActionListener != null) {
                            this.fActionListener.actionPerformed(new ActionEvent(this, 0, this.getActionCommand()));
                        }
                        if (this.fTarget == null) break;
                        this.fTarget.doCommand(this.fCommand);
                        break;
                    }
                    case 1: {
                        this.setState(!this.fState);
                        this.fMouseIn = rectangle.contains(mouseEvent.getPoint());
                        this.repaint();
                        break;
                    }
                    case 2: {
                        if (!this.fState) {
                            this.setState(true);
                        }
                        this.fMouseIn = rectangle.contains(mouseEvent.getPoint());
                        this.repaint();
                    }
                }
            }
            if (this.fDragListener != null) {
                this.fDragListener.finishDrag(mouseEvent);
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (!this.fWantsToShow && !this.fMouseIn) {
            this.fWantsToShow = true;
            this.mouseEntered(mouseEvent);
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.fTracking) {
            if (this.fDragListener != null) {
                this.fDragListener.continueDrag(mouseEvent);
            } else {
                boolean bl;
                Point point = mouseEvent.getPoint();
                Dimension dimension = this.getSize();
                boolean bl2 = bl = point.x >= 0 && point.x <= dimension.width && point.y >= 0 && point.y <= dimension.height;
                if (this.fMouseIn != bl) {
                    this.fMouseIn = bl;
                    this.repaint();
                }
            }
        }
    }

    @Override
    public void setTarget(MWCommandTarget mWCommandTarget) {
        this.fTarget = mWCommandTarget;
    }

    @Override
    public final MWCommandTarget getTarget() {
        return this.fTarget;
    }

    @Override
    public void setCommand(int n) {
        this.fCommand = n;
    }

    @Override
    public final int getCommand() {
        return this.fCommand;
    }

    @Override
    public void enableCommand(boolean bl) {
        if (bl != this.isEnabled()) {
            this.setEnabled(bl);
        }
    }

    @Override
    public void paint(Graphics graphics) {
        this.drawButton(graphics);
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public void removeNotify() {
        this.fHasFocus = false;
        super.removeNotify();
        this.flushImages();
    }

    private void flushImages() {
        if (this.fImageResource != null) {
            this.fImageResource.dispose();
        }
        if (this.fDecorationCache != null) {
            for (int i = 0; i < this.fDecorationCache.length; ++i) {
                if (this.fDecorationCache[i] == null) continue;
                this.fDecorationCache[i].dispose();
            }
        }
    }

    protected boolean isTracking() {
        return this.fTracking && this.fMouseIn;
    }

    protected boolean isMouseIn() {
        return this.fMouseIn;
    }

    private void drawButton(Graphics graphics) {
        Object object;
        boolean bl;
        this.calcLocations();
        this.calcTextMargin();
        boolean bl2 = this.fBehavior == 1 && !this.fActiveToggle ? false : this.fTracking && this.fMouseIn;
        boolean bl3 = this.fBehavior == 1 && !this.fActiveToggle ? false : this.fState;
        switch (this.fBehavior) {
            case 1: {
                if (this.fTracking && this.fMouseIn) {
                    bl = true;
                    break;
                }
                bl = this.fState;
                break;
            }
            case 2: {
                if (this.fTracking && this.fMouseIn) {
                    bl = true;
                    break;
                }
                bl = this.fState;
                break;
            }
            default: {
                bl = this.fTracking && this.fMouseIn;
            }
        }
        Rectangle rectangle = this.getBounds();
        rectangle.translate(-rectangle.x, -rectangle.y);
        if (this.fHideBevel && PlatformInfo.getAppearance() == 1) {
            object = MWComponent.getComponentFrame(this);
            if (this.fMouseIn && this.isEnabled() && object instanceof MWFrame && (((MWFrame)object).isFrameActive() || PlatformInfo.useWindowsXPAppearance()) || this.getState()) {
                if (this.fToolbarBevel) {
                    Decorations.drawTBButtonBevel(graphics, rectangle, bl, this.fState, this.isEnabled());
                } else if (this.fImageResource == null) {
                    Decorations.drawTextButtonBevel(graphics, rectangle, bl, this.fState, this.isEnabled());
                } else {
                    Decorations.drawButtonBevel(graphics, rectangle, bl, this.fState, this.isEnabled());
                }
            } else {
                graphics.setColor(this.getBackground());
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        } else if (this.fDefault && PlatformInfo.getAppearance() != 0) {
            if (!(this.fHasFocus && PlatformInfo.getAppearance() == 2 || PlatformInfo.useWindowsXPAppearance())) {
                graphics.setColor(Decorations.getColor(10));
                graphics.drawRect(0, 0, rectangle.width - 1, rectangle.height - 1);
                rectangle.grow(-1, -1);
            }
            if (this.fRollover) {
                object = this.getTopLevelWindow();
                if (this.fMouseIn && this.isEnabled() && (PlatformInfo.useWindowsXPAppearance() || object instanceof MWFrame && ((MWFrame)object).isFrameActive() || object instanceof MWDialog && ((MWDialog)object).isFrameActive()) || this.getState()) {
                    bl3 = true;
                }
            }
            if (this.fImageResource == null) {
                Decorations.drawTextButtonBevel(graphics, rectangle, bl, bl3, this.isEnabled());
            } else {
                Decorations.drawButtonBevel(graphics, rectangle, bl, bl3, this.isEnabled());
            }
        } else {
            if (this.fRollover) {
                object = this.getTopLevelWindow();
                if (this.fMouseIn && this.isEnabled() && (PlatformInfo.useWindowsXPAppearance() || object instanceof MWFrame && ((MWFrame)object).isFrameActive() || object instanceof MWDialog && ((MWDialog)object).isFrameActive()) || this.getState()) {
                    bl3 = true;
                }
            }
            if (this.fImageResource == null) {
                Decorations.drawTextButtonBevel(graphics, rectangle, bl, bl3, this.isEnabled());
            } else {
                Decorations.drawButtonBevel(graphics, rectangle, bl, bl3, this.isEnabled());
            }
        }
        object = graphics.getClip();
        if (!PlatformInfo.useWindowsXPAppearance()) {
            graphics.clipRect(BEVEL_SIZE, BEVEL_SIZE, this.getSize().width - BEVEL_SIZE * 2, this.getSize().height - BEVEL_SIZE * 2);
        }
        if (this.fHasFocus && this.fBehavior != 1 && PlatformInfo.getAppearance() == 1) {
            if (!PlatformInfo.useWindowsXPAppearance()) {
                rectangle.x += BEVEL_SIZE + 1;
                rectangle.y += BEVEL_SIZE + 1;
                rectangle.width -= (BEVEL_SIZE + 1) * 2 + 1;
                rectangle.height -= (BEVEL_SIZE + 1) * 2 + 1;
                Decorations.drawFocusRect(graphics, rectangle);
            } else if (!bl && !this.fMouseIn) {
                this.drawXPFocusOutline(graphics, rectangle);
            }
        }
        graphics.setFont(this.getFont());
        Decorations.drawButtonLabel(graphics, this.fLabel, this.fTextX, this.fTextY, bl2, this.isEnabled());
        this.drawMnemonic(graphics, this.fTextX, this.fTextY, bl2, this.isEnabled());
        if (PlatformInfo.getAppearance() != this.fCachedAppearance) {
            this.fCachedAppearance = PlatformInfo.getAppearance();
            this.fDecorationCache = null;
        }
        if (this.fImageResource != null) {
            this.fDecorationCache = Decorations.drawButtonImage(this.fDecorationCache, graphics, this.fImageResource, this.fImageX, this.fImageY, bl2, this.isEnabled());
        }
        graphics.setClip((Shape)object);
    }

    private void drawMnemonic(Graphics graphics, int n, int n2, boolean bl, boolean bl2) {
        if (this.fMnemonic != '\u0000') {
            n += this.fAltX;
            n2 += this.fAltY;
            if (!bl2 || bl && PlatformInfo.getAppearance() == 1) {
                Color color = PlatformInfo.getAppearance() == 1 ? Decorations.getColor(9) : Color.gray;
                graphics.setColor(color);
                graphics.drawLine(n, n2, n + this.fAltWidth, n2);
                if (PlatformInfo.getAppearance() != 0) {
                    graphics.setColor(Decorations.getColor(7));
                    graphics.drawLine(++n, ++n2, n + this.fAltWidth, n2);
                }
            } else {
                Color color = PlatformInfo.getAppearance() == 1 ? SystemColor.controlText : (bl && PlatformInfo.getAppearance() == 0 ? Color.white : Color.black);
                graphics.setColor(color);
                graphics.drawLine(n, n2, n + this.fAltWidth, n2);
            }
        }
    }

    private void drawXPFocusOutline(Graphics graphics, Rectangle rectangle) {
        int n = PlatformInfo.getWindowsXPScheme();
        int n2 = rectangle.width - 1;
        int n3 = rectangle.height - 1;
        graphics.setColor(sXPBlueTopOuter[n]);
        graphics.drawLine(2, 1, n2 - 2, 1);
        graphics.setColor(sXPBlueTopInner[n]);
        graphics.drawLine(1, 2, n2 - 1, 2);
        graphics.setColor(sXPBlueBottomInner[n]);
        graphics.drawLine(1, n3 - 2, n2 - 1, n3 - 2);
        graphics.setColor(sXPBlueBottomOuter[n]);
        graphics.drawLine(2, n3 - 1, n2 - 2, n3 - 1);
        graphics.setColor(sXPBlueTopInner[n]);
        graphics.drawLine(1, 3, 1, n3 - 3);
        graphics.drawLine(n2 - 1, 3, n2 - 1, n3 - 3);
        if (PlatformInfo.getWindowsXPScheme() != 2) {
            graphics.setColor(sXPBlueBottomInner[n]);
        } else {
            graphics.setColor(Color.white);
        }
        graphics.drawLine(2, 3, 2, n3 - 3);
        graphics.drawLine(n2 - 2, 3, n2 - 2, n3 - 3);
    }

    private void calcLocations() {
        this.calcSizes();
        this.alignImage();
        this.alignText();
    }

    private void alignImage() {
        int n = this.fGraphicAlignment & 0xF;
        switch (n) {
            case 1: {
                this.fImageX = BEVEL_SIZE + 2;
                break;
            }
            case 0: {
                this.fImageX = (this.getSize().width - this.fImageW) / 2;
                if (this.fTextPlacement == 3) {
                    this.fImageX += (this.fTextW + this.fTextMargin) / 2;
                    break;
                }
                if (this.fTextPlacement != 4) break;
                this.fImageX -= (this.fTextW + this.fTextMargin) / 2;
                break;
            }
            case 2: {
                this.fImageX = this.getSize().width - this.fImageW - (BEVEL_SIZE + 2);
            }
        }
        n = this.fGraphicAlignment & 0xF0;
        switch (n) {
            case 16: {
                this.fImageY = BEVEL_SIZE + 2;
                break;
            }
            case 0: {
                this.fImageY = (this.getSize().height - this.fImageH) / 2;
                if (this.fTextPlacement == 2) {
                    this.fImageY += this.fTextH / 2;
                    break;
                }
                if (this.fTextPlacement != 1) break;
                this.fImageY -= this.fTextH / 2;
                break;
            }
            case 32: {
                this.fImageY = this.getSize().height - this.fImageH - (BEVEL_SIZE + 2);
            }
        }
    }

    private void alignText() {
        switch (this.fTextPlacement) {
            case 0: {
                this.fTextY = (this.getSize().height - this.fTextH) / 2 + this.fTextBase;
                switch (this.fTextAlignment) {
                    case 1: {
                        this.fTextX = BEVEL_SIZE + 2;
                        break;
                    }
                    case 0: {
                        this.fTextX = (this.getSize().width - this.fTextW) / 2;
                        break;
                    }
                    case 2: {
                        this.fTextX = this.getSize().width - this.fTextW - (BEVEL_SIZE + 2);
                    }
                }
                break;
            }
            case 2: {
                this.fTextX = (this.getSize().width - this.fTextW) / 2;
                this.fTextY = this.fImageY - this.fTextH + this.fTextBase;
                break;
            }
            case 1: {
                this.fTextX = (this.getSize().width - this.fTextW) / 2;
                this.fTextY = this.fImageY + this.fImageH + this.fTextBase;
                break;
            }
            case 3: {
                this.fTextX = this.fImageX - this.fTextW - this.fTextMargin;
                this.fTextY = (this.getSize().height - this.fTextH) / 2 + this.fTextBase;
                break;
            }
            case 4: {
                this.fTextX = this.fImageX + this.fImageW + this.fTextMargin;
                this.fTextY = (this.getSize().height - this.fTextH) / 2 + this.fTextBase;
            }
        }
    }

    private void calcSizes() {
        Object object;
        if (this.fImageResource != null && this.fImageResource.getImage(this) != null) {
            object = this.fImageResource.getImage(this);
            this.fImageW = ((Image)object).getWidth(this);
            this.fImageH = ((Image)object).getHeight(this);
        } else {
            this.fImageW = 0;
            this.fImageH = 0;
        }
        Font font = this.getFont();
        if (font != null && this.fLabel != null && this.fLabel.length() > 0) {
            object = this.getFontMetrics(font);
            int n = 0;
            if (PlatformInfo.isMacintosh() && ((FontMetrics)object).getLeading() > ((FontMetrics)object).getMaxAscent() >> 1 && (Locale.getDefault().equals(Locale.JAPAN) || Locale.getDefault().equals(Locale.JAPANESE))) {
                n = (((FontMetrics)object).getMaxAscent() >> 3) - ((FontMetrics)object).getLeading();
            }
            this.fTextW = ((FontMetrics)object).stringWidth(this.fLabel);
            this.fTextH = ((FontMetrics)object).getHeight() + n;
            this.fTextBase = ((FontMetrics)object).getAscent() + ((FontMetrics)object).getLeading() + n;
            if (this.fBehavior == 1 && !this.fActiveToggle) {
                this.fTextBase -= ((FontMetrics)object).getLeading() + n;
            }
            if (this.fMnemonic != '\u0000') {
                this.fAltWidth = ((FontMetrics)object).charWidth(this.fMnemonic);
                this.fAltY = 1;
                this.fAltX = this.fAltLead != null ? ((FontMetrics)object).charsWidth(this.fAltLead, 0, this.fAltLead.length) : 0;
            }
        } else {
            this.fTextW = 0;
            this.fTextH = 0;
            this.fTextBase = 0;
        }
    }

    private void calcTextMargin() {
        Font font = this.getFont();
        if (font != null) {
            FontMetrics fontMetrics = this.getFontMetrics(font);
            this.fTextMargin = fontMetrics.stringWidth("3") / 2;
        } else {
            this.fTextMargin = 2;
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    static {
        if (PlatformInfo.useWindowsXPAppearance()) {
            --BEVEL_SIZE;
            MIN_TEXT_WIDTH = 75;
        }
    }
}

