/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt;

import com.mathworks.mwt.MWButton;
import com.mathworks.mwt.MWCheckbox;
import com.mathworks.mwt.MWCombobox;
import com.mathworks.mwt.MWFocusChain;
import com.mathworks.mwt.MWFrame;
import com.mathworks.mwt.MWFrameProxy;
import com.mathworks.mwt.MWListbox;
import com.mathworks.mwt.MWTextArea;
import com.mathworks.mwt.MWTextField;
import com.mathworks.mwt.MWTreeView;
import com.mathworks.mwt.dialog.MWDialog;
import com.mathworks.mwt.table.Table;
import com.mathworks.util.IntBuffer;
import com.mathworks.util.NativeJava;
import com.mathworks.util.PlatformInfo;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;

public class MWUtils {
    public static final int FOCUS_EXTENT = 2;

    private static native short GetCurrentProcess(byte[] var0);

    private static native short SetFrontProcessWithOptions(byte[] var0, int var1);

    private static native short _SetFrontProcessWithOptions(byte[] var0, int var1);

    private MWUtils() {
    }

    public static boolean isAWTEventQueueThread() {
        return EventQueue.isDispatchThread();
    }

    public static Rectangle boundsInTopLevelWindow(Component component) {
        return MWUtils.boundsInOtherComponent(component, MWUtils.getTopLevelWindow(component));
    }

    public static Rectangle boundsInOtherComponent(Component component, Component component2) {
        Dimension dimension = component.getSize();
        Rectangle rectangle = new Rectangle(0, 0, dimension.width, dimension.height);
        MWUtils.mapFromComponentToComponent(rectangle, component, component2);
        return rectangle;
    }

    public static Window getTopLevelWindow(Component component) {
        while (component != null && !(component instanceof Window)) {
            component = component.getParent();
        }
        return (Window)component;
    }

    public static boolean isParentFrameActive(Component component) {
        boolean bl = false;
        while (component != null) {
            if (component instanceof MWFrame) {
                bl = ((MWFrame)component).isFrameActive();
                component = null;
                continue;
            }
            if (component instanceof MWDialog) {
                bl = ((MWDialog)component).isFrameActive();
                component = null;
                continue;
            }
            if (component instanceof MWFrameProxy) {
                bl = ((MWFrameProxy)component).isFrameActive();
                component = null;
                continue;
            }
            component = component.getParent();
        }
        return bl;
    }

    public static MWFocusChain getNextFocusLink(Component component) {
        if (component != null) {
            for (component = component.getParent(); component != null && !(component instanceof MWFocusChain); component = component.getParent()) {
            }
        }
        return (MWFocusChain)((Object)component);
    }

    public static Point mapFromComponentToScreen(Point point, Component component) {
        Point point2 = component.getLocationOnScreen();
        point.translate(point2.x, point2.y);
        return point;
    }

    public static Point mapFromScreenToComponent(Point point, Component component) {
        Point point2 = component.getLocationOnScreen();
        point.translate(-point2.x, -point2.y);
        return point;
    }

    public static Rectangle mapFromComponentToScreen(Rectangle rectangle, Component component) {
        Point point = component.getLocationOnScreen();
        rectangle.translate(point.x, point.y);
        return rectangle;
    }

    public static Rectangle mapFromScreenToComponent(Rectangle rectangle, Component component) {
        Point point = component.getLocationOnScreen();
        rectangle.translate(-point.x, -point.y);
        return rectangle;
    }

    public static Point mapFromComponentToComponent(Point point, Component component, Component component2) {
        MWUtils.mapFromComponentToScreen(point, component);
        MWUtils.mapFromScreenToComponent(point, component2);
        return point;
    }

    public static Rectangle mapFromComponentToComponent(Rectangle rectangle, Component component, Component component2) {
        MWUtils.mapFromComponentToScreen(rectangle, component);
        MWUtils.mapFromScreenToComponent(rectangle, component2);
        return rectangle;
    }

    public static boolean contains(Rectangle rectangle, Rectangle rectangle2) {
        return MWUtils.contains(rectangle, rectangle2.x, rectangle2.y) && MWUtils.contains(rectangle, rectangle2.x + rectangle2.width, rectangle2.y + rectangle2.height);
    }

    public static boolean contains(Rectangle rectangle, Point point) {
        return MWUtils.contains(rectangle, point.x, point.y);
    }

    public static boolean contains(Rectangle rectangle, int n, int n2) {
        return n >= rectangle.x && n - rectangle.x <= rectangle.width && n2 >= rectangle.y && n2 - rectangle.y <= rectangle.height;
    }

    public static Rectangle unionRect(Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        if (rectangle3 == null) {
            rectangle3 = new Rectangle();
        }
        int n = rectangle2.x < rectangle.x ? rectangle2.x : rectangle.x;
        int n2 = rectangle.x + rectangle.width;
        int n3 = rectangle2.x + rectangle2.width;
        rectangle3.width = n3 > n2 ? n3 - n : n2 - n;
        rectangle3.x = n;
        n = rectangle2.y < rectangle.y ? rectangle2.y : rectangle.y;
        n2 = rectangle.y + rectangle.height;
        n3 = rectangle2.y + rectangle2.height;
        rectangle3.height = n3 > n2 ? n3 - n : n2 - n;
        rectangle3.y = n;
        return rectangle3;
    }

    public static Rectangle getFocusBounds(Component component) {
        Rectangle rectangle = null;
        boolean bl = false;
        if (component == null) {
            return rectangle;
        }
        if (PlatformInfo.getAppearance() == 0) {
            if (component instanceof MWListbox || component instanceof MWTreeView) {
                bl = true;
            } else {
                for (component = component.getParent(); component != null; component = component.getParent()) {
                    if (component instanceof MWTextField) {
                        Container container = component.getParent();
                        if (container != null && (container instanceof MWCombobox || container instanceof Table)) break;
                        bl = true;
                        break;
                    }
                    if (!(component instanceof MWTextArea)) continue;
                    if (!MWTextArea.class.equals(component.getClass())) break;
                    bl = true;
                    break;
                }
            }
        } else if (PlatformInfo.getAppearance() == 2 && !bl) {
            if (component instanceof MWButton || component instanceof MWCheckbox) {
                bl = true;
            } else if (component instanceof Table) {
                if (component instanceof MWListbox || component instanceof MWTreeView) {
                    bl = true;
                    for (Container container = component.getParent(); container != null; container = container.getParent()) {
                        if (!(container instanceof MWFrameProxy)) continue;
                        Dimension dimension = container.getSize();
                        Dimension dimension2 = container.getSize();
                        if (dimension.width != dimension2.width || dimension.height != dimension2.height) break;
                        bl = false;
                        break;
                    }
                }
            } else {
                for (component = component.getParent(); component != null; component = component.getParent()) {
                    if (component instanceof MWTextField) {
                        bl = true;
                        Container container = component.getParent();
                        if (container == null) break;
                        if (container instanceof MWCombobox) {
                            component = container;
                            break;
                        }
                        if (!(container instanceof Table)) break;
                        bl = false;
                        break;
                    }
                    if (!(component instanceof MWTextArea)) continue;
                    if (!MWTextArea.class.equals(component.getClass())) break;
                    bl = true;
                    break;
                }
            }
        }
        if (bl) {
            try {
                rectangle = MWUtils.boundsInTopLevelWindow(component);
                rectangle.x -= 2;
                rectangle.y -= 2;
                rectangle.width += 4;
                rectangle.height += 4;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return rectangle;
    }

    public static long hWndFromComponent(Component component) {
        return NativeJava.hWndFromComponent((Component)component);
    }

    public static void enableAllChildren(Container container, boolean bl) {
        boolean bl2 = container.isEnabled();
        MWUtils.doEnableAllChildren(container, bl);
        container.setEnabled(bl2);
    }

    private static void doEnableAllChildren(Container container, boolean bl) {
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            if (component instanceof Container) {
                MWUtils.enableAllChildren((Container)component, bl);
                continue;
            }
            component.setEnabled(bl);
        }
        container.setEnabled(bl);
    }

    public static IntBuffer enableAllChildren(Container container, boolean bl, IntBuffer intBuffer) {
        if (bl) {
            if (intBuffer == null) {
                intBuffer = new IntBuffer(16, 16);
                MWUtils.saveAllStates(container, intBuffer);
            } else {
                MWUtils.doEnableAllChildren(container, intBuffer, 0);
            }
        } else {
            if (intBuffer == null) {
                intBuffer = new IntBuffer(16, 16);
            } else {
                intBuffer.setSize(0);
            }
            MWUtils.doDisableAllChildren(container, intBuffer);
            container.setEnabled(intBuffer.getAt(0) != 0);
        }
        return intBuffer;
    }

    private static void saveAllStates(Container container, IntBuffer intBuffer) {
        intBuffer.append(container.isEnabled() ? 1 : 0);
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            if (component instanceof Container) {
                MWUtils.saveAllStates((Container)component, intBuffer);
                continue;
            }
            intBuffer.append(component.isEnabled() ? 1 : 0);
        }
    }

    private static void doDisableAllChildren(Container container, IntBuffer intBuffer) {
        intBuffer.append(container.isEnabled() ? 1 : 0);
        container.setEnabled(false);
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            if (component instanceof Container) {
                MWUtils.doDisableAllChildren((Container)component, intBuffer);
                continue;
            }
            intBuffer.append(component.isEnabled() ? 1 : 0);
            component.setEnabled(false);
        }
    }

    private static int doEnableAllChildren(Container container, IntBuffer intBuffer, int n) {
        container.setEnabled(intBuffer.getAt(n++) != 0);
        int n2 = container.getComponentCount();
        for (int i = 0; i < n2; ++i) {
            Component component = container.getComponent(i);
            if (component instanceof Container) {
                n = MWUtils.doEnableAllChildren((Container)component, intBuffer, n);
                continue;
            }
            component.setEnabled(intBuffer.getAt(n++) != 0);
        }
        return n;
    }

    public static String shortenString(String string, FontMetrics fontMetrics, int n) {
        String string2;
        int n2;
        int n3 = fontMetrics != null ? fontMetrics.stringWidth("...") : 0;
        int n4 = n2 = fontMetrics != null && string != null ? fontMetrics.stringWidth(string) : 0;
        if (n2 < n) {
            string2 = string;
        } else if (n3 > n) {
            string2 = "";
        } else {
            string2 = new String(string);
            while (n2 + n3 > n) {
                string2 = string2.substring(0, string2.length() - 1);
                n2 = fontMetrics.stringWidth(string2);
            }
            string2 = string2 + "...";
        }
        return string2;
    }

    public static String stripMenuItemLabel(String string) {
        int n = string.lastIndexOf("\t");
        if (n != -1) {
            return MWUtils.stripChar(string.substring(0, n), '&');
        }
        return MWUtils.stripChar(string, '&');
    }

    private static String stripChar(String string, char c) {
        if (string.indexOf(c) != -1) {
            int n = string.length();
            StringBuffer stringBuffer = new StringBuffer(n);
            for (int i = 0; i < n; ++i) {
                char c2 = string.charAt(i);
                if (c2 == c) continue;
                stringBuffer.append(c2);
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public static Point placeOnScreen(Point point, Dimension dimension) {
        return MWUtils.placeOnScreen(point.x, point.y, dimension);
    }

    public static Point placeOnScreen(int n, int n2, Dimension dimension) {
        Point point = new Point();
        point.x = n;
        point.y = n2;
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        if (point.x < 0) {
            point.x = 10;
        } else if (point.x + dimension.width > dimension2.width) {
            point.x = dimension2.width - dimension.width - 8;
            if (point.x < 0) {
                point.x = 10;
            }
        }
        if (point.y < 0) {
            point.y = 10;
        } else if (point.y + dimension.height > dimension2.height) {
            point.y = dimension2.height - dimension.height - 30;
            if (point.y < 0) {
                point.y = 10;
            }
        }
        return point;
    }
}

