/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt.table;

import com.mathworks.mwt.table.TableDataEvent;
import com.mathworks.mwt.table.TableDataListener;
import java.util.Vector;

public abstract class TableData {
    public static final int AT_END = -1;
    private Vector fDataListeners;
    private boolean fFireDataChanged = true;
    private int fRowMin;
    private int fRowMax;
    private int fColMin;
    private int fColMax;

    public abstract Object getData(int var1, int var2);

    public abstract void setData(int var1, int var2, Object var3);

    public abstract void setPort(Object var1, int var2, int var3, int var4, int var5);

    public abstract int getWidth();

    public abstract void setWidth(int var1);

    public abstract int getHeight();

    public abstract void setHeight(int var1);

    public abstract void addRows(int var1, int var2);

    public abstract void addColumns(int var1, int var2);

    public abstract void removeRows(int var1, int var2);

    public abstract void removeColumns(int var1, int var2);

    public String getDataAsText(int n, int n2) {
        Object object = this.getData(n, n2);
        if (object instanceof String) {
            return (String)object;
        }
        return null;
    }

    public void setDataAsText(int n, int n2, String string) {
        this.setData(n, n2, string);
    }

    public void addDataListener(TableDataListener tableDataListener) {
        if (this.fDataListeners == null) {
            this.fDataListeners = new Vector();
        }
        if (!this.fDataListeners.contains(tableDataListener)) {
            this.fDataListeners.addElement(tableDataListener);
        }
    }

    public void removeDataListener(TableDataListener tableDataListener) {
        if (this.fDataListeners == null && this.fDataListeners.contains(tableDataListener)) {
            this.fDataListeners.removeElement(tableDataListener);
        }
    }

    public void suspendDataChangedNotification() {
        this.fFireDataChanged = false;
    }

    public void resumeDataChangedNotification(boolean bl) {
        this.fFireDataChanged = true;
        if (bl) {
            this.fireDataEvent(new TableDataEvent(this.fColMin, this.fRowMin, this.fColMax - this.fColMin + 1, this.fRowMax - this.fRowMin + 1));
        }
        this.fRowMax = 0;
        this.fRowMin = 0;
        this.fColMax = 0;
        this.fColMin = 0;
    }

    protected void fireDataChangedEvent(int n, int n2) {
        if (this.fFireDataChanged) {
            this.fireDataEvent(new TableDataEvent(n2, n, 1, 1));
        } else {
            if (n2 < this.fColMin) {
                this.fColMin = n2;
            } else if (n2 > this.fColMax) {
                this.fColMax = n2;
            }
            if (n < this.fRowMin) {
                this.fRowMin = n;
            } else if (n > this.fRowMax) {
                this.fRowMax = n;
            }
        }
    }

    protected void fireDataEvent(TableDataEvent tableDataEvent) {
        Vector vector = (Vector)this.fDataListeners.clone();
        block7: for (int i = 0; i < vector.size(); ++i) {
            TableDataListener tableDataListener = (TableDataListener)vector.elementAt(i);
            switch (tableDataEvent.getEventType()) {
                case 0: {
                    tableDataListener.dataChanged(tableDataEvent);
                    continue block7;
                }
                case 1: {
                    tableDataListener.dataBoundsChanged(tableDataEvent);
                    continue block7;
                }
                case 2: {
                    tableDataListener.rowsAdded(tableDataEvent);
                    continue block7;
                }
                case 3: {
                    tableDataListener.rowsRemoved(tableDataEvent);
                    continue block7;
                }
                case 4: {
                    tableDataListener.dataBoundsChanging(tableDataEvent);
                }
            }
        }
    }
}

