/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.index;

import com.mathworks.helpsearch.index.DocTraversalStrategy;
import com.mathworks.helpsearch.index.DocumentationDocument;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Queue;

public class DirectoryListingTraversalStrategy
implements DocTraversalStrategy {
    private final Queue<String> fPendingDirs = new LinkedList<String>();
    private final File fBaseDir;
    private String fCurrentDir;

    public DirectoryListingTraversalStrategy(File baseDir) {
        this.fBaseDir = baseDir;
        this.fCurrentDir = "";
        this.fPendingDirs.add("");
    }

    @Override
    public Collection<String> updateAfterDocument(DocumentationDocument lastDocument, boolean indexed) {
        return Collections.emptyList();
    }

    @Override
    public Collection<String> getPendingDocuments() {
        while (!this.fPendingDirs.isEmpty()) {
            this.fCurrentDir = this.fPendingDirs.remove();
            this.updatePendingDirectories();
            Collection<String> docsInCurrentDirectory = this.findHtmlDocsInCurrentDirectory();
            if (docsInCurrentDirectory.isEmpty()) continue;
            return docsInCurrentDirectory;
        }
        return Collections.emptyList();
    }

    private void updatePendingDirectories() {
        File curDir = this.getCurrentDirectory();
        String[] subDirs = curDir.list(new SubDirectoryFileFilter());
        if (subDirs != null) {
            for (String subDir : subDirs) {
                this.fPendingDirs.add(this.fCurrentDir + subDir + "/");
            }
        }
    }

    private Collection<String> findHtmlDocsInCurrentDirectory() {
        File curDir = this.getCurrentDirectory();
        String[] htmlFileNames = curDir.list(new HtmlFileFilter());
        if (htmlFileNames != null) {
            LinkedList<String> htmlFiles = new LinkedList<String>();
            for (String htmlFileName : htmlFileNames) {
                htmlFiles.add(this.fCurrentDir + htmlFileName);
            }
            return htmlFiles;
        }
        return Collections.emptyList();
    }

    private File getCurrentDirectory() {
        return this.fCurrentDir.length() == 0 ? this.fBaseDir : new File(this.fBaseDir, this.fCurrentDir);
    }

    private static class SubDirectoryFileFilter
    implements FilenameFilter {
        private SubDirectoryFileFilter() {
        }

        @Override
        public boolean accept(File file, String name) {
            return new File(file, name).isDirectory();
        }
    }

    private class HtmlFileFilter
    implements FilenameFilter {
        private HtmlFileFilter() {
        }

        @Override
        public boolean accept(File file, String filename) {
            return filename.endsWith(".html");
        }
    }
}

