/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.index;

import com.mathworks.helpsearch.ContentFormat;
import com.mathworks.helpsearch.index.DocumentationDocument;
import com.mathworks.helpsearch.index.report.BackLinkReportItem;
import com.mathworks.helpsearch.index.report.BackLinkReportSerializer;
import com.mathworks.helpsearch.index.report.ReportSerializer;
import com.mathworks.helpsearch.index.report.ReportUtils;
import com.mathworks.helpsearch.index.report.ReportWriter;
import com.mathworks.helpsearch.index.report.SimpleReport;
import com.mathworks.helpsearch.index.report.SimpleReportItemSerializer;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

class ReportBuilder {
    private final Map<String, List<String>> fBackLinks = new HashMap<String, List<String>>();
    private final Map<SimpleReport, Collection<DocumentationDocument>> fReportDocs = new EnumMap<SimpleReport, Collection<DocumentationDocument>>(SimpleReport.class);

    ReportBuilder() {
    }

    protected boolean addToReports(DocumentationDocument doc) {
        List<SimpleReport> reports = ReportBuilder.getReportsForDocument(doc);
        this.addDocumentToReports(doc, reports);
        return ReportBuilder.checkReportsForIndexInclusion(reports);
    }

    private static List<SimpleReport> getReportsForDocument(DocumentationDocument doc) {
        LinkedList<SimpleReport> reports = new LinkedList<SimpleReport>();
        for (SimpleReport report : SimpleReport.values()) {
            if (!report.includeDocument(doc)) continue;
            reports.add(report);
        }
        return reports;
    }

    private void addDocumentToReports(DocumentationDocument doc, List<SimpleReport> reports) {
        for (SimpleReport report : reports) {
            this.addToReport(doc, report);
        }
        Collection<String> outgoingLinks = doc.getOutgoingLinks();
        for (String link : outgoingLinks) {
            this.addBackLink(link, doc.getRelativePath());
        }
    }

    private static boolean checkReportsForIndexInclusion(List<SimpleReport> reports) {
        for (SimpleReport report : reports) {
            if (!report.excludesFromIndex()) continue;
            return false;
        }
        return true;
    }

    private void addToReport(DocumentationDocument doc, SimpleReport report) {
        Collection<DocumentationDocument> reportDocs = this.fReportDocs.get((Object)report);
        if (reportDocs == null) {
            reportDocs = new LinkedList<DocumentationDocument>();
            this.fReportDocs.put(report, reportDocs);
        }
        reportDocs.add(doc);
    }

    private void addBackLink(String to, String from) {
        List<String> backLinks = this.fBackLinks.get(to);
        if (backLinks == null) {
            backLinks = new LinkedList<String>();
            this.fBackLinks.put(to, backLinks);
        }
        backLinks.add(from);
    }

    protected void reportBrokenLink(DocumentationDocument doc) {
        doc.setTitle(doc.getRelativePath());
        this.addToReport(doc, SimpleReport.BROKEN_LINK);
    }

    boolean writeAllReports(File resourceDir, ContentFormat format) throws IOException {
        if (resourceDir != null) {
            File reportsDir = new File(resourceDir, "reports");
            boolean exists = reportsDir.exists();
            if (!exists) {
                exists = reportsDir.mkdirs();
            }
            if (exists) {
                this.writeSimpleReports(reportsDir);
                if (ReportUtils.supportsBacklinks(format)) {
                    this.writeBackLinks(reportsDir);
                }
                return true;
            }
        }
        return false;
    }

    private void writeSimpleReports(File reportsDir) throws IOException {
        for (Map.Entry<SimpleReport, Collection<DocumentationDocument>> entry : this.fReportDocs.entrySet()) {
            File reportFile = new File(reportsDir, entry.getKey().getFileName());
            SimpleReportItemSerializer serializer = new SimpleReportItemSerializer();
            ReportBuilder.writeReportFile(reportFile, serializer, entry.getValue());
        }
    }

    private void writeBackLinks(File reportsDir) throws IOException {
        LinkedList<BackLinkReportItem> items = new LinkedList<BackLinkReportItem>();
        for (Map.Entry<String, List<String>> links : this.fBackLinks.entrySet()) {
            items.add(new BackLinkReportItem(links.getKey(), links.getValue()));
        }
        File file = new File(reportsDir, "backlinks.txt");
        ReportBuilder.writeReportFile(file, new BackLinkReportSerializer(), items);
    }

    private static <T> void writeReportFile(File file, ReportSerializer<T> serializer, Collection<T> docs) throws IOException {
        ReportWriter<T> writer = new ReportWriter<T>(file, serializer);
        writer.writeReport(docs);
    }

    Map<SimpleReport, Integer> createProductReportSummary() {
        EnumMap<SimpleReport, Integer> reportSummary = new EnumMap<SimpleReport, Integer>(SimpleReport.class);
        for (Map.Entry<SimpleReport, Collection<DocumentationDocument>> entry : this.fReportDocs.entrySet()) {
            SimpleReport report = entry.getKey();
            int numDocs = entry.getValue() == null ? 0 : entry.getValue().size();
            reportSummary.put(report, numDocs);
        }
        return reportSummary;
    }
}

