/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.index.doccenter;

import com.mathworks.helpsearch.CategoryUtils;
import com.mathworks.helpsearch.ResultCategory;
import com.mathworks.helpsearch.index.DocumentationDocument;
import com.mathworks.helpsearch.index.IndexUtils;
import com.mathworks.helpsearch.index.XmlFragmentHandler;
import com.mathworks.helpsearch.index.XmlFragmentReader;
import com.mathworks.helpsearch.index.XmlTagInfo;
import com.mathworks.helpsearch.index.doccenter.DocCenterHtmlTagUtils;
import com.mathworks.helpsearch.product.DocProduct;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class BreadCrumbFragmentHandler
implements XmlFragmentHandler,
XmlFragmentReader {
    private ResultCategory fCurrentCategory;
    private final List<ResultCategory> fBreadCrumbs = new ArrayList<ResultCategory>();
    private final String[] fDocDirs;
    private final DocProduct fProduct;
    private StringBuilder fLabel;
    private String fRelPath;
    private String fId;
    private boolean fUnused = false;
    private boolean fMalformed = false;

    BreadCrumbFragmentHandler(DocProduct product, String docPath) {
        this.fProduct = product;
        this.fDocDirs = IndexUtils.getDirectoriesForFilePath(docPath);
    }

    @Override
    public String[] getEnclosingTagNames() {
        return new String[]{"div"};
    }

    @Override
    public boolean useHandler(XmlTagInfo xmlItem) {
        return DocCenterHtmlTagUtils.isBreadCrumbContainerTag(xmlItem);
    }

    @Override
    public boolean continueHandling() {
        return false;
    }

    @Override
    public XmlFragmentReader startFragment(XmlTagInfo location) {
        this.fCurrentCategory = null;
        return this;
    }

    @Override
    public void startElement(XmlTagInfo tagInfo) {
        if (tagInfo.getTagName().equals("a")) {
            this.fLabel = new StringBuilder();
            String href = tagInfo.getAttribute("href");
            if (IndexUtils.includeLinkInBreadCrumb(href = IndexUtils.resolveRelativePath(href, this.fDocDirs))) {
                this.fRelPath = href;
                this.fId = CategoryUtils.createIdFromFilePath(this.fProduct, this.fRelPath);
            } else {
                this.fRelPath = null;
                this.fId = null;
            }
        }
    }

    @Override
    public void characters(XmlTagInfo position, String chars) {
        if (this.fLabel != null) {
            this.fLabel.append(chars);
        }
    }

    @Override
    public void endElement(XmlTagInfo location) {
        String tagName = location.getTagName();
        if (tagName.equals("a")) {
            String label = this.fLabel.toString();
            if (this.fId != null) {
                if (label.startsWith("UNUSED TOPICS FOR")) {
                    this.fUnused = true;
                } else if (label.trim().length() == 0) {
                    this.fMalformed = true;
                }
                this.fCurrentCategory = new ResultCategory(this.fCurrentCategory, label, this.fRelPath, this.fId);
            }
            this.fLabel = null;
            this.fRelPath = null;
            this.fId = null;
        }
    }

    @Override
    public void endFragment(XmlTagInfo location) {
        if (this.fCurrentCategory != null) {
            this.fBreadCrumbs.add(this.fCurrentCategory);
        }
    }

    private List<ResultCategory> getBreadCrumbs() {
        return Collections.unmodifiableList(this.fBreadCrumbs);
    }

    private boolean isUnusedCategory() {
        return this.fUnused;
    }

    private boolean isMalformed() {
        return this.fMalformed;
    }

    @Override
    public void populateDocument(DocumentationDocument doc) {
        List<ResultCategory> existing = doc.getBreadCrumbs();
        if (existing == null || existing.isEmpty()) {
            List<ResultCategory> breadCrumbs = this.getBreadCrumbs();
            doc.setBreadCrumbs(breadCrumbs);
            doc.setUnused(this.isUnusedCategory());
            doc.setBreadCrumbMalformed(this.isMalformed());
        }
    }
}

