/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.reference;

import com.mathworks.helpsearch.reference.RefEntityType;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ReferenceEntity {
    private static final Pattern INDEX_STRING_PATTERN = Pattern.compile("^(\\w*)\\|(.+)");
    private static final Pattern METADATA_PATTERN = Pattern.compile("^(\\w+):(.+)");
    private final RefEntityType fType;
    private final String fName;

    public ReferenceEntity(RefEntityType type, String name) {
        this.fType = type;
        this.fName = name;
    }

    public static ReferenceEntity fromRefPageMetaData(String metaData) {
        RefEntityType type;
        if (metaData == null) {
            return null;
        }
        Matcher m = METADATA_PATTERN.matcher(metaData);
        if (m.find() && (type = RefEntityType.resolve(m.group(1))) != null) {
            return new ReferenceEntity(type, m.group(2));
        }
        return null;
    }

    public static List<ReferenceEntity> fromIndexString(String indexString) {
        if (indexString == null) {
            return Collections.emptyList();
        }
        String[] parts = indexString.split("\\n");
        LinkedList<ReferenceEntity> entities = new LinkedList<ReferenceEntity>();
        for (String part : parts) {
            ReferenceEntity entity = ReferenceEntity.fromIndexStringSegment(part);
            if (entity == null) continue;
            entities.add(entity);
        }
        return entities;
    }

    private static ReferenceEntity fromIndexStringSegment(String indexStringPart) {
        Matcher m = INDEX_STRING_PATTERN.matcher(indexStringPart);
        if (m.find()) {
            String typePart = m.group(1);
            String namePart = m.group(2);
            return ReferenceEntity.fromIndexStringParts(typePart, namePart);
        }
        return null;
    }

    private static ReferenceEntity fromIndexStringParts(String typePart, String namePart) {
        RefEntityType type = RefEntityType.resolve(typePart);
        String name = ReferenceEntity.getEntityNameForIndexStringPart(namePart);
        return new ReferenceEntity(type, name);
    }

    public RefEntityType getType() {
        return this.fType;
    }

    public String getName() {
        return this.fName;
    }

    public String getFullIndexString() {
        String nameString = this.getIndexStringForEntityName();
        return (this.fType == null ? "" : this.fType.getIndexValue()) + '|' + nameString;
    }

    public String getIndexStringForEntityName() {
        return ReferenceEntity.getIndexStringForEntityName(this.fName);
    }

    public static String getIndexStringForEntityName(String entityName) {
        return ReferenceEntity.reverseParts(entityName, "\\.", '/');
    }

    public static String getEntityNameForIndexStringPart(String indexString) {
        return ReferenceEntity.reverseParts(indexString, "/", '.');
    }

    private static String reverseParts(String toReverse, String splitRegexp, char replacement) {
        if (toReverse == null || toReverse.matches("^\\W*$")) {
            return toReverse;
        }
        String[] parts = toReverse.split(splitRegexp);
        if (parts == null || parts.length == 0) {
            return null;
        }
        if (parts.length == 1) {
            return parts[0];
        }
        StringBuilder replaced = new StringBuilder();
        for (String part : parts) {
            replaced.insert(0, replacement).insert(0, part);
        }
        return replaced.deleteCharAt(replaced.length() - 1).toString();
    }

    public int hashCode() {
        return (this.fType == null ? 0 : this.fType.hashCode()) + this.fName.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof ReferenceEntity) {
            ReferenceEntity other = (ReferenceEntity)o;
            return other.fType == this.fType && other.fName.equals(this.fName);
        }
        return false;
    }

    public String toString() {
        return (this.fType == null ? "" : this.fType) + ":" + this.fName;
    }
}

