/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.reference;

import com.mathworks.helpsearch.DocSearchEngineFactory;
import com.mathworks.helpsearch.SearchConfig;
import com.mathworks.helpsearch.product.DocumentationSet;
import com.mathworks.helpsearch.reference.ReferenceData;
import com.mathworks.helpsearch.reference.ReferenceRequest;
import com.mathworks.helpsearch.reference.ReferenceRetrievalStrategy;
import com.mathworks.search.ListSearchResultCollector;
import com.mathworks.search.SearchCriteria;
import com.mathworks.search.SearchEngine;
import com.mathworks.search.SearchException;
import com.mathworks.search.SearchResult;
import com.mathworks.search.SearchResultAdapter;
import com.mathworks.search.SearchResultCollector;
import com.mathworks.search.SearchResults;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SearchEngineReferenceStrategy
implements ReferenceRetrievalStrategy {
    private final SearchEngine fSearchEngine;
    private final SearchResultAdapter<ReferenceData> fResultAdapter;

    public SearchEngineReferenceStrategy(SearchConfig config, DocumentationSet docSet) {
        this(DocSearchEngineFactory.createSearchEngine(config, docSet), docSet);
    }

    SearchEngineReferenceStrategy(SearchEngine engine, DocumentationSet docSet) {
        this.fSearchEngine = engine;
        this.fResultAdapter = new ReferenceDataAdapter(docSet);
    }

    @Override
    public List<ReferenceData> getReferenceData(ReferenceRequest request) {
        try {
            SearchCriteria criteria = new SearchCriteria(request.getFullSearchExpression());
            SearchResults<ReferenceData> results = this.getReferenceData(criteria);
            return SearchEngineReferenceStrategy.toList(results);
        }
        catch (Exception ioe) {
            return Collections.emptyList();
        }
    }

    @Override
    public void close() throws IOException {
        this.fSearchEngine.closeIndex();
    }

    private SearchResults<ReferenceData> getReferenceData(SearchCriteria criteria) throws IOException, SearchException {
        ListSearchResultCollector collector = ListSearchResultCollector.createCollector(this.fResultAdapter);
        this.fSearchEngine.search(criteria, new SearchResultCollector[]{collector});
        SearchResults results = collector.getResults(0, collector.getNumResults());
        return results;
    }

    private static List<ReferenceData> toList(SearchResults<ReferenceData> results) {
        ArrayList<ReferenceData> resultsList = new ArrayList<ReferenceData>(results.getNumIncluded());
        for (ReferenceData data : results) {
            resultsList.add(data);
        }
        return resultsList;
    }

    private static class ReferenceDataAdapter
    implements SearchResultAdapter<ReferenceData> {
        private final DocumentationSet iDocSet;

        private ReferenceDataAdapter(DocumentationSet docSet) {
            this.iDocSet = docSet;
        }

        public ReferenceData adaptResult(SearchResult result) {
            return ReferenceData.fromSearchResult(this.iDocSet, result);
        }
    }
}

