/*
 * Decompiled with CFR 0.152.
 */
package ice.storm;

import ice.debug.Debug;
import ice.storm.ContentLoader;
import ice.storm.Pilot;
import ice.storm.PilotFactory;
import ice.storm.PilotInfo;
import ice.storm.Scripter;
import ice.storm.ScripterInfo;
import ice.storm.StormPropertiesLoader;
import ice.storm.URLClassLoaderFactory;
import ice.util.Defs;
import ice.util.security.SecurityKit;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class DefaultFactory
implements PilotFactory,
URLClassLoaderFactory {
    private Vector OEAB = new Vector();
    private Vector Z = new Vector();
    private Hashtable addElement = new Hashtable();
    private Hashtable addScripterInfo = new Hashtable();

    public void addPilotInfo(PilotInfo pilotInfo) {
        this.OEAB.addElement(pilotInfo);
    }

    public void removePilotInfo(PilotInfo pilotInfo) {
        this.OEAB.removeElement(pilotInfo);
    }

    public void addScripterInfo(ScripterInfo scripterInfo) {
        if (scripterInfo.aliases != null && scripterInfo.aliases.length > 0) {
            this.Z.addElement(scripterInfo);
            int n = 0;
            while (n < scripterInfo.aliases.length) {
                this.addElement.put(scripterInfo.aliases[n], scripterInfo);
                ++n;
            }
        }
    }

    public void removeScripterInfo(ScripterInfo scripterInfo) {
        if (this.Z.removeElement(scripterInfo)) {
            int n = 0;
            while (n < scripterInfo.aliases.length) {
                this.addElement.remove(scripterInfo.aliases[n]);
                ++n;
            }
        }
    }

    public Enumeration getAllPilotInfos() {
        return this.OEAB.elements();
    }

    public Enumeration getAllScripterInfos() {
        return this.Z.elements();
    }

    public Scripter createScripter(String string) {
        ScripterInfo scripterInfo = this.getScripterInfo(string);
        if (scripterInfo == null) {
            return null;
        }
        Scripter scripter = (Scripter)Defs.newClassInstance((String)scripterInfo.className);
        if (scripter == null) {
            if (Debug.trace) {
                Debug.trace((String)("Failed to load scripter for " + string));
            }
            this.removeScripterInfo(scripterInfo);
            return null;
        }
        scripterInfo.loaded = true;
        return scripter;
    }

    public ScripterInfo getScripterInfo(String string) {
        ScripterInfo scripterInfo = (ScripterInfo)this.addElement.get(string.toLowerCase());
        if (scripterInfo != null && !scripterInfo.enabled) {
            scripterInfo = null;
        }
        return scripterInfo;
    }

    public Pilot createPilot(String string) {
        int n = string.indexOf(59);
        if (n > 0) {
            string = string.substring(0, n);
        }
        Pilot pilot = null;
        int n2 = 0;
        block0: while (n2 < this.OEAB.size()) {
            PilotInfo pilotInfo = (PilotInfo)this.OEAB.elementAt(n2);
            if (pilotInfo.enabled) {
                int n3 = 0;
                while (n3 < pilotInfo.supportedContentTypes.length) {
                    String string2 = pilotInfo.supportedContentTypes[n3];
                    if (this.addScripterInfo(string2, string) && (pilot = this.OEAB(pilotInfo)) != null) break block0;
                    ++n3;
                }
            }
            ++n2;
        }
        return pilot;
    }

    public Pilot createPilot(ContentLoader contentLoader) {
        String string = this.extractContentType(contentLoader);
        return this.createPilot(string);
    }

    private Pilot OEAB(PilotInfo pilotInfo) {
        Pilot pilot;
        block6: {
            pilot = null;
            try {
                if (pilotInfo.cl == null && pilotInfo.codeBaseURLs != null && pilotInfo.codeBaseURLs.length > 0) {
                    pilotInfo.cl = this.createURLClassLoader(pilotInfo.codeBaseURLs);
                }
                Class<?> clazz = pilotInfo.cl != null ? pilotInfo.cl.loadClass(pilotInfo.className) : Class.forName(pilotInfo.className);
                pilot = (Pilot)Defs.newClassInstance(clazz);
            }
            catch (Throwable throwable) {
                if (!Debug.ex) break block6;
                Debug.ex((Throwable)throwable);
            }
        }
        if (pilot != null) {
            pilotInfo.loaded = true;
        } else {
            if (Debug.trace) {
                Debug.trace((String)("Could not load " + pilotInfo.className));
            }
            this.removePilotInfo(pilotInfo);
        }
        return pilot;
    }

    public boolean isContentTypeSupported(Pilot pilot, ContentLoader contentLoader, String string) {
        String string2 = pilot.getClass().getName();
        if (string == null) {
            string = this.extractContentType(contentLoader);
        }
        int n = 0;
        int n2 = this.OEAB.size() - 1;
        while (n != n2) {
            PilotInfo pilotInfo = (PilotInfo)this.OEAB.elementAt(n);
            if (pilotInfo.enabled && string2.equals(pilotInfo.className)) {
                String[] stringArray = pilotInfo.supportedContentTypes;
                int n3 = 0;
                int n4 = stringArray.length;
                while (n3 != n4) {
                    if (this.addScripterInfo(stringArray[n3], string)) {
                        return true;
                    }
                    ++n3;
                }
            }
            ++n;
        }
        return false;
    }

    public ClassLoader createURLClassLoader(URL[] uRLArray) {
        return SecurityKit.newURLClassLoader((URL[])uRLArray);
    }

    protected void loadDefaultResources() {
        boolean bl;
        block13: {
            Object object;
            block12: {
                String string = Defs.sysProperty((String)"ice.storm.storm");
                bl = false;
                if (string != null) {
                    try {
                        object = new URL(string);
                        InputStream inputStream = ((URL)object).openStream();
                        try {
                            this.Z(inputStream);
                            bl = true;
                            Object var6_6 = null;
                        }
                        catch (Throwable throwable) {
                            Object var6_7 = null;
                            inputStream.close();
                            throw throwable;
                        }
                        inputStream.close();
                        {
                        }
                    }
                    catch (IOException iOException) {
                        if (Debug.ex) {
                            Debug.ex((Throwable)iOException);
                        }
                        if (!Debug.trace) break block12;
                        Debug.trace((String)("ERROR: failed to load properties from " + string + ", trying built-in."));
                    }
                }
            }
            if (!bl && (object = this.getClass().getResourceAsStream("storm")) != null) {
                try {
                    try {
                        this.Z((InputStream)object);
                        bl = true;
                        Object var8_9 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_10 = null;
                        ((InputStream)object).close();
                        throw throwable;
                    }
                    ((InputStream)object).close();
                    {
                    }
                }
                catch (IOException iOException) {
                    if (!Debug.ex) break block13;
                    Debug.ex((Throwable)iOException);
                }
            }
        }
        if (!bl && Debug.trace) {
            Debug.trace((String)"ERROR: Could not load default storm properties file");
        }
    }

    private void Z(InputStream inputStream) throws IOException {
        StormPropertiesLoader stormPropertiesLoader = new StormPropertiesLoader();
        stormPropertiesLoader.loadProperties(inputStream, this.addScripterInfo);
        Object e = null;
        int n = this.OEAB.size();
        if (n > 0) {
            e = this.OEAB.elementAt(n - 1);
            this.OEAB.removeElementAt(n - 1);
        }
        int n2 = 0;
        while (n2 < stormPropertiesLoader.infos.size()) {
            this.OEAB.addElement(stormPropertiesLoader.infos.elementAt(n2));
            ++n2;
        }
        if (e != null) {
            this.OEAB.addElement(e);
        }
        int n3 = 0;
        while (n3 < stormPropertiesLoader.scripters.size()) {
            ScripterInfo scripterInfo = (ScripterInfo)stormPropertiesLoader.scripters.elementAt(n3);
            this.addScripterInfo(scripterInfo);
            ++n3;
        }
    }

    protected String extractContentType(ContentLoader contentLoader) {
        String string = contentLoader.getContentType();
        String string2 = null;
        if (string == null) {
            string2 = this.addElement(contentLoader.getLocation());
        } else {
            int n = (string = string.toLowerCase()).indexOf(59);
            if (n >= 0) {
                string = string.substring(0, n).trim();
            } else if (string.indexOf("unknown") >= 0) {
                string2 = this.addElement(contentLoader.getLocation());
            } else if (string.equalsIgnoreCase("text/html") || string.equalsIgnoreCase("text/plain")) {
                // empty if block
            }
        }
        if (string2 != null) {
            string = string2;
            contentLoader.setContentType(string2);
        }
        return string;
    }

    private String addElement(String string) {
        String string2;
        int n;
        String string3 = "content/unknown";
        String string4 = null;
        if (string != null && (n = string.lastIndexOf(47)) >= 0) {
            int n2 = string.indexOf(35, n + 1);
            int n3 = string.indexOf(63, n + 1);
            int n4 = n2 < 0 || n3 < 0 ? string.length() : (n2 < 0 || n2 > n3 ? n3 : n2);
            int n5 = string.lastIndexOf(46, n4 - 1);
            if (n5 > n && n5 != n4 - 1) {
                string4 = string.substring(n5, n4);
            }
        }
        if (string4 != null && (string2 = (String)this.addScripterInfo.get(string4)) != null) {
            string3 = string2;
        }
        return string3;
    }

    private boolean addScripterInfo(String string, String string2) {
        if (string.indexOf(42) < 0) {
            return string.equals(string2);
        }
        int n = string.indexOf(47);
        if (n < 0) {
            return string.length() == 1;
        }
        String string3 = string.substring(0, n);
        String string4 = string.substring(n + 1);
        return !(!string3.equals("*") && !string2.startsWith(string3) || !string4.equals("*") && !string2.endsWith(string4));
    }
}

