/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html;

import com.mathworks.html.AggregatePageChangedListener;
import com.mathworks.html.AggregateStatusTextListener;
import com.mathworks.html.BasicHtmlActionStateManager;
import com.mathworks.html.DefaultContextMenuBuilder;
import com.mathworks.html.FileExtensionHandler;
import com.mathworks.html.FindOption;
import com.mathworks.html.HtmlActionStateManager;
import com.mathworks.html.HtmlActions;
import com.mathworks.html.HtmlComponent;
import com.mathworks.html.HtmlContextMenuBuilder;
import com.mathworks.html.HtmlDataListener;
import com.mathworks.html.HtmlFindInPage;
import com.mathworks.html.HtmlPanelContextMenuHandler;
import com.mathworks.html.HtmlPanelSupport;
import com.mathworks.html.HtmlPanelSupportFactory;
import com.mathworks.html.HtmlUtils;
import com.mathworks.html.PageChangedEvent;
import com.mathworks.html.PageChangedListener;
import com.mathworks.html.PopupWindowListener;
import com.mathworks.html.RequestHandler;
import com.mathworks.html.StatusTextListener;
import com.mathworks.html.jxbrowser.JxBrowserFactory;
import java.awt.Component;
import java.io.File;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public final class HtmlPanel<T extends HtmlActions>
implements HtmlComponent<T> {
    private static File sResourceDir;
    private final HtmlPanelSupport fSupport;
    private final AggregatePageChangedListener fPageChangedListener = new AggregatePageChangedListener();
    private final AggregateStatusTextListener fStatusListener = new AggregateStatusTextListener();
    private final List<HtmlActionStateManager<? super T>> fStateManagers = new LinkedList<HtmlActionStateManager<? super T>>();
    private T fActions;
    private String fHomeUrl = null;
    private HtmlContextMenuBuilder<T> fHtmlContextMenuBuilder;
    private boolean fNavigationEnabled = true;

    public HtmlPanel() {
        this(BrowserType.JXBROWSER);
    }

    public HtmlPanel(BrowserType browserType) {
        this(HtmlPanel.getImplementorFactory(browserType));
    }

    public HtmlPanel(final HtmlPanelSupportFactory htmlPanelSupportFactory) {
        this.fSupport = htmlPanelSupportFactory.buildSupport(this.fPageChangedListener, this.fStatusListener);
        this.fSupport.setContextMenuHandler(new HtmlPanelContextMenuHandler(this));
        this.fSupport.addRequestHandler(new FileExtensionHandler("pdf", "doc", "docx", "c", "cpp"));
        this.fHtmlContextMenuBuilder = new DefaultContextMenuBuilder();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                htmlPanelSupportFactory.doWhenPanelCreated(new UpdateActionStatesListener());
            }
        });
    }

    private void updateActionStates() {
        T t = this.getActions();
        if (t != null) {
            for (HtmlActionStateManager<T> htmlActionStateManager : this.fStateManagers) {
                htmlActionStateManager.updateActionStates(t);
            }
        }
    }

    private static HtmlPanelSupportFactory getImplementorFactory(BrowserType browserType) {
        switch (browserType) {
            default: 
        }
        return new JxBrowserFactory();
    }

    public BrowserType getBrowserType() {
        return this.fSupport.getBrowserType();
    }

    @Override
    public JComponent getComponent() {
        return this.fSupport.getComponent();
    }

    @Override
    public boolean isInitialized() {
        return this.fSupport.isInitialized();
    }

    @Override
    public void setCurrentLocation(String string) {
        string = HtmlUtils.correctUrl(string);
        this.fSupport.setCurrentLocation(string);
    }

    @Override
    public void setHtmlText(String string) {
        this.fSupport.setHtmlText(string);
    }

    @Override
    public String getCurrentLocation() {
        return this.fSupport.getCurrentLocation();
    }

    @Override
    public String getTitle() {
        return this.fSupport.getTitle();
    }

    @Override
    public void executeScript(String string) {
        this.executeScript(string, null);
    }

    @Override
    public void executeScript(String string, HtmlDataListener<String> htmlDataListener) {
        this.fSupport.executeScript(string, htmlDataListener);
    }

    @Override
    public boolean canGoBack() {
        return this.fNavigationEnabled && this.fSupport.canGoBack();
    }

    @Override
    public void goBack() {
        if (this.fNavigationEnabled) {
            this.fSupport.goBack();
        }
    }

    @Override
    public boolean canGoForward() {
        return this.fNavigationEnabled && this.fSupport.canGoForward();
    }

    @Override
    public void goForward() {
        if (this.fNavigationEnabled) {
            this.fSupport.goForward();
        }
    }

    @Override
    public void reload() {
        if (this.fNavigationEnabled) {
            this.fSupport.reload();
        }
    }

    public void setHomeUrl(String string) {
        this.fHomeUrl = string;
    }

    @Override
    public String getHomeUrl() {
        return this.fHomeUrl;
    }

    @Override
    public String getSelectedText() {
        return this.fSupport.getSelectedText();
    }

    @Override
    @Deprecated
    public void getSelectedText(HtmlDataListener<String> htmlDataListener) {
        htmlDataListener.dataRetrieved(this.getSelectedText());
    }

    public void addSelectedTextListener(HtmlDataListener<String> htmlDataListener) {
        this.fSupport.addSelectedTextListener(htmlDataListener);
    }

    public void removeSelectedTextListener(HtmlDataListener<String> htmlDataListener) {
        this.fSupport.removeSelectedTextListener(htmlDataListener);
    }

    @Override
    public String getHtmlText() {
        return this.fSupport.getHtmlText();
    }

    @Override
    public boolean isPrintingSupported() {
        return this.fSupport.isPrintingSupported();
    }

    @Override
    public void print() {
        this.fSupport.print();
    }

    @Override
    public void saveAs(File file) {
        this.fSupport.saveAs(file);
    }

    @Override
    public void dispose() {
        this.fSupport.dispose();
        if (this.fActions != null) {
            this.fActions.dispose();
        }
    }

    @Override
    public void addPageChangedListener(PageChangedListener pageChangedListener) {
        this.fPageChangedListener.addListener(pageChangedListener);
    }

    @Override
    public void removePageChangedListener(PageChangedListener pageChangedListener) {
        this.fPageChangedListener.removeListener(pageChangedListener);
    }

    @Override
    public void addStatusTextListener(StatusTextListener statusTextListener) {
        this.fStatusListener.addListener(statusTextListener);
    }

    @Override
    public void removeStatusTextListener(StatusTextListener statusTextListener) {
        this.fStatusListener.removeListener(statusTextListener);
    }

    @Override
    public void disableNavigation() {
        this.fNavigationEnabled = false;
        if (this.fActions != null) {
            this.fActions.removeNavigationActions();
        }
    }

    public void addRequestHandler(RequestHandler requestHandler) {
        this.fSupport.addRequestHandler(requestHandler);
    }

    public void setActions(T t) {
        if (!this.fNavigationEnabled && t != null) {
            t.removeNavigationActions();
        }
        this.fActions = t;
    }

    @Override
    public T getActions() {
        return this.fActions;
    }

    public HtmlContextMenuBuilder<T> getContextMenuBuilder() {
        return this.fHtmlContextMenuBuilder;
    }

    public void setHtmlContextMenuBuilder(HtmlContextMenuBuilder<T> htmlContextMenuBuilder) {
        this.fHtmlContextMenuBuilder = htmlContextMenuBuilder;
    }

    @Override
    public void findInPage(String string, Collection<FindOption> collection, HtmlDataListener<Boolean> htmlDataListener) {
        HtmlFindInPage htmlFindInPage = this.fSupport.getFindInPage();
        htmlFindInPage.find(string, collection, htmlDataListener);
    }

    public void addHtmlActionStateManager(HtmlActionStateManager<? super T> htmlActionStateManager) {
        this.fStateManagers.add(htmlActionStateManager);
    }

    public static synchronized void setResourceDirectory(File file) {
        sResourceDir = file;
    }

    public static synchronized File getResourceDirectory() {
        return sResourceDir;
    }

    public void setPopupWindowListener(PopupWindowListener<T> popupWindowListener) {
        this.fSupport.setPopupWindowListener(popupWindowListener);
    }

    private class UpdateActionStatesListener
    implements HtmlPanelSupportFactory.ComponentCreatedListener {
        private UpdateActionStatesListener() {
        }

        @Override
        public void panelCreated(Component component) {
            HtmlPanel.this.fStateManagers.add(new BasicHtmlActionStateManager(HtmlPanel.this));
            HtmlPanel.this.addSelectedTextListener(new HtmlDataListener<String>(){

                @Override
                public void dataRetrieved(String string) {
                    HtmlPanel.this.updateActionStates();
                }
            });
            HtmlPanel.this.addPageChangedListener(new PageChangedListener(){

                @Override
                public void pageChanged(PageChangedEvent pageChangedEvent) {
                    HtmlPanel.this.updateActionStates();
                }
            });
        }
    }

    public static enum BrowserType {
        JXBROWSER;

    }
}

