/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html.jxbrowser;

import com.mathworks.html.HtmlDataListener;
import com.mathworks.html.jxbrowser.JxBrowserSwingComponent;
import com.teamdev.jxbrowser.Browser;
import java.awt.Component;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class FocusTracker
implements FocusListener,
PropertyChangeListener,
AncestorListener {
    private final JComponent fBrowserComponent;
    private final List<Component> fComponentsToTrack;
    private final List<HtmlDataListener<Boolean>> fFocusChangeListeners = new LinkedList<HtmlDataListener<Boolean>>();
    private final MouseListener fFocusTrackerMouseListener = new FocusTrackerMouseListener();
    private final FocusTrackerWindowListener fWindowListener = new FocusTrackerWindowListener();
    private boolean fFocused = false;
    private boolean fNativeFocusListenersInstalled = false;

    FocusTracker(JxBrowserSwingComponent jxBrowserSwingComponent) {
        this(jxBrowserSwingComponent, FocusTracker.findComponentsForFocusTracking(jxBrowserSwingComponent.getBrowser()));
    }

    private static List<Component> findComponentsForFocusTracking(Browser browser) {
        switch (browser.getType()) {
            case IE: {
                Container container = (Container)browser.getComponent();
                return Arrays.asList(container.getComponents()[0]);
            }
            case Mozilla: {
                return Arrays.asList(browser.getComponent());
            }
            case Safari: {
                LinkedList<Component> linkedList = new LinkedList<Component>();
                Component component = browser.getComponent();
                linkedList.add(component);
                if (component instanceof Container) {
                    linkedList.addAll(Arrays.asList(((Container)component).getComponents()));
                }
                Collections.reverse(linkedList);
                return linkedList;
            }
        }
        return null;
    }

    protected FocusTracker(JComponent jComponent, Collection<Component> collection) {
        this.fBrowserComponent = jComponent;
        this.fComponentsToTrack = new LinkedList<Component>(collection);
    }

    public void install() {
        for (Component component : this.fComponentsToTrack) {
            component.addFocusListener(this);
        }
        this.fBrowserComponent.addMouseListener(this.fFocusTrackerMouseListener);
    }

    Component getNativeComponentForFocus() {
        return this.fComponentsToTrack.get(0);
    }

    protected void focusChanged(boolean bl) {
        if (this.fFocused != bl) {
            this.fFocused = bl;
            for (HtmlDataListener<Boolean> htmlDataListener : this.fFocusChangeListeners) {
                htmlDataListener.dataRetrieved(bl);
            }
            if (!bl) {
                this.handleNativeFocusLost();
            }
        }
    }

    public final boolean hasFocus() {
        return this.fFocused;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.focusChanged(true);
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (this.hasFocus()) {
            Component component = focusEvent.getOppositeComponent();
            if (component != null && !this.fComponentsToTrack.contains(component)) {
                this.focusChanged(false);
            } else if (component == null) {
                this.handleNativeFocusGained();
            }
        }
    }

    private void handleNativeFocusGained() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", this);
        this.fWindowListener.updateWindow();
        this.fBrowserComponent.addAncestorListener(this);
        this.fNativeFocusListenersInstalled = true;
    }

    private void handleNativeFocusLost() {
        if (this.fNativeFocusListenersInstalled) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("focusOwner", this);
            this.fBrowserComponent.removeAncestorListener(this);
            this.fWindowListener.remove();
            this.fNativeFocusListenersInstalled = false;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getNewValue();
        if (object instanceof Component && this.hasFocus() && !this.isFocusChangeToBrowser((Component)object)) {
            this.focusChanged(false);
        }
    }

    private boolean isFocusChangeToBrowser(Component component) {
        return component != null && (this.fComponentsToTrack.contains(component) || this.fBrowserComponent.equals(component));
    }

    @Override
    public void ancestorAdded(AncestorEvent ancestorEvent) {
        this.fWindowListener.updateWindow();
    }

    @Override
    public void ancestorRemoved(AncestorEvent ancestorEvent) {
        this.fWindowListener.updateWindow();
    }

    @Override
    public void ancestorMoved(AncestorEvent ancestorEvent) {
    }

    public void addFocusChangeListener(HtmlDataListener<Boolean> htmlDataListener) {
        this.fFocusChangeListeners.add(htmlDataListener);
    }

    protected MouseListener getMouseListener() {
        return this.fFocusTrackerMouseListener;
    }

    protected WindowListener getWindowListener() {
        return this.fWindowListener;
    }

    private class FocusTrackerWindowListener
    extends WindowAdapter {
        private Window iBrowserWindow;

        private FocusTrackerWindowListener() {
        }

        private void updateWindow() {
            Window window = SwingUtilities.windowForComponent(FocusTracker.this.fBrowserComponent);
            if (this.iBrowserWindow != null && !this.iBrowserWindow.equals(window)) {
                this.remove();
            }
            if (window != null && !window.equals(this.iBrowserWindow)) {
                window.addWindowListener(this);
            }
            this.iBrowserWindow = window;
        }

        private void remove() {
            if (this.iBrowserWindow != null) {
                this.iBrowserWindow.removeWindowListener(this);
                this.iBrowserWindow = null;
            }
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
            if (FocusTracker.this.hasFocus()) {
                FocusTracker.this.focusChanged(false);
            }
        }
    }

    private class FocusTrackerMouseListener
    extends MouseAdapter {
        private FocusTrackerMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (!FocusTracker.this.hasFocus()) {
                FocusTracker.this.fBrowserComponent.dispatchEvent(new FocusEvent(mouseEvent.getComponent(), 1004));
                FocusTracker.this.focusChanged(true);
            }
        }
    }
}

