/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyEvent;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Highlighter;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

public final class JEditorPaneHyperlinkHandler {
    private boolean fListenersInstalled = false;
    private FocusState fFocusState = FocusState.IGNORE;
    private KeyStroke fNavigationKs = null;
    private final JEditorPane fComp;
    private boolean fNavigating = false;
    private KeyboardFocusManager fFocusManager;
    private KeyEventDispatcher fDispatcher = null;
    private ArrayList<KeyStroke> fKeyStrokes;
    private HierarchyListener fHierarchyListener;
    private CaretListener fCaretListener;
    private FocusListener fFocusListener;

    public JEditorPaneHyperlinkHandler(JEditorPane jEditorPane) {
        this.fComp = jEditorPane;
        this.fFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        if (this.fComp == null) {
            throw new IllegalArgumentException("comp cannot be null");
        }
        if (this.fComp.isEditable()) {
            throw new IllegalArgumentException("JEditorPaneHyperlinkHandler does not support editable JEditorPanes");
        }
        if (!(this.fComp.getEditorKit() instanceof HTMLEditorKit)) {
            throw new IllegalArgumentException("JEditorPaneHyperlinkHandler only supports JEditorPanes with an HTMLEditorKit");
        }
        if (!this.fComp.isFocusable()) {
            throw new IllegalArgumentException("JEditorPaneHyperlinkHandler only supports focusable JEditorPanes");
        }
        try {
            Class<?> clazz = Class.forName("javax.swing.text.html.HTMLEditorKit$NavigateLinkAction");
            Constructor<?> constructor = clazz.getConstructor(String.class);
            constructor.setAccessible(true);
            Object obj = constructor.newInstance("next-link-action");
            this.fComp.getActionMap().put("next-link-action", (Action)obj);
            Object obj2 = constructor.newInstance("previous-link-action");
            this.fComp.getActionMap().put("previous-link-action", (Action)obj2);
        }
        catch (Exception exception) {
            return;
        }
        this.fComp.setFocusCycleRoot(false);
        this.fCaretListener = new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                if (!JEditorPaneHyperlinkHandler.this.fNavigating) {
                    JEditorPaneHyperlinkHandler.this.resetHighlights(caretEvent);
                }
            }
        };
        this.fFocusListener = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                JEditorPaneHyperlinkHandler.this.fComp.setFocusTraversalKeysEnabled(false);
                if (JEditorPaneHyperlinkHandler.this.fFocusState.equals((Object)FocusState.FORWARD)) {
                    JEditorPaneHyperlinkHandler.this.navigateToFirstLink(JEditorPaneHyperlinkHandler.this.fNavigationKs, null);
                } else if (JEditorPaneHyperlinkHandler.this.fFocusState.equals((Object)FocusState.BACKWARD)) {
                    JEditorPaneHyperlinkHandler.this.navigateToLastLink(JEditorPaneHyperlinkHandler.this.fNavigationKs, null);
                }
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                JEditorPaneHyperlinkHandler.this.fFocusState = FocusState.IGNORE;
                JEditorPaneHyperlinkHandler.this.fNavigationKs = null;
                if (!focusEvent.isTemporary()) {
                    JEditorPaneHyperlinkHandler.this.resetHighlights(null);
                }
            }
        };
        this.addListeners();
    }

    public void addListeners() {
        if (!this.fListenersInstalled) {
            Object object;
            Set<AWTKeyStroke> set = this.fFocusManager.getDefaultFocusTraversalKeys(0);
            Set<AWTKeyStroke> set2 = this.fFocusManager.getDefaultFocusTraversalKeys(1);
            this.fKeyStrokes = new ArrayList();
            for (AWTKeyStroke object22 : set) {
                object = KeyStroke.getKeyStroke(object22.getKeyCode(), object22.getModifiers());
                this.fComp.getInputMap().put((KeyStroke)object, new AbstractAction((KeyStroke)object){
                    final /* synthetic */ KeyStroke val$ks;
                    {
                        this.val$ks = keyStroke;
                    }

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        JEditorPaneHyperlinkHandler.this.navigateToNextLink(this.val$ks, actionEvent);
                    }
                });
                this.fKeyStrokes.add((KeyStroke)object);
            }
            for (AWTKeyStroke aWTKeyStroke : set2) {
                object = KeyStroke.getKeyStroke(aWTKeyStroke.getKeyCode(), aWTKeyStroke.getModifiers());
                this.fComp.getInputMap().put((KeyStroke)object, new AbstractAction((KeyStroke)object){
                    final /* synthetic */ KeyStroke val$ks;
                    {
                        this.val$ks = keyStroke;
                    }

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        JEditorPaneHyperlinkHandler.this.navigateToPreviousLink(this.val$ks, actionEvent);
                    }
                });
                this.fKeyStrokes.add((KeyStroke)object);
            }
            KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0);
            Object object2 = this.fComp.getInputMap().get(keyStroke);
            object = object2 != null ? this.fComp.getActionMap().get(object2) : null;
            this.fComp.getInputMap().put(keyStroke, new AbstractAction((Action)object){
                final /* synthetic */ Action val$existingAction;
                {
                    this.val$existingAction = action;
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    boolean bl = JEditorPaneHyperlinkHandler.this.activateHyperlink(actionEvent);
                    if (!bl && this.val$existingAction != null) {
                        this.val$existingAction.actionPerformed(actionEvent);
                    }
                }
            });
            this.fKeyStrokes.add(keyStroke);
            if (this.fHierarchyListener == null) {
                this.fHierarchyListener = this.createHierarchyListener(set, set2, keyStroke, object2);
            }
            if (this.fComp.isShowing()) {
                this.installKeyEventDispatcher(set, set2);
            }
            this.fComp.addHierarchyListener(this.fHierarchyListener);
            this.fComp.addFocusListener(this.fFocusListener);
            this.fComp.addCaretListener(this.fCaretListener);
            this.fListenersInstalled = true;
        }
    }

    private HierarchyListener createHierarchyListener(final Set<AWTKeyStroke> set, final Set<AWTKeyStroke> set2, final KeyStroke keyStroke, final Object object) {
        return new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                if ((hierarchyEvent.getChangeFlags() & 4L) != 0L) {
                    if (JEditorPaneHyperlinkHandler.this.fComp.isShowing()) {
                        JEditorPaneHyperlinkHandler.this.installKeyEventDispatcher(set, set2);
                    } else {
                        JEditorPaneHyperlinkHandler.this.deinstallKeyEventDispatcher();
                    }
                }
                if ((hierarchyEvent.getChangeFlags() & 2L) != 0L && !JEditorPaneHyperlinkHandler.this.fComp.isDisplayable()) {
                    JEditorPaneHyperlinkHandler.this.deinstallKeyEventDispatcher();
                    for (KeyStroke keyStroke2 : JEditorPaneHyperlinkHandler.this.fKeyStrokes) {
                        JEditorPaneHyperlinkHandler.this.fComp.getInputMap().remove(keyStroke2);
                    }
                    JEditorPaneHyperlinkHandler.this.fComp.getInputMap().put(keyStroke, object);
                    this.removeListenersAndResetHighlights();
                }
            }

            private void removeListenersAndResetHighlights() {
                JEditorPaneHyperlinkHandler.this.fComp.removeCaretListener(JEditorPaneHyperlinkHandler.this.fCaretListener);
                JEditorPaneHyperlinkHandler.this.fComp.removeFocusListener(JEditorPaneHyperlinkHandler.this.fFocusListener);
                JEditorPaneHyperlinkHandler.this.fComp.removeHierarchyListener(JEditorPaneHyperlinkHandler.this.fHierarchyListener);
                JEditorPaneHyperlinkHandler.this.resetHighlights(null);
                JEditorPaneHyperlinkHandler.this.fListenersInstalled = false;
            }
        };
    }

    private void navigateToFirstLink(KeyStroke keyStroke, ActionEvent actionEvent) {
        this.fComp.select(0, 0);
        this.navigateToNextLink(keyStroke, actionEvent);
    }

    private void installKeyEventDispatcher(final Set<AWTKeyStroke> set, final Set<AWTKeyStroke> set2) {
        if (this.fDispatcher == null) {
            this.fDispatcher = new KeyEventDispatcher(){

                @Override
                public boolean dispatchKeyEvent(KeyEvent keyEvent) {
                    if (keyEvent.getID() == 401) {
                        FocusTraversalPolicy focusTraversalPolicy;
                        Container container = JEditorPaneHyperlinkHandler.this.fFocusManager.getCurrentFocusCycleRoot();
                        Component component = JEditorPaneHyperlinkHandler.this.fFocusManager.getFocusOwner();
                        KeyStroke keyStroke = KeyStroke.getKeyStroke(keyEvent.getKeyCode(), keyEvent.getModifiers());
                        if (container != null && component != null && JEditorPaneHyperlinkHandler.this.fComp.isFocusCycleRoot(container) && component.isFocusCycleRoot(container) && (focusTraversalPolicy = container.getFocusTraversalPolicy()) != null) {
                            if (JEditorPaneHyperlinkHandler.this.fComp.equals(focusTraversalPolicy.getComponentAfter(container, component)) && set.contains(keyStroke)) {
                                JEditorPaneHyperlinkHandler.this.fFocusState = FocusState.FORWARD;
                                JEditorPaneHyperlinkHandler.this.fNavigationKs = keyStroke;
                                return false;
                            }
                            if (JEditorPaneHyperlinkHandler.this.fComp.equals(focusTraversalPolicy.getComponentBefore(container, component)) && set2.contains(keyStroke)) {
                                JEditorPaneHyperlinkHandler.this.fFocusState = FocusState.BACKWARD;
                                JEditorPaneHyperlinkHandler.this.fNavigationKs = keyStroke;
                                return false;
                            }
                        }
                    }
                    return false;
                }
            };
            this.fFocusManager.addKeyEventDispatcher(this.fDispatcher);
        }
    }

    private void deinstallKeyEventDispatcher() {
        if (this.fDispatcher != null) {
            this.fFocusManager.removeKeyEventDispatcher(this.fDispatcher);
            this.fDispatcher = null;
        }
    }

    private void navigateToNextLink(KeyStroke keyStroke, ActionEvent actionEvent) {
        this.resetHighlights(null);
        this.fNavigating = true;
        int n = this.fComp.getSelectionStart();
        int n2 = this.fComp.getSelectionEnd();
        Action action = this.fComp.getActionMap().get("next-link-action");
        if (action != null) {
            action.actionPerformed(actionEvent);
        }
        this.fNavigating = false;
        if (n == this.fComp.getSelectionStart() && n2 == this.fComp.getSelectionEnd()) {
            Container container = this.fFocusManager.getCurrentFocusCycleRoot();
            FocusTraversalPolicy focusTraversalPolicy = container.getFocusTraversalPolicy();
            if (focusTraversalPolicy != null && this.fComp.equals(focusTraversalPolicy.getComponentAfter(container, this.fComp))) {
                HTMLDocument hTMLDocument = (HTMLDocument)this.fComp.getDocument();
                HTMLDocument.Iterator iterator = hTMLDocument.getIterator(HTML.Tag.A);
                if (iterator.isValid()) {
                    this.navigateToFirstLink(keyStroke, actionEvent);
                }
            } else {
                int n3 = this.fComp.getDocument().getLength();
                this.fComp.select(n3, n3);
                this.fComp.setFocusTraversalKeysEnabled(true);
                this.fFocusManager.dispatchEvent(new KeyEvent(this.fComp, 401, new Date().getTime(), keyStroke.getModifiers(), keyStroke.getKeyCode(), keyStroke.getKeyChar()));
            }
        }
    }

    private void navigateToLastLink(KeyStroke keyStroke, ActionEvent actionEvent) {
        int n = this.fComp.getDocument().getLength();
        this.fComp.select(n, n);
        this.navigateToPreviousLink(keyStroke, actionEvent);
    }

    private void navigateToPreviousLink(KeyStroke keyStroke, ActionEvent actionEvent) {
        this.resetHighlights(null);
        this.fNavigating = true;
        int n = this.fComp.getSelectionStart();
        int n2 = this.fComp.getSelectionEnd();
        HTMLDocument hTMLDocument = (HTMLDocument)this.fComp.getDocument();
        boolean bl = false;
        HTMLDocument.Iterator iterator = hTMLDocument.getIterator(HTML.Tag.A);
        if (iterator.isValid() && n < iterator.getStartOffset()) {
            bl = true;
        }
        Action action = this.fComp.getActionMap().get("previous-link-action");
        if (!bl && action != null) {
            action.actionPerformed(actionEvent);
        }
        this.fNavigating = false;
        if (n == this.fComp.getSelectionStart() && n2 == this.fComp.getSelectionEnd()) {
            Container container = this.fFocusManager.getCurrentFocusCycleRoot();
            FocusTraversalPolicy focusTraversalPolicy = container.getFocusTraversalPolicy();
            if (focusTraversalPolicy != null && this.fComp.equals(focusTraversalPolicy.getComponentBefore(container, this.fComp))) {
                HTMLDocument.Iterator iterator2 = hTMLDocument.getIterator(HTML.Tag.A);
                if (iterator2.isValid()) {
                    this.navigateToLastLink(keyStroke, actionEvent);
                }
            } else {
                this.fComp.select(0, 0);
                this.fComp.setFocusTraversalKeysEnabled(true);
                this.fFocusManager.dispatchEvent(new KeyEvent(this.fComp, 401, new Date().getTime(), keyStroke.getModifiers(), keyStroke.getKeyCode(), keyStroke.getKeyChar()));
            }
        }
    }

    private boolean activateHyperlink(ActionEvent actionEvent) {
        boolean bl = false;
        HTMLDocument hTMLDocument = (HTMLDocument)this.fComp.getDocument();
        HTMLDocument.Iterator iterator = hTMLDocument.getIterator(HTML.Tag.A);
        int n = this.fComp.getSelectionStart();
        while (iterator.isValid() && !bl) {
            AttributeSet attributeSet = iterator.getAttributes();
            int n2 = iterator.getStartOffset();
            if (n == n2) {
                Object object = attributeSet.getAttribute(HTML.Attribute.HREF);
                if (object != null) {
                    URL uRL = null;
                    String string = null;
                    try {
                        uRL = new URL(object.toString());
                    }
                    catch (MalformedURLException malformedURLException) {
                        string = object.toString();
                    }
                    this.fComp.fireHyperlinkUpdate(new HyperlinkEvent(actionEvent, HyperlinkEvent.EventType.ACTIVATED, uRL, string));
                }
                bl = true;
            }
            iterator.next();
        }
        return bl;
    }

    private void resetHighlights(CaretEvent caretEvent) {
        Highlighter.Highlight[] highlightArray;
        for (Highlighter.Highlight highlight : highlightArray = this.fComp.getHighlighter().getHighlights()) {
            try {
                if (caretEvent != null && (highlight.getStartOffset() == caretEvent.getDot() || highlight.getEndOffset() == caretEvent.getDot()) && (highlight.getStartOffset() == caretEvent.getMark() || highlight.getEndOffset() == caretEvent.getMark())) continue;
                this.fComp.getHighlighter().changeHighlight(highlight, 1, 1);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        this.fComp.repaint();
    }

    private static enum FocusState {
        FORWARD,
        BACKWARD,
        IGNORE;

    }
}

