/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.RobotUtils;
import com.mathworks.util.PlatformInfo;
import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.reflect.Method;
import javax.swing.SwingUtilities;

public class KeyControlledDragger {
    protected Component fInvoker;
    protected Component fDragComponent;
    private KeyEventDispatcher fKeyDispatcher;
    private WindowListener fWindowListener;
    private AWTEventListener fMouseListener;
    private Robot fRobot;
    protected Point fOriginalPoint;
    protected Point fDragStartPoint;
    protected Point fDragPoint;
    private int fMoveIncrement = 5;
    private boolean fIsMouseDown;
    public static final int DEFAULT_INCREMENT = 5;

    public void activate(Component component) {
        assert (this.fInvoker == null);
        this.fInvoker = component;
        this.fKeyDispatcher = new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent keyEvent) {
                if (keyEvent.getID() == 401) {
                    Point point = null;
                    switch (keyEvent.getKeyCode()) {
                        case 37: 
                        case 226: {
                            point = KeyControlledDragger.this.getNextPoint(KeyControlledDragger.this.fDragPoint, 7);
                            break;
                        }
                        case 39: 
                        case 227: {
                            point = KeyControlledDragger.this.getNextPoint(KeyControlledDragger.this.fDragPoint, 3);
                            break;
                        }
                        case 38: 
                        case 224: {
                            point = KeyControlledDragger.this.getNextPoint(KeyControlledDragger.this.fDragPoint, 1);
                            break;
                        }
                        case 40: 
                        case 225: {
                            point = KeyControlledDragger.this.getNextPoint(KeyControlledDragger.this.fDragPoint, 5);
                            break;
                        }
                        case 10: {
                            KeyControlledDragger.this.deactivate();
                            break;
                        }
                        case 27: {
                            KeyControlledDragger.this.fRobot.mouseMove(KeyControlledDragger.this.fDragStartPoint.x, KeyControlledDragger.this.fDragStartPoint.y);
                            KeyControlledDragger.this.deactivate();
                        }
                    }
                    if (point != null && (KeyControlledDragger.this.fDragPoint == null || point.x != KeyControlledDragger.this.fDragPoint.x || point.y != KeyControlledDragger.this.fDragPoint.y)) {
                        KeyControlledDragger.this.fDragPoint = point;
                        KeyControlledDragger.this.prepareForMove();
                        KeyControlledDragger.this.fRobot.mouseMove(point.x, point.y);
                    }
                }
                return true;
            }
        };
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.fKeyDispatcher);
        Window window = SwingUtilities.windowForComponent(component);
        this.fWindowListener = new WindowAdapter(){

            @Override
            public void windowDeactivated(WindowEvent windowEvent) {
                KeyControlledDragger.this.deactivate();
            }
        };
        window.addWindowListener(this.fWindowListener);
        this.fMouseListener = new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent aWTEvent) {
                if (aWTEvent.getID() == 506) {
                    if (KeyControlledDragger.this.fDragComponent == null) {
                        KeyControlledDragger.this.fDragComponent = (Component)aWTEvent.getSource();
                    }
                } else if (aWTEvent.getID() == 501) {
                    if (KeyControlledDragger.this.fIsMouseDown) {
                        ((MouseEvent)aWTEvent).consume();
                    } else {
                        KeyControlledDragger.this.fIsMouseDown = true;
                    }
                } else if (aWTEvent.getID() == 502) {
                    Component component = KeyControlledDragger.this.fDragComponent;
                    KeyControlledDragger.this.deactivate(false);
                    if (component != null) {
                        MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                        mouseEvent = SwingUtilities.convertMouseEvent(mouseEvent.getComponent(), mouseEvent, component);
                        component.dispatchEvent(mouseEvent);
                        mouseEvent.consume();
                    }
                }
            }
        };
        Toolkit.getDefaultToolkit().addAWTEventListener(this.fMouseListener, 48L);
        Cursor cursor = this.getDragCursor();
        if (cursor != null) {
            MJUtilities.setGlobalCursor(window, cursor);
        }
        this.fOriginalPoint = this.getOriginalPoint();
        this.fDragPoint = this.fDragStartPoint = this.getDragStartPoint();
        this.fIsMouseDown = false;
        try {
            this.fRobot = RobotUtils.createRobot();
            this.fRobot.mouseMove(this.fDragStartPoint.x, this.fDragStartPoint.y);
            this.fRobot.mousePress(16);
        }
        catch (AWTException aWTException) {
            this.fRobot = null;
            this.deactivate();
        }
    }

    public void deactivate() {
        this.deactivate(true);
    }

    public void deactivate(boolean bl) {
        if (this.fInvoker == null) {
            return;
        }
        if (this.fRobot != null) {
            if (bl) {
                this.fRobot.mouseRelease(16);
            }
            if (this.fOriginalPoint != null) {
                this.fRobot.mouseMove(this.fOriginalPoint.x, this.fOriginalPoint.y);
            }
        }
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this.fKeyDispatcher);
        Window window = SwingUtilities.windowForComponent(this.fInvoker);
        window.removeWindowListener(this.fWindowListener);
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.fMouseListener);
        MJUtilities.clearGlobalCursor(window);
        this.fKeyDispatcher = null;
        this.fWindowListener = null;
        this.fMouseListener = null;
        this.fInvoker = null;
        this.fDragComponent = null;
        this.fRobot = null;
        this.fOriginalPoint = null;
        this.fDragStartPoint = null;
        this.fDragPoint = null;
        this.fIsMouseDown = false;
    }

    public boolean isActive() {
        return this.fRobot != null;
    }

    public void startDrag(int n, int n2) {
        if (this.fRobot != null && this.fDragPoint != null) {
            this.fDragPoint.x += n;
            this.fDragPoint.y += n2;
            this.fRobot.mouseMove(this.fDragPoint.x, this.fDragPoint.y);
        }
    }

    public void setMoveIncrement(int n) {
        this.fMoveIncrement = n;
    }

    public int getMoveIncrement() {
        return this.fMoveIncrement;
    }

    protected Cursor getDragCursor() {
        return Cursor.getPredefinedCursor(13);
    }

    protected Point getDragStartPoint() {
        Point point = new Point(this.fInvoker.getWidth() / 2, this.fInvoker.getHeight() / 2);
        SwingUtilities.convertPointToScreen(point, this.fInvoker);
        return point;
    }

    protected Point getNextPoint(Point point, int n) {
        switch (n) {
            case 1: {
                return new Point(point.x, point.y - this.fMoveIncrement);
            }
            case 5: {
                return new Point(point.x, point.y + this.fMoveIncrement);
            }
            case 3: {
                return new Point(point.x + this.fMoveIncrement, point.y);
            }
            case 7: {
                return new Point(point.x - this.fMoveIncrement, point.y);
            }
        }
        return point;
    }

    protected void prepareForMove() {
    }

    private Point getOriginalPoint() {
        if (PlatformInfo.getVersion() < 6) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName("java.awt.MouseInfo");
            Method method = clazz.getMethod("getPointerInfo", null);
            Class<?> clazz2 = Class.forName("java.awt.PointerInfo");
            Method method2 = clazz2.getMethod("getLocation", null);
            Object object = method.invoke(null, null);
            Point point = (Point)method2.invoke(object, null);
            return point;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

